/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.San.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Date;
import javax.swing.JPanel;
import org.eclipse.aperi.San.common.Lun;
import org.eclipse.aperi.San.common.LunAdjuster;
import org.eclipse.aperi.San.gui.LogicalUnitDDI;
import org.eclipse.aperi.TStorm.gui.ReportingDDI;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportRequest;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.MutableLong;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.gui.BaseTableModel;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.TJCTableMouseAdapter;
import org.eclipse.aperi.gui.TableCellRenderers;
import org.eclipse.aperi.gui.tables.MegaTable;
import org.eclipse.aperi.request.Response;

public class LunTable
extends JPanel
implements GuiRequestor {
    private MegaTable lunTable = new MegaTable();
    private GuiReportReq grr;
    private Lun[] lunArray;
    private LunAdjuster adjuster;

    public LunTable(GuiReportReq guiReportReq) {
        this.grr = guiReportReq;
        GuiReportRequest guiReportRequest = new GuiReportRequest(guiReportReq);
        GuiClient.doRequest(this, guiReportRequest);
        this.adjuster = new LunAdjuster(guiReportReq);
    }

    public void handleResponse(short s, Response response) {
        this.setLayout(new BorderLayout());
        if (s <= 4) {
            this.lunArray = (Lun[])response.responseData;
        }
        int n = 0;
        if (this.lunArray != null) {
            n = this.lunArray.length;
        }
        if (n == 0) {
            this.add((Component)ReportingDDI.getNoDataMessage(this.grr), "Center");
            return;
        }
        this.adjuster.adjust(this.lunArray, false);
        this.lunArray = (Lun[])this.adjuster.getArray();
        this.lunTable.setFrozenColumns(this.adjuster.frozenColumns);
        this.lunTable.setMouseListener(new SelectionListener());
        this.lunTable.setCellRenderer(MutableInteger.class, TableCellRenderers.number);
        this.lunTable.setCellRenderer(MutableLong.class, TableCellRenderers.space);
        this.lunTable.setCellRenderer(Date.class, TableCellRenderers.date);
        this.lunTable.setRowIcon(10, true);
        if (this.adjuster.frozenRows > 0) {
            this.lunTable.setFrozenRows(this.adjuster.frozenRows);
        }
        this.lunTable.setBaseTableModel(new LunTableModel());
        this.lunTable.setAsFirstColumn(this.adjuster.getFirstColumn());
        this.add((Component)this.lunTable, "Center");
    }

    private class LunTableModel
    extends BaseTableModel {
        LunTableModel() {
            this.columnNames = ((LunTable)LunTable.this).adjuster.colNames;
            this.rowCount = LunTable.this.lunArray.length;
            this.commonAdjuster = LunTable.this.adjuster;
        }

        public Object getTableDataItem(int n, int n2) {
            return LunTable.this.adjuster.getCellData(n, LunTable.this.adjuster.translateColumn(n2));
        }
    }

    public class SelectionListener
    extends TJCTableMouseAdapter {
        public boolean select(int n, int n2) {
            return n >= ((LunTable)LunTable.this).adjuster.frozenRows;
        }

        public void doubleClick(int n, int n2) {
            if (n >= ((LunTable)LunTable.this).adjuster.frozenRows) {
                Lun lun = LunTable.this.lunArray[n];
                NameList nameList = new NameList();
                nameList.nlID = lun.lunDaID;
                nameList.nlName = lun.lunDaAlias;
                nameList.nlID2 = lun.lunOSType;
                new LogicalUnitDDI(null, lun.lunID, nameList, lun.lunName);
            }
        }
    }
}

