/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.San.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.eclipse.aperi.San.gui.PerfAlertEditor;
import org.eclipse.aperi.San.gui.SubsystemAlertCreateOrEdit;
import org.eclipse.aperi.TStorm.common.AlertHeader;
import org.eclipse.aperi.TStorm.gui.SubsystemAlertSelector;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.IntToString;
import org.eclipse.aperi.gui.TTextField;

public class SubsystemAlertEditor
extends PerfAlertEditor
implements ActionListener {
    private SubsystemAlertCreateOrEdit daCOE;
    private SubsystemAlertSelector subsystemSelector;
    protected JCheckBox suppressCheckBox;
    protected TTextField suppressThresholdEntry;
    protected JLabel suppressThresholdPercent;
    protected static final String SUPPRESS_THRESHOLD_DEFAULT_VALUE = "80";
    protected int suppressThresholdValue = -1;

    public SubsystemAlertEditor(SubsystemAlertCreateOrEdit subsystemAlertCreateOrEdit) {
        this.daCOE = subsystemAlertCreateOrEdit;
    }

    public SubsystemAlertEditor(SubsystemAlertCreateOrEdit subsystemAlertCreateOrEdit, AlertHeader alertHeader) {
        super(alertHeader);
        this.daCOE = subsystemAlertCreateOrEdit;
    }

    protected void initAlert() {
        super.initAlert();
        this.alert.aldProductID = (short)3;
        this.alert.aldType = (short)20;
        this.alert.aldCondition = (short)64;
    }

    protected JPanel buildConditionPanel() {
        JPanel jPanel = super.buildConditionPanel();
        this.suppressCheckBox = new JCheckBox(Util.getString("DISK_SUPPRESS_ALERT_TEXT"));
        this.suppressThresholdEntry = TTextField.newTTextField(SUPPRESS_THRESHOLD_DEFAULT_VALUE, 2, true);
        this.suppressThresholdPercent = new JLabel(Util.getString("DISK_PERCENT"));
        GuiUtil.setAccessible(this.suppressCheckBox, Util.getString("DISK_SUPPRESS_ALERT_TEXT"), Util.getString("DISK_SUPPRESS_ALERT_TEXT"));
        GuiUtil.setAccessible(this.suppressThresholdEntry, Util.getString("DISK_SUPPRESS_ALERT_TEXT"), Util.getString("DISK_SUPPRESS_ALERT_TEXT"));
        GuiUtil.setAccessible(this.suppressThresholdPercent, Util.getString("DISK_PERCENT"), Util.getString("DISK_PERCENT"));
        this.constraints.gridx = 0;
        this.constraints.gridy = 2;
        this.constraints.gridwidth = 2;
        this.constraints.gridheight = 1;
        this.layout.setConstraints(this.suppressCheckBox, this.constraints);
        jPanel.add(this.suppressCheckBox);
        this.constraints.gridx = 2;
        this.constraints.gridy = 2;
        this.constraints.gridwidth = 1;
        this.constraints.gridheight = 1;
        this.layout.setConstraints(this.suppressThresholdEntry, this.constraints);
        jPanel.add(this.suppressThresholdEntry);
        this.constraints.gridx = 3;
        this.constraints.gridy = 2;
        this.constraints.gridwidth = 1;
        this.constraints.gridheight = 1;
        this.layout.setConstraints(this.suppressThresholdPercent, this.constraints);
        jPanel.add(this.suppressThresholdPercent);
        this.suppressCheckBox.setSelected(true);
        this.suppressCheckBox.addActionListener(this);
        this.suppressAlertEnabled(false);
        GuiUtil.completePanel(jPanel);
        this.setPanelSize(jPanel);
        return jPanel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.suppressCheckBox) {
            this.suppressThresholdEntry.setEnabled(this.suppressCheckBox.isSelected());
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    protected void initConditions() {
        this.oldConditions = new IntToString[32];
        this.oldConditions[0] = new IntToString(64, "ALR1114W");
        this.oldConditions[1] = new IntToString(67, "STG5503L");
        this.oldConditions[2] = new IntToString(68, "STG5504L");
        this.oldConditions[3] = new IntToString(5, "STG4005L");
        this.oldConditions[4] = new IntToString(6, "STG4006L");
        this.oldConditions[5] = new IntToString(65, "STG5505L");
        this.oldConditions[6] = new IntToString(140, Util.getString("FabricAlert_Subsystem_Status_Change_Offline"));
        this.oldConditions[7] = new IntToString(141, Util.getString("FabricAlert_Subsystem_Status_Change_Online"));
        this.oldConditions[8] = new IntToString(142, Util.getString("FabricAlert_Subsystem_Version_Change"));
        this.oldConditions[9] = new IntToString(123, Util.getString("FabricAlert_Subsystem_Property_Change"));
        this.oldConditions[10] = new IntToString(143, Util.getString("FabricAlert_Subsystem_Allocated_Capacity_Change"));
        this.oldConditions[11] = new IntToString(144, Util.getString("FabricAlert_Subsystem_Available_Capacity_Change"));
        this.oldConditions[12] = new IntToString(145, Util.getString("FabricAlert_Subsystem_Backend_Capacity_Change"));
        this.oldConditions[13] = new IntToString(146, Util.getString("FabricAlert_Subsystem_BackendController_Status_Change_Offline"));
        this.oldConditions[14] = new IntToString(147, Util.getString("FabricAlert_Subsystem_BackendController_Status_Change_Online"));
        this.oldConditions[15] = new IntToString(148, Util.getString("FabricAlert_Subsystem_Volume_Status_Change_Offline"));
        this.oldConditions[16] = new IntToString(149, Util.getString("FabricAlert_Subsystem_Volume_Status_Change_Online"));
        this.oldConditions[17] = new IntToString(150, Util.getString("FabricAlert_Subsystem_Volume_Capacity_Change"));
        this.oldConditions[18] = new IntToString(151, Util.getString("FabricAlert_Subsystem_Pool_Status_Change"));
        this.oldConditions[19] = new IntToString(152, Util.getString("FabricAlert_Subsystem_Pool_Discovered"));
        this.oldConditions[20] = new IntToString(153, Util.getString("FabricAlert_Subsystem_Pool_Status_Change_Offline"));
        this.oldConditions[21] = new IntToString(154, Util.getString("FabricAlert_Subsystem_Pool_Status_Change_Online"));
        this.oldConditions[22] = new IntToString(155, Util.getString("FabricAlert_Subsystem_Pool_Capacity_Change"));
        this.oldConditions[23] = new IntToString(156, Util.getString("FabricAlert_Subsystem_Pool_Available_Space_Change"));
        this.oldConditions[24] = new IntToString(137, Util.getString("FabricAlert_Endpoint_Node_Status_Change_Offline"));
        this.oldConditions[25] = new IntToString(138, Util.getString("FabricAlert_Endpoint_Node_Status_Change_Online"));
        this.oldConditions[26] = new IntToString(135, Util.getString("FabricAlert_Endpoint_Node_State_Change"));
        this.oldConditions[27] = new IntToString(136, Util.getString("FabricAlert_Endpoint_Node_Discovered"));
        this.oldConditions[28] = new IntToString(111, Util.getString("FabricAlert_Datapath_State_Change"));
        this.oldConditions[29] = new IntToString(112, Util.getString("FabricAlert_Datapath_Discovered"));
        this.oldConditions[30] = new IntToString(185, "ALR1347W");
        this.oldConditions[31] = new IntToString(186, "ALR1348W");
    }

    protected void setConditionData() {
        super.setConditionData();
        if (this.alert.aldAlertID > 0 && this.alert.aldAlertID <= 299) {
            this.conditionList.removeAllItems();
            this.conditionList.addItem(new IntToString(64, Util.getString("ALR1114W")));
        }
    }

    protected void conditionChange() {
        super.conditionChange();
        short s = this.getConditionValue();
        if (s == 64) {
            this.daCOE.tabbedPane.setEnabledAt(1, false);
        } else {
            this.daCOE.tabbedPane.setEnabledAt(1, true);
        }
    }

    protected void switchCard(int n) {
        switch (n) {
            case 5: 
            case 6: 
            case 64: 
            case 65: 
            case 67: 
            case 68: 
            case 111: 
            case 112: 
            case 123: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 185: 
            case 186: {
                this.suppressAlertEnabled(false);
                this.actionPanelEnabled(true);
            }
        }
        this.oldAlertType = n;
    }

    private void updateSubsystemList(boolean bl) {
        this.subsystemSelector.setDoPerfAlert(bl);
        this.subsystemSelector.resetSelector();
    }

    private void suppressAlertEnabled(boolean bl) {
        this.suppressCheckBox.setEnabled(bl);
        if (this.suppressCheckBox.isSelected() && bl) {
            this.suppressThresholdEntry.setEnabled(true);
        } else {
            this.suppressThresholdEntry.setEnabled(false);
        }
        this.suppressThresholdPercent.setEnabled(bl);
    }

    private void actionPanelEnabled(boolean bl) {
        this.snmpTrap.setEnabled(bl);
        this.tecTrap.setEnabled(bl);
        this.loginNotification.setEnabled(bl);
        if (this.loginNotification.isSelected()) {
            this.lLoginID.setEnabled(bl);
            this.loginID.setEnabled(bl);
        }
        if (Constants.isWindows(GuiClient.serverStatusResp.osType)) {
            this.osLog.setEnabled(bl);
            if (this.osLog.isSelected()) {
                this.lLogLevel.setEnabled(bl);
                this.logLevel.setEnabled(bl);
            }
        } else {
            this.lLogFacility.setEnabled(bl);
            this.logFacility.setEnabled(bl);
        }
        this.runScript.setEnabled(bl);
        if (this.runScript.isSelected()) {
            this.scriptSettings.setEnabled(bl);
        }
        this.email.setEnabled(bl);
    }

    public void setSelector(SubsystemAlertSelector subsystemAlertSelector) {
        this.subsystemSelector = subsystemAlertSelector;
    }

    protected void getConditionData() {
        switch (this.getConditionValue()) {
            case 5: 
            case 6: 
            case 64: 
            case 65: 
            case 67: 
            case 68: 
            case 111: 
            case 112: 
            case 123: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 185: 
            case 186: {
                super.getConditionData();
                this.alert.aldType = (short)20;
            }
        }
    }

    protected void validateConditionData() throws GeneralException {
        super.validateConditionData();
        if (this.suppressThresholdEntry.isEnabled() && (this.suppressThresholdValue < 0 || this.suppressThresholdValue > 99)) {
            this.throwException("STG4263E");
        }
    }
}

