/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.common;

import java.io.Serializable;
import org.eclipse.aperi.common.Encrypt;
import org.eclipse.aperi.common.Packable;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.logging.TraceLogger;

public class CimomConfig
implements Packable,
Serializable {
    static final long serialVersionUID = -9214883649970322355L;
    public transient CimomConfig ciNext;
    public int ciID = -1;
    public String ciHost;
    public int ciPort;
    public String ciUserName;
    private String ciPassword;
    public byte ciProtocol;
    public String ciINamespace;
    public static final byte HTTP = 0;
    public static final byte HTTPS = 1;
    public static final String[] PROTOCOL_STRING = new String[]{"http", "https"};

    public CimomConfig() {
        this(null, 5989, "http", null, null, null);
    }

    public CimomConfig(String string, int n, String string2) {
        this(string, n, string2, null, null, null);
    }

    public CimomConfig(String string, int n, String string2, String string3, String string4, String string5) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CimomConfig.class.getName(), "CimomConfig", "host, port, protocol, userName, password, certificate, inamespace");
        }
        this.ciHost = string;
        this.ciPort = n;
        this.ciUserName = string3;
        this.encryptPassword(string4);
        this.ciINamespace = string5;
        this.setProtocol(string2);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CimomConfig.class.getName(), "CimomConfig");
        }
    }

    public boolean equalsCimom(CimomConfig cimomConfig) {
        return Util.stringsEqual(this.ciHost, cimomConfig.ciHost) && this.ciPort == cimomConfig.ciPort;
    }

    public boolean equals(Object object) {
        if (object instanceof CimomConfig) {
            return this.equalsCimom((CimomConfig)object);
        }
        return false;
    }

    public void setPassword(String string) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CimomConfig.class.getName(), "setPassword", "password");
        }
        this.ciPassword = string;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CimomConfig.class.getName(), "setPassword");
        }
    }

    public String getPassword() {
        return this.ciPassword;
    }

    public void encryptPassword(String string) {
        this.ciPassword = string != null ? Encrypt.encrypt(string) : null;
    }

    public String decryptPassword() {
        return this.ciPassword == null ? null : Encrypt.decrypt(this.ciPassword);
    }

    public String getProtocolString() {
        return PROTOCOL_STRING[this.ciProtocol];
    }

    public void setProtocol(String string) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CimomConfig.class.getName(), "setProtocol", "protocol");
        }
        this.ciProtocol = string == null || string.equalsIgnoreCase(PROTOCOL_STRING[0]) ? (byte)0 : 1;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CimomConfig.class.getName(), "setProtocol");
        }
    }

    public Packable getNext() {
        return this.ciNext;
    }

    public void setNext(Packable packable) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(CimomConfig.class.getName(), "setNext", "next");
        }
        this.ciNext = (CimomConfig)packable;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(CimomConfig.class.getName(), "setNext");
        }
    }
}

