/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.common;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.aperi.TStorm.common.Device;
import org.eclipse.aperi.common.Packable;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.xmsg.MessageLog;

public class VolGroup
implements Serializable,
Packable {
    static final long serialVersionUID = -555478448336753458L;
    public static final byte NO_ACTION = 0;
    public static final byte NEW = 1;
    public static final byte UPDATE = 2;
    public static final byte DELETE = 3;
    public transient VolGroup vgNext;
    public int vgID = -1;
    public int vgComputerID;
    public String vgName;
    public long vgFreeSpace;
    public long vgTotalSpace;
    public short vgType;
    public short vgFlag;
    public int vgVolumes;
    public int vgDisks;
    public short vgConfig;
    public String vgDiskGroup;
    public String vgArray;
    public String vgRank;
    public String vgLSS;
    public String vgRaidLevels;
    public short vgFormat;
    public short vgStatus;
    public long vgSurfacedLunCap;
    public long vgUnSurfacedLunCap;
    public int vgExtentSize;
    public long vgDiscoveredTime;
    public long vgProbeTime;
    public transient short vgWidth;
    public transient long vgOffset;
    public Device[] vgDevices;
    public short[] vgConfigs;
    public String[] vgDiskGroups;
    public String[] vgArrays;
    public String[] vgRanks;
    public String vgInstanceID;
    public int vgOperationalStatus;
    public static final short UNKNOWN = -1;
    public static final short VERITAS = 0;
    public static final short LVM = 1;
    public static final short ESS_VS = 2;
    public static final short SPOOL = 3;
    public static final short DS8000_VS = 4;
    public static final short DS6000_VS = 5;
    public static final short MRAID_SPOOL = 6;
    public static final String[] TYPES = new String[]{"VERITAS", "LVM", MessageLog.getMessageNoID("SAG0052I"), MessageLog.getMessageNoID("SAG0053I"), MessageLog.getMessageNoID("SAG0083I"), MessageLog.getMessageNoID("SAG0098I")};
    public static final short RAID5 = 0;
    public static final short RAID10 = 1;
    public static final short JBOD = 2;
    public static final short RAID0 = 3;
    public static final short RAID1 = 4;
    public static final short RAID2 = 5;
    public static final short RAID3 = 6;
    public static final short RAID4 = 7;
    public static final short RAID6 = 8;
    public static final short RAID51 = 9;
    public static final short RAID15 = 10;
    public static final short UNKNOWN_CONFIG = 11;
    public static final short RAIDTYPE_MAX = 12;
    public static final String[] RAID_LEVELS = new String[]{"RAID5", "RAID10", "JBOD", "RAID0", "RAID1", "RAID2", "RAID3", "RAID4", "RAID6", "RAID51", "RAID15"};
    public static final String[] CONFIGS = new String[]{MessageLog.getMessageNoID("SAG0057I"), MessageLog.getMessageNoID("SAG0058I"), MessageLog.getMessageNoID("SAG0059I"), MessageLog.getMessageNoID("SAG0516I"), MessageLog.getMessageNoID("SAG0517I"), MessageLog.getMessageNoID("SAG0518I"), MessageLog.getMessageNoID("SAG0519I"), MessageLog.getMessageNoID("SAG0520I"), MessageLog.getMessageNoID("SAG0522I"), MessageLog.getMessageNoID("SAG0523I"), MessageLog.getMessageNoID("SAG0524I"), MessageLog.getMessageNoID("SAG0521I")};
    public static final short UNKNOWN_FORMAT = 0;
    public static final short FIXED_BLOCK = 1;
    public static final short BLOCK_512 = 2;
    public static final short BLOCK_520_PROTECTED = 3;
    public static final short BLOCK_520_UNPROTECTED = 4;
    public static final short FORMAT_3380 = 5;
    public static final short FORMAT_3390 = 6;
    public static final short FORMAT_3390_EXTENDED = 7;
    public static final short CKD = 8;
    public static final String[] FORMATS = new String[]{MessageLog.getMessageNoID("SAG0600L"), MessageLog.getMessageNoID("SAG0055I"), MessageLog.getMessageNoID("SAG0631I"), MessageLog.getMessageNoID("SAG0632I"), MessageLog.getMessageNoID("SAG0633I"), MessageLog.getMessageNoID("SAG0634I"), MessageLog.getMessageNoID("SAG0635I"), MessageLog.getMessageNoID("SAG0636I"), MessageLog.getMessageNoID("SAG0056I")};
    public static final int OPERATIONAL = 0;
    public static final int REBUILDING = 1;
    public static final int READ_ONLY = 2;
    public static final int FAILED = 3;
    public static final String[] STATUS = new String[]{MessageLog.getMessageNoID("SAG0043L"), MessageLog.getMessageNoID("SAG0044L"), MessageLog.getMessageNoID("SAG0045L"), MessageLog.getMessageNoID("SAG0046L")};
    public static final String[] OPERATIONAL_STATUS = new String[]{MessageLog.getMessageNoID("SAG0600L"), MessageLog.getMessageNoID("SAG0601L"), MessageLog.getMessageNoID("SAG0602L"), MessageLog.getMessageNoID("SAG0603L"), MessageLog.getMessageNoID("SAG0604L"), MessageLog.getMessageNoID("SAG0605L"), MessageLog.getMessageNoID("SAG0606L"), MessageLog.getMessageNoID("SAG0607L"), MessageLog.getMessageNoID("SAG0608L"), MessageLog.getMessageNoID("SAG0609L"), MessageLog.getMessageNoID("SAG0610L"), MessageLog.getMessageNoID("SAG0611L"), MessageLog.getMessageNoID("SAG0612L"), MessageLog.getMessageNoID("SAG0613L"), MessageLog.getMessageNoID("SAG0614L"), MessageLog.getMessageNoID("SAG0615L"), MessageLog.getMessageNoID("SAG0616L"), MessageLog.getMessageNoID("SAG0617L"), MessageLog.getMessageNoID("SAG0618L")};

    public boolean equals(Object object) {
        VolGroup volGroup = (VolGroup)object;
        return this.vgComputerID == volGroup.vgComputerID && this.vgID == volGroup.vgID && Util.stringsEqual(this.vgName, volGroup.vgName) && this.vgFreeSpace == volGroup.vgFreeSpace && this.vgTotalSpace == volGroup.vgTotalSpace && this.vgType == volGroup.vgType && this.vgVolumes == volGroup.vgVolumes && this.vgConfig == volGroup.vgConfig && this.vgStatus == volGroup.vgStatus && this.vgOperationalStatus == volGroup.vgOperationalStatus && this.vgFormat == volGroup.vgFormat && this.vgSurfacedLunCap == volGroup.vgSurfacedLunCap && this.vgUnSurfacedLunCap == volGroup.vgUnSurfacedLunCap && this.vgDisks == volGroup.vgDisks && this.vgProbeTime == volGroup.vgProbeTime && Util.stringsEqual(this.vgDiskGroup, volGroup.vgDiskGroup) && Util.stringsEqual(this.vgLSS, volGroup.vgLSS);
    }

    public Packable getNext() {
        return this.vgNext;
    }

    public void setNext(Packable packable) {
        this.vgNext = (VolGroup)packable;
    }

    public String getOperationalStatus(int n) {
        String string = new String();
        int n2 = 0;
        while (n2 < OPERATIONAL_STATUS.length) {
            int n3 = 1 << n2;
            if ((n3 & n) != 0) {
                string = string.concat(OPERATIONAL_STATUS[n2]);
                string = string.concat(", ");
            }
            ++n2;
        }
        string = string.length() != 0 ? string.substring(0, string.length() - 2) : MessageLog.getMessageNoID("SAG0600L");
        return string;
    }

    public String getStatus() {
        String string = MessageLog.getMessageNoID("STG1020L");
        if (this.vgStatus > -1) {
            try {
                string = STATUS[this.vgStatus];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        }
        return string;
    }

    public String getTrackFormat() {
        String string = MessageLog.getMessageNoID("STG1020L");
        if (this.vgFormat > -1) {
            try {
                string = FORMATS[this.vgFormat];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        }
        return string;
    }

    public String getType() {
        String string = MessageLog.getMessageNoID("STG1020L");
        if (this.vgType > -1) {
            try {
                string = TYPES[this.vgType];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        }
        return string;
    }

    public String getConfig() {
        String string = MessageLog.getMessageNoID("STG1020L");
        if (this.vgConfig > -1) {
            try {
                string = CONFIGS[this.vgConfig];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        }
        return string;
    }

    public String getConfigs() {
        StringBuffer stringBuffer = new StringBuffer(256);
        int n = 0;
        while (n < this.vgConfigs.length) {
            if (n > 0) {
                stringBuffer.append(new String(", "));
            }
            stringBuffer.append(Short.toString(this.vgConfigs[n]));
            ++n;
        }
        stringBuffer.append(new String(","));
        return stringBuffer.toString();
    }

    public String getConfigsforDisplay() {
        String string = new String();
        String string2 = new String();
        if (this.vgConfigs != null) {
            int n = 0;
            while (n < this.vgConfigs.length) {
                string2 = CONFIGS[this.vgConfigs[n]];
                string = string.concat(string2);
                string = string.concat(new String(", "));
                ++n;
            }
            string = string.substring(0, string.length() - 2);
        }
        return string;
    }

    public String getArraySitesforDisplay() {
        return this.vgArray;
    }

    public String getArraySitesforDB() {
        StringBuffer stringBuffer = new StringBuffer(256);
        List<String> list = Arrays.asList(this.vgDiskGroups);
        Collections.sort(list);
        int n = 0;
        while (n < list.size()) {
            if (n == 0) {
                stringBuffer.append(' ');
            }
            if (n > 0) {
                stringBuffer.append(new String(", "));
            }
            stringBuffer.append(list.get(n));
            ++n;
        }
        stringBuffer.append(',');
        return stringBuffer.toString();
    }

    public String getArrays() {
        StringBuffer stringBuffer = new StringBuffer(256);
        List<String> list = Arrays.asList(this.vgArrays);
        Collections.sort(list);
        int n = 0;
        while (n < list.size()) {
            if (n > 0) {
                stringBuffer.append(new String(", "));
            }
            stringBuffer.append(list.get(n));
            ++n;
        }
        return stringBuffer.toString();
    }

    public String getRanks() {
        StringBuffer stringBuffer = new StringBuffer(256);
        List<String> list = Arrays.asList(this.vgRanks);
        Collections.sort(list);
        int n = 0;
        while (n < list.size()) {
            if (n > 0) {
                stringBuffer.append(new String(", "));
            }
            stringBuffer.append(list.get(n));
            ++n;
        }
        return stringBuffer.toString();
    }
}

