/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.SwingUtilities;
import org.eclipse.aperi.TStorm.gui.EditableObjectLabel;
import org.eclipse.aperi.TStorm.gui.FSGroupSelectorHelper;
import org.eclipse.aperi.TStorm.server.guireq.GuiListReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiRequest;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.TreeSelector;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;

public class FSGroupEditor
implements Runnable,
GuiRequestor,
ActionListener {
    private NameList selected;
    private Runnable callingObject;
    public TreeSelector selector;
    private ComputerTreeNode compAvailHead;
    private ComputerTreeNode compNode;
    private NameList currentFS;
    private NameList prevFS;
    private boolean hold;
    private FSGroupSelectorHelper gsh;
    private boolean forComputer;

    public FSGroupEditor(NameList nameList, Runnable runnable, boolean bl) {
        this.selected = nameList;
        this.callingObject = runnable;
        this.forComputer = bl;
        SwingUtilities.invokeLater(this);
    }

    public void run() {
        Request request;
        if (this.forComputer) {
            request = EditableObjectLabel.makeRequest((short)1, (short)0, (short)0);
            GuiListReq guiListReq = (GuiListReq)request.requestData;
            guiListReq.includeUnmanaged = true;
        } else {
            request = new Request();
            GuiRequest.filesystemList(request, -1);
        }
        GuiClient.doRequest(this, request);
    }

    public void handleResponse(short s, Response response) {
        if (s > 4) {
            return;
        }
        NameList nameList = (NameList)response.responseData;
        this.gsh = new FSGroupSelectorHelper();
        this.selector = this.forComputer ? this.gsh.getComputerTreeSelector(nameList, this.selected, false) : this.gsh.getFSTreeSelector(nameList, this.selected, false);
        this.selector.setGroupByClusterButtonActionListener(this);
        this.callingObject.run();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JCheckBox) {
            boolean bl = ((JCheckBox)actionEvent.getSource()).isSelected();
            if (this.forComputer) {
                this.selector.replaceTrees(this.gsh.makeComputerTree(this.selector.getAvailableList(), bl), this.gsh.makeComputerTree(this.selector.getSelectedList(), bl));
            } else {
                this.selector.replaceTrees(this.gsh.makeFsTree(this.selector.getAvailableList(), bl), this.gsh.makeFsTree(this.selector.getSelectedList(), bl));
            }
        }
    }

    private static class ComputerTreeNode {
        public ComputerTreeNode next;
        public NameList computer;
        public NameList filesystems;

        private ComputerTreeNode() {
        }
    }
}

