/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.util.Enumeration;
import javax.swing.tree.TreeNode;
import org.eclipse.aperi.TStorm.gui.EditableObjectHistoryNode;
import org.eclipse.aperi.TStorm.gui.EditableObjectHistoryRunDDI;
import org.eclipse.aperi.TStorm.gui.EditableObjectLabel;
import org.eclipse.aperi.TStorm.gui.NameListToTreeNode;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.gui.BaseTreeNode;
import org.eclipse.aperi.gui.DataDisplayInfo;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.scheduler.SchHistoryRequestNode;
import org.eclipse.aperi.xmsg.MessageLog;

public class HistoryHelper
implements GuiRequestor,
NameListToTreeNode {
    private BaseTreeNode treeNode;
    private int scheduleID;
    public String description;

    public HistoryHelper(BaseTreeNode baseTreeNode, String string, int n) {
        this.treeNode = baseTreeNode;
        this.description = string;
        this.scheduleID = n;
    }

    public void sendRequest() {
        SchHistoryRequestNode schHistoryRequestNode = new SchHistoryRequestNode();
        schHistoryRequestNode.queryType = 1;
        schHistoryRequestNode.queryID = this.scheduleID;
        Request request = new Request();
        request.typeCode = "org.eclipse.aperi.server.svp.SchedulerSvp";
        request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
        request.subType = "org.eclipse.aperi.server.handler.scheduler.ScheduleGuiHandler";
        request.requestData = schHistoryRequestNode;
        GuiClient.doRequest(this, request);
    }

    public void sendUpdateRequest() {
        SchHistoryRequestNode schHistoryRequestNode = new SchHistoryRequestNode();
        Request request = new Request();
        schHistoryRequestNode.queryID = this.scheduleID;
        request.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
        request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
        request.subType = "org.eclipse.aperi.server.handler.gui.UpdateJobStatusHndlr";
        request.requestData = schHistoryRequestNode;
        GuiClient.doRequest(this, request);
    }

    public void handleResponse(short s, Response response) {
        if (s > 4) {
            return;
        }
        EditableObjectLabel.refresh(this.treeNode, response, this);
        DataDisplayInfo dataDisplayInfo = DataDisplayInfo.getCurrent();
        Enumeration<TreeNode> enumeration = this.treeNode.children();
        while (enumeration.hasMoreElements()) {
            BaseTreeNode baseTreeNode = (BaseTreeNode)enumeration.nextElement();
            DataDisplayInfo dataDisplayInfo2 = baseTreeNode.ddi;
            if (dataDisplayInfo2 == null) continue;
            dataDisplayInfo2.nullOutPanel();
            if (dataDisplayInfo2 != dataDisplayInfo) continue;
            dataDisplayInfo2.reDisplay();
        }
    }

    public void makeRunDDI() {
        Object[] objectArray = new Object[]{this.description};
        String string = MessageLog.getMessageNoID("JSS1000L", objectArray);
        new EditableObjectHistoryRunDDI(this.scheduleID, this.treeNode, string);
    }

    public BaseTreeNode makeChild(NameList nameList) {
        EditableObjectHistoryNode editableObjectHistoryNode = new EditableObjectHistoryNode(nameList, this.description){};
        ((EditableObjectHistoryNode)editableObjectHistoryNode).setResourceType(nameList.nlInfo);
        return editableObjectHistoryNode;
    }

    public int getKey(NameList nameList) {
        return nameList.nlID2;
    }

    public BaseTreeNode getTreeNode() {
        return this.treeNode;
    }
}

