/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.aperi.TStorm.common.ProbePing;
import org.eclipse.aperi.TStorm.gui.GroupSelector;
import org.eclipse.aperi.TStorm.gui.PingAlertEditor;
import org.eclipse.aperi.TStorm.gui.PingOptionsEditor;
import org.eclipse.aperi.TStorm.server.guireq.GuiRequest;
import org.eclipse.aperi.common.CreateHeader;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.CreateHeaderPanel;
import org.eclipse.aperi.gui.CreateOrEdit;
import org.eclipse.aperi.gui.CreateOrEditDDI;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.JSgcScheduleCreateWhenData;
import org.eclipse.aperi.gui.ObjectChangeListener;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class PingCreateOrEdit
implements CreateOrEdit,
ChangeListener,
GuiRequestor,
ObjectChangeListener {
    private static final int COMPUTERS_TAB = 0;
    private static final int SCHEDULE_TAB = 1;
    private static final int OPTIONS_TAB = 2;
    private static final int ALERT_TAB = 3;
    private CreateOrEditDDI DDI;
    private CreateHeaderPanel createHeaderPanel;
    private JTabbedPane tabs;
    private JSgcScheduleCreateWhenData scheduleEditor;
    private GroupSelector selector;
    private PingAlertEditor alertEditor;
    private PingOptionsEditor optionsEditor;

    public PingCreateOrEdit(CreateOrEditDDI createOrEditDDI) {
        this.DDI = createOrEditDDI;
        this.DDI.showEnabled = true;
        this.DDI.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
        this.DDI.subType = "org.eclipse.aperi.server.handler.gui.GuiProbeHndlr";
    }

    public void build(int n) {
        if (n > 0) {
            this.submitRetrieve(n);
        } else {
            this.makeNew();
        }
    }

    public void build(CreateHeader createHeader) {
        ProbePing probePing = (ProbePing)createHeader;
        this.create(probePing);
    }

    public CreateHeader getData() {
        this.scheduleEditor.getData();
        ProbePing probePing = (ProbePing)this.createHeaderPanel.getData();
        NameList[] nameListArray = this.selector.getData();
        probePing.pbComputers = nameListArray[0];
        probePing.pbComputerGroups = nameListArray[1];
        probePing.pbClusters = nameListArray[2];
        probePing.pbAllComputers = this.selector.allMembersSelected;
        probePing.pbAlert = this.alertEditor.getData();
        probePing.arguments = this.optionsEditor.getData();
        return probePing;
    }

    public void validate(CreateHeader createHeader) throws GeneralException {
        ProbePing probePing = (ProbePing)createHeader;
        if (probePing.isEmpty()) {
            String string = MessageLog.getMessageNoTS("STG4048E", null);
            this.DDI.exceptionTabIndex = 0;
            throw new GeneralException(string);
        }
        this.DDI.exceptionTabIndex = 1;
        this.scheduleEditor.validate(probePing);
        this.DDI.exceptionTabIndex = 3;
        this.alertEditor.validateData();
    }

    private void submitRetrieve(int n) {
        ProbePing probePing = new ProbePing(17);
        probePing.ID = n;
        Request request = GuiRequest.newRequest("org.eclipse.aperi.server.handler.gui.GuiProbeHndlr", probePing);
        request.flags = (byte)4;
        GuiClient.doRequest(this, request);
    }

    private void makeNew() {
        ProbePing probePing = new ProbePing(17);
        this.create(probePing);
        this.DDI.oldCreateHeader = (CreateHeader)probePing.clone();
        ((ProbePing)this.DDI.oldCreateHeader).pbAlert = this.alertEditor.getData();
    }

    private void create(ProbePing probePing) {
        this.createHeaderPanel = new CreateHeaderPanel(probePing, this, this.DDI);
        this.scheduleEditor = new JSgcScheduleCreateWhenData(17, this.DDI);
        JPanel jPanel = this.scheduleEditor.build(probePing);
        this.selector = new GroupSelector(1, probePing.pbComputers, probePing.pbComputerGroups, probePing.pbClusters, probePing.pbAllComputers, true, true);
        this.optionsEditor = new PingOptionsEditor(probePing.arguments);
        this.alertEditor = probePing.pbAlert == null ? new PingAlertEditor() : new PingAlertEditor(probePing.pbAlert);
        this.tabs = new JTabbedPane();
        this.tabs.setFont(BaseTree.boldFont);
        String string = MessageLog.getMessageNoID("STG4041L");
        this.tabs.addTab(string, this.selector.getComponent());
        string = MessageLog.getMessageNoID("GUI8222L");
        this.tabs.addTab(string, jPanel);
        string = MessageLog.getMessageNoID("STG4069L");
        this.tabs.addTab(string, this.optionsEditor.getComponent());
        string = MessageLog.getMessageNoID("STG4036L");
        this.tabs.addTab(string, this.alertEditor.getComponent());
        this.tabs.setSelectedIndex(this.DDI.tabIndex);
        this.tabs.addChangeListener(this);
        this.createHeaderPanel.add((Component)this.tabs, "Center");
        this.DDI.panel = this.createHeaderPanel;
        this.DDI.show();
        this.createHeaderPanel.gettingFocus();
        this.DDI.addObjectChangeListener(this, (short)0);
    }

    public void replace(CreateHeader createHeader) {
        ProbePing probePing = (ProbePing)createHeader;
        this.createHeaderPanel.replace(probePing);
        this.scheduleEditor.replace(probePing);
        this.selector.replace(probePing.pbComputers, probePing.pbComputerGroups, probePing.pbClusters, probePing.pbAllComputers);
    }

    public void losingFocus() {
        this.createHeaderPanel.losingFocus();
    }

    public void gettingFocus() {
        this.createHeaderPanel.gettingFocus();
    }

    public void showTab(int n) {
        this.tabs.setSelectedIndex(n);
    }

    public CreateHeaderPanel getHeaderPanel() {
        return this.createHeaderPanel;
    }

    public void handleResponse(short s, Response response) {
        if (s > 4) {
            return;
        }
        ProbePing probePing = (ProbePing)response.responseData;
        this.DDI.oldCreateHeader = (CreateHeader)probePing.clone();
        this.create(probePing);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.DDI.tabIndex = this.tabs.getSelectedIndex();
    }

    public void changeOccurred(int n, NameList nameList) {
        if (n == 100) {
            this.selector.invalidateGroups(nameList.nlInfo);
        } else if (n == 1) {
            this.selector.addGroup(nameList);
        }
    }

    public String getHelpID(int n) {
        switch (n) {
            case 0: {
                return "mopi5";
            }
            case 1: {
                return "mopi10";
            }
            case 2: {
                return "mopi15";
            }
            case 3: {
                return "mopi20";
            }
        }
        return null;
    }
}

