/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.io.Serializable;
import java.util.TreeSet;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import org.eclipse.aperi.TStorm.common.GroupDefinition;
import org.eclipse.aperi.TStorm.gui.FSSelector;
import org.eclipse.aperi.TStorm.server.guireq.GuiListReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiRequest;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.TreeSelector;
import org.eclipse.aperi.gui.TreeSelectorNode;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class ProbeGroupSelector
implements TreeExpansionListener,
GuiRequestor {
    private TreeSelector selector;
    private JTree selectedTree;
    private JTree sourceTree;
    private NameList compSelections;
    private NameList compGroupSelections;
    private NameList clusterSelections;
    private NameList diskSelections;
    private NameList diskGroupSelections;
    private NameList fabricSelections;
    private NameList fabricGroupSelections;
    private NameList librariesSelections;
    private NameList librariesGroupSelections;
    private NameList rootName;
    public boolean allCompsSelected;
    public boolean allDisksSelected;
    public boolean allFabricsSelected;
    public boolean allLibrariesSelected;
    private TreeSet compIncludeSet = new TreeSet();
    private TreeSet compExcludeSet = new TreeSet();
    private TreeSet diskIncludeSet = new TreeSet();
    private TreeSet diskExcludeSet = new TreeSet();
    private TreeSet fabricIncludeSet = new TreeSet();
    private TreeSet fabricExcludeSet = new TreeSet();
    private TreeSet libraryIncludeSet = new TreeSet();
    private TreeSet libraryExcludeSet = new TreeSet();
    private JTree expansionTree;
    private TreeSelectorNode sourceCompGroupLabel;
    private TreeSelectorNode sourceDiskGroupLabel;
    private TreeSelectorNode sourceFabricGroupLabel;
    private TreeSelectorNode sourceLibraryGroupLabel;
    private TreeSelectorNode expansionNode;
    private DefaultTreeModel expansionModel;
    private boolean clusterExpanding;
    private boolean groupExpanding;
    private static final int ROOT_ID = -10;
    private static final int COMP_GROUP_ID = -9;
    private static final int COMP_ID = -8;
    private static final int CLUSTER_ID = -7;
    private static final int DISK_GROUP_ID = -2;
    private static final int DISK_ID = -1;
    private static final int FABRIC_GROUP_ID = -6;
    private static final int FABRIC_ID = -5;
    private static final int LIBRARIES_ID = -3;
    private static final int LIBRARIES_GROUP_ID = -4;
    private static final int ALL_COMP_ID = Integer.MAX_VALUE;
    private static final int ALL_DISK_ID = 0x7FFFFFFE;
    private static final int ALL_FABRICS_ID = 0x7FFFFFFD;
    private static final int ALL_LIBRARIES_ID = 0x7FFFFFFC;
    public static final int COMP_IX = 0;
    public static final int COMP_GROUP_IX = 1;
    public static final int DISK_IX = 2;
    public static final int DISK_GROUP_IX = 3;
    public static final int CLUSTER_IX = 4;
    public static final int FABRIC_IX = 5;
    public static final int FABRIC_GROUP_IX = 6;
    public static final int LIBRARIES_IX = 7;
    public static final int LIBRARIES_GROUP_IX = 8;
    private static final String COMP_GROUP_MSG = MessageLog.getMessageNoID("STG3012L");
    private static final String COMP_MSG = MessageLog.getMessageNoID("STG4041L");
    private static final String ALL_COMP_MSG = MessageLog.getMessageNoID("STG3100L");
    private static final String CLUSTER_MSG = Util.getString("LABEL_CLUSTERS");
    private static final String DISK_GROUP_MSG = MessageLog.getMessageNoID("STG5500L");
    private static final String DISK_MSG = MessageLog.getMessageNoID("STG4191L");
    private static final String ALL_DISK_MSG = MessageLog.getMessageNoID("STG5501L");
    private static final String FABRIC_GROUP_MSG = MessageLog.getMessageNoID("STG7573L");
    private static final String FABRIC_MSG = MessageLog.getMessageNoID("STG7574L");
    private static final String ALL_FABRICS_MSG = MessageLog.getMessageNoID("STG7575L");
    private static final String LIBRARIES_GROUP_MSG = MessageLog.getMessageNoID("STG7736L");
    private static final String LIBRARY_MSG = MessageLog.getMessageNoID("STG7737L");
    private static final String ALL_LIBRARY_MSG = MessageLog.getMessageNoID("STG7735L");

    public ProbeGroupSelector(NameList nameList, NameList nameList2, NameList nameList3, NameList nameList4, NameList nameList5, NameList nameList6, NameList nameList7, NameList nameList8, NameList nameList9, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.compSelections = nameList;
        this.compGroupSelections = nameList2;
        this.clusterSelections = nameList3;
        this.diskSelections = nameList4;
        this.diskGroupSelections = nameList5;
        this.fabricSelections = nameList6;
        this.fabricGroupSelections = nameList7;
        this.librariesSelections = nameList8;
        this.librariesGroupSelections = nameList9;
        this.allCompsSelected = bl;
        this.allDisksSelected = bl2;
        this.allFabricsSelected = bl3;
        this.allLibrariesSelected = bl4;
    }

    public JPanel getComponent() {
        if (this.selector != null) {
            return this.selector;
        }
        this.buildSourceTree();
        this.buildSelectedTree();
        this.selector = new TreeSelector(this.sourceTree, this.selectedTree);
        return this.selector;
    }

    public NameList[] getData() {
        NameList[] nameListArray = new NameList[9];
        NameList[] nameListArray2 = new NameList[9];
        NameList nameList = null;
        this.allCompsSelected = false;
        this.allDisksSelected = false;
        this.allFabricsSelected = false;
        this.allLibrariesSelected = false;
        NameList nameList2 = this.selector.getNameList();
        while (nameList2 != null) {
            int n = -999;
            if (nameList2.nlInfo == 0) {
                n = 1;
            } else if (nameList2.nlInfo == 1) {
                n = 0;
            } else if (nameList2.nlInfo == 77) {
                n = 3;
            } else if (nameList2.nlInfo == 78) {
                n = 2;
            } else if (nameList2.nlInfo == 99) {
                n = 4;
            }
            if (nameList2.nlInfo == 113) {
                n = 6;
            } else if (nameList2.nlInfo == 114) {
                n = 5;
            } else if (nameList2.nlInfo == 13) {
                this.allCompsSelected = true;
            } else if (nameList2.nlInfo == 54) {
                this.allDisksSelected = true;
            } else if (nameList2.nlInfo == 115) {
                this.allFabricsSelected = true;
            } else if (nameList2.nlInfo == 133) {
                n = 8;
            } else if (nameList2.nlInfo == 134) {
                n = 7;
            } else if (nameList2.nlInfo == 135) {
                this.allLibrariesSelected = true;
            }
            if (n < 0) {
                nameList2 = nameList2.nlNext;
                continue;
            }
            nameList = nameList2;
            nameList2 = nameList.nlNext;
            nameList.nlNext = null;
            if (nameListArray2[n] == null) {
                nameListArray[n] = nameList;
            } else {
                nameListArray2[n].nlNext = nameList;
            }
            nameListArray2[n] = nameList;
        }
        return nameListArray;
    }

    private void buildSourceTree() {
        TreeSelectorNode treeSelectorNode = this.newRoot();
        this.sourceCompGroupLabel = this.addLabelNode(COMP_GROUP_MSG, -9, treeSelectorNode);
        this.addLabelNode(COMP_MSG, -8, treeSelectorNode);
        this.addLabelNode(CLUSTER_MSG, -7, treeSelectorNode);
        this.sourceFabricGroupLabel = this.addLabelNode(FABRIC_GROUP_MSG, -6, treeSelectorNode);
        this.addLabelNode(FABRIC_MSG, -5, treeSelectorNode);
        this.sourceLibraryGroupLabel = this.addLabelNode(LIBRARIES_GROUP_MSG, -4, treeSelectorNode);
        this.addLabelNode(LIBRARY_MSG, -3, treeSelectorNode);
        this.sourceDiskGroupLabel = this.addLabelNode(DISK_GROUP_MSG, -2, treeSelectorNode);
        this.addLabelNode(DISK_MSG, -1, treeSelectorNode);
        this.sourceTree = new JTree(treeSelectorNode, true);
        this.sourceTree.addTreeExpansionListener(this);
    }

    private TreeSelectorNode buildSelectedTreeStructure() {
        TreeSelectorNode treeSelectorNode = null;
        TreeSelectorNode treeSelectorNode2 = null;
        TreeSelectorNode treeSelectorNode3 = null;
        TreeSelectorNode treeSelectorNode4 = null;
        TreeSelectorNode treeSelectorNode5 = null;
        TreeSelectorNode treeSelectorNode6 = null;
        TreeSelectorNode treeSelectorNode7 = null;
        TreeSelectorNode treeSelectorNode8 = null;
        TreeSelectorNode treeSelectorNode9 = null;
        TreeSelectorNode treeSelectorNode10 = null;
        TreeSelectorNode treeSelectorNode11 = null;
        TreeSelectorNode treeSelectorNode12 = null;
        TreeSelectorNode treeSelectorNode13 = null;
        TreeSelectorNode treeSelectorNode14 = this.newRoot();
        NameList nameList = this.compGroupSelections;
        while (nameList != null) {
            if (treeSelectorNode == null) {
                treeSelectorNode = this.addLabelNode(COMP_GROUP_MSG, -9, treeSelectorNode14);
            }
            treeSelectorNode.add(new TreeSelectorNode(nameList, true, false, true, true, null, true, true));
            nameList = nameList.nlNext;
        }
        this.fillSets(this.compSelections, this.compIncludeSet, this.compExcludeSet, true, false);
        if (this.allCompsSelected || !this.compIncludeSet.isEmpty()) {
            treeSelectorNode2 = this.addLabelNode(COMP_MSG, -8, treeSelectorNode14);
            if (this.allCompsSelected) {
                this.addAllMembersNode(ALL_COMP_MSG, Integer.MAX_VALUE, 13, treeSelectorNode2, true);
            }
            this.addTreeSet(treeSelectorNode2, this.compIncludeSet);
        }
        if (!this.compExcludeSet.isEmpty()) {
            treeSelectorNode3 = TreeSelector.makeExcludeRoot();
            treeSelectorNode14.add(treeSelectorNode3);
            this.addTreeSet(treeSelectorNode3, this.compExcludeSet);
        }
        nameList = this.clusterSelections;
        while (nameList != null) {
            if (treeSelectorNode4 == null) {
                treeSelectorNode4 = this.addLabelNode(CLUSTER_MSG, -7, treeSelectorNode14);
            }
            treeSelectorNode4.add(new TreeSelectorNode(nameList, true, false, true, true, null, false, true));
            nameList = nameList.nlNext;
        }
        nameList = this.fabricGroupSelections;
        while (nameList != null) {
            if (treeSelectorNode8 == null) {
                treeSelectorNode8 = this.addLabelNode(FABRIC_GROUP_MSG, -6, treeSelectorNode14);
            }
            treeSelectorNode8.add(new TreeSelectorNode(nameList, true, false, true, true, null));
            nameList = nameList.nlNext;
        }
        this.fillSets(this.fabricSelections, this.fabricIncludeSet, this.fabricExcludeSet, true, false);
        if (this.allFabricsSelected || !this.fabricIncludeSet.isEmpty()) {
            treeSelectorNode9 = this.addLabelNode(FABRIC_MSG, -5, treeSelectorNode14);
            if (this.allFabricsSelected) {
                this.addAllMembersNode(ALL_FABRICS_MSG, 0x7FFFFFFD, 115, treeSelectorNode9, true);
            }
            this.addTreeSet(treeSelectorNode9, this.fabricIncludeSet);
        }
        if (!this.fabricExcludeSet.isEmpty()) {
            treeSelectorNode10 = TreeSelector.makeExcludeRoot();
            treeSelectorNode14.add(treeSelectorNode10);
            this.addTreeSet(treeSelectorNode10, this.fabricExcludeSet);
        }
        if (!GuiUtil.isAnyDiskArrayInstalled()) {
            return treeSelectorNode14;
        }
        nameList = this.diskGroupSelections;
        while (nameList != null) {
            if (treeSelectorNode5 == null) {
                treeSelectorNode5 = this.addLabelNode(DISK_GROUP_MSG, -2, treeSelectorNode14);
            }
            treeSelectorNode5.add(new TreeSelectorNode(nameList, true, false, true, true, null));
            nameList = nameList.nlNext;
        }
        this.fillSets(this.diskSelections, this.diskIncludeSet, this.diskExcludeSet, true, false);
        if (this.allDisksSelected || !this.diskIncludeSet.isEmpty()) {
            treeSelectorNode6 = this.addLabelNode(DISK_MSG, -1, treeSelectorNode14);
            if (this.allDisksSelected) {
                this.addAllMembersNode(ALL_DISK_MSG, 0x7FFFFFFE, 54, treeSelectorNode6, true);
            }
            this.addTreeSet(treeSelectorNode6, this.diskIncludeSet);
        }
        if (!this.diskExcludeSet.isEmpty()) {
            treeSelectorNode7 = TreeSelector.makeExcludeRoot();
            treeSelectorNode14.add(treeSelectorNode7);
            this.addTreeSet(treeSelectorNode7, this.diskExcludeSet);
        }
        nameList = this.librariesGroupSelections;
        while (nameList != null) {
            if (treeSelectorNode11 == null) {
                treeSelectorNode11 = this.addLabelNode(LIBRARIES_GROUP_MSG, -4, treeSelectorNode14);
            }
            treeSelectorNode11.add(new TreeSelectorNode(nameList, true, false, true, true, null));
            nameList = nameList.nlNext;
        }
        this.fillSets(this.librariesSelections, this.libraryIncludeSet, this.libraryExcludeSet, true, false);
        if (this.allLibrariesSelected || !this.libraryIncludeSet.isEmpty()) {
            treeSelectorNode12 = this.addLabelNode(LIBRARY_MSG, -3, treeSelectorNode14);
            if (this.allLibrariesSelected) {
                this.addAllMembersNode(ALL_LIBRARY_MSG, 0x7FFFFFFC, 135, treeSelectorNode12, true);
            }
            this.addTreeSet(treeSelectorNode12, this.libraryIncludeSet);
        }
        if (!this.libraryExcludeSet.isEmpty()) {
            treeSelectorNode13 = TreeSelector.makeExcludeRoot();
            treeSelectorNode14.add(treeSelectorNode13);
            this.addTreeSet(treeSelectorNode13, this.libraryExcludeSet);
        }
        return treeSelectorNode14;
    }

    private void buildSelectedTree() {
        TreeSelectorNode treeSelectorNode = this.buildSelectedTreeStructure();
        this.selectedTree = new JTree(treeSelectorNode, true);
        this.selectedTree.addTreeExpansionListener(this);
    }

    public void replace(NameList nameList, NameList nameList2, NameList nameList3, NameList nameList4, NameList nameList5, NameList nameList6, NameList nameList7, NameList nameList8, NameList nameList9, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.compSelections = nameList;
        this.compGroupSelections = nameList2;
        this.clusterSelections = nameList3;
        this.diskSelections = nameList4;
        this.diskGroupSelections = nameList5;
        this.fabricSelections = nameList6;
        this.fabricGroupSelections = nameList7;
        this.librariesSelections = nameList8;
        this.librariesGroupSelections = nameList9;
        this.allCompsSelected = bl;
        this.allDisksSelected = bl2;
        this.allFabricsSelected = bl3;
        this.allLibrariesSelected = bl4;
        this.compIncludeSet.clear();
        this.compExcludeSet.clear();
        this.diskIncludeSet.clear();
        this.diskExcludeSet.clear();
        this.fabricIncludeSet.clear();
        this.fabricExcludeSet.clear();
        this.libraryIncludeSet.clear();
        this.libraryExcludeSet.clear();
        TreeSelectorNode treeSelectorNode = this.buildSelectedTreeStructure();
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(treeSelectorNode, true);
        this.selectedTree.setModel(defaultTreeModel);
        this.selector.setUpExcludes();
    }

    private void fillSets(NameList nameList, TreeSet treeSet, TreeSet treeSet2, boolean bl, boolean bl2) {
        boolean bl3 = true;
        TreeSelectorNode treeSelectorNode = null;
        while (nameList != null) {
            boolean bl4;
            boolean bl5;
            TreeSet treeSet3;
            if (Constants.isVirtualServer(nameList.nlID2)) {
                nameList = nameList.nlNext;
                continue;
            }
            if ((nameList.nlState & 1) != 0) {
                treeSet3 = treeSet2;
                bl5 = false;
                bl4 = true;
            } else {
                treeSet3 = treeSet;
                bl5 = bl;
                bl4 = bl2;
            }
            if (this.clusterExpanding) {
                bl3 = false;
            }
            treeSelectorNode = new TreeSelectorNode(nameList, bl5, bl4, false, false, null, bl3, true);
            if (this.clusterExpanding || this.groupExpanding) {
                treeSelectorNode.setButtonFlag(false);
            }
            treeSet3.add(treeSelectorNode);
            nameList = nameList.nlNext;
        }
    }

    private void addTreeSet(TreeSelectorNode treeSelectorNode, TreeSet treeSet) {
        for (TreeSelectorNode treeSelectorNode2 : treeSet) {
            treeSelectorNode.add(treeSelectorNode2);
        }
    }

    public void invalidateGroups(short s) {
        FSSelector.invalidateGroups(this.selector, this.selectedTree, s);
    }

    public void addGroup(NameList nameList) {
        TreeSelectorNode treeSelectorNode;
        if (nameList.nlID == -9) {
            treeSelectorNode = this.sourceCompGroupLabel;
        } else if (nameList.nlID == -2) {
            treeSelectorNode = this.sourceDiskGroupLabel;
        } else if (nameList.nlID == -6) {
            treeSelectorNode = this.sourceFabricGroupLabel;
        } else if (nameList.nlID == -4) {
            treeSelectorNode = this.sourceLibraryGroupLabel;
        } else {
            return;
        }
        if (!treeSelectorNode.childrenFetched) {
            return;
        }
        NameList nameList2 = (NameList)nameList.clone();
        TreeSelectorNode treeSelectorNode2 = new TreeSelectorNode(nameList2, true, false, true, true, null);
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.sourceTree.getModel();
        this.selector.addChild(defaultTreeModel, treeSelectorNode, treeSelectorNode2);
    }

    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        this.clusterExpanding = false;
        this.groupExpanding = false;
        TreePath treePath = treeExpansionEvent.getPath();
        this.expansionNode = (TreeSelectorNode)treePath.getLastPathComponent();
        if (this.expansionNode.childrenFetched) {
            return;
        }
        NameList nameList = this.expansionNode.getNameList();
        this.expansionTree = (JTree)treeExpansionEvent.getSource();
        this.expansionModel = (DefaultTreeModel)this.expansionTree.getModel();
        if (this.expansionTree == this.sourceTree) {
            if (nameList.nlID == -9) {
                this.sendRequest((short)0, -1);
            } else if (nameList.nlID == -8) {
                this.sendRequest((short)1, -1);
            } else if (nameList.nlID == -2) {
                this.sendRequest((short)77, -1);
            } else if (nameList.nlID == -1) {
                this.sendRequest((short)78, -1);
            } else if (nameList.nlID == -7) {
                this.sendRequest((short)101, -1);
            } else if (nameList.nlID == -5) {
                this.sendRequest((short)114, -1);
            } else if (nameList.nlID == -6) {
                this.sendRequest((short)113, -1);
            } else if (nameList.nlID == -3) {
                this.sendRequest((short)134, -1);
            } else if (nameList.nlID == -4) {
                this.sendRequest((short)133, -1);
            }
        } else if (nameList.nlInfo == 0) {
            this.sendRequest((short)1, nameList.nlID);
            this.groupExpanding = true;
        } else if (nameList.nlInfo == 99) {
            this.clusterExpanding = true;
            this.sendRequest(nameList.nlInfo, nameList.nlID);
        } else if (nameList.nlInfo == 113) {
            this.sendRequest((short)114, nameList.nlID);
            this.groupExpanding = true;
        } else if (nameList.nlInfo == 133) {
            this.sendRequest((short)134, nameList.nlID);
            this.groupExpanding = true;
        } else if (nameList.nlInfo == 13) {
            this.sendRequest((short)1, -1);
        } else if (nameList.nlInfo == 77) {
            this.sendRequest((short)78, nameList.nlID);
            this.groupExpanding = true;
        } else if (nameList.nlInfo == 54) {
            this.sendRequest((short)78, -1);
        } else if (nameList.nlInfo == 115) {
            this.sendRequest((short)114, -1);
        } else if (nameList.nlInfo == 135) {
            this.sendRequest((short)134, -1);
        }
    }

    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
    }

    protected GuiListReq makeListRequestData(short s, int n) {
        GuiListReq guiListReq = new GuiListReq();
        if (s == 99) {
            guiListReq.listRequested = 11;
        } else {
            if (s == 101) {
                s = (short)99;
            }
            guiListReq.listRequested = 10000 + s;
            guiListReq.groupID = n;
        }
        return guiListReq;
    }

    protected GroupDefinition makeGroupRequestData(short s, int n) {
        GroupDefinition groupDefinition = new GroupDefinition();
        groupDefinition.groupType = s;
        groupDefinition.ID = n;
        return groupDefinition;
    }

    private void sendRequest(short s, int n) {
        Request request;
        if (s == 99) {
            GroupDefinition groupDefinition = this.makeGroupRequestData(s, n);
            request = GuiRequest.newRequest("org.eclipse.aperi.server.handler.gui.GroupDefHndlr.Definition", groupDefinition);
        } else {
            GuiListReq guiListReq = this.makeListRequestData(s, n);
            request = GuiRequest.newRequest("org.eclipse.aperi.server.handler.gui.GuiListHndlr", guiListReq);
        }
        GuiClient.doRequest(this, request);
    }

    public void handleResponse(short s, Response response) {
        Cloneable cloneable;
        if (s > 4) {
            return;
        }
        boolean bl = true;
        Serializable serializable = response.responseData;
        NameList nameList = null;
        if (serializable instanceof GroupDefinition) {
            cloneable = (GroupDefinition)response.responseData;
            nameList = cloneable.members;
        } else {
            nameList = (NameList)response.responseData;
        }
        if (nameList == null) {
            return;
        }
        this.expansionNode.childrenFetched = true;
        this.expansionNode.removeAllChildren();
        if (nameList.nlInfo == 0 || nameList.nlInfo == 113 || nameList.nlInfo == 77 || nameList.nlInfo == 99 || nameList.nlInfo == 133) {
            if (nameList.nlInfo == 99) {
                bl = false;
            }
            while (nameList != null) {
                cloneable = new TreeSelectorNode(nameList, true, false, false, true, null, bl, true);
                this.expansionNode.add((MutableTreeNode)((Object)cloneable));
                nameList = nameList.nlNext;
            }
        } else {
            boolean bl2;
            boolean bl3 = this.expansionTree == this.sourceTree;
            boolean bl4 = bl2 = !bl3;
            if (nameList.nlInfo == 1) {
                if (bl3) {
                    this.addAllMembersNode(ALL_COMP_MSG, Integer.MAX_VALUE, 13, this.expansionNode, false);
                }
                this.compIncludeSet.clear();
                this.fillSets(nameList, this.compIncludeSet, this.compExcludeSet, bl3, bl2);
                this.addTreeSet(this.expansionNode, this.compIncludeSet);
            } else if (nameList.nlInfo == 114) {
                if (bl3) {
                    this.addAllMembersNode(ALL_FABRICS_MSG, 0x7FFFFFFD, 115, this.expansionNode, false);
                }
                this.fabricIncludeSet.clear();
                this.fillSets(nameList, this.fabricIncludeSet, this.fabricExcludeSet, bl3, bl2);
                this.addTreeSet(this.expansionNode, this.fabricIncludeSet);
            } else if (nameList.nlInfo == 134) {
                if (bl3) {
                    this.addAllMembersNode(ALL_LIBRARY_MSG, 0x7FFFFFFC, 135, this.expansionNode, false);
                }
                this.libraryIncludeSet.clear();
                this.fillSets(nameList, this.libraryIncludeSet, this.libraryExcludeSet, bl3, bl2);
                this.addTreeSet(this.expansionNode, this.libraryIncludeSet);
            } else {
                if (bl3) {
                    this.addAllMembersNode(ALL_DISK_MSG, 0x7FFFFFFE, 54, this.expansionNode, false);
                }
                this.diskIncludeSet.clear();
                this.fillSets(nameList, this.diskIncludeSet, this.diskExcludeSet, bl3, bl2);
                this.addTreeSet(this.expansionNode, this.diskIncludeSet);
            }
        }
        this.expansionModel.nodeStructureChanged(this.expansionNode);
        if (this.expansionTree == this.selectedTree) {
            this.selector.pruneExcluded(this.expansionNode);
        } else {
            this.selector.pruneSelected(this.expansionNode, this.expansionNode.hiOrderSortKey);
        }
    }

    private TreeSelectorNode newRoot() {
        if (this.rootName == null) {
            this.rootName = this.newNameList("", -10, -1);
        }
        return new TreeSelectorNode(this.rootName, false, false, true);
    }

    private TreeSelectorNode addLabelNode(String string, int n, TreeSelectorNode treeSelectorNode) {
        NameList nameList = this.newNameList(string, n, -1);
        TreeSelectorNode treeSelectorNode2 = new TreeSelectorNode(nameList, false, false, true);
        treeSelectorNode2.setButtonFlag(false);
        treeSelectorNode2.setSortKey(n);
        treeSelectorNode.add(treeSelectorNode2);
        return treeSelectorNode2;
    }

    private void addAllMembersNode(String string, int n, int n2, TreeSelectorNode treeSelectorNode, boolean bl) {
        NameList nameList = this.newNameList(string, n, n2);
        TreeSelectorNode treeSelectorNode2 = new TreeSelectorNode(nameList, true, false, bl, true, null);
        treeSelectorNode2.setSortKey(-1);
        treeSelectorNode.add(treeSelectorNode2);
    }

    private NameList newNameList(String string, int n, int n2) {
        NameList nameList = new NameList();
        nameList.nlName = string;
        nameList.nlID = n;
        nameList.nlInfo = (short)n2;
        return nameList;
    }
}

