/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.eclipse.aperi.TStorm.common.ReportDataAdjuster;
import org.eclipse.aperi.TStorm.gui.DisplaysChartPopupInterface;
import org.eclipse.aperi.TStorm.gui.HistoryChart;
import org.eclipse.aperi.TStorm.gui.ReportCreateOrEdit;
import org.eclipse.aperi.TStorm.gui.ReportPrefsManager;
import org.eclipse.aperi.TStorm.gui.ReportingObjectBuilder;
import org.eclipse.aperi.TStorm.gui.ReportingSelectionDriver;
import org.eclipse.aperi.TStorm.gui.ReportingTreeNode;
import org.eclipse.aperi.TStorm.gui.SavedReportDDI;
import org.eclipse.aperi.TStorm.gui.SavedReportNode;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiSavedReportReq;
import org.eclipse.aperi.TStorm.server.guireq.ReportPrefs;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.PrintOptions;
import org.eclipse.aperi.common.TableCellStrings;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.gui.BaseTableModel;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.BaseTreeNode;
import org.eclipse.aperi.gui.BlackLabel;
import org.eclipse.aperi.gui.ChangeManager;
import org.eclipse.aperi.gui.DataDisplayInfo;
import org.eclipse.aperi.gui.ExportTableData;
import org.eclipse.aperi.gui.FlexibleTable;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.HistoryChoiceInterface;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.IconFactory;
import org.eclipse.aperi.gui.ObjectChangeListener;
import org.eclipse.aperi.gui.PrintComponent;
import org.eclipse.aperi.gui.PrintOutputChooser;
import org.eclipse.aperi.gui.PrintPreviewPanel;
import org.eclipse.aperi.gui.PrintPreviewable;
import org.eclipse.aperi.gui.PrintTableData;
import org.eclipse.aperi.gui.TJCTableMouseInterface;
import org.eclipse.aperi.gui.charting.AperiChart;
import org.eclipse.aperi.gui.tables.MegaTable;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class ReportingDDI
extends SavedReportDDI
implements ActionListener,
ChangeListener,
GuiRequestor,
ObjectChangeListener {
    String firstReportDescription;
    JTabbedPane tabPanel;
    TabNode tabNodeHead;
    TabNode tabNodeTail;
    Object[] objectName;
    int selectedIndex;
    public boolean jumpToChart;
    private int selectionServices;
    protected byte productCode;
    private boolean jumpStart;
    private boolean saveEnabled;
    private boolean exportEnabled;
    private boolean changeListening;
    private boolean saveAs;
    private boolean showing;
    protected boolean productAvailable = true;
    boolean selectionError;
    boolean listNeeded;
    String selectionTabTip;
    String selectionTabTitle;
    String reportTabTitle;
    ReportingSelectionDriver selectionPanel;
    static final String CHART = MessageLog.getMessageNoID("STG5052L");
    static final String CHARTPOPUP = MessageLog.getMessageNoID("STG2091T");
    static final String EXPORT = MessageLog.getMessageNoID("GUI5077T");
    static final String ROWS = MessageLog.getMessageNoID("STG5262L");
    static final int MAX_REPORT_NODE = 776;
    static final int CHART_NODE = 777;
    static final int OBJECT_NODE = 999;
    private GridBagConstraints gbc = new GridBagConstraints();
    protected FlexibleTable printableTable;
    protected PageFormat pf;
    protected Graphics g;
    protected IGuiMain guiMain = GuiManager.getGuiManager().getGuiMain();

    public ReportingDDI(GuiSavedReportReq guiSavedReportReq, BaseTreeNode baseTreeNode) {
        this(guiSavedReportReq.grr, baseTreeNode);
        this.gsrr = guiSavedReportReq;
        this.setDescription(String.valueOf(guiSavedReportReq.creator) + "." + guiSavedReportReq.getName());
        this.selectedIndex = 1;
        this.jumpStart = true;
    }

    public ReportingDDI(GuiReportReq guiReportReq, BaseTreeNode baseTreeNode) {
        this.grr = guiReportReq;
        this.productAvailable = true;
        this.treeNode = baseTreeNode;
        this.selectionServices = ((ReportingTreeNode)this.treeNode).selectionServices;
        this.productCode = ((ReportingTreeNode)this.treeNode).productCode;
        this.displayInScrollPane = false;
        this.setDescription(GuiReportReq.guiClasses[guiReportReq.reportType][2] == GuiReportReq.subtypeTreeLabels[guiReportReq.reportSubtype][0] ? "" : String.valueOf(MessageLog.getMessageNoID(GuiReportReq.guiClasses[guiReportReq.reportType][2])) + Util.getString("COLON") + MessageLog.getMessageNoID(GuiReportReq.subtypeTreeLabels[guiReportReq.reportSubtype][0]));
        this.objectName = new Object[1];
        if (this.selectionServices == 4) {
            this.reportTabTitle = MessageLog.getMessageNoID(GuiReportReq.guiClasses[guiReportReq.reportType][2]);
            if (this.getDescription().equals("")) {
                this.setDescription(this.reportTabTitle);
            }
            this.objectName[0] = this.reportTabTitle;
        } else {
            this.setTabTitleAndObjectName();
        }
        this.firstReportDescription = this.getDescription();
        this.helpID = guiReportReq.reportSubtype == 15 && guiReportReq.reportType == 31 && guiReportReq.profile == 24 ? "mrsys1" : GuiReportReq.guiClasses[guiReportReq.reportType][4];
        this.selectionTabTip = MessageLog.getMessageNoID("STG5010L", this.objectName);
        this.selectionTabTitle = MessageLog.getMessageNoID("STG5049L");
        if (this.guiMain.getUserPrefs().tabToDisplay != 0) {
            this.selectedIndex = 1;
            this.jumpStart = true;
            if (this.guiMain.getUserPrefs().tabToDisplay == 2) {
                this.jumpToChart = true;
            }
            if (guiReportReq.profile == 0) {
                this.setJumpPrefs();
            }
        }
    }

    private void setTabTitleAndObjectName() {
        switch (this.grr.reportSubtype) {
            case 8: {
                this.objectName[0] = MessageLog.getMessageNoID("STG3143L");
                this.reportTabTitle = MessageLog.getMessageNoID("STG2016L");
                break;
            }
            case 9: {
                this.objectName[0] = MessageLog.getMessageNoID("STG3116T");
                this.reportTabTitle = MessageLog.getMessageNoID("STG3117L");
                break;
            }
            case 10: {
                this.objectName[0] = MessageLog.getMessageNoID("STG3135T");
                this.reportTabTitle = MessageLog.getMessageNoID("STG1006L");
                break;
            }
            case 11: {
                this.objectName[0] = MessageLog.getMessageNoID("STG3124T");
                this.reportTabTitle = MessageLog.getMessageNoID("STG4032L");
                break;
            }
            case 12: {
                this.objectName[0] = MessageLog.getMessageNoID("STG1102L");
                this.reportTabTitle = MessageLog.getMessageNoID("STG4041L");
                break;
            }
            case 13: {
                this.objectName[0] = MessageLog.getMessageNoID("STG3125T");
                this.reportTabTitle = MessageLog.getMessageNoID("STG3012L");
                break;
            }
            case 14: {
                this.objectName[0] = MessageLog.getMessageNoID("STG1104L");
                this.reportTabTitle = MessageLog.getMessageNoID("STG5004L");
                break;
            }
            case 15: {
                this.objectName[0] = MessageLog.getMessageNoID("STG2038L");
                this.reportTabTitle = MessageLog.getMessageNoID("STG2038L");
                break;
            }
            case 27: {
                this.objectName[0] = MessageLog.getMessageNoID("STG1240L");
                this.reportTabTitle = MessageLog.getMessageNoID("STG1004L");
                break;
            }
            case 16: {
                this.objectName[0] = MessageLog.getMessageNoID("STG0022T");
                this.reportTabTitle = MessageLog.getMessageNoID("STG3154L");
                break;
            }
            case 6: {
                this.objectName[0] = MessageLog.getMessageNoID("STG3122T");
                this.reportTabTitle = MessageLog.getMessageNoID("STG3123L");
                break;
            }
            case 30: {
                this.objectName[0] = MessageLog.getMessageNoID("STG2019L");
                this.reportTabTitle = MessageLog.getMessageNoID("STG2020L");
                break;
            }
            case 74: {
                this.objectName[0] = MessageLog.getMessageNoID("STG4201L");
                this.reportTabTitle = MessageLog.getMessageNoID("STG4197L");
                break;
            }
            case 75: 
            case 109: {
                this.objectName[0] = MessageLog.getMessageNoID("STG7620L");
                this.reportTabTitle = MessageLog.getMessageNoID("STG7743L");
                break;
            }
            case 76: {
                this.objectName[0] = MessageLog.getMessageNoID("STG1240L");
                this.reportTabTitle = MessageLog.getMessageNoID("STG1004L");
                break;
            }
            case 77: 
            case 89: 
            case 90: {
                this.objectName[0] = MessageLog.getMessageNoID("STG4201L");
                this.reportTabTitle = MessageLog.getMessageNoID("STG4191L");
                break;
            }
            case 73: {
                this.objectName[0] = MessageLog.getMessageNoID("STG4203L");
                this.reportTabTitle = MessageLog.getMessageNoID("STG4199L");
                break;
            }
            case 82: {
                this.objectName[0] = MessageLog.getMessageNoID("STG1136L");
                this.reportTabTitle = MessageLog.getMessageNoID("STG1149L");
                break;
            }
            case 101: {
                this.objectName[0] = MessageLog.getMessageNoID("STG1136L");
                this.reportTabTitle = MessageLog.getMessageNoID("STG3913L");
                break;
            }
            case 102: {
                this.objectName[0] = MessageLog.getMessageNoID("STG3925L");
                this.reportTabTitle = MessageLog.getMessageNoID("STG3914L");
                break;
            }
            case 103: {
                this.objectName[0] = MessageLog.getMessageNoID("STG3925L");
                this.reportTabTitle = MessageLog.getMessageNoID("STG3915L");
                break;
            }
            case 104: {
                this.objectName[0] = MessageLog.getMessageNoID("STG3925L");
                this.reportTabTitle = MessageLog.getMessageNoID("STG3916L");
                break;
            }
            default: {
                this.objectName[0] = MessageLog.getMessageNoID("STG6052L");
                this.reportTabTitle = MessageLog.getMessageNoID("STG6053L");
            }
        }
    }

    protected void setJumpPrefs() {
        ReportPrefs reportPrefs = ReportPrefsManager.getOne(this.grr.reportType);
        this.grr.profile = reportPrefs.rpProfileID;
        switch (this.grr.reportSubtype) {
            case 8: {
                this.grr.rowsToReturn = reportPrefs.rpDirMaxRows;
                break;
            }
            case 9: {
                this.grr.rowsToReturn = reportPrefs.rpDirGrpMaxRows;
                break;
            }
            case 10: {
                this.grr.rowsToReturn = reportPrefs.rpFSMaxRows;
                break;
            }
            case 11: {
                this.grr.rowsToReturn = reportPrefs.rpFSGrpMaxRows;
                break;
            }
            case 12: 
            case 82: {
                this.grr.rowsToReturn = reportPrefs.rpComputerMaxRows;
                break;
            }
            case 13: {
                this.grr.rowsToReturn = reportPrefs.rpCompGrpMaxRows;
                break;
            }
            case 14: {
                this.grr.rowsToReturn = reportPrefs.rpDomMaxRows;
                break;
            }
            case 15: {
                this.grr.rowsToReturn = reportPrefs.rpNetMaxRows;
                break;
            }
            case 16: {
                this.grr.rowsToReturn = reportPrefs.rpQuotaMaxRows;
            }
        }
        if (this.grr.reportType == 67) {
            switch (this.grr.reportSubtype) {
                case 12: 
                case 73: {
                    this.grr.bySubtype = 75;
                    break;
                }
                default: {
                    this.grr.bySubtype = 12;
                }
            }
        }
    }

    public void losingFocus() {
        if (!this.showing) {
            if (this.selectionPanel != null && this.gsrr == null) {
                this.selectionPanel.setPrefs();
            }
            if (this.saveEnabled) {
                this.saveEnabled = false;
                this.guiMain.setSaveActionEnabled(false, false);
                this.guiMain.setSaveAsActionEnabled(false, false);
                this.guiMain.setSaveActionToolTip(null);
                this.guiMain.setSaveAsActionToolTip(null);
                this.guiMain.removeSaveActionListener(this);
                this.guiMain.removeSaveAsActionListener(this);
            }
            this.disableExport();
        }
    }

    public void panelToBeNulled() {
        if (this.tabPanel != null) {
            this.selectedIndex = this.tabPanel.getSelectedIndex();
            this.tabPanel = null;
            if (this.selectionPanel != null) {
                try {
                    this.selectionPanel.getData();
                }
                catch (GeneralException generalException) {}
                this.selectionPanel = null;
            }
        }
    }

    public void goingAway() {
        if (this.changeListening) {
            ChangeManager.removeListener(this);
        }
        this.deletePartitions(this.tabNodeHead);
    }

    public void reDisplay() {
        if (!this.productAvailable) {
            return;
        }
        GuiUtil.getUserName();
        if (this.panel == null) {
            Object object;
            this.panel = new JPanel();
            ((JPanel)this.panel).setLayout(new BorderLayout());
            JPopupMenu jPopupMenu = null;
            if (this.treeNode instanceof SavedReportNode) {
                jPopupMenu = this.treeNode.getPopupMenuForButtons();
                object = this.getButtonPanel(jPopupMenu);
                if (this.getActionButtonCount() > 0) {
                    this.panel.add((Component)object, "North");
                }
            }
            this.tabPanel = new JTabbedPane();
            this.tabPanel.setFont(BaseTree.boldFont);
            if (this.selectedIndex > 0) {
                this.listNeeded = true;
                this.tabPanel.insertTab(this.selectionTabTitle, null, new JPanel(), this.selectionTabTip, 0);
            } else {
                this.selectionPanel = new ReportingSelectionDriver(this, this.grr, this.selectionServices, this.objectName);
                this.tabPanel.insertTab(this.selectionTabTitle, null, this.selectionPanel, this.selectionTabTip, 0);
            }
            ((JPanel)this.panel).add((Component)this.tabPanel, "Center");
            if (this.tabNodeHead != null) {
                this.rebuild();
            }
            this.tabPanel.addChangeListener(this);
            object = new Mouser();
            this.tabPanel.addMouseListener((MouseListener)object);
        }
        if (this.jumpStart) {
            this.jumpStart = false;
            this.addFirstReport(this.grr);
        }
        this.showing = true;
        this.show();
        this.showing = false;
        this.checkTab();
        if (!this.saveEnabled) {
            this.saveEnabled = true;
            this.guiMain.setSaveActionEnabled(true, true);
            this.guiMain.setSaveAsActionEnabled(true, true);
            this.guiMain.setSaveActionToolTip(MessageLog.getMessageNoID("GUI5066T"));
            this.guiMain.setSaveAsActionToolTip(MessageLog.getMessageNoID("GUI5067T"));
            this.guiMain.addSaveActionListener(this);
            this.guiMain.addSaveAsActionListener(this);
        }
        if (!this.changeListening) {
            this.changeListening = true;
            ChangeManager.addListener(this, (short)35);
        }
    }

    private void rebuild() {
        int n = 1;
        TabNode tabNode = this.tabNodeHead;
        while (tabNode != null) {
            this.rebuild(tabNode, n);
            ++n;
            tabNode = tabNode.next;
        }
        this.tabPanel.setSelectedIndex(this.selectedIndex);
        this.checkTab();
    }

    protected void rebuild(TabNode tabNode, int n) {
        if (tabNode.level == 777) {
            JPanel jPanel = new JPanel(new GridLayout(1, 1));
            jPanel.add(tabNode.chart);
            this.makeTab(tabNode.title, jPanel, tabNode.toolTip, n, tabNode);
        } else if (tabNode.level == 999) {
            Serializable serializable;
            ReportingObjectBuilder reportingObjectBuilder = null;
            JPanel jPanel = new JPanel(new GridLayout(1, 1));
            try {
                serializable = Class.forName(tabNode.className);
                reportingObjectBuilder = (ReportingObjectBuilder)serializable.newInstance();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.out.println("Class load failed");
                reportingObjectBuilder = null;
            }
            if (reportingObjectBuilder != null) {
                serializable = reportingObjectBuilder.build(tabNode.object);
                tabNode.baseComponent = serializable;
                jPanel.add((Component)serializable);
                if (reportingObjectBuilder instanceof HistoryChart) {
                    tabNode.builder = reportingObjectBuilder;
                }
                this.makeTab(tabNode.title, jPanel, tabNode.toolTip, n, tabNode);
            }
        } else {
            this.makeTab(tabNode.title, null, tabNode.toolTip, n, tabNode);
            tabNode.tableNeeded = true;
        }
    }

    public static JComponent getNoDataMessage(GuiReportReq guiReportReq) {
        JLabel jLabel = new JLabel();
        if (guiReportReq != null && (guiReportReq.reportSubtype == 24 || guiReportReq.reportSubtype == 23)) {
            jLabel.setText(Util.getString("LABEL_NO_DISK_DEFECTS_DISCOVERED"));
        } else {
            jLabel.setText(MessageLog.getMessageNoID("STG0020M"));
        }
        jLabel.setHorizontalAlignment(0);
        return jLabel;
    }

    public JComponent getNoDataMessage_instance(GuiReportReq guiReportReq) {
        JLabel jLabel = new JLabel();
        if (guiReportReq != null && (guiReportReq.reportSubtype == 24 || guiReportReq.reportSubtype == 23)) {
            jLabel.setText(Util.getString("LABEL_NO_DISK_DEFECTS_DISCOVERED"));
        } else {
            jLabel.setText(MessageLog.getMessageNoID("STG0020M"));
        }
        jLabel.setHorizontalAlignment(0);
        this.disableExport();
        return jLabel;
    }

    public void addFirstReport(GuiReportReq guiReportReq) {
        TabNode tabNode = this.tabNodeHead;
        while (tabNode != null) {
            this.tabPanel.removeTabAt(1);
            tabNode = tabNode.next;
        }
        this.deletePartitions(this.tabNodeHead);
        guiReportReq.partitionToken = 0L;
        this.tabNodeTail = this.tabNodeHead = new TabNode(guiReportReq, this.reportTabTitle, this.firstReportDescription);
        this.tabNodeHead.level = 1;
        this.makeReport(guiReportReq, this.reportTabTitle, this.firstReportDescription, 1, this.tabNodeHead);
    }

    public void addReport(GuiReportReq guiReportReq, GuiReportReq guiReportReq2, String string) {
        String string2;
        String string3 = string2 = GuiReportReq.guiClasses[guiReportReq2.reportType][2] == GuiReportReq.subtypeTreeLabels[guiReportReq2.reportSubtype][0] ? "" : String.valueOf(MessageLog.getMessageNoID(GuiReportReq.guiClasses[guiReportReq2.reportType][2])) + Util.getString("COLON") + MessageLog.getMessageNoID(GuiReportReq.subtypeTreeLabels[guiReportReq2.reportSubtype][0]);
        if (string.length() > 64) {
            string = String.valueOf(string.substring(0, 62)) + "-";
        }
        TabNode tabNode = new TabNode(guiReportReq2, string, string2);
        int n = 2;
        TabNode tabNode2 = this.tabNodeHead;
        while (tabNode2 != null && tabNode2.grr != guiReportReq) {
            ++n;
            tabNode2 = tabNode2.next;
        }
        if (tabNode2 != null) {
            tabNode.level = tabNode2.level + 1;
            tabNode2 = tabNode2.next;
            while (tabNode2 != null && tabNode2.level >= tabNode.level) {
                ++n;
                tabNode2 = tabNode2.next;
            }
            if (tabNode2 == null) {
                tabNode.prev = this.tabNodeTail;
                this.tabNodeTail.next = tabNode;
                this.tabNodeTail = tabNode;
            } else {
                tabNode.prev = tabNode2.prev;
                tabNode.next = tabNode2;
                tabNode2.prev = tabNode;
                tabNode.prev.next = tabNode;
            }
            this.makeReport(guiReportReq2, string, string2, n, tabNode);
        }
    }

    public void makeReport(GuiReportReq guiReportReq, String string, String string2, int n, TabNode tabNode) {
        JPanel jPanel = null;
        try {
            Object[] objectArray;
            Constructor<?> constructor;
            Class<?> clazz = Class.forName(GuiReportReq.guiClasses[guiReportReq.reportType][0]);
            Class[] classArray = new Class[]{GuiReportReq.class, ReportingDDI.class};
            try {
                constructor = clazz.getConstructor(classArray);
                objectArray = new Object[2];
                objectArray[1] = this;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    classArray[1] = DataDisplayInfo.class;
                    constructor = clazz.getConstructor(classArray);
                    objectArray = new Object[2];
                    objectArray[1] = this;
                }
                catch (NoSuchMethodException noSuchMethodException2) {
                    Class[] classArray2 = new Class[]{GuiReportReq.class};
                    constructor = clazz.getConstructor(classArray2);
                    objectArray = new Object[]{guiReportReq};
                }
            }
            jPanel = (JPanel)constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            System.err.println(exception);
            exception.printStackTrace();
        }
        this.makeTab(string, jPanel, string2, n, tabNode);
    }

    public void addChart(GuiReportReq guiReportReq, JComponent jComponent, String string) {
        if (string == null || string.equals("")) {
            try {
                string = String.valueOf(MessageLog.getMessageNoID(GuiReportReq.guiClasses[guiReportReq.reportType][2])) + GuiUtil.getString("COLON") + MessageLog.getMessageNoID(GuiReportReq.subtypeTreeLabels[guiReportReq.reportSubtype][0]);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        }
        TabNode tabNode = new TabNode(jComponent, CHART, string, jComponent);
        int n = 2;
        TabNode tabNode2 = this.tabNodeHead;
        while (tabNode2 != null && tabNode2.grr != guiReportReq) {
            ++n;
            tabNode2 = tabNode2.next;
        }
        if (tabNode2 != null) {
            tabNode2 = tabNode2.next;
            while (tabNode2 != null && (tabNode2.level == 777 || tabNode2.level == 999)) {
                ++n;
                tabNode2 = tabNode2.next;
            }
            if (tabNode2 == null) {
                tabNode.prev = this.tabNodeTail;
                this.tabNodeTail.next = tabNode;
                this.tabNodeTail = tabNode;
            } else {
                tabNode.prev = tabNode2.prev;
                tabNode.next = tabNode2;
                tabNode2.prev = tabNode;
                tabNode.prev.next = tabNode;
            }
            JPanel jPanel = new JPanel(new GridLayout(1, 1));
            jPanel.add(jComponent);
            this.makeTab(CHART, jPanel, string, n, tabNode);
        }
    }

    public void addObject(GuiReportReq guiReportReq, String string, Object object, String string2, String string3) {
        this.addObject(guiReportReq, string, object, string2, string3, -1, null);
    }

    public void addObject(GuiReportReq guiReportReq, String string, Object object, String string2, String string3, Object object2) {
        this.addObject(guiReportReq, string, object, string2, string3, -1, object2);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void addObject(GuiReportReq var1_1, String var2_2, Object var3_3, String var4_4, String var5_5, int var6_6, Object var7_7) {
        block10: {
            block11: {
                var8_8 = null;
                try {
                    var9_9 /* !! */  = Class.forName(var2_2);
                    var8_8 = (ReportingObjectBuilder)var9_9 /* !! */ .newInstance();
                    if (var8_8 instanceof HistoryChart) {
                        ((HistoryChart)var8_8).setDDI(this);
                    }
                }
                catch (Exception var9_10) {
                    var9_10.printStackTrace();
                    System.out.println("Class load failed");
                    var8_8 = null;
                }
                if (var8_8 == null) break block10;
                var9_9 /* !! */  = var8_8.build(var3_3);
                var10_11 = new JPanel(new GridLayout(1, 1));
                var10_11.add((Component)var9_9 /* !! */ );
                var11_12 = new TabNode(var3_3, var4_4, var5_5, var2_2, (Component)var9_9 /* !! */ );
                if (var8_8 instanceof HistoryChart) {
                    var11_12.builder = var8_8;
                    var12_13 = (HistoryChoiceInterface)var7_7;
                    var11_12.historyArrays = var12_13.getChoices(var1_1.reportType, var1_1.reportSubtype);
                    var11_12.historySubtype = var1_1.reportSubtype;
                }
                var12_14 = 2;
                var13_15 = this.tabNodeHead;
                if (var6_6 <= 0) ** GOTO lbl34
                var12_14 = var6_6;
                while (var13_15 != null && var6_6 > 1) {
                    --var6_6;
                    var13_15 = var13_15.next;
                }
                break block11;
lbl-1000:
                // 1 sources

                {
                    ++var12_14;
                    var13_15 = var13_15.next;
lbl34:
                    // 2 sources

                    ** while (var13_15 != null && var13_15.grr != var1_1)
                }
lbl35:
                // 1 sources

                if (var13_15 != null) {
                    var13_15 = var13_15.next;
                    while (var13_15 != null && (var13_15.level == 777 || var13_15.level == 999)) {
                        ++var12_14;
                        var13_15 = var13_15.next;
                    }
                }
            }
            if (var13_15 == null) {
                var11_12.prev = this.tabNodeTail;
                this.tabNodeTail.next = var11_12;
                this.tabNodeTail = var11_12;
            } else {
                var11_12.prev = var13_15.prev;
                var11_12.next = var13_15;
                var13_15.prev = var11_12;
                var11_12.prev.next = var11_12;
            }
            this.makeTab(var4_4, var10_11, var5_5, var12_14, var11_12);
        }
    }

    protected void makeTab(String string, Component component, String string2, int n, TabNode tabNode) {
        tabNode.rowsLabel = null;
        JPanel jPanel = new JPanel();
        if (component != null) {
            Object object;
            jPanel.setLayout(new BorderLayout());
            tabNode.titlePanel = new JPanel(new GridBagLayout());
            this.gbc.fill = 0;
            this.gbc.anchor = 17;
            this.gbc.gridwidth = 0;
            this.gbc.insets.bottom = 4;
            this.gbc.insets.left = 4;
            tabNode.titleLabel = new JLabel(string2);
            tabNode.titlePanel.add((Component)tabNode.titleLabel, this.gbc);
            if (DisplaysChartPopupInterface.class.isInstance(component) && (object = ((DisplaysChartPopupInterface)((Object)component)).getShowsPopup()) != null) {
                JButton jButton = new JButton(IconFactory.getPieChartIcon());
                jButton.setMargin(new Insets(0, 0, 0, 0));
                jButton.setToolTipText(CHARTPOPUP);
                jButton.addActionListener(new ChartButtonPressed((TJCTableMouseInterface)object));
                GuiUtil.setAccessible(jButton, CHARTPOPUP, CHARTPOPUP);
                this.gbc.gridwidth = 1;
                tabNode.titlePanel.add((Component)jButton, this.gbc);
                this.gbc.gridwidth = 0;
            }
            object = new JPanel(new FlowLayout(0));
            ((JComponent)object).setOpaque(false);
            ((Container)object).add(tabNode.titlePanel);
            jPanel.add((Component)object, "North");
            jPanel.add(component, "Center");
        }
        this.tabPanel.insertTab(string, null, jPanel, string2, n);
        this.tabPanel.setSelectedIndex(n);
        if (!this.jumpToChart) {
            this.showing = true;
            this.show();
            this.showing = false;
        }
    }

    public void addRowCount(ReportDataAdjuster reportDataAdjuster) {
        int n = this.tabPanel.getSelectedIndex();
        TabNode tabNode = this.tabNodeHead;
        int n2 = 1;
        while (n2 < n) {
            tabNode = tabNode.next;
            ++n2;
        }
        if (tabNode.titlePanel != null) {
            if (tabNode.rowsLabel != null) {
                tabNode.titlePanel.remove(tabNode.rowsLabel);
            }
            n2 = reportDataAdjuster.getNumberRows();
            if (reportDataAdjuster.hasTotalsRow()) {
                --n2;
            }
            tabNode.rowsLabel = new BlackLabel(" " + ROWS + " " + n2);
            tabNode.titlePanel.add((Component)tabNode.rowsLabel, this.gbc);
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.checkTab();
    }

    private void checkTab() {
        int n = this.tabPanel.getSelectedIndex();
        if (n == 0) {
            if (this.listNeeded) {
                this.listNeeded = false;
                this.selectionPanel = new ReportingSelectionDriver(this, this.grr, this.selectionServices, this.objectName);
                this.tabPanel.removeTabAt(0);
                this.tabPanel.insertTab(this.selectionTabTitle, null, this.selectionPanel, this.selectionTabTip, 0);
                this.tabPanel.setSelectedIndex(0);
            }
            this.disableExport();
        } else {
            TabNode tabNode = this.tabNodeHead;
            int n2 = 1;
            while (n2 < n) {
                tabNode = tabNode.next;
                ++n2;
            }
            if (tabNode.tableNeeded) {
                tabNode.tableNeeded = false;
                this.tabPanel.removeTabAt(n);
                this.makeReport(tabNode.grr, tabNode.title, tabNode.toolTip, n, tabNode);
            }
            if (tabNode.level <= 776) {
                if (tabNode.grr.reportSubtype != 28 || tabNode.grr.reportType == 4 || tabNode.grr.reportType == 5) {
                    this.enableExport();
                } else {
                    this.disableExport();
                }
            } else if (tabNode.builder != null) {
                this.enableExport();
            } else {
                this.disableExport();
                this.guiMain.setPrintActionEnabled(true, true);
            }
        }
    }

    protected void enableExport() {
        this.guiMain.setExportActionEnabled(true, true);
        this.guiMain.setExportActionToolTip(EXPORT);
        if (!this.exportEnabled) {
            this.exportEnabled = true;
            this.guiMain.addExportActionListener(this);
        }
    }

    protected void disableExport() {
        this.guiMain.setExportActionEnabled(false, false);
        this.guiMain.setExportActionToolTip(null);
        this.guiMain.setPrintActionEnabled(false, false);
        if (this.exportEnabled) {
            this.exportEnabled = false;
            this.guiMain.removeExportActionListener(this);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "Save") {
            this.saveAs = false;
            this.save();
        } else if (string == "SaveAs") {
            this.saveAs = true;
            this.save();
        } else if (string == "Export") {
            this.export();
        }
    }

    private void save() {
        GeneralException generalException = null;
        GuiSavedReportReq guiSavedReportReq = new GuiSavedReportReq();
        if (this.gsrr == null || this.gsrr.ID <= 299) {
            this.saveAs = true;
            guiSavedReportReq.creator = GuiUtil.getUserName();
            guiSavedReportReq.grr = this.grr;
        } else {
            guiSavedReportReq.creator = this.gsrr.creator;
            guiSavedReportReq.setName(this.gsrr.getTrueName());
            guiSavedReportReq.ID = this.gsrr.ID;
            guiSavedReportReq.grr = this.gsrr.grr;
        }
        guiSavedReportReq.productCode = this.productCode;
        if (this.selectionPanel != null) {
            try {
                this.selectionPanel.getData();
            }
            catch (GeneralException generalException2) {
                generalException = generalException2;
            }
        }
        if (generalException != null) {
            GuiUtil.displayException(generalException);
            generalException = null;
            this.showing = true;
            this.show();
            this.showing = false;
            return;
        }
        if (this.saveAs) {
            guiSavedReportReq.ID = -1;
            String string = MessageLog.getMessageNoID("GUI5007L");
            String string2 = MessageLog.getMessageNoID("STG4207L");
            String string3 = MessageLog.getMessageNoID("GUI5011L", new Object[]{string2});
            boolean bl = true;
            while (bl) {
                guiSavedReportReq.setName(GuiUtil.displayOkCancelPane(string, string3, 32, false, null, this.guiMain.getFrame()));
                boolean bl2 = bl = guiSavedReportReq.getName() != null && !guiSavedReportReq.getName().equals("") && guiSavedReportReq.getName().indexOf(46) >= 0;
                if (!bl) continue;
                String string4 = MessageLog.getMessageNoTS("GUI0056E", null);
                GuiUtil.displayErrorMessage(string4);
            }
        }
        if (guiSavedReportReq.getName() != null && !guiSavedReportReq.getName().equals("")) {
            SavedReportNode.doRequest(this, guiSavedReportReq);
        }
    }

    public void handleResponse(short s, Response response) {
        Serializable serializable;
        if (s <= 4 && response.responseData != null && (serializable = response.responseData) instanceof GuiSavedReportReq) {
            this.gsrr = (GuiSavedReportReq)response.responseData;
            this.changeDescription();
            NameList nameList = new NameList();
            nameList.nlInfo = (short)35;
            nameList.nlName = this.gsrr.getName();
            nameList.nlID = this.gsrr.ID;
            nameList.nlState = this.productCode;
            ChangeManager.signalChange(1, nameList);
        }
    }

    private void export() {
        int n = this.tabPanel.getSelectedIndex();
        MegaTable megaTable = this.getTable();
        if (megaTable != null) {
            String string;
            if (n == 1) {
                string = this.getDescription();
            } else {
                TabNode tabNode = this.tabNodeHead;
                int n2 = 1;
                while (n2 < n) {
                    tabNode = tabNode.next;
                    ++n2;
                }
                string = tabNode.toolTip;
            }
            ExportTableData.exportTable(megaTable, null, string);
        } else {
            TabNode tabNode = this.getTabNode();
            if (tabNode.builder != null && tabNode.builder instanceof HistoryChart) {
                GuiReportReq guiReportReq = (GuiReportReq)tabNode.object;
                Object[] objectArray = ((HistoryChart)tabNode.builder).getArrays();
                String[] stringArray = (String[])tabNode.historyArrays[0];
                byte[] byArray = (byte[])tabNode.historyArrays[2];
                String string = null;
                int n3 = 0;
                while (n3 < byArray.length) {
                    if (byArray[n3] == guiReportReq.histSubtype) {
                        string = ReportCreateOrEdit.adjustHistoryName(stringArray[n3]);
                        if (tabNode.historyArrays.length <= 3) break;
                        stringArray = (String[])tabNode.historyArrays[3];
                        string = string.endsWith("%") ? String.valueOf(string) + "  " : String.valueOf(string) + " ";
                        string = String.valueOf(string) + MessageLog.getMessageNoID(stringArray[guiReportReq.histSubtypeRange - 1]);
                        break;
                    }
                    ++n3;
                }
                ExportTableData.exportHistory(tabNode.historySubtype, objectArray, null, tabNode.toolTip, string);
            }
        }
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        this.pf = pageFormat;
        this.g = graphics;
        if (this.tabPanel == null) {
            super.print(graphics, pageFormat, n);
        } else {
            JTableHeader jTableHeader;
            int n2 = this.tabPanel.getSelectedIndex();
            MegaTable megaTable = null;
            if (n2 > 0) {
                megaTable = this.getTable();
            }
            if (megaTable == null) {
                this.printableTable = null;
                return super.print(graphics, pageFormat, n);
            }
            this.printableTable = this.generatePrintableJTable(megaTable, graphics);
            Dimension dimension = null;
            if (this.printableTable.getWidth() == 0 || this.printableTable.getHeight() == 0) {
                this.printableTable.setSize(this.printableTable.getPreferredSize());
            }
            if ((jTableHeader = this.printableTable.getTableHeader()).getHeight() == 0 || jTableHeader.getWidth() == 0) {
                jTableHeader.setSize(jTableHeader.getPreferredSize());
            }
            int n3 = this.printableTable.getWidth();
            int n4 = this.printableTable.getHeight();
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            while (n6 < n4) {
                n5 = 0;
                while (n5 < n3) {
                    dimension = this.getPrintableClip(this.printableTable, n5, n6, graphics);
                    if (n7 == n) {
                        this.paintTable(this.printableTable, graphics, n5, n6, dimension, n7);
                        return 0;
                    }
                    ++n7;
                    n5 += dimension.width;
                }
                n6 += dimension.height;
            }
        }
        return 1;
    }

    protected Dimension getPrintableClip(JTable jTable, int n, int n2, Graphics graphics) {
        int n3;
        Rectangle rectangle;
        int n4;
        int n5 = (int)this.pf.getImageableWidth();
        int n6 = (int)this.pf.getImageableHeight();
        n6 -= jTable.getTableHeader().getHeight();
        FontMetrics fontMetrics = graphics.getFontMetrics(jTable.getFont());
        n6 -= fontMetrics.getHeight() * 4;
        n6 -= fontMetrics.getAscent() * 2;
        int n7 = jTable.columnAtPoint(new Point(n + n5, n2));
        if (n7 == -1) {
            n4 = jTable.getWidth() - n;
        } else {
            rectangle = jTable.getCellRect(0, n7 - 1, true);
            n4 = rectangle.x + rectangle.width - n;
        }
        int n8 = jTable.rowAtPoint(new Point(n, n2 + n6));
        if (n8 == -1) {
            n3 = jTable.getHeight() - n2;
        } else {
            rectangle = jTable.getCellRect(n8 - 1, 0, true);
            n3 = rectangle.y + rectangle.height - n2;
        }
        return new Dimension(n4, n3);
    }

    protected void paintTable(JTable jTable, Graphics graphics, int n, int n2, Dimension dimension, int n3) {
        int n4 = (int)this.pf.getImageableX();
        int n5 = (int)this.pf.getImageableY();
        JTableHeader jTableHeader = jTable.getTableHeader();
        int n6 = jTableHeader.getHeight();
        int n7 = 0;
        graphics.translate(n4 - n, n5);
        graphics.setFont(jTable.getFont().deriveFont(1));
        graphics.setColor(Color.black);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        n7 = fontMetrics.getAscent();
        n7 += fontMetrics.getHeight();
        if (n3 == 0) {
            graphics.drawString(String.valueOf(PrintPreviewable.CREATED_BY) + " " + GuiUtil.getUserName() + "     " + PrintPreviewable.PRINTED_ON + " " + Util.formatDateTime(new Date()), 0, fontMetrics.getAscent());
        }
        graphics.drawString(this.getDescription(), n, n7);
        n7 = fontMetrics.getHeight() * 3;
        graphics.translate(0, n7);
        graphics.clipRect(n, 0, dimension.width, dimension.height + n6);
        jTableHeader.setForeground(Color.black);
        jTableHeader.setBackground(Color.white);
        jTableHeader.paint(graphics);
        graphics.translate(0, n6 - n2);
        graphics.clipRect(n, n2, dimension.width, dimension.height);
        jTable.paint(graphics);
        graphics.translate(0, -(n6 - n2 + n7));
        graphics.setClip(n, 0, (int)this.pf.getImageableWidth(), (int)this.pf.getImageableHeight());
        graphics.drawString(Util.getString("LABEL_PAGE_X_OF_Y", Integer.toString(n3 + 1), Integer.toString(this.getNumberOfPages())), n, (int)(this.pf.getImageableHeight() - (double)fontMetrics.getHeight()));
    }

    public int getNumberOfPages() {
        if (this.printableTable == null) {
            return super.getNumberOfPages();
        }
        Dimension dimension = null;
        int n = this.printableTable.getWidth();
        int n2 = this.printableTable.getHeight();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n4 < n2) {
            n3 = 0;
            while (n3 < n) {
                dimension = this.getPrintableClip(this.printableTable, n3, n4, this.g);
                n3 += dimension.width;
                ++n5;
            }
            n4 += dimension.height;
        }
        return n5;
    }

    public PageFormat getPageFormat(int n) {
        if (this.printableTable == null) {
            return super.getPageFormat(n);
        }
        return this.pf;
    }

    public void printData(Container container) {
        if (this.tabPanel == null) {
            super.printData(null);
        } else {
            Object object;
            String string;
            int n = this.tabPanel.getSelectedIndex();
            if (n <= 1) {
                string = this.getDescription();
            } else {
                object = this.tabNodeHead;
                int n2 = 1;
                while (n2 < n) {
                    object = ((TabNode)object).next;
                    ++n2;
                }
                string = ((TabNode)object).toolTip;
            }
            object = null;
            if (n > 0) {
                object = this.getTable();
            }
            if (object != null) {
                PrintTableData.printTable(this, (MegaTable)object, GuiUtil.getUserName(), string, string);
            } else {
                Component component = null;
                component = n == 0 ? this.tabPanel.getComponentAt(0) : this.getTabNode().baseComponent;
                if (component != null) {
                    boolean bl = false;
                    AperiChart aperiChart = null;
                    if (component instanceof AperiChart) {
                        bl = true;
                        aperiChart = (AperiChart)component;
                    }
                    PrintOutputChooser printOutputChooser = new PrintOutputChooser();
                    printOutputChooser.allowCSV(this.exportEnabled);
                    printOutputChooser.allowFormatted(this.exportEnabled);
                    boolean bl2 = this.getPdfAllowed();
                    PrintOptions printOptions = printOutputChooser.getOptions(bl, bl2);
                    if (printOptions != null) {
                        printOptions.htmlChart = aperiChart;
                        if (printOptions.outputType == 1) {
                            new PrintPreviewPanel(this, string, true);
                        } else {
                            PrintComponent.print(printOptions, component, GuiUtil.getUserName(), string, string, true);
                        }
                    }
                }
            }
        }
    }

    private MegaTable getTable() {
        MegaTable megaTable = null;
        int n = this.tabPanel.getSelectedIndex();
        megaTable = this.getTable((Container)this.tabPanel.getComponentAt(n));
        return megaTable;
    }

    private MegaTable getTable(Container container) {
        MegaTable megaTable = null;
        Component[] componentArray = container.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] instanceof MegaTable) {
                megaTable = (MegaTable)componentArray[n];
                break;
            }
            if (componentArray[n] instanceof Container && (megaTable = this.getTable((Container)componentArray[n])) != null) break;
            ++n;
        }
        return megaTable;
    }

    private FlexibleTable generatePrintableJTable(MegaTable megaTable, Graphics graphics) {
        Serializable serializable;
        int n;
        int n2;
        Object object;
        int n3;
        int n4;
        BaseTableModel baseTableModel = (BaseTableModel)megaTable.getDataSource();
        ReportDataAdjuster reportDataAdjuster = baseTableModel.getAdjuster();
        int[] nArray = null;
        nArray = reportDataAdjuster.fixColumnArray(nArray);
        int[] nArray2 = new int[reportDataAdjuster.getNumberFrozenRows() + reportDataAdjuster.getNumberRows()];
        int n5 = 0;
        while (n5 < nArray2.length) {
            nArray2[n5] = n5;
            ++n5;
        }
        String[] stringArray = reportDataAdjuster.getLabels();
        int n6 = reportDataAdjuster.getNumberFrozenRows();
        int n7 = stringArray.length;
        int n8 = reportDataAdjuster.getNumberSpannedRows();
        Object[] objectArray = new String[nArray.length];
        FlexibleTable flexibleTable = null;
        Object[][] objectArray2 = new String[reportDataAdjuster.getNumberRows()][objectArray.length];
        if (n8 == 0) {
            n4 = 0;
            while (n4 < objectArray.length) {
                n3 = nArray[n4];
                object = new StringBuffer(25);
                ((StringBuffer)object).append(stringArray[n3]);
                if (n6 > 0) {
                    n2 = 0;
                    while (n2 < n6) {
                        ((StringBuffer)object).append("\n");
                        ((StringBuffer)object).append(reportDataAdjuster.getCellData(reportDataAdjuster.getRowIndex(n2, nArray2), n3));
                        ++n2;
                    }
                }
                objectArray[n4] = ((StringBuffer)object).toString();
                ++n4;
            }
            n4 = n6;
            while (n4 < reportDataAdjuster.getNumberRows() + n6) {
                int n9 = 0;
                while (n9 < nArray.length) {
                    objectArray2[n4 - n6][n9] = this.formatData(reportDataAdjuster, n4, nArray[n9], nArray2);
                    ++n9;
                }
                ++n4;
            }
        }
        object = new boolean[n7];
        if (n8 > 0) {
            int n10;
            n2 = 0;
            while (n2 < nArray.length) {
                n3 = nArray[n2];
                n4 = n3 + 1;
                if (n4 < stringArray.length && stringArray[n4].length() == 0) {
                    object[n3] = true;
                    ++n2;
                }
                ++n2;
            }
            n2 = 0;
            while (n2 < n8 - 1) {
                n10 = 0;
                while (n10 < nArray.length) {
                    n3 = nArray[n10];
                    if (object[n3] != false) {
                        objectArray[n10] = reportDataAdjuster.getCellData(reportDataAdjuster.getRowIndex(n2 + 1, nArray2), n3).toString();
                        objectArray[n10 + 1] = reportDataAdjuster.getCellData(reportDataAdjuster.getRowIndex(n2 + 1, nArray2), n3 + 1).toString();
                        ++n10;
                    } else {
                        objectArray[n10] = stringArray[n3];
                    }
                    ++n10;
                }
                ++n2;
            }
            n2 = n6;
            while (n2 < reportDataAdjuster.getNumberRows() + n6) {
                n10 = 0;
                while (n10 < nArray.length) {
                    objectArray2[n2 - n6][n10] = this.formatData(reportDataAdjuster, n2, nArray[n10], nArray2);
                    ++n10;
                }
                ++n2;
            }
        }
        DefaultTableModel defaultTableModel = new DefaultTableModel(objectArray2, objectArray);
        flexibleTable = new FlexibleTable(defaultTableModel);
        flexibleTable.setDoubleBuffered(false);
        flexibleTable.setAutoResizeMode(0);
        TableColumnModel tableColumnModel = flexibleTable.getColumnModel();
        int n11 = tableColumnModel.getColumnCount();
        if (n8 > 0) {
            int n12 = 0;
            while (n12 < n8 - 1) {
                n = 0;
                while (n < nArray.length) {
                    n3 = nArray[n];
                    if (object[n3] != false) {
                        serializable = new StringBuffer();
                        ((StringBuffer)serializable).append(stringArray[n3]);
                        ((StringBuffer)serializable).append("\n");
                        ((StringBuffer)serializable).append(reportDataAdjuster.getCellData(reportDataAdjuster.getRowIndex(n12, nArray2), n3).toString());
                        flexibleTable.makeNewColumnGroup(((StringBuffer)serializable).toString());
                        flexibleTable.addColumnToGroup(tableColumnModel.getColumn(n));
                        flexibleTable.addColumnToGroup(tableColumnModel.getColumn(++n));
                    } else {
                        objectArray[n] = stringArray[n];
                    }
                    ++n;
                }
                ++n12;
            }
        }
        FontMetrics fontMetrics = graphics.getFontMetrics(megaTable.getFont().deriveFont(1));
        n = 0;
        while (n < n11) {
            int n13;
            serializable = tableColumnModel.getColumn(n);
            int n14 = 0;
            StringTokenizer stringTokenizer = new StringTokenizer((String)objectArray[n], "\r\n");
            while (stringTokenizer.hasMoreTokens()) {
                n13 = (int)fontMetrics.getStringBounds(stringTokenizer.nextToken(), graphics).getWidth();
                if (n13 <= n14) continue;
                n14 = n13;
            }
            n14 += fontMetrics.getMaxAdvance();
            n13 = 0;
            fontMetrics = graphics.getFontMetrics(megaTable.getFont());
            int n15 = 0;
            while (n15 < flexibleTable.getRowCount()) {
                n13 = (int)Math.max((double)n13, fontMetrics.getStringBounds(flexibleTable.getModel().getValueAt(n15, n).toString(), graphics).getWidth());
                ++n15;
            }
            n15 = Math.max(n13, n14) + fontMetrics.getMaxAdvance();
            ((TableColumn)serializable).setWidth(n15);
            ((TableColumn)serializable).setMinWidth(n15);
            ++n;
        }
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
        defaultTableCellRenderer.setHorizontalAlignment(4);
        flexibleTable.setDefaultRenderer(String.class, defaultTableCellRenderer);
        return flexibleTable;
    }

    private String formatData(ReportDataAdjuster reportDataAdjuster, int n, int n2, int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer(25);
        DateFormat dateFormat = DateFormat.getDateTimeInstance();
        DecimalFormat decimalFormat = new DecimalFormat();
        int[] nArray2 = reportDataAdjuster.getRenderers();
        int n3 = nArray2[n2];
        Object object = reportDataAdjuster.getCellData(reportDataAdjuster.getRowIndex(n, nArray), n2);
        int n4 = reportDataAdjuster.getScale();
        String string = reportDataAdjuster.getSuffix();
        String string2 = n3 == 0 ? (object == null ? "-" : object.toString()) : (n3 == 7 ? TableCellStrings.SpaceRenderer(object) : (n3 == 1 ? TableCellStrings.DateRenderer(object, dateFormat) : (n3 == 2 ? TableCellStrings.DecimalRenderer(n4, string, object, stringBuffer) : (n3 == 5 ? TableCellStrings.NumberRenderer(object, decimalFormat) : (n3 == 4 ? TableCellStrings.MegabyteRenderer(object, decimalFormat) : (n3 == 6 ? TableCellStrings.PercentRenderer(object, decimalFormat) : (n3 == 3 ? TableCellStrings.DurationRenderer(object, stringBuffer) : (n3 == 8 ? TableCellStrings.SpaceNoDecimalRenderer(object) : (n3 == 9 ? Util.formatHertz(((Number)object).intValue()) : "-")))))))));
        return string2;
    }

    private TabNode getTabNode() {
        int n = this.tabPanel.getSelectedIndex();
        TabNode tabNode = this.tabNodeHead;
        int n2 = 1;
        while (n2 < n) {
            tabNode = tabNode.next;
            ++n2;
        }
        return tabNode;
    }

    private String getTitle() {
        int n = this.tabPanel.getSelectedIndex();
        TabNode tabNode = this.tabNodeHead;
        int n2 = 1;
        while (n2 < n) {
            tabNode = tabNode.next;
            ++n2;
        }
        return tabNode.toolTip;
    }

    public boolean setChartTitle(String string) {
        if (this.tabPanel == null) {
            return false;
        }
        int n = this.tabPanel.getSelectedIndex();
        TabNode tabNode = this.tabNodeHead;
        int n2 = 1;
        while (n2 < n) {
            tabNode = tabNode.next;
            ++n2;
        }
        if (tabNode.titleLabel != null) {
            tabNode.titleLabel.setText(string);
        } else {
            tabNode.titleLabel = new JLabel(string);
        }
        tabNode.toolTip = string;
        this.tabPanel.setToolTipTextAt(n, string);
        return true;
    }

    public String getChartTitle() {
        int n = this.tabPanel.getSelectedIndex();
        String string = "";
        TabNode tabNode = this.tabNodeHead;
        int n2 = 1;
        while (n2 < n) {
            tabNode = tabNode.next;
            ++n2;
        }
        if (tabNode.titleLabel != null) {
            string = tabNode.titleLabel.getText();
        }
        return string;
    }

    public void changeOccurred(int n, NameList nameList) {
        if (n == 0 && this.gsrr != null && nameList.nlID == this.gsrr.ID) {
            this.gsrr.setName(nameList.nlName);
            this.changeDescription();
        }
    }

    private void changeDescription() {
        this.setDescription(String.valueOf(this.gsrr.creator) + "." + this.gsrr.getName());
        if (ReportingDDI.getCurrent() == this) {
            this.showing = true;
            this.show();
            this.showing = false;
        }
    }

    private void deletePartitions(TabNode tabNode) {
        int n = 0;
        Object object = tabNode;
        while (object != null) {
            if (((TabNode)object).grr != null && ((TabNode)object).grr.partitionToken != 0L) {
                ++n;
            }
            object = ((TabNode)object).next;
        }
        if (n == 0) {
            return;
        }
        object = new long[n];
        Object object2 = tabNode;
        while (object2 != null) {
            if (((TabNode)object2).grr != null && ((TabNode)object2).grr.partitionToken != 0L) {
                object[--n] = ((TabNode)object2).grr.partitionToken;
            }
            object2 = ((TabNode)object2).next;
        }
        object2 = new Request();
        ((Request)object2).typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
        ((Request)object2).serviceName = RequestTypeManager.getInternalName(((Request)object2).typeCode);
        ((Request)object2).subType = "org.eclipse.aperi.server.handler.gui.PartitionHndlr";
        ((Request)object2).requestData = object;
        GuiClient.doRhetoricalRequest((Request)object2);
    }

    public int getSelectedIndex() {
        return this.tabPanel == null ? -1 : this.tabPanel.getSelectedIndex();
    }

    public void setHelpID(String string) {
        if (string != null) {
            this.helpID = string;
        }
    }

    private class ChartButtonPressed
    implements ActionListener {
        TJCTableMouseInterface showsPopup;

        ChartButtonPressed(TJCTableMouseInterface tJCTableMouseInterface) {
            this.showsPopup = tJCTableMouseInterface;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.showsPopup.showPopup(-1, -1, (Component)actionEvent.getSource(), 10, 10);
        }
    }

    private class Mouser
    extends MouseAdapter
    implements ActionListener {
        int mouseIndex;

        private Mouser() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.checkPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.checkPopup(mouseEvent);
        }

        private void checkPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
                this.mouseIndex = ReportingDDI.this.tabPanel.getUI().tabForCoordinate(ReportingDDI.this.tabPanel, n, n2);
                if (this.mouseIndex > 0) {
                    JPopupMenu jPopupMenu = new JPopupMenu();
                    JMenuItem jMenuItem = jPopupMenu.add(MessageLog.getMessageNoID("GUI5008L"));
                    jMenuItem.setActionCommand("Close");
                    jMenuItem.addActionListener(this);
                    jPopupMenu.show(ReportingDDI.this.tabPanel, n, n2);
                }
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getActionCommand() == "Close") {
                TabNode tabNode;
                ReportingDDI.this.tabPanel.removeTabAt(this.mouseIndex);
                if (this.mouseIndex == 1) {
                    tabNode = ReportingDDI.this.tabNodeHead;
                    ReportingDDI.this.tabNodeHead = ReportingDDI.this.tabNodeHead.next;
                    if (ReportingDDI.this.tabNodeHead == null) {
                        ReportingDDI.this.tabNodeTail = null;
                    } else {
                        ReportingDDI.this.tabNodeHead.prev = null;
                    }
                } else {
                    tabNode = ReportingDDI.this.tabNodeHead;
                    while (this.mouseIndex > 1) {
                        --this.mouseIndex;
                        tabNode = tabNode.next;
                    }
                    tabNode.prev.next = tabNode.next;
                    if (tabNode.next == null) {
                        ReportingDDI.this.tabNodeTail = tabNode.prev;
                    } else {
                        tabNode.next.prev = tabNode.prev;
                    }
                }
                tabNode.next = null;
                ReportingDDI.this.deletePartitions(tabNode);
            }
        }
    }

    protected class TabNode {
        TabNode prev;
        TabNode next;
        int level;
        boolean tableNeeded;
        GuiReportReq grr;
        JComponent chart;
        Object object;
        Component baseComponent;
        JPanel titlePanel;
        JLabel rowsLabel;
        String className;
        String title;
        String toolTip;
        JLabel titleLabel;
        Object[] historyArrays;
        int historySubtype;
        ReportingObjectBuilder builder;

        public TabNode(GuiReportReq guiReportReq, String string, String string2) {
            this.grr = guiReportReq;
            this.title = string;
            this.toolTip = string2;
        }

        public TabNode(JComponent jComponent, String string, String string2, Component component) {
            this.chart = jComponent;
            this.title = string;
            this.toolTip = string2;
            this.baseComponent = component;
            this.level = 777;
        }

        public TabNode(Object object, String string, String string2, String string3, Component component) {
            this.object = object;
            this.title = string;
            this.toolTip = string2;
            this.className = string3;
            this.baseComponent = component;
            this.level = 999;
        }
    }
}

