/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.eclipse.aperi.TStorm.common.GroupDefinition;
import org.eclipse.aperi.TStorm.gui.ReportingGroupResourceData;
import org.eclipse.aperi.TStorm.gui.ReportingGroupSelector;
import org.eclipse.aperi.TStorm.gui.ShowResource;
import org.eclipse.aperi.TStorm.server.guireq.GuiListReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiRequest;
import org.eclipse.aperi.common.CreateHeader;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.gui.ChangeManager;
import org.eclipse.aperi.gui.CreateHeaderPanel;
import org.eclipse.aperi.gui.CreateOrEdit;
import org.eclipse.aperi.gui.CreateOrEditDDI;
import org.eclipse.aperi.gui.FilterPanel;
import org.eclipse.aperi.gui.FilterResultsViewer;
import org.eclipse.aperi.gui.GridBagPanel;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.TreeSelector;
import org.eclipse.aperi.gui.TreeSelectorNode;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class ReportingGroupCreateOrEdit
implements CreateOrEdit,
GuiRequestor,
ActionListener {
    private CreateHeaderPanel createHeaderPanel;
    private CreateOrEditDDI DDI;
    private ReportingGroupSelector grpSelector;
    private Vector filterVec;
    private GridBagPanel filterPanel;
    private JButton selectResourcesButton;
    private JButton showAllButton;
    private boolean showAllRequest;

    public ReportingGroupCreateOrEdit(CreateOrEditDDI createOrEditDDI) {
        this.DDI = createOrEditDDI;
        this.DDI.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
        this.DDI.subType = "org.eclipse.aperi.server.handler.gui.GroupDefHndlr.Definition";
    }

    public CreateHeader getData() {
        GroupDefinition groupDefinition = (GroupDefinition)this.createHeaderPanel.getData();
        TreeSelector treeSelector = (TreeSelector)this.grpSelector.getComponent();
        groupDefinition.members = treeSelector.getReportingNameList();
        groupDefinition.members = this.avoidDuplicates(groupDefinition.members);
        groupDefinition.maskList = null;
        if (!this.filterVec.isEmpty()) {
            int n = this.filterVec.size();
            int n2 = 0;
            switch (this.DDI.nlInfo) {
                case 89: {
                    n2 = 95;
                }
            }
            NameList nameList = null;
            int n3 = 0;
            while (n3 < n) {
                NameList nameList2 = new NameList();
                nameList2.nlName = this.filterVec.get(n3).toString();
                nameList2.nlInfo = (short)n2;
                nameList2.nlNext = nameList;
                nameList = nameList2;
                ++n3;
            }
            groupDefinition.maskList = nameList;
        }
        return groupDefinition;
    }

    public void validate(CreateHeader createHeader) throws GeneralException {
        GroupDefinition groupDefinition = (GroupDefinition)createHeader;
        if (groupDefinition.members == null && groupDefinition.maskList == null) {
            String string = MessageLog.getMessageNoTS("STG3156E", null);
            throw new GeneralException(string);
        }
    }

    private void create(GroupDefinition groupDefinition) {
        this.createHeaderPanel = new CreateHeaderPanel(groupDefinition, this, this.DDI);
        (new NameList[1])[0] = groupDefinition.members;
        NameList nameList = groupDefinition.members;
        String[] stringArray = new String[5];
        stringArray[1] = "STG4029L";
        stringArray[4] = "STG4030L";
        NameList nameList2 = null;
        NameList nameList3 = null;
        NameList nameList4 = null;
        NameList nameList5 = null;
        NameList nameList6 = null;
        NameList nameList7 = null;
        this.filterVec = new Vector();
        switch (this.DDI.nlInfo) {
            case 89: {
                while (nameList != null) {
                    if (nameList.nlInfo == 1) {
                        nameList5 = this.newNameList(nameList.nlName, nameList.nlID, nameList.nlInfo);
                        nameList5.nlNext = nameList2;
                        nameList2 = nameList5;
                    } else if (nameList.nlInfo == 0) {
                        nameList6 = this.newNameList(nameList.nlName, nameList.nlID, nameList.nlInfo);
                        nameList6.nlNext = nameList3;
                        nameList3 = nameList6;
                    } else if (nameList.nlInfo == 89) {
                        nameList7 = this.newNameList(nameList.nlName, nameList.nlID, nameList.nlInfo);
                        nameList7.nlNext = nameList4;
                        nameList4 = nameList7;
                    }
                    nameList = nameList.nlNext;
                }
                this.grpSelector = new ReportingGroupSelector(1, nameList2, nameList3, nameList4, false, false, true, this.DDI.ID);
            }
        }
        nameList = groupDefinition.maskList;
        while (nameList != null) {
            this.filterVec.add(nameList.nlName);
            nameList = nameList.nlNext;
        }
        GridBagPanel gridBagPanel = new GridBagPanel(new Insets(0, 0, 0, 0));
        this.filterPanel = new FilterPanel(this.filterVec, new Insets(0, 0, 0, 0), this.DDI.nlInfo);
        gridBagPanel.add((JComponent)this.filterPanel, 1, new Insets(0, 4, 0, 4));
        gridBagPanel.newRow();
        gridBagPanel.add((JComponent)this.grpSelector.getComponent(), 25, 1);
        GridBagPanel gridBagPanel2 = new GridBagPanel();
        this.selectResourcesButton = new JButton(Util.getString("LABEL_SELECT_RESOURCES"));
        this.selectResourcesButton.setMnemonic(GuiUtil.getMnemonic("MNEMONIC_SELECT_RESOURCES"));
        this.selectResourcesButton.addActionListener(this);
        this.showAllButton = new JButton(Util.getString("LABEL_SHOW_ALL_RESOURCES"));
        this.showAllButton.setMnemonic(GuiUtil.getMnemonic("MNEMONIC_SHOW_ALL_RESOURCES"));
        this.showAllButton.addActionListener(this);
        gridBagPanel2.add((JComponent)this.selectResourcesButton, 21, new Insets(0, 4, 0, 4));
        gridBagPanel2.add((JComponent)new JPanel(), 10, new Insets(0, 125, 0, 60));
        gridBagPanel2.add((JComponent)this.showAllButton, 22, new Insets(0, 4, 0, 4));
        gridBagPanel.newRow();
        gridBagPanel.add((JComponent)gridBagPanel2, 21);
        this.createHeaderPanel.add(gridBagPanel);
        this.DDI.panel = this.createHeaderPanel;
        this.DDI.show();
        this.createHeaderPanel.gettingFocus();
    }

    public void replace(CreateHeader createHeader) {
        this.createHeaderPanel.replace(createHeader);
        NameList nameList = new NameList();
        nameList.nlInfo = this.DDI.nlInfo;
        ChangeManager.signalChange(100, nameList);
        this.grpSelector.hideSavedID(createHeader.ID);
    }

    private void submitRetrieve(int n) {
        Request request = new Request();
        request.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
        request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
        request.subType = "org.eclipse.aperi.server.handler.gui.GroupDefHndlr.Definition";
        request.flags = (byte)5;
        request.userName = GuiUtil.getUserName();
        GroupDefinition groupDefinition = new GroupDefinition();
        groupDefinition.ID = n;
        groupDefinition.groupType = this.DDI.nlInfo;
        groupDefinition.members = null;
        request.requestData = groupDefinition;
        GuiClient.doRequest(this, request);
    }

    private void makeNew() {
        GroupDefinition groupDefinition = new GroupDefinition();
        groupDefinition.groupType = this.DDI.nlInfo;
        this.create(groupDefinition);
        this.DDI.oldCreateHeader = (CreateHeader)groupDefinition.clone();
    }

    public void build(int n) {
        if (n > 0) {
            this.submitRetrieve(n);
        } else {
            this.makeNew();
        }
    }

    public void build(CreateHeader createHeader) {
        this.create((GroupDefinition)createHeader);
    }

    public void losingFocus() {
        this.createHeaderPanel.losingFocus();
    }

    public void gettingFocus() {
        this.createHeaderPanel.gettingFocus();
    }

    public void showTab(int n) {
    }

    public CreateHeaderPanel getHeaderPanel() {
        return this.createHeaderPanel;
    }

    public void handleResponse(short s, Response response) {
        if (s > 4) {
            return;
        }
        if (!this.showAllRequest) {
            GroupDefinition groupDefinition = (GroupDefinition)response.responseData;
            this.DDI.oldCreateHeader = (CreateHeader)groupDefinition.clone();
            this.create(groupDefinition);
        } else {
            NameList nameList = (NameList)response.responseData;
            this.showAllRequest = false;
            this.showDialog(nameList);
        }
    }

    private NameList avoidDuplicates(NameList nameList) {
        HashMap<Integer, NameList> hashMap = new HashMap<Integer, NameList>();
        NameList nameList2 = null;
        NameList nameList3 = null;
        NameList nameList42 = null;
        while (nameList != null) {
            nameList3 = this.newNameList(nameList.nlName, nameList.nlID, nameList.nlInfo);
            hashMap.put(new Integer(nameList3.nlID), nameList3);
            nameList = nameList.nlNext;
        }
        Collection collection = hashMap.values();
        for (NameList nameList42 : collection) {
            nameList3 = this.newNameList(nameList42.nlName, nameList42.nlID, nameList42.nlInfo);
            nameList3.nlNext = nameList2;
            nameList2 = nameList3;
        }
        return nameList2;
    }

    public String getHelpID(int n) {
        return "repgrp5";
    }

    private NameList newNameList(String string, int n, int n2) {
        NameList nameList = new NameList();
        nameList.nlName = string;
        nameList.nlID = n;
        nameList.nlInfo = (short)n2;
        return nameList;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.selectResourcesButton) {
            FilterResultsViewer filterResultsViewer = new FilterResultsViewer(guiMain.getFrame(), FilterResultsViewer.PICK, this, 0, null, this.DDI.nlInfo, Util.getString("TITLE_SELECT_RESOURCES"));
            GuiUtil.centerDialog(filterResultsViewer);
            filterResultsViewer.displayDialog();
        } else {
            this.sendShowAllRequest();
        }
    }

    private NameList getNameList() {
        GroupDefinition groupDefinition = (GroupDefinition)this.createHeaderPanel.getData();
        TreeSelector treeSelector = (TreeSelector)this.grpSelector.getComponent();
        groupDefinition.members = treeSelector.getReportingNameList();
        if (!this.filterVec.isEmpty()) {
            int n = this.filterVec.size();
            int n2 = 0;
            switch (this.DDI.nlInfo) {
                case 89: {
                    n2 = 95;
                }
            }
            int n3 = 0;
            while (n3 < n) {
                NameList nameList = new NameList();
                nameList.nlName = this.filterVec.get(n3).toString();
                nameList.nlInfo = (short)n2;
                nameList.nlNext = groupDefinition.members;
                groupDefinition.members = nameList;
                ++n3;
            }
        }
        return groupDefinition.members;
    }

    private void sendShowAllRequest() {
        GuiListReq guiListReq = new GuiListReq();
        guiListReq.listRequested = 11;
        Request request = GuiRequest.newRequest("org.eclipse.aperi.server.handler.gui.GuiListHndlr", guiListReq);
        request.flags = (byte)4;
        guiListReq.qualifierObject = this.getNameList();
        if (guiListReq.qualifierObject != null) {
            this.showAllRequest = true;
            GuiClient.doRequest(this, request);
        } else {
            JOptionPane.showMessageDialog(guiMain.getFrame(), Util.getString("LABEL_ALL_RESOURCES_EMPTY"), "GUI1621I", 1);
        }
    }

    private void showDialog(NameList nameList) {
        Object object;
        if (nameList == null) {
            return;
        }
        Vector<Object> vector = new Vector<Object>();
        while (nameList != null) {
            object = new ReportingGroupResourceData();
            ((ReportingGroupResourceData)object).setComputerName(nameList.nlName);
            ((ReportingGroupResourceData)object).setOsType(GuiUtil.getComputer((int)nameList.nlID).gcOsType);
            vector.add(object);
            nameList = nameList.nlNext;
        }
        object = new Vector();
        ((Vector)object).add(Util.getString("STG1102L"));
        new ShowResource(vector, (Vector)object, 1);
    }

    public void addSelectedResources(NameList[] nameListArray) {
        JTree jTree = this.grpSelector.getSourceTree();
        jTree.expandRow(2);
        jTree.clearSelection();
        TreeSelector treeSelector = this.grpSelector.getTreeSelector();
        while (!this.grpSelector.getResourcesAvailable()) {
            System.out.println("Waiting for computer resources");
        }
        jTree.getSelectionModel();
        TreeSelectorNode treeSelectorNode = (TreeSelectorNode)jTree.getModel().getRoot();
        TreeSelectorNode treeSelectorNode2 = (TreeSelectorNode)treeSelectorNode.getChildAt(2);
        int n = 0;
        while (n < nameListArray.length) {
            System.out.println("Selected resources are:  " + nameListArray[n].toString());
            int n2 = 0;
            while (n2 < treeSelectorNode2.getChildCount()) {
                TreeSelectorNode treeSelectorNode3 = (TreeSelectorNode)treeSelectorNode2.getChildAt(n2);
                if (((NameList)treeSelectorNode3.getUserObject()).nlID == nameListArray[n].nlID) {
                    TreePath treePath = new TreePath(treeSelectorNode3.getPath());
                    jTree.addSelectionPath(treePath);
                    break;
                }
                ++n2;
            }
            ++n;
        }
        if (jTree.getSelectionPaths() != null) {
            treeSelector.processSelections(jTree, this.grpSelector.getSelectedTree());
        }
        treeSelector.disableAddButton();
        jTree.setSelectionRow(0);
        jTree.requestFocus();
    }
}

