/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.eclipse.aperi.TStorm.gui.ReportingSelectionDriver;
import org.eclipse.aperi.TStorm.gui.ReportingSelectionTable;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.xmsg.MessageLog;

class ReportingSelectionTableDialog
implements ActionListener {
    private static final char CANCEL = 'X';
    private static final char OK = 'K';
    public Component mainPanel;
    private JDialog dialog;
    private JButton okButton;
    private JButton cancelButton;
    private ReportingSelectionTable resourceSelector;
    private ReportingSelectionTable userSelector;
    private ReportingSelectionTable[] tables;
    private ReportingSelectionDriver driver;
    private Dimension screenSize;
    private JSplitPane splitPane;
    private IGuiMain guiMain = GuiManager.getGuiManager().getGuiMain();

    public ReportingSelectionTableDialog(ReportingSelectionDriver reportingSelectionDriver, GuiReportReq guiReportReq, Object[] objectArray) {
        this.driver = reportingSelectionDriver;
        this.mainPanel = null;
        Object[] objectArray2 = new Object[]{MessageLog.getMessageNoID("STG2019L")};
        boolean bl = false;
        boolean bl2 = false;
        int n = -1;
        if (guiReportReq.reportSubtype == 15) {
            if (bl || bl2) {
                this.userSelector = ReportingSelectionTable.createInstance(this, guiReportReq, n, objectArray2);
                this.resourceSelector = ReportingSelectionTable.createInstance(this, guiReportReq, guiReportReq.reportSubtype, objectArray);
                this.tables = new ReportingSelectionTable[1];
                this.tables[0] = this.userSelector;
                this.mainPanel = this.userSelector;
            }
        } else if (bl || bl2) {
            int n2;
            String string;
            String string2;
            this.userSelector = ReportingSelectionTable.createInstance(this, guiReportReq, n, objectArray2);
            this.resourceSelector = ReportingSelectionTable.createInstance(this, guiReportReq, guiReportReq.reportSubtype, objectArray);
            this.splitPane = new JSplitPane(0);
            if (bl) {
                string2 = "top";
                string = "bottom";
                n2 = 0;
            } else {
                string2 = "bottom";
                string = "top";
                n2 = 1;
            }
            this.splitPane.add((Component)this.resourceSelector, string);
            this.splitPane.add((Component)this.userSelector, string2);
            this.mainPanel = this.splitPane;
            this.tables = new ReportingSelectionTable[2];
            this.tables[n2] = this.userSelector;
            this.tables[1 - n2] = this.resourceSelector;
        } else {
            this.splitPane = null;
            this.resourceSelector = ReportingSelectionTable.createInstance(this, guiReportReq, guiReportReq.reportSubtype, objectArray);
            this.tables = new ReportingSelectionTable[1];
            this.tables[0] = this.resourceSelector;
            this.mainPanel = this.resourceSelector;
        }
        int n3 = this.tables == null ? 0 : this.tables.length;
        while (n3 > 0) {
            if (this.tables[--n3].objectType != -1) continue;
            this.mainPanel = null;
        }
    }

    public void show() {
        int n = this.tables == null ? 0 : this.tables.length;
        boolean bl = n != 0;
        boolean bl2 = !bl;
        int n2 = 0;
        while (n2 < n) {
            ReportingSelectionTable reportingSelectionTable = this.tables[n2];
            if (reportingSelectionTable.status < 2) {
                bl = false;
                switch (reportingSelectionTable.status) {
                    case 0: {
                        reportingSelectionTable.submitRequest();
                        break;
                    }
                    case -1: {
                        bl2 = true;
                    }
                }
            } else if (reportingSelectionTable.status == 3) {
                reportingSelectionTable.selectRows(true);
            } else {
                reportingSelectionTable.selectRows(false);
                reportingSelectionTable.buildPanel();
            }
            ++n2;
        }
        if (!bl) {
            if (bl2) {
                this.driver.disableRowSelectionTableButton();
            }
        } else {
            if (this.dialog != null) {
                Container container = this.dialog.getContentPane();
                container.remove(this.mainPanel);
                this.dialog = null;
            }
            this.makeDialog();
            this.dialog.pack();
            if (this.screenSize == null) {
                this.screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            }
            int n3 = 9 * this.screenSize.height / 10;
            if (this.dialog.getHeight() > n3) {
                this.dialog.setSize(this.dialog.getWidth(), n3);
            } else {
                n3 = this.dialog.getHeight();
            }
            if (this.splitPane != null) {
                this.splitPane.setDividerLocation(n3 / 2);
            }
            GuiUtil.centerDialog(this.dialog);
            this.dialog.show();
            this.driver.setSelectionButtonIcon();
        }
    }

    private void makeDialog() {
        String string = MessageLog.getMessageNoID("GUI2083L");
        this.dialog = new JDialog(this.guiMain.getFrame(), string, true);
        Container container = this.dialog.getContentPane();
        container.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.insets.bottom = 10;
        gridBagConstraints.insets.left = 10;
        gridBagConstraints.insets.right = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        container.add(this.mainPanel, gridBagConstraints);
        string = MessageLog.getMessageNoID("GUI0113L");
        this.okButton = new JButton(string);
        this.okButton.setActionCommand(ReportingSelectionDriver.charToString('K'));
        this.okButton.addActionListener(this);
        JPanel jPanel = new JPanel(new GridBagLayout());
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 0;
        jPanel.add((Component)this.okButton, gridBagConstraints);
        string = MessageLog.getMessageNoID("GUI0114L");
        this.cancelButton = new JButton(string);
        string = ReportingSelectionDriver.charToString('X');
        this.cancelButton.setActionCommand(string);
        this.cancelButton.addActionListener(this);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets.right = 0;
        jPanel.add((Component)this.cancelButton, gridBagConstraints);
        gridBagConstraints.insets.bottom = 10;
        container.add((Component)jPanel, gridBagConstraints);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        boolean bl = true;
        char c = actionEvent.getActionCommand().charAt(0);
        if (c == 'K') {
            try {
                int n = 0;
                while (n < this.tables.length) {
                    this.tables[n].setArray();
                    ++n;
                }
            }
            catch (GeneralException generalException) {
                GuiUtil.displayException(generalException);
                bl = false;
            }
        }
        if (bl) {
            this.dialog.dispose();
        }
    }

    public boolean selectionChanged() {
        return this.resourceSelector.selectionChanged();
    }

    public ReportingSelectionDriver getDriver() {
        return this.driver;
    }
}

