/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.eclipse.aperi.TStorm.common.VolGroupAdjuster;
import org.eclipse.aperi.TStorm.common.VolGroupGrapher;
import org.eclipse.aperi.TStorm.gui.DisplaysChartPopupInterface;
import org.eclipse.aperi.TStorm.gui.ReportingDDI;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportRequest;
import org.eclipse.aperi.TStorm.server.guireq.RespVolGroup;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.MutableLong;
import org.eclipse.aperi.common.MutableShort;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.AskForRowIconInterface;
import org.eclipse.aperi.gui.BaseTableModel;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.HistoryChoiceInterface;
import org.eclipse.aperi.gui.TJCTableMouseAdapter;
import org.eclipse.aperi.gui.TJCTableMouseInterface;
import org.eclipse.aperi.gui.TableCellRenderers;
import org.eclipse.aperi.gui.tables.MegaTable;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class VolGroupTable
extends JPanel
implements GuiRequestor,
DisplaysChartPopupInterface,
HistoryChoiceInterface {
    private MegaTable table = new MegaTable();
    private RespVolGroup[] volGroups;
    private GuiReportReq grr;
    private ReportingDDI ddi;
    private VolGroupAdjuster adjuster;
    private VolGroupGrapher grapher;
    private VolGroupTableModel vgModel;
    private TJCTableMouseAdapter myMouseListener = new selectListener();

    public VolGroupTable(GuiReportReq guiReportReq, ReportingDDI reportingDDI) {
        this.grr = guiReportReq;
        this.ddi = reportingDDI;
        GuiReportRequest guiReportRequest = new GuiReportRequest(guiReportReq);
        GuiClient.doRequest(this, guiReportRequest);
        this.setLayout(new BorderLayout());
        this.adjuster = new VolGroupAdjuster(guiReportReq);
        this.grapher = new VolGroupGrapher();
    }

    public void handleResponse(short s, Response response) {
        this.volGroups = s <= 4 ? (RespVolGroup[])response.responseData : null;
        int n = this.volGroups != null ? this.volGroups.length : 0;
        if (n == 0) {
            this.add((Component)this.ddi.getNoDataMessage_instance(this.grr), "Center");
            this.ddi.jumpToChart = false;
            return;
        }
        this.adjuster.adjust(this.volGroups, false);
        this.volGroups = (RespVolGroup[])this.adjuster.getArray();
        this.vgModel = new VolGroupTableModel();
        this.table.setMouseListener(new selectListener());
        this.table.setFrozenColumns(this.adjuster.getFrozenColumns());
        this.table.setFrozenRows(this.adjuster.frozenRows);
        this.table.setCellRenderer(MutableInteger.class, TableCellRenderers.number);
        this.table.setCellRenderer(MutableLong.class, TableCellRenderers.space);
        this.table.setCellRenderer(Date.class, TableCellRenderers.date);
        this.table.setCellRenderer(MutableShort.class, TableCellRenderers.percent);
        this.table.setBaseTableModel(this.vgModel);
        this.table.iconChanger = this.vgModel;
        this.table.setRowIcon(13, true);
        if (!this.adjuster.columnsAreCustomized()) {
            this.table.setAsFirstColumn(this.adjuster.firstColumn);
        }
        this.ddi.addRowCount(this.adjuster);
        this.add((Component)this.table, "Center");
        if (this.ddi.jumpToChart) {
            this.ddi.jumpToChart = false;
            this.showJumpChart();
        }
    }

    public TJCTableMouseInterface getShowsPopup() {
        return this.myMouseListener;
    }

    public void showJumpChart() {
        ActionEvent actionEvent = new ActionEvent(this, 777, "STG1294T");
        ((ActionListener)((Object)this.myMouseListener)).actionPerformed(actionEvent);
    }

    public VolGroupTable(String string, String string2, String string3, String string4) {
    }

    public Object[] getChoices(int n, int n2) {
        Object[] objectArray = new Object[3];
        String[] stringArray = new String[]{"STG7530L", "STG7531L", "STG7539L", "STG6207L"};
        byte[] byArray = new byte[]{1, 8, 1, 6};
        byte[] byArray2 = new byte[4];
        byArray2[0] = 1;
        byArray2[1] = 2;
        byArray2[2] = 5;
        byte[] byArray3 = byArray2;
        objectArray[0] = stringArray;
        objectArray[1] = byArray;
        objectArray[2] = byArray3;
        return objectArray;
    }

    public Object[] getCharts(int n, int n2) {
        Object[] objectArray = new Object[2];
        String[] stringArray = new String[]{"STG1294T"};
        byte[] byArray = new byte[]{101};
        objectArray[0] = stringArray;
        objectArray[1] = byArray;
        return objectArray;
    }

    public int[] getGraphID(String string) {
        int[] nArray = new int[2];
        nArray[0] = string == "STG5556T" ? 101 : (string == "STG1294T" ? 102 : (string == "STG5105L" ? 1 : (string == "STG5106L" ? 2 : (string == "STG5109L" ? 5 : 0))));
        return nArray;
    }

    private class VolGroupTableModel
    extends BaseTableModel
    implements AskForRowIconInterface {
        VolGroupTableModel() {
            this.rowCount = ((VolGroupTable)VolGroupTable.this).adjuster.volGroups.length;
            this.columnNames = ((VolGroupTable)VolGroupTable.this).adjuster.columnNameList;
            this.commonAdjuster = VolGroupTable.this.adjuster;
        }

        public Object getTableDataItem(int n, int n2) {
            return VolGroupTable.this.adjuster.getCellData(n, VolGroupTable.this.adjuster.translateColumn(n2));
        }

        public boolean changeIcon(int n) {
            return n == 0 && VolGroupTable.this.adjuster.hasTotalsRow();
        }
    }

    public class selectListener
    extends TJCTableMouseAdapter
    implements ActionListener {
        public boolean select(int n, int n2) {
            return true;
        }

        public void doubleClick(int n, int n2) {
            String string;
            String string2;
            RespVolGroup respVolGroup = VolGroupTable.this.volGroups[n];
            respVolGroup.vgFreeSpace /= 512L;
            respVolGroup.vgTotalSpace /= 512L;
            if (respVolGroup.vgType == 2 || respVolGroup.vgType == 4 || respVolGroup.vgType == 5) {
                string2 = MessageLog.getMessageNoID("SAG0032L");
                string = MessageLog.getMessageNoID("SAG0060I");
            } else if (respVolGroup.vgType == 3 || respVolGroup.vgType == 6) {
                if (respVolGroup.rvgComputerOsType == 21) {
                    string2 = MessageLog.getMessageNoID("SAG0063I");
                    string = MessageLog.getMessageNoID("SAG0028L");
                } else {
                    string2 = MessageLog.getMessageNoID("SAG0053I");
                    string = MessageLog.getMessageNoID("SAG0060I");
                }
            } else if (respVolGroup.vgType == 1) {
                string2 = MessageLog.getMessageNoID("STG6101L");
                string = MessageLog.getMessageNoID("SAG0061I");
            } else {
                string2 = MessageLog.getMessageNoID("STG6208L");
                string = MessageLog.getMessageNoID("SAG0028L");
            }
            string2 = String.valueOf(string2) + Util.getString("COLON") + respVolGroup.vgName;
            VolGroupTable.this.ddi.addObject(VolGroupTable.this.grr, "org.eclipse.aperi.TStorm.gui.VolGroupData", respVolGroup, string, string2);
            respVolGroup.vgFreeSpace *= 512L;
            respVolGroup.vgTotalSpace *= 512L;
        }

        public void showPopup(int n, int n2, Component component, int n3, int n4) {
            boolean bl = VolGroupTable.this.table.rowsSelected();
            JPopupMenu jPopupMenu = new JPopupMenu();
            JMenuItem jMenuItem = jPopupMenu.add(MessageLog.getMessageNoID("STG5556T"));
            jMenuItem.setActionCommand("STG5556T");
            jMenuItem.setEnabled(bl);
            jMenuItem.addActionListener(this);
            jMenuItem = jPopupMenu.add(MessageLog.getMessageNoID("STG1294T"));
            jMenuItem.setActionCommand("STG1294T");
            if (((VolGroupTable)VolGroupTable.this).adjuster.volGroups == null) {
                jMenuItem.setEnabled(false);
            } else {
                jMenuItem.setEnabled(true);
            }
            jMenuItem.addActionListener(this);
            jPopupMenu.addSeparator();
            jMenuItem = jPopupMenu.add(MessageLog.getMessageNoID("STG5105L"));
            jMenuItem.setActionCommand("STG5105L");
            jMenuItem.setEnabled(bl);
            jMenuItem.addActionListener(this);
            jMenuItem = jPopupMenu.add(MessageLog.getMessageNoID("STG5106L"));
            jMenuItem.setActionCommand("STG5106L");
            jMenuItem.setEnabled(bl);
            jMenuItem.addActionListener(this);
            jMenuItem = jPopupMenu.add(MessageLog.getMessageNoID("STG5109L"));
            jMenuItem.setActionCommand("STG5109L");
            jMenuItem.setEnabled(bl);
            jMenuItem.addActionListener(this);
            jMenuItem = jPopupMenu.add(MessageLog.getMessageNoID("STG6207L"));
            jMenuItem.setActionCommand("STG6207L");
            jMenuItem.setEnabled(bl);
            jMenuItem.addActionListener(this);
            jPopupMenu.show(component, n3, n4);
            jPopupMenu.requestFocus();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray;
            String string = actionEvent.getActionCommand();
            if (string == "STG1294T") {
                nArray = new int[((VolGroupTable)VolGroupTable.this).adjuster.volGroups.length];
                int n = 0;
                while (n < nArray.length) {
                    nArray[n] = VolGroupTable.this.table.getDataRow(n);
                    ++n;
                }
            } else {
                nArray = VolGroupTable.this.table.getSelectedRows();
            }
            if (string == "STG1294T" || string == "STG5556T") {
                int[] nArray2 = VolGroupTable.this.getGraphID(string);
                ((VolGroupTable)VolGroupTable.this).grr.chartSubtype = (byte)nArray2[0];
                VolGroupTable.this.grapher.createChart(VolGroupTable.this.grr, VolGroupTable.this.volGroups, nArray, VolGroupTable.this.adjuster, VolGroupTable.this.ddi, null);
            } else {
                this.createHistory(nArray, string);
            }
        }

        public void showDefaultChart(int n) {
            int[] nArray = new int[]{n};
            this.createHistory(nArray, "STG5105L");
        }

        private void createHistory(int[] nArray, String string) {
            GuiReportReq guiReportReq = VolGroupTable.this.grapher.createHistory(VolGroupTable.this.grr, VolGroupTable.this.volGroups, nArray, string, VolGroupTable.this.adjuster);
            VolGroupTable.this.ddi.addObject(VolGroupTable.this.grr, "org.eclipse.aperi.TStorm.gui.SpaceHistChart", guiReportReq, MessageLog.getMessageNoID("STG1279T"), guiReportReq.historyTitle, VolGroupTable.this);
        }

        public void addActionListener(ActionListener actionListener) {
            VolGroupTable.this.listenerList.add(ActionListener.class, actionListener);
        }
    }
}

