/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui.rptfilter;

import java.text.DecimalFormatSymbols;
import org.eclipse.aperi.TStorm.common.ColumnFilter;
import org.eclipse.aperi.TStorm.common.ColumnFilterValue;
import org.eclipse.aperi.TStorm.gui.rptfilter.FreeForm;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.MutableLong;
import org.eclipse.aperi.xmsg.MessageLog;

public class IntegerFreeForm
extends FreeForm {
    public static char decimalPoint;
    private int escala;

    static {
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
        decimalPoint = decimalFormatSymbols.getDecimalSeparator();
    }

    public static String format(MutableLong mutableLong, int n) {
        String string = Long.toString(mutableLong.value);
        if (n > 0) {
            int n2 = string.length();
            StringBuffer stringBuffer = new StringBuffer(n2 + 1);
            int n3 = n2 - n;
            int n4 = 0;
            while (n4 < n2) {
                if (n4 == n3) {
                    stringBuffer.append(decimalPoint);
                }
                stringBuffer.append(string.charAt(n4));
                ++n4;
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    public static MutableLong parse(String string, int n) throws GeneralException {
        int n2;
        int n3 = n2 = string.length();
        boolean bl = true;
        int n4 = 0;
        while (bl && n4 < n2) {
            char c = string.charAt(n4);
            if (!Character.isDigit(c)) {
                if (c != decimalPoint || n3 < n2) {
                    bl = false;
                } else {
                    n3 = n4;
                }
            }
            ++n4;
        }
        if (!bl) {
            Object[] objectArray = new Object[]{string};
            String string2 = MessageLog.getMessageNoTS("STG3266E", objectArray);
            throw new GeneralException(string2);
        }
        StringBuffer stringBuffer = new StringBuffer();
        n4 = 0;
        while (n4 < n3) {
            stringBuffer.append(string.charAt(n4++));
        }
        ++n4;
        while (n > 0) {
            if (n4 < n2) {
                stringBuffer.append(string.charAt(n4++));
            } else {
                stringBuffer.append('0');
            }
            --n;
        }
        try {
            long l = Long.parseLong(stringBuffer.toString());
            return new MutableLong(l);
        }
        catch (NumberFormatException numberFormatException) {
            Object[] objectArray = new Object[]{string};
            String string3 = MessageLog.getMessageNoTS("STG3266E", objectArray);
            throw new GeneralException(string3);
        }
    }

    public IntegerFreeForm(ColumnFilter columnFilter) {
        super(columnFilter);
        this.escala = columnFilter.clfColumn.cdScale;
    }

    public void refresh() {
        String string = "";
        ColumnFilterValue columnFilterValue = this.filter.clfValueList;
        if (columnFilterValue != null) {
            Object object = columnFilterValue.fvValue;
            if (!(object instanceof MutableLong)) {
                string = "***ERROR***";
            } else {
                MutableLong mutableLong = (MutableLong)object;
                string = IntegerFreeForm.format(mutableLong, this.escala);
            }
        }
        this.textField.setText(string);
    }

    public void getData() throws GeneralException {
        ColumnFilterValue columnFilterValue;
        this.ensureNonEmpty();
        String string = this.textField.getText().trim();
        MutableLong mutableLong = IntegerFreeForm.parse(string, this.escala);
        this.filter.clfValueList = columnFilterValue = new ColumnFilterValue(mutableLong);
    }
}

