/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui.rptfilter;

import java.io.Serializable;
import java.text.NumberFormat;
import java.text.ParseException;
import org.eclipse.aperi.TStorm.common.ColumnFilter;
import org.eclipse.aperi.TStorm.common.ColumnFilterValue;
import org.eclipse.aperi.TStorm.gui.rptfilter.FreeForm;
import org.eclipse.aperi.TStorm.gui.rptfilter.IntegerFreeForm;
import org.eclipse.aperi.TStorm.gui.rptfilter.StringMultipleFreeForm;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.MutableLong;
import org.eclipse.aperi.xmsg.MessageLog;

public class StorageFreeForm
extends FreeForm {
    private static final int FRACTION_DIGITS = 2;
    public static double addAmt = 0.005;
    public static double subAmt = -0.005;
    private static final String UNITS = "bkMGT";
    private static final String CAPITAL_UNITS = "bkMGT".toUpperCase();

    private static char getUnitLetter(short s) {
        char c = '\u0000';
        if (s >= 0 && s < UNITS.length()) {
            c = UNITS.charAt(s);
        }
        return c;
    }

    private static boolean validateNumber(String string, MutableInteger mutableInteger) {
        boolean bl = false;
        boolean bl2 = false;
        int n = string.length();
        boolean bl3 = true;
        while (bl3 && mutableInteger.value < n) {
            char c = string.charAt(mutableInteger.value);
            if (Character.isDigit(c)) {
                bl2 = true;
            } else if (c == IntegerFreeForm.decimalPoint && !bl) {
                bl = true;
            } else {
                bl3 = false;
            }
            if (!bl3) continue;
            ++mutableInteger.value;
        }
        return bl2;
    }

    public static ColumnFilterValue parse(String string, MutableInteger mutableInteger, boolean bl) throws GeneralException {
        return StorageFreeForm.parse(string, mutableInteger, bl, false, 0.0);
    }

    public static ColumnFilterValue parse(String string, MutableInteger mutableInteger, boolean bl, boolean bl2, double d) throws GeneralException {
        StringMultipleFreeForm.breezeBySpace(string, mutableInteger);
        ColumnFilterValue columnFilterValue = null;
        int n = mutableInteger.value;
        if (StorageFreeForm.validateNumber(string, mutableInteger)) {
            boolean bl3 = true;
            short s = 0;
            String string2 = string.substring(n, mutableInteger.value);
            int n2 = string.length();
            StringMultipleFreeForm.breezeBySpace(string, mutableInteger);
            if (mutableInteger.value < n2) {
                char c = Character.toUpperCase(string.charAt(mutableInteger.value));
                short s2 = (short)CAPITAL_UNITS.indexOf(c);
                if (s2 >= 0) {
                    s = s2;
                    ++mutableInteger.value;
                    StringMultipleFreeForm.breezeByNonSpace(string, mutableInteger);
                } else if (!bl) {
                    bl3 = false;
                }
            }
            if (bl3) {
                Serializable serializable;
                long l = -1L;
                if (s == 0) {
                    try {
                        l = Long.parseLong(string2);
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else {
                    string2 = StorageFreeForm.trimDecimal(string2);
                    serializable = NumberFormat.getInstance();
                    Number number = null;
                    try {
                        number = serializable.parse(string2);
                    }
                    catch (ParseException parseException) {}
                    if (number != null) {
                        double d2 = number.doubleValue();
                        d2 *= (double)StorageFreeForm.longFromUnit(s);
                        if (bl2) {
                            d2 += d * (double)StorageFreeForm.longFromUnit(s);
                        }
                        l = (long)d2;
                    }
                }
                if (l >= 0L) {
                    serializable = new MutableLong(l);
                    columnFilterValue = new ColumnFilterValue(serializable, s);
                }
            }
        }
        if (columnFilterValue == null) {
            Object[] objectArray = new Object[]{string.substring(n)};
            String string3 = MessageLog.getMessageNoTS("STG3267E", objectArray);
            throw new GeneralException(string3);
        }
        return columnFilterValue;
    }

    public static String format(MutableLong mutableLong, short s) {
        String string;
        long l = mutableLong.value;
        if (s <= 0) {
            string = Long.toString(l);
        } else {
            long l2 = StorageFreeForm.longFromUnit(s);
            double d = (double)l / (double)l2;
            NumberFormat numberFormat = NumberFormat.getInstance();
            numberFormat.setMaximumFractionDigits(2);
            numberFormat.setGroupingUsed(false);
            StringBuffer stringBuffer = new StringBuffer(40);
            stringBuffer.append(numberFormat.format(d));
            char c = StorageFreeForm.getUnitLetter(s);
            if (c != '\u0000') {
                stringBuffer.append(c);
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    public StorageFreeForm(ColumnFilter columnFilter) {
        super(columnFilter);
    }

    public void refresh(boolean bl) {
        String string = "";
        ColumnFilterValue columnFilterValue = this.filter.clfValueList;
        if (columnFilterValue != null) {
            Object object = columnFilterValue.fvValue;
            if (!(object instanceof MutableLong)) {
                string = "***ERROR***";
            } else {
                MutableLong mutableLong = (MutableLong)object;
                if (bl) {
                    mutableLong = this.adjustForRounding(mutableLong);
                }
                string = StorageFreeForm.format(mutableLong, columnFilterValue.fvInputUnit);
            }
        }
        this.textField.setText(string);
    }

    public void refresh() {
        this.refresh(false);
    }

    public void getAdjustedData(double d) throws GeneralException {
        this.ensureNonEmpty();
        String string = this.textField.getText();
        short cfr_ignored_0 = this.filter.clfCondition;
        this.filter.clfValueList = StorageFreeForm.parse(string, new MutableInteger(), false, true, d);
    }

    public void getData() throws GeneralException {
        this.ensureNonEmpty();
        String string = this.textField.getText();
        this.filter.clfValueList = StorageFreeForm.parse(string, new MutableInteger(), false);
    }

    public static String trimDecimal(String string) {
        int n = string.indexOf(IntegerFreeForm.decimalPoint);
        if (n >= 0 && string.length() > (n += 2) + 1) {
            string = string.substring(0, n + 1);
        }
        return string;
    }
}

