/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui.rptfilter;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.eclipse.aperi.TStorm.common.ColumnDescriptor;
import org.eclipse.aperi.TStorm.common.ColumnFilter;
import org.eclipse.aperi.TStorm.gui.ReportingSelectionDriver;
import org.eclipse.aperi.TStorm.gui.rptfilter.DateBetweenEditor;
import org.eclipse.aperi.TStorm.gui.rptfilter.DateEditor;
import org.eclipse.aperi.TStorm.gui.rptfilter.DurationBetweenEditor;
import org.eclipse.aperi.TStorm.gui.rptfilter.DurationEditor;
import org.eclipse.aperi.TStorm.gui.rptfilter.EnumeratedMultipleEditor;
import org.eclipse.aperi.TStorm.gui.rptfilter.IntegerMultipleEditor;
import org.eclipse.aperi.TStorm.gui.rptfilter.StorageBetweenEditor;
import org.eclipse.aperi.TStorm.gui.rptfilter.StorageEditor;
import org.eclipse.aperi.TStorm.gui.rptfilter.StorageMultipleEditor;
import org.eclipse.aperi.TStorm.gui.rptfilter.StringMultipleEditor;
import org.eclipse.aperi.TStorm.gui.rptfilter.ValueEditor;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.xmsg.MessageLog;

public class ValueEditorDialog
implements ActionListener,
WindowListener {
    private static char OK = (char)75;
    private static char CANCEL = (char)88;
    private JDialog dialog;
    private ColumnFilter original;
    private ColumnFilter changed;
    private ValueEditor editor;
    private JButton okButton;
    private boolean okPressed;

    public ValueEditorDialog(Dialog dialog, ColumnFilter columnFilter) {
        this.original = columnFilter;
        this.changed = (ColumnFilter)columnFilter.clone();
        ColumnDescriptor columnDescriptor = columnFilter.clfColumn;
        this.dialog = new JDialog(dialog, columnDescriptor.cdReportName, true);
        Container container = this.dialog.getContentPane();
        container.setLayout(new BorderLayout());
        container.add(Box.createHorizontalStrut(10), "West");
        container.add(Box.createHorizontalStrut(10), "East");
        container.add(Box.createVerticalStrut(10), "North");
        JPanel jPanel = new JPanel(new GridBagLayout());
        String string = MessageLog.getMessageNoID("GUI0113L");
        this.okButton = new JButton(string);
        string = ReportingSelectionDriver.charToString(OK);
        this.okButton.setActionCommand(string);
        this.okButton.addActionListener(this);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.insets.bottom = 15;
        gridBagConstraints.insets.right = 3;
        gridBagConstraints.gridheight = 0;
        jPanel.add((Component)this.okButton, gridBagConstraints);
        this.dialog.getRootPane().setDefaultButton(this.okButton);
        string = MessageLog.getMessageNoID("GUI0114L");
        JButton jButton = new JButton(string);
        string = ReportingSelectionDriver.charToString(CANCEL);
        jButton.setActionCommand(string);
        jButton.addActionListener(this);
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.insets.left = 3;
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)jButton, gridBagConstraints);
        container.add((Component)jPanel, "South");
        if (columnFilter.clfColumn.cdValidValue != null) {
            this.editor = new EnumeratedMultipleEditor(this.changed, this);
        } else {
            this.editor = null;
            block0 : switch (columnFilter.clfDataType) {
                case 1: {
                    this.editor = new StringMultipleEditor(this.changed, this);
                    break;
                }
                case 2: {
                    this.editor = new IntegerMultipleEditor(this.changed, this);
                    break;
                }
                case 3: 
                case 6: {
                    if (columnFilter.clfCondition == 11 || columnFilter.clfCondition == 12) {
                        this.editor = new DateBetweenEditor(this.changed, this);
                        break;
                    }
                    this.editor = new DateEditor(this.changed, this);
                    break;
                }
                case 4: {
                    if (columnFilter.clfCondition == 11 || columnFilter.clfCondition == 12) {
                        this.editor = new DurationBetweenEditor(this.changed);
                        break;
                    }
                    this.editor = new DurationEditor(this.changed);
                    break;
                }
                case 5: {
                    switch (columnFilter.clfCondition) {
                        case 7: {
                            this.editor = new StorageMultipleEditor(this.changed, this);
                            break block0;
                        }
                        case 11: 
                        case 12: {
                            this.editor = new StorageBetweenEditor(this.changed);
                            break block0;
                        }
                    }
                    this.editor = new StorageEditor(this.changed);
                }
            }
        }
        if (this.editor == null) {
            string = "Unknown data type: " + Integer.toString(columnFilter.clfDataType);
            throw new RuntimeException(string);
        }
        container.add(this.editor.getWholeComponent(), "Center");
        this.dialog.addWindowListener(this);
    }

    public boolean show() {
        this.okPressed = false;
        this.dialog.pack();
        GuiUtil.centerDialog(this.dialog);
        this.dialog.show();
        return this.okPressed;
    }

    public void setOKEnabled(boolean bl) {
        this.okButton.setEnabled(bl);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.charAt(0) == OK) {
            try {
                this.editor.getData();
            }
            catch (GeneralException generalException) {
                Toolkit.getDefaultToolkit().beep();
                if (generalException.getMessage() != null) {
                    GuiUtil.displayException(generalException);
                }
                return;
            }
            this.original.clfDataType = this.changed.clfDataType;
            this.original.clfValueList = this.changed.clfValueList;
            this.okPressed = true;
        }
        this.dialog.dispose();
    }

    public void windowClosing(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
        this.editor.setFocus();
    }
}

