/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.common;

import java.io.Serializable;
import org.eclipse.aperi.common.LockRequestor;
import org.eclipse.aperi.common.Packable;
import org.eclipse.aperi.common.Packer;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.ReusableObjectPool;

public class LockResource
implements Serializable,
Cloneable,
Packable {
    static final long serialVersionUID = -4938072426549870056L;
    public LockResource lrsNext;
    public short lrsProductID;
    public String lrsResource;
    public LockRequestor lrsHolders;
    public LockRequestor lrsWaitersHead;
    public transient LockRequestor lrsWaitersTail;
    private Packable[] lrsHoldersPacked;
    private Packable[] lrsWaitersPacked;
    public static final int MAX_PRODUCTS = 5;
    public static final short TSTORM = 0;
    public static final short TTIME = 1;
    public static final short SERVER = 2;
    public static final short DB = 3;
    public static final short NAS = 4;
    public static final String[] productName = new String[]{"T-Storm", "T-Time", "Server", "Db", "Nas"};
    private static ReusableObjectPool pool = new ReusableObjectPool(30);

    public static LockResource getLockResource(short s, String string) {
        LockResource lockResource;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(LockResource.class.getName(), "getLockResource", "productID, resource");
        }
        if ((lockResource = (LockResource)pool.getObject()) == null) {
            lockResource = new LockResource();
        }
        lockResource.lrsProductID = s;
        lockResource.lrsResource = string;
        LockResource lockResource2 = lockResource;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(LockResource.class.getName(), "getLockResource", lockResource2);
        }
        return lockResource2;
    }

    public void returnLockResource() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(LockResource.class.getName(), "returnLockResource", "");
        }
        this.lrsNext = null;
        this.lrsResource = null;
        this.lrsWaitersHead = null;
        this.lrsWaitersTail = null;
        this.lrsHolders = null;
        pool.returnObject(this);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(LockResource.class.getName(), "returnLockResource");
        }
    }

    public Object clone() {
        LockResource lockResource = LockResource.getLockResource(this.lrsProductID, this.lrsResource);
        lockResource.lrsHolders = this.cloneRequestors(this.lrsHolders);
        lockResource.lrsWaitersHead = this.cloneRequestors(this.lrsWaitersHead);
        return lockResource;
    }

    public LockRequestor cloneRequestors(LockRequestor lockRequestor) {
        LockRequestor lockRequestor2 = null;
        LockRequestor lockRequestor3 = null;
        while (lockRequestor != null) {
            LockRequestor lockRequestor4 = (LockRequestor)lockRequestor.clone();
            if (lockRequestor3 == null) {
                lockRequestor2 = lockRequestor4;
            } else {
                lockRequestor3.lrqNext = lockRequestor4;
            }
            lockRequestor3 = lockRequestor4;
            lockRequestor = lockRequestor.lrqNext;
        }
        return lockRequestor2;
    }

    public static LockResource[] pack(LockResource lockResource) {
        LockResource lockResource2 = lockResource;
        while (lockResource2 != null) {
            lockResource2.lrsHoldersPacked = (Packable[])Packer.pack(lockResource2.lrsHolders);
            lockResource2.lrsWaitersPacked = (Packable[])Packer.pack(lockResource2.lrsWaitersHead);
            lockResource2 = lockResource2.lrsNext;
        }
        return (LockResource[])Packer.pack(lockResource);
    }

    public static LockResource unpack(LockResource[] lockResourceArray) {
        LockResource lockResource;
        LockResource lockResource2 = lockResource = (LockResource)Packer.unpack(lockResourceArray);
        while (lockResource2 != null) {
            lockResource2.lrsHolders = (LockRequestor)Packer.unpack(lockResource2.lrsHoldersPacked);
            lockResource2.lrsWaitersHead = (LockRequestor)Packer.unpack(lockResource2.lrsWaitersPacked);
            lockResource2 = lockResource2.lrsNext;
        }
        return lockResource;
    }

    public Packable getNext() {
        return this.lrsNext;
    }

    public void setNext(Packable packable) {
        this.lrsNext = (LockResource)packable;
    }
}

