/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.common;

import org.eclipse.aperi.common.CreateHeader;
import org.eclipse.aperi.common.Util;

public class ScheduleHeader
extends CreateHeader {
    static final long serialVersionUID = -3533266123886784522L;
    public byte scheduleType = 1;
    public short startYear;
    public short startMonth;
    public short startDay;
    public short startHour;
    public short startMinute;
    public byte repeatType = 1;
    public byte intervalType = (byte)4;
    public short intervalNumber = 1;
    public byte runSunday = 1;
    public byte runMonday = 1;
    public byte runTuesday = 1;
    public byte runWednesday = 1;
    public byte runThursday = 1;
    public byte runFriday = 1;
    public byte runSaturday = 1;
    public byte timezoneType = 1;
    public byte globalType = 0;
    public String timezone = " ";
    public String arguments = " ";
    public int alertID = 0;
    public short jobType = 0;
    public int highRunNumber = 0;
    public int computerID = 0;
    public static final byte DISABLED = 0;
    public static final byte ENABLED = 1;
    public static final byte NOW = 1;
    public static final byte ONCE = 2;
    public static final byte REPEATEDLY = 3;
    public static final byte APPLICATION_DEFINED = 4;
    public static final byte INTERVAL = 1;
    public static final byte DAYS = 2;
    public static final byte LOCAL = 1;
    public static final byte GLOBAL = 2;
    public static final byte SERVER = 1;
    public static final byte ZONE = 2;
    public static final byte NO = 1;
    public static final byte YES = 2;
    public static final byte MINUTE = 1;
    public static final byte HOUR = 2;
    public static final byte DAY = 3;
    public static final byte WEEK = 4;
    public static final byte MONTH = 5;

    public void clear() {
        this.scheduleType = 1;
        this.startYear = 0;
        this.startMonth = 0;
        this.startDay = 0;
        this.startHour = 0;
        this.startMinute = 0;
        this.repeatType = 1;
        this.intervalType = (byte)4;
        this.intervalNumber = 1;
        this.runSunday = 1;
        this.runMonday = 1;
        this.runTuesday = 1;
        this.runWednesday = 1;
        this.runThursday = 1;
        this.runFriday = 1;
        this.runSaturday = 1;
        this.timezoneType = 1;
        this.globalType = 0;
        this.timezone = " ";
        this.arguments = " ";
    }

    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        ScheduleHeader scheduleHeader = (ScheduleHeader)object;
        if (this.computerID != scheduleHeader.computerID) {
            return false;
        }
        if (this.scheduleType != scheduleHeader.scheduleType) {
            return false;
        }
        if (this.scheduleType == 1) {
            return true;
        }
        if (this.startMinute != scheduleHeader.startMinute || this.startHour != scheduleHeader.startHour || this.startDay != scheduleHeader.startDay || this.startMonth != scheduleHeader.startMonth || this.startYear != scheduleHeader.startYear) {
            return false;
        }
        if (this.scheduleType == 3) {
            if (this.repeatType != scheduleHeader.repeatType) {
                return false;
            }
            if (this.repeatType == 1 ? this.intervalType != scheduleHeader.intervalType || this.intervalNumber != scheduleHeader.intervalNumber : this.runSunday != scheduleHeader.runSunday || this.runMonday != scheduleHeader.runMonday || this.runTuesday != scheduleHeader.runTuesday || this.runWednesday != scheduleHeader.runWednesday || this.runThursday != scheduleHeader.runThursday || this.runFriday != scheduleHeader.runFriday || this.runSaturday != scheduleHeader.runSaturday) {
                return false;
            }
        }
        if (!Util.stringsEqual(this.arguments, scheduleHeader.arguments)) {
            return false;
        }
        if (this.jobType != 17) {
            if (this.timezoneType != scheduleHeader.timezoneType) {
                return false;
            }
            if (this.timezoneType == 1) {
                return true;
            }
        }
        if (this.globalType != scheduleHeader.globalType) {
            return false;
        }
        if (this.globalType == 1) {
            return true;
        }
        return Util.stringsEqual(this.timezone, scheduleHeader.timezone);
    }
}

