/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.constants.metadata;

import java.util.AbstractSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.aperi.constants.metadata.IMetadataManagerListener;
import org.eclipse.aperi.constants.metadata.IMetadataSource;
import org.eclipse.aperi.util.osgi.IDisposable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.RegistryFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataManager
implements IRegistryChangeListener,
IDisposable {
    public static final String ATTR_CLASS = "class";
    private String extensionPointId;
    private Set<IMetadataManagerListener> listenerSet;
    private Map<String, IMetadataSource> metadataSourceCache;
    private ReadWriteLock cacheLock;

    public MetadataManager(String string) {
        this.extensionPointId = string;
        this.listenerSet = new HashSet<IMetadataManagerListener>();
        this.metadataSourceCache = new HashMap<String, IMetadataSource>();
        this.cacheLock = new ReentrantReadWriteLock(true);
    }

    public void initialize() {
        IExtensionRegistry iExtensionRegistry = RegistryFactory.getRegistry();
        if (iExtensionRegistry != null) {
            IConfigurationElement[] iConfigurationElementArray = iExtensionRegistry.getConfigurationElementsFor(this.extensionPointId);
            int n = 0;
            while (n < iConfigurationElementArray.length) {
                try {
                    this.addSource(iConfigurationElementArray[n]);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                ++n;
            }
        } else {
            throw new RuntimeException("Failed to obtain reference to extension registry.");
        }
        iExtensionRegistry.addRegistryChangeListener((IRegistryChangeListener)this);
    }

    public void dispose() {
        this.cacheLock.writeLock().lock();
        try {
            RegistryFactory.getRegistry().removeRegistryChangeListener((IRegistryChangeListener)this);
            for (IMetadataSource iMetadataSource : this.metadataSourceCache.values()) {
                try {
                    iMetadataSource.dispose();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            this.metadataSourceCache.clear();
            this.listenerSet.clear();
        }
        finally {
            this.cacheLock.writeLock().unlock();
        }
    }

    public void registryChanged(IRegistryChangeEvent iRegistryChangeEvent) {
        IExtensionDelta[] iExtensionDeltaArray = iRegistryChangeEvent.getExtensionDeltas();
        int n = 0;
        while (n < iExtensionDeltaArray.length) {
            IExtension iExtension = iExtensionDeltaArray[n].getExtension();
            if (iExtension.getExtensionPointUniqueIdentifier().equals(this.extensionPointId)) {
                int n2;
                IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
                if (iExtensionDeltaArray[n].getKind() == 1) {
                    n2 = 0;
                    while (n2 < iConfigurationElementArray.length) {
                        try {
                            this.addSource(iConfigurationElementArray[n2]);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        ++n2;
                    }
                } else if (iExtensionDeltaArray[n].getKind() == 2) {
                    n2 = 0;
                    while (n2 < iConfigurationElementArray.length) {
                        try {
                            this.removeSource(iConfigurationElementArray[n2]);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        ++n2;
                    }
                }
            }
            ++n;
        }
    }

    public Object get(Object object, String string) {
        Object object2 = null;
        this.cacheLock.readLock().lock();
        try {
            Iterator<IMetadataSource> iterator = this.metadataSourceCache.values().iterator();
            while (iterator.hasNext()) {
                object2 = iterator.next().getValue(object, string);
                if (object2 == null) continue;
                break;
            }
        }
        finally {
            this.cacheLock.readLock().unlock();
        }
        return object2;
    }

    public Lock getCacheReadLock() {
        return this.cacheLock.readLock();
    }

    public Set<?> getSupportedConstants() {
        return this.getSupportedConstants(false);
    }

    public Set<?> getSupportedConstants(boolean bl) {
        AbstractSet abstractSet = bl ? new TreeSet() : new HashSet();
        this.cacheLock.readLock().lock();
        try {
            Iterator<IMetadataSource> iterator = this.metadataSourceCache.values().iterator();
            while (iterator.hasNext()) {
                abstractSet.addAll(iterator.next().getSupportedConstants());
            }
        }
        finally {
            this.cacheLock.readLock().unlock();
        }
        return abstractSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(IMetadataManagerListener iMetadataManagerListener) {
        Set<IMetadataManagerListener> set = this.listenerSet;
        synchronized (set) {
            this.listenerSet.add(iMetadataManagerListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(IMetadataManagerListener iMetadataManagerListener) {
        Set<IMetadataManagerListener> set = this.listenerSet;
        synchronized (set) {
            this.listenerSet.remove(iMetadataManagerListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSource(IConfigurationElement iConfigurationElement) throws Exception {
        this.cacheLock.writeLock().lock();
        try {
            String string = iConfigurationElement.getAttribute(ATTR_CLASS);
            if (this.metadataSourceCache.containsKey(string)) {
                throw new RuntimeException("Metadata source named " + string + " is already registred.");
            }
            IMetadataSource iMetadataSource = (IMetadataSource)iConfigurationElement.createExecutableExtension(ATTR_CLASS);
            this.metadataSourceCache.put(string, iMetadataSource);
            Set<IMetadataManagerListener> set = this.listenerSet;
            synchronized (set) {
                Iterator<IMetadataManagerListener> iterator = this.listenerSet.iterator();
                while (iterator.hasNext()) {
                    try {
                        iterator.next().metadataSourceAdded(iMetadataSource);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }
        finally {
            this.cacheLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSource(IConfigurationElement iConfigurationElement) throws Exception {
        block9: {
            this.cacheLock.writeLock().lock();
            try {
                String string = iConfigurationElement.getAttribute(ATTR_CLASS);
                IMetadataSource iMetadataSource = this.metadataSourceCache.remove(string);
                if (iMetadataSource == null) break block9;
                Set<IMetadataManagerListener> set = this.listenerSet;
                synchronized (set) {
                    Iterator<IMetadataManagerListener> iterator = this.listenerSet.iterator();
                    while (iterator.hasNext()) {
                        try {
                            iterator.next().metadataSourceRemoved(iMetadataSource);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
                iMetadataSource.dispose();
            }
            finally {
                this.cacheLock.writeLock().unlock();
            }
        }
    }
}

