/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.common;

import java.util.ArrayList;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.common.api.SRMMessage;
import org.eclipse.aperi.disk.common.IConvertableSubJobResult;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;

public class ResultHelper {
    public static AsyncResult addAsyncSubResultsSuccess(AsyncResult asyncResult, ArrayList arrayList, String string) {
        AsyncResult[] asyncResultArray = new AsyncResult[arrayList.size()];
        int n = 0;
        while (n < arrayList.size()) {
            SRMMessage sRMMessage = new SRMMessage("HWN020001I", new String[]{string});
            AsyncResult asyncResult2 = new AsyncResult(0, 1, sRMMessage);
            if (!(arrayList.get(n) instanceof IConvertableSubJobResult)) {
                throw new RuntimeException("Type of pResults.get(i) not supported. Extend method addAsyncSubResultsSuccess for proper support.");
            }
            asyncResult2.setResults(((IConvertableSubJobResult)arrayList.get(n)).toArray());
            asyncResultArray[n] = asyncResult2;
            ++n;
        }
        ResultHelper.addAsyncSubResults(asyncResult, asyncResultArray);
        return asyncResult;
    }

    public static AsyncResult addAsyncSubResultsException(AsyncResult asyncResult, ArrayList arrayList, int n, SRMMessage sRMMessage, Exception exception) {
        AsyncResult[] asyncResultArray = new AsyncResult[arrayList.size()];
        int n2 = 0;
        while (n2 < arrayList.size()) {
            AsyncResult asyncResult2 = new AsyncResult(n, 0, sRMMessage);
            asyncResult2.setResults(new Object[]{arrayList.get(n2)});
            asyncResult2.setReturnException(exception);
            asyncResultArray[n2] = asyncResult2;
            ++n2;
        }
        ResultHelper.addAsyncSubResults(asyncResult, asyncResultArray);
        return asyncResult;
    }

    public static AsyncResult addAsyncSubResults(AsyncResult asyncResult, AsyncResult[] asyncResultArray) {
        if (asyncResultArray.length == 0) {
            return asyncResult;
        }
        AsyncResult[] asyncResultArray2 = asyncResult.getSubJobResults();
        int n = 0;
        if (asyncResultArray2 != null) {
            n = asyncResultArray2.length;
        }
        AsyncResult[] asyncResultArray3 = new AsyncResult[n + asyncResultArray.length];
        if (n > 0) {
            System.arraycopy(asyncResultArray2, 0, asyncResultArray3, 0, n);
        }
        int n2 = 0;
        while (n2 < asyncResultArray.length) {
            asyncResultArray3[n + n2] = asyncResultArray[n2];
            ++n2;
        }
        asyncResult.setSubJobResults(asyncResultArray3);
        return asyncResult;
    }

    public static AsyncResult computeAndSetFinalStatus(AsyncResult asyncResult, String string) throws RuntimeException {
        return ResultHelper.computeAndSetFinalStatus(asyncResult.getSubJobResults(), string);
    }

    public static AsyncResult computeAndSetFinalStatus(AsyncResult[] asyncResultArray, String string) throws RuntimeException {
        AsyncResult asyncResult = new AsyncResult(-1, -1);
        int n = asyncResult.getStatus();
        int n2 = 0;
        while (n2 < asyncResultArray.length) {
            if (n == 4) break;
            switch (asyncResultArray[n2].getStatus()) {
                case 3: 
                case 4: {
                    n = 4;
                    break;
                }
                case 1: {
                    if (n == 0) {
                        n = 4;
                        break;
                    }
                    n = 1;
                    break;
                }
                case 0: {
                    if (n == 1) {
                        n = 4;
                        break;
                    }
                    n = 0;
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid status of subjob. Status is: " + asyncResultArray[n2].getStatus());
                }
            }
            ++n2;
        }
        if (asyncResult.getReturnException() != null && n == 1) {
            n = 4;
        }
        switch (n) {
            case 1: {
                asyncResult.setSRMMessage(new SRMMessage("HWN020001I", new String[]{string}));
                asyncResult.setRc(0);
                break;
            }
            case 4: {
                asyncResult.setSRMMessage(new SRMMessage("HWN021600W", new String[]{string}));
                asyncResult.setRc(10008);
                break;
            }
            case 0: {
                asyncResult.setSRMMessage(new SRMMessage("HWN021601E", new String[]{string}));
                asyncResult.setRc(10007);
                break;
            }
            default: {
                throw new RuntimeException("Invalid status. Status is: " + n);
            }
        }
        asyncResult.setStatus(n);
        asyncResult.setSubJobResults(asyncResultArray);
        return asyncResult;
    }

    public static ArrayList getSubResults(AsyncResult asyncResult) {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry("ResultHelper", "getSuccessfulSubResults", new Object[]{asyncResult});
        ArrayList<Object> arrayList = new ArrayList<Object>();
        try {
            ArrayList<AsyncResult> arrayList2 = new ArrayList<AsyncResult>();
            AsyncResult[] asyncResultArray = asyncResult.getSubJobResults();
            int n = 0;
            while (n < asyncResultArray.length) {
                arrayList2.add(asyncResultArray[n]);
                ++n;
            }
            int n2 = 0;
            while (n2 < arrayList2.size()) {
                AsyncResult asyncResult2 = (AsyncResult)arrayList2.get(n2);
                arrayList.add(asyncResult2.getResults()[0]);
                ++n2;
            }
        }
        finally {
            logTraceHelper.exit(arrayList);
        }
        return arrayList;
    }

    public static ArrayList getSuccessfulSubResults(AsyncResult asyncResult) {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry("ResultHelper", "getSuccessfulSubResults", new Object[]{asyncResult});
        ArrayList<Object> arrayList = new ArrayList<Object>();
        try {
            ArrayList<AsyncResult> arrayList2 = new ArrayList<AsyncResult>();
            AsyncResult[] asyncResultArray = asyncResult.getSubJobResults();
            int n = 0;
            while (n < asyncResultArray.length) {
                if (asyncResultArray[n].getStatus() == 1) {
                    arrayList2.add(asyncResultArray[n]);
                }
                ++n;
            }
            int n2 = 0;
            while (n2 < arrayList2.size()) {
                AsyncResult asyncResult2 = (AsyncResult)arrayList2.get(n2);
                arrayList.add(asyncResult2.getResults()[0]);
                ++n2;
            }
        }
        finally {
            logTraceHelper.exit(arrayList);
        }
        return arrayList;
    }

    public static ArrayList checkForFailureResults(AsyncResult[] asyncResultArray) {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry("ResultHelper", "checkForFailureResults", new Object[]{asyncResultArray});
        ArrayList<AsyncResult> arrayList = new ArrayList<AsyncResult>();
        try {
            int n = 0;
            while (n < asyncResultArray.length) {
                if (asyncResultArray[n].getStatus() != 1) {
                    arrayList.add(asyncResultArray[n]);
                }
                ++n;
            }
        }
        finally {
            logTraceHelper.exit(arrayList);
        }
        return arrayList;
    }
}

