/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.common.util;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.LinkedList;
import org.eclipse.aperi.common.api.InvalidParameterException;
import org.eclipse.aperi.common.api.SRMMessage;
import org.eclipse.aperi.common.api.ServerException;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.common.util.DiskReportingHelper;
import org.eclipse.aperi.disk.common.util.exceptions.IDParseException;
import org.eclipse.aperi.disk.control.util.OutputHelper;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.objects.Port;
import org.eclipse.aperi.infrastructure.database.objects.StoragePool;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem;
import org.eclipse.aperi.infrastructure.database.objects.StorageVolume;
import org.eclipse.aperi.infrastructure.database.sql.SqlStorageSubsystem;

public class ExternalKeyConverter {
    public static final String DELIMITER = "+";
    public static final int STORAGE_SUBSYSTEM_KEY_PART_COUNT = 2;
    public static final int STORAGE_SUBSYSTEM_KEY_NAME_FORMAT_POSISTION = 1;
    public static final int STORAGE_EXTEND_KEY_PART_COUNT = 3;
    public static final int STORAGE_POOL_KEY_PART_COUNT = 3;
    public static final int STORAGE_POOL_KEY_SUBSYSTEM_NAME_FORMAT_POSISTION = 2;
    public static final int STORAGE_VOLUME_KEY_PART_COUNT = 4;
    public static final int STORAGE_VOLUME_KEY_VOL_NAME_FORMAT_POSISTION = 1;
    public static final int STORAGE_VOLUME_KEY_SUBSYSTEM_NAME_FORMAT_POSISTION = 3;
    public static final int PORT_KEY_PART_COUNT = 4;

    public static String frameKeyStorageSubsystem(String string, short s) {
        return new String(String.valueOf(ExternalKeyConverter.convertString(string)) + DELIMITER + s);
    }

    public static String frameKeyStoragePool(String string, String string2, short s) {
        return new String(String.valueOf(ExternalKeyConverter.convertString(string)) + DELIMITER + ExternalKeyConverter.convertString(string2) + DELIMITER + s);
    }

    public static String frameKeyStorageExtent(String string, String string2, short s) {
        return new String(String.valueOf(ExternalKeyConverter.convertString(string)) + DELIMITER + ExternalKeyConverter.convertString(string2) + DELIMITER + s);
    }

    public static String frameKeyStorageVolume(String string, short s, String string2, short s2) {
        return new String(String.valueOf(ExternalKeyConverter.convertString(string)) + DELIMITER + s + DELIMITER + ExternalKeyConverter.convertString(string2) + DELIMITER + s2);
    }

    public static String frameKeyCIMOM(String string, int n) {
        return new String(String.valueOf(string) + DELIMITER + n);
    }

    public static String frameKeyStorageSubsystemFromPool(String string, LogTraceHelper logTraceHelper) throws IDParseException {
        String[] stringArray = ExternalKeyConverter.obtainStoragePoolKeyParts(string, logTraceHelper);
        String string2 = new String(String.valueOf(ExternalKeyConverter.convertString(stringArray[1])) + DELIMITER + ExternalKeyConverter.convertString(stringArray[2]));
        return string2;
    }

    public static String frameKeyStorageSubsystemFromExtent(String string, LogTraceHelper logTraceHelper) throws IDParseException {
        String string2 = null;
        String[] stringArray = ExternalKeyConverter.obtainStorageExtentKeyParts(string, logTraceHelper);
        string2 = new String(String.valueOf(ExternalKeyConverter.convertString(stringArray[1])) + DELIMITER + ExternalKeyConverter.convertString(stringArray[2]));
        return string2;
    }

    public static String frameKeyStorageSubsystemFromVolume(String string, LogTraceHelper logTraceHelper) throws IDParseException {
        String string2 = null;
        String[] stringArray = ExternalKeyConverter.obtainStorageVolumeKeyParts(string, logTraceHelper);
        string2 = new String(String.valueOf(ExternalKeyConverter.convertString(stringArray[2])) + DELIMITER + ExternalKeyConverter.convertString(stringArray[3]));
        return string2;
    }

    public static String getPortKey(Port port) {
        return port.getName();
    }

    public static String[] splitKey(String string) {
        String[] stringArray = string.split("\\+");
        stringArray = ExternalKeyConverter.checkForSlash(stringArray);
        String string2 = null;
        String string3 = null;
        int n = 0;
        while (n < stringArray.length) {
            string2 = stringArray[n].replaceAll("\\\\\\\\", "\\\\");
            stringArray[n] = string3 = string2.replaceAll("\\\\\\+", "\\+");
            ++n;
        }
        return stringArray;
    }

    private static String[] checkForSlash(String[] stringArray) {
        LinkedList<String> linkedList = new LinkedList<String>();
        String string = null;
        if (stringArray.length > 0) {
            boolean bl = false;
            int n = 0;
            while (n < stringArray.length) {
                string = bl ? String.valueOf(string) + DELIMITER + stringArray[n] : stringArray[n];
                if (string.endsWith("\\")) {
                    int n2 = ExternalKeyConverter.countSlashFromEnd(string);
                    if (n2 % 2 == 0) {
                        linkedList.add(string);
                        bl = false;
                        string = null;
                    } else {
                        bl = true;
                    }
                } else {
                    linkedList.add(string);
                    bl = false;
                    string = null;
                }
                ++n;
            }
        }
        if (string != null) {
            linkedList.add(String.valueOf(string) + DELIMITER);
        }
        return linkedList.toArray(new String[0]);
    }

    public static String excapeDelimiter(String string) {
        return string.replaceAll("\\+", "\\\\+");
    }

    private static int countSlashFromEnd(String string) {
        int n = 0;
        int n2 = string.length() - 1;
        while (n2 >= 0) {
            if (string.charAt(n2) == '\\') {
                ++n;
            } else {
                return n;
            }
            --n2;
        }
        return n;
    }

    public static Object getStoragePoolKey(StoragePool storagePool, String string, LogTraceHelper logTraceHelper) throws IDParseException {
        String[] stringArray = ExternalKeyConverter.obtainStorageSubsystemKeyParts(string, logTraceHelper);
        return String.valueOf(ExternalKeyConverter.convertString(storagePool.getInstanceId())) + DELIMITER + ExternalKeyConverter.convertString(stringArray[0]) + DELIMITER + ExternalKeyConverter.convertString(stringArray[1]);
    }

    public static Object getStoragePoolKey(StoragePool storagePool, StorageSubsystem storageSubsystem) {
        return String.valueOf(ExternalKeyConverter.convertString(storagePool.getInstanceId())) + DELIMITER + ExternalKeyConverter.getStorageSubsystemKey(storageSubsystem);
    }

    public static Object getStorageVolumeKey(StorageVolume storageVolume, String string, LogTraceHelper logTraceHelper) throws IDParseException {
        String[] stringArray = ExternalKeyConverter.obtainStorageSubsystemKeyParts(string, logTraceHelper);
        return String.valueOf(ExternalKeyConverter.convertString(storageVolume.getName())) + DELIMITER + storageVolume.getNameFormat() + DELIMITER + ExternalKeyConverter.convertString(stringArray[0]) + DELIMITER + ExternalKeyConverter.convertString(stringArray[1]);
    }

    public static Object getStorageSubsystemKey(StorageSubsystem storageSubsystem) {
        return String.valueOf(ExternalKeyConverter.convertString(storageSubsystem.getName())) + DELIMITER + storageSubsystem.getNameFormat();
    }

    public static Hashtable getStorageSubsystemWhereClause(String string, LogTraceHelper logTraceHelper) {
        Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
        String[] stringArray = ExternalKeyConverter.splitKey(string);
        ColumnInfo columnInfo = DiskReportingHelper.getColumnInfo(StorageSubsystem.class, "NAME", logTraceHelper);
        hashtable.put(columnInfo, stringArray[0]);
        columnInfo = DiskReportingHelper.getColumnInfo(StorageSubsystem.class, "NAME_FORMAT", logTraceHelper);
        hashtable.put(columnInfo, stringArray[1]);
        return hashtable;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Hashtable getVolumeWhereclause(LogTraceHelper logTraceHelper, String string, DBConnection dBConnection) throws ServerException {
        Hashtable<ColumnInfo, String> hashtable;
        DBResultSet dBResultSet = null;
        try {
            Hashtable<ColumnInfo, String> hashtable2 = new Hashtable<ColumnInfo, String>();
            ColumnInfo columnInfo = DiskReportingHelper.getColumnInfo(StorageVolume.class, "NAME", logTraceHelper);
            String[] stringArray = ExternalKeyConverter.splitKey(string);
            if (stringArray.length != 4) {
                throw new InvalidParameterException(1, new SRMMessage("HWN020003E", new String[]{string}));
            }
            hashtable2.put(columnInfo, stringArray[0]);
            columnInfo = DiskReportingHelper.getColumnInfo(StorageVolume.class, "NAME_FORMAT", logTraceHelper);
            hashtable2.put(columnInfo, stringArray[1]);
            Hashtable<ColumnInfo, String> hashtable3 = new Hashtable<ColumnInfo, String>();
            columnInfo = DiskReportingHelper.getColumnInfo(StorageSubsystem.class, "NAME", logTraceHelper);
            hashtable3.put(columnInfo, stringArray[2]);
            columnInfo = DiskReportingHelper.getColumnInfo(StorageSubsystem.class, "NAME_FORMAT", logTraceHelper);
            hashtable3.put(columnInfo, stringArray[3]);
            dBResultSet = SqlStorageSubsystem.sqlQuery(dBConnection, SqlStorageSubsystem.querySubSystemID, hashtable3);
            while (true) {
                if (!dBResultSet.next()) {
                    hashtable = hashtable2;
                    if (dBResultSet == null) return hashtable;
                    break;
                }
                int n = dBResultSet.getInt("SUBSYSTEM_ID");
                columnInfo = DiskReportingHelper.getColumnInfo(StorageVolume.class, "SUBSYSTEM_ID", logTraceHelper);
                hashtable2.put(columnInfo, Integer.toString(n));
            }
        }
        catch (SQLException sQLException) {
            try {
                throw DiskMessageHelper.getServerException("HWN021503E", sQLException.getMessage(), logTraceHelper);
            }
            catch (Throwable throwable) {
                if (dBResultSet == null) throw throwable;
                try {
                    dBResultSet.getStatement().close();
                    throw throwable;
                }
                catch (SQLException sQLException2) {}
                throw throwable;
            }
        }
        try {
            dBResultSet.getStatement().close();
            return hashtable;
        }
        catch (SQLException sQLException) {}
        return hashtable;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Hashtable getPoolWhereclause(LogTraceHelper logTraceHelper, String string, DBConnection dBConnection) {
        Hashtable<ColumnInfo, String> hashtable;
        DBResultSet dBResultSet = null;
        try {
            Hashtable<ColumnInfo, String> hashtable2 = new Hashtable<ColumnInfo, String>();
            ColumnInfo columnInfo = DiskReportingHelper.getColumnInfo(StoragePool.class, "INSTANCE_ID", logTraceHelper);
            String[] stringArray = ExternalKeyConverter.splitKey(string);
            hashtable2.put(columnInfo, stringArray[0]);
            columnInfo = DiskReportingHelper.getColumnInfo(StoragePool.class, "PRIMORDIAL", logTraceHelper);
            hashtable2.put(columnInfo, "0");
            Hashtable<ColumnInfo, String> hashtable3 = new Hashtable<ColumnInfo, String>();
            columnInfo = DiskReportingHelper.getColumnInfo(StorageSubsystem.class, "NAME", logTraceHelper);
            hashtable3.put(columnInfo, stringArray[1]);
            columnInfo = DiskReportingHelper.getColumnInfo(StorageSubsystem.class, "NAME_FORMAT", logTraceHelper);
            hashtable3.put(columnInfo, stringArray[2]);
            dBResultSet = SqlStorageSubsystem.sqlQuery(dBConnection, SqlStorageSubsystem.querySubSystemID, hashtable3);
            while (true) {
                if (!dBResultSet.next()) {
                    hashtable = hashtable2;
                    if (dBResultSet == null) return hashtable;
                    break;
                }
                int n = dBResultSet.getInt("SUBSYSTEM_ID");
                columnInfo = DiskReportingHelper.getColumnInfo(StorageVolume.class, "SUBSYSTEM_ID", logTraceHelper);
                hashtable2.put(columnInfo, Integer.toString(n));
            }
        }
        catch (SQLException sQLException) {
            try {
                throw DiskMessageHelper.getServerException("HWN021503E", sQLException.getMessage(), logTraceHelper);
            }
            catch (Throwable throwable) {
                if (dBResultSet == null) throw throwable;
                try {
                    dBResultSet.getStatement().close();
                    throw throwable;
                }
                catch (SQLException sQLException2) {}
                throw throwable;
            }
        }
        try {
            dBResultSet.getStatement().close();
            return hashtable;
        }
        catch (SQLException sQLException) {}
        return hashtable;
    }

    public static String[] obtainStorageSubsystemKeyParts(String string, LogTraceHelper logTraceHelper) throws IDParseException {
        String[] stringArray = null;
        String[] stringArray2 = ExternalKeyConverter.splitKey(string);
        if (ExternalKeyConverter.checkValidFormatForLength(stringArray2, 2, logTraceHelper) && ExternalKeyConverter.checkValidFormatForType(stringArray2, 1, logTraceHelper)) {
            stringArray = stringArray2;
        }
        return stringArray;
    }

    public static String[] obtainStoragePoolKeyParts(String string, LogTraceHelper logTraceHelper) throws IDParseException {
        String[] stringArray = null;
        String[] stringArray2 = ExternalKeyConverter.splitKey(string);
        if (ExternalKeyConverter.checkValidFormatForLength(stringArray2, 3, logTraceHelper) && ExternalKeyConverter.checkValidFormatForType(stringArray2, 2, logTraceHelper)) {
            stringArray = stringArray2;
        }
        return stringArray;
    }

    public static String[] obtainStorageExtentKeyParts(String string, LogTraceHelper logTraceHelper) throws IDParseException {
        String[] stringArray = null;
        String[] stringArray2 = ExternalKeyConverter.splitKey(string);
        if (ExternalKeyConverter.checkValidFormatForLength(stringArray2, 3, logTraceHelper)) {
            stringArray = stringArray2;
        }
        return stringArray;
    }

    public static String[] obtainStorageVolumeKeyParts(String string, LogTraceHelper logTraceHelper) throws IDParseException {
        String[] stringArray = null;
        String[] stringArray2 = ExternalKeyConverter.splitKey(string);
        if (ExternalKeyConverter.checkValidFormatForLength(stringArray2, 4, logTraceHelper) && ExternalKeyConverter.checkValidFormatForType(stringArray2, 1, logTraceHelper) && ExternalKeyConverter.checkValidFormatForType(stringArray2, 3, logTraceHelper)) {
            stringArray = stringArray2;
        }
        return stringArray;
    }

    public static String[] obtainPortKeyParts(String string, LogTraceHelper logTraceHelper) throws IDParseException {
        String[] stringArray = new String[]{string};
        return stringArray;
    }

    private static boolean checkValidFormatForLength(String[] stringArray, int n, LogTraceHelper logTraceHelper) throws IDParseException {
        if (stringArray != null && stringArray.length == n) {
            return true;
        }
        if (stringArray != null) {
            throw new IDParseException(OutputHelper.arrayToCS(stringArray));
        }
        throw new IDParseException();
    }

    private static boolean checkValidFormatForType(String[] stringArray, int n, LogTraceHelper logTraceHelper) throws IDParseException {
        boolean bl = false;
        try {
            Short.parseShort(stringArray[n]);
            bl = true;
        }
        catch (Exception exception) {
            logTraceHelper.traceError(exception.getMessage(), exception);
            throw new IDParseException(exception);
        }
        return bl;
    }

    private static String convertString(String string) {
        string = string.replaceAll("\\\\", "\\\\\\\\");
        string = string.replaceAll("\\+", "\\\\+");
        return string;
    }
}

