/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.common.util.thread;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.common.api.SRMMessage;
import org.eclipse.aperi.disk.common.ResultHelper;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.common.util.thread.DiskManagerExecException;
import org.eclipse.aperi.disk.common.util.thread.DiskManagerRTException;
import org.eclipse.aperi.disk.common.util.thread.DiskManagerTimeoutException;
import org.eclipse.aperi.disk.common.util.thread.DiskMgrThread;
import org.eclipse.aperi.disk.common.util.thread.DiskThreadManager;
import org.eclipse.aperi.disk.common.util.thread.ThreadObserver;
import org.eclipse.aperi.interfaces.IController;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;

public class ExecGroup
implements ThreadObserver {
    private static Random stRandom = null;
    private long cID = -1L;
    private Map cTasks = null;
    private Map cSubJobs = null;
    private DiskThreadManager cThreadMgr = null;
    public static final String TRACE_NAME = "aperi.logger.trace.CIMScanner";
    public static ILogger traceLogger;
    public static String className;

    static {
        stRandom = new Random();
        traceLogger = null;
        className = ExecGroup.class.getName();
        traceLogger = LogManagerFactory.getTraceLogger(TRACE_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecGroup(DiskThreadManager diskThreadManager) {
        Class<ExecGroup> clazz = ExecGroup.class;
        synchronized (ExecGroup.class) {
            this.cID = System.currentTimeMillis() + (long)((int)(Math.random() * 100.0));
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.cTasks = new Hashtable();
            this.cSubJobs = new Hashtable();
            this.cThreadMgr = diskThreadManager;
            return;
        }
    }

    public Long execute(Object object, String string, Object[] objectArray, LogTraceHelper logTraceHelper) {
        return this.execute(object, string, DiskThreadManager.getParamTypes(objectArray), objectArray, logTraceHelper);
    }

    public Long executeAsSubJob(Object object, String string, Object[] objectArray, LogTraceHelper logTraceHelper, IController iController, int n) {
        Long l = this.execute(object, string, DiskThreadManager.getParamTypes(objectArray), objectArray, logTraceHelper);
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = iController.startSubJob(String.valueOf(string) + l, false);
            ++n2;
        }
        this.cSubJobs.put(l, nArray);
        return l;
    }

    /*
     * Unable to fully structure code
     */
    public AsyncResult getExecutionResultInSubJob(Long var1_1, IController var2_2, LogTraceHelper var3_3) throws DiskManagerExecException {
        block12: {
            var4_4 = "getExecutionResultInSubJob";
            new AsyncResult(-1, -1);
            var5_5 = null;
            var6_6 = (int[])this.cSubJobs.get(var1_1);
            var7_7 = null;
            try {
                var7_7 = this.getExecutionResult(var1_1);
                break block12;
            }
            catch (Exception var8_8) {
                var5_5 = new AsyncResult(0, 0, new SRMMessage("HWN021503E", null));
                var5_5.setReturnException(var8_8);
                var9_11 = 0;
                ** while (var9_11 < var6_6.length)
            }
lbl-1000:
            // 1 sources

            {
                var2_2.endSubJob(var6_6[var9_11], var5_5.getRc(), var5_5.getStatus(), var5_5.getSRMMessage(), var8_8, null);
                ++var9_11;
                continue;
            }
lbl18:
            // 1 sources

            return var5_5;
        }
        if (var7_7 instanceof AsyncResult) {
            var8_9 = ((AsyncResult)var7_7).getSubJobResults();
            var9_12 = 0;
            while (var9_12 < var6_6.length) {
                var2_2.endSubJob(var6_6[var9_12], var8_9[var9_12].getRc(), var8_9[var9_12].getStatus(), var8_9[var9_12].getSRMMessage(), null, var8_9[var9_12].getResults());
                ++var9_12;
            }
            var5_5 = (AsyncResult)var7_7;
        } else if (var7_7 instanceof AsyncResult[]) {
            var8_10 = (AsyncResult[])var7_7;
            if (var6_6.length != var8_10.length) {
                if (var3_3 != null) {
                    var3_3.traceInfo("Usage of executeAsSubJob and getExecutionResultInSubJob wrong: Number of AsyncResults must correspond to jobs created.");
                    var3_3.traceInfo("If asynchronously started method returns a AsyncResult only (no array), number of jobs must be one.");
                } else if (ExecGroup.traceLogger.isLogging()) {
                    ExecGroup.traceLogger.text(IRecordType.TYPE_INFO, ExecGroup.className, var4_4, "Usage of executeAsSubJob and getExecutionResultInSubJob wrong: Number of AsyncResults must correspond to jobs created.");
                    ExecGroup.traceLogger.text(IRecordType.TYPE_INFO, ExecGroup.className, var4_4, "If asynchronously started method returns a AsyncResult only (no array), number of jobs must be one.");
                }
                throw DiskMessageHelper.getServerException("HWN021503E", null, var3_3);
            }
            var9_13 = 0;
            while (var9_13 < var6_6.length) {
                var2_2.endSubJob(var6_6[var9_13], var8_10[var9_13].getRc(), var8_10[var9_13].getStatus(), var8_10[var9_13].getSRMMessage(), null, var8_10[var9_13].getResults());
                ++var9_13;
            }
            var5_5 = ResultHelper.computeAndSetFinalStatus(var8_10, var4_4);
            var5_5.setSubJobResults(var8_10);
        }
        return var5_5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long execute(Object object, String string, Class[] classArray, Object[] objectArray, LogTraceHelper logTraceHelper) {
        String string2 = "execute";
        Long l = null;
        Object object2 = ExecGroup.class;
        synchronized (ExecGroup.class) {
            l = new Long(System.currentTimeMillis() * 100L + (long)stRandom.nextInt(100));
            // ** MonitorExit[var8_8] (shouldn't be in output)
            try {
                object2 = this.cThreadMgr.getThread();
                ((DiskMgrThread)object2).execute(this, object, string, classArray, objectArray);
                this.cTasks.put(l, object2);
                return l;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if (logTraceHelper != null) {
                    logTraceHelper.traceError("ExecGroup.execute - Internal error: NoSuchMethodException", noSuchMethodException);
                } else if (traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERR, className, string2, "ExecGroup.execute - Internal error: NoSuchMethodException" + noSuchMethodException);
                }
                throw new DiskManagerRTException(noSuchMethodException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForCompletion(long l) throws DiskManagerTimeoutException {
        long l2 = System.currentTimeMillis();
        while (!this.checkCompletion()) {
            ExecGroup execGroup = this;
            synchronized (execGroup) {
                try {
                    this.wait(l / 5L);
                }
                catch (InterruptedException interruptedException) {}
                if (l > 0L && !this.checkCompletion() && System.currentTimeMillis() > l2 + l) {
                    throw new DiskManagerTimeoutException("Execution time exceeded " + l + " milliseconds");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyExecutionComplete() {
        ExecGroup execGroup = this;
        synchronized (execGroup) {
            this.notifyAll();
        }
    }

    private boolean checkCompletion() {
        for (Map.Entry entry : this.cTasks.entrySet()) {
            if (((DiskMgrThread)entry.getValue()).cIsExecutionComplete()) continue;
            return false;
        }
        return true;
    }

    public Object getExecutionResult(Long l) throws DiskManagerExecException {
        Throwable throwable = null;
        throwable = this.getExecutionError(l);
        if (throwable != null) {
            throw new DiskManagerExecException(throwable);
        }
        DiskMgrThread diskMgrThread = (DiskMgrThread)this.cTasks.get(l);
        if (diskMgrThread != null) {
            return diskMgrThread.getResult();
        }
        return null;
    }

    public Map getExecutionResults() {
        HashMap<Long, Object> hashMap = new HashMap<Long, Object>();
        for (Long l : this.cTasks.keySet()) {
            hashMap.put(l, ((DiskMgrThread)this.cTasks.get(l)).getResult());
        }
        return hashMap;
    }

    public Map getExecutionErrors() {
        HashMap<Long, Throwable> hashMap = new HashMap<Long, Throwable>();
        for (Long l : this.cTasks.keySet()) {
            hashMap.put(l, ((DiskMgrThread)this.cTasks.get(l)).getThrowable());
        }
        return hashMap;
    }

    public Throwable getExecutionError(Long l) {
        DiskMgrThread diskMgrThread = (DiskMgrThread)this.cTasks.get(l);
        if (diskMgrThread != null) {
            return diskMgrThread.getThrowable();
        }
        return null;
    }

    public synchronized void clear() {
        Iterator iterator = this.cTasks.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            this.cThreadMgr.returnThread((DiskMgrThread)entry.getValue());
            iterator.remove();
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.clear();
        }
        finally {
            super.finalize();
        }
    }
}

