/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.discovery;

import java.sql.SQLException;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.common.api.Result;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.common.util.ParameterHelper;
import org.eclipse.aperi.disk.discovery.RetryDeleteParameters;
import org.eclipse.aperi.infrastructure.database.ComplexQuery;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.SQLExceptionHelper;
import org.eclipse.aperi.infrastructure.database.tables.TResChunkCllctnTable;
import org.eclipse.aperi.infrastructure.database.tables.TResChunkTable;
import org.eclipse.aperi.infrastructure.database.tables.TResCimkeyPortTable;
import org.eclipse.aperi.infrastructure.database.tables.TResCimkeyVolumeTable;
import org.eclipse.aperi.infrastructure.database.tables.TResDataPathTable;
import org.eclipse.aperi.infrastructure.database.tables.TResMaskingInfoTable;
import org.eclipse.aperi.infrastructure.database.tables.TResPhysicalVolumeTable;
import org.eclipse.aperi.infrastructure.database.tables.TResPhysicalvolume2extentTable;
import org.eclipse.aperi.infrastructure.database.tables.TResPortTable;
import org.eclipse.aperi.infrastructure.database.tables.TResStorageExtentTable;
import org.eclipse.aperi.infrastructure.database.tables.TResStoragePoolTable;
import org.eclipse.aperi.infrastructure.database.tables.TResStorageVolumeTable;
import org.eclipse.aperi.infrastructure.database.tables.TResVolume2extentTable;
import org.eclipse.aperi.infrastructure.database.tables.TStatDiskHistTable;
import org.eclipse.aperi.infrastructure.database.tables.TStatDiskTable;

public class SubsystemDBHelper {
    private static final int DEL_VOLUMES = 0;
    private static final int DEL_POOLS = 1;
    private static final int DEL_PHYVOLS = 2;
    private static final int DEL_PORTS = 3;

    public static boolean deleteStorageVolumes(int[] nArray) throws SQLException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry(SubsystemDBHelper.class, "deleteStorageVolumes", new Object[]{nArray});
        Boolean bl = new Boolean(false);
        try {
            bl = SubsystemDBHelper.deadlockSafeSubentityDeletion(nArray, logTraceHelper, 0);
            boolean bl2 = bl;
            return bl2;
        }
        finally {
            logTraceHelper.exit(bl);
        }
    }

    public static boolean deleteStoragePools(int[] nArray) throws SQLException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry(SubsystemDBHelper.class, "deleteStoragePools", new Object[]{nArray});
        Boolean bl = new Boolean(false);
        try {
            bl = SubsystemDBHelper.deadlockSafeSubentityDeletion(nArray, logTraceHelper, 1);
            boolean bl2 = bl;
            return bl2;
        }
        finally {
            logTraceHelper.exit(bl);
        }
    }

    public static boolean deletePorts(int[] nArray) throws SQLException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry(SubsystemDBHelper.class, "deletePorts", new Object[]{nArray});
        Boolean bl = new Boolean(false);
        try {
            bl = SubsystemDBHelper.deadlockSafeSubentityDeletion(nArray, logTraceHelper, 3);
            boolean bl2 = bl;
            return bl2;
        }
        finally {
            logTraceHelper.exit(bl);
        }
    }

    public static boolean deletePhysicalVolumes(int[] nArray) throws SQLException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry(SubsystemDBHelper.class, "deletePhysicalVolumes", new Object[]{nArray});
        Boolean bl = new Boolean(false);
        try {
            bl = SubsystemDBHelper.deadlockSafeSubentityDeletion(nArray, logTraceHelper, 2);
            boolean bl2 = bl;
            return bl2;
        }
        finally {
            logTraceHelper.exit(bl);
        }
    }

    public static boolean handleDeadlock(DBConnection dBConnection, LogTraceHelper logTraceHelper, RetryDeleteParameters retryDeleteParameters, Exception exception, Result result, String string) {
        logTraceHelper.traceInfo("Deadlock ..... rollback!");
        try {
            dBConnection.rollback();
        }
        catch (SQLException sQLException) {
            logTraceHelper.traceInfo("Exception in rollback  " + sQLException.getMessage());
            retryDeleteParameters.setToRetry(false);
            throw DiskMessageHelper.getServerException("HWN021503E", exception.getMessage(), logTraceHelper);
        }
        retryDeleteParameters.setNumRetries(retryDeleteParameters.getNumRetries() + 1);
        if (retryDeleteParameters.getNumRetries() > retryDeleteParameters.getAllowed_Retries()) {
            retryDeleteParameters.setToRetry(false);
            if (result != null && string != null) {
                result.setSRMMessage("HWN021672E", new String[]{string});
            }
            return false;
        }
        logTraceHelper.traceInfo("Retry " + retryDeleteParameters.getNumRetries() + " after deadlock");
        retryDeleteParameters.setToRetry(true);
        retryDeleteParameters.setMsWaitPeriod((long)((double)retryDeleteParameters.getMult_Retry_Interval() * RetryDeleteParameters.getRandGen().nextDouble() * (double)retryDeleteParameters.getNumRetries()));
        if (retryDeleteParameters.getMsWaitPeriod() < retryDeleteParameters.getMin_Retry_Internal()) {
            retryDeleteParameters.setMsWaitPeriod(retryDeleteParameters.getMin_Retry_Internal());
        }
        try {
            Thread.sleep(retryDeleteParameters.getMsWaitPeriod());
        }
        catch (InterruptedException interruptedException) {
            logTraceHelper.traceInfo("InterruptedException " + exception.getMessage());
        }
        return true;
    }

    private static Boolean deadlockSafeSubentityDeletion(int[] nArray, LogTraceHelper logTraceHelper, int n) throws SQLException {
        Boolean bl = new Boolean(false);
        DBConnection dBConnection = null;
        RetryDeleteParameters retryDeleteParameters = new RetryDeleteParameters();
        retryDeleteParameters.init(logTraceHelper);
        try {
            if (nArray != null && nArray.length != 0) {
                String string = "(" + ParameterHelper.intArrayToString(nArray) + ")";
                while (retryDeleteParameters.isToRetry()) {
                    try {
                        dBConnection = ServiceUtils.getConnection();
                        dBConnection.setAutoCommit(false);
                        switch (n) {
                            case 0: {
                                bl = new Boolean(SubsystemDBHelper.performVolDelete(dBConnection, string, nArray));
                                break;
                            }
                            case 2: {
                                bl = new Boolean(SubsystemDBHelper.performPhyVolDelete(dBConnection, string, nArray));
                                break;
                            }
                            case 3: {
                                bl = new Boolean(SubsystemDBHelper.performPortDelete(dBConnection, string, nArray));
                                break;
                            }
                            case 1: {
                                bl = new Boolean(SubsystemDBHelper.performPoolDelete(dBConnection, string, nArray));
                            }
                        }
                        dBConnection.commit();
                        retryDeleteParameters.setToRetry(false);
                    }
                    catch (SQLException sQLException) {
                        if (SQLExceptionHelper.isDeadlock(dBConnection, sQLException)) {
                            if (!SubsystemDBHelper.handleDeadlock(dBConnection, logTraceHelper, retryDeleteParameters, sQLException, null, null)) continue;
                            continue;
                        }
                        throw sQLException;
                    }
                }
            }
        }
        finally {
            try {
                if (dBConnection != null) {
                    dBConnection.close();
                }
            }
            catch (RuntimeException runtimeException) {
                logTraceHelper.traceError("Error during commit or close of DBConnection", runtimeException);
                logTraceHelper.exit(new Boolean(false));
                throw runtimeException;
            }
            catch (SQLException sQLException) {
                logTraceHelper.traceError("Error during commit or close of DBConnection", sQLException);
                logTraceHelper.exit(new Boolean(false));
                throw sQLException;
            }
        }
        return bl;
    }

    private static int execDelete(String string, String string2, String string3, DBConnection dBConnection) throws SQLException {
        String string4 = "DELETE FROM " + string + " WHERE " + string2 + " IN " + string3;
        return ComplexQuery.sqlUpdate(dBConnection, string4, null);
    }

    private static boolean performPoolDelete(DBConnection dBConnection, String string, int[] nArray) throws SQLException {
        SubsystemDBHelper.execDelete(TResStorageExtentTable.getTablename(), "POOL_ID", string, dBConnection);
        return SubsystemDBHelper.execDelete(TResStoragePoolTable.getTablename(), "POOL_ID", string, dBConnection) == nArray.length;
    }

    private static boolean performPortDelete(DBConnection dBConnection, String string, int[] nArray) throws SQLException {
        String string2 = "SELECT MASKING_INFO_ID FROM " + TResDataPathTable.getTablename() + " WHERE " + "TARGET_PORT_ID" + " IN " + string;
        String string3 = "DELETE FROM " + TResMaskingInfoTable.getTablename() + " WHERE " + "MASKING_INFO_ID" + " IN (" + string2 + ")";
        ComplexQuery.sqlUpdate(dBConnection, string3, null);
        SubsystemDBHelper.execDelete(TResDataPathTable.getTablename(), "TARGET_PORT_ID", string, dBConnection);
        SubsystemDBHelper.execDelete(TResDataPathTable.getTablename(), "INITIATOR_PORT_ID", string, dBConnection);
        SubsystemDBHelper.execDelete(TResCimkeyPortTable.getTablename(), "CIMKEY_PORT_ID", string, dBConnection);
        return SubsystemDBHelper.execDelete(TResPortTable.getTablename(), "PORT_ID", string, dBConnection) == nArray.length;
    }

    private static boolean performPhyVolDelete(DBConnection dBConnection, String string, int[] nArray) throws SQLException {
        SubsystemDBHelper.execDelete(TStatDiskTable.getTablename(), "DISK_ID", string, dBConnection);
        SubsystemDBHelper.execDelete(TStatDiskHistTable.getTablename(), "DISK_ID", string, dBConnection);
        SubsystemDBHelper.execDelete(TResPhysicalvolume2extentTable.getTablename(), "PHYSICAL_VOLUME_ID", string, dBConnection);
        return SubsystemDBHelper.execDelete(TResPhysicalVolumeTable.getTablename(), "PHYSICAL_VOLUME_ID", string, dBConnection) == nArray.length;
    }

    private static boolean performVolDelete(DBConnection dBConnection, String string, int[] nArray) throws SQLException {
        SubsystemDBHelper.execDelete(TResDataPathTable.getTablename(), "DEVICE_LUN_ID", string, dBConnection);
        SubsystemDBHelper.execDelete(TResChunkTable.getTablename(), "LOGICAL_DISK_ID", string, dBConnection);
        SubsystemDBHelper.execDelete(TResChunkCllctnTable.getTablename(), "LOGICAL_DISK_ID", string, dBConnection);
        SubsystemDBHelper.execDelete(TResVolume2extentTable.getTablename(), "VOLUME_ID", string, dBConnection);
        SubsystemDBHelper.execDelete(TResCimkeyVolumeTable.getTablename(), "VOLUME_ID", string, dBConnection);
        return SubsystemDBHelper.execDelete(TResStorageVolumeTable.getTablename(), "SVID", string, dBConnection) == nArray.length;
    }
}

