/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.fabric;

import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Vector;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.fabric.api.FabricManagerConstants;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.Hba;
import org.eclipse.aperi.infrastructure.database.objects.Host;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;

public class ExternalKeyConverter {
    public static final String DELIMITER = "+";
    public static String[] externalKeyAttributes = null;
    private static ILogger traceLogger = null;
    static final String className = ExternalKeyConverter.class.getName();
    public static Vector columnName = new Vector(1);

    public static String frameComputerKey(String string, String string2, String string3, String string4, String string5, String string6) {
        String string7 = new String("");
        if (string != null) {
            string = string.trim();
        }
        string7 = String.valueOf(string) + DELIMITER + string2 + DELIMITER + string3 + DELIMITER + string4 + DELIMITER + string5 + DELIMITER + string6;
        string7 = string7.replaceAll("null", "");
        return string7;
    }

    public static String frameHBAKey(String string, String string2, String string3) {
        String string4 = new String("");
        string4 = String.valueOf(string) + DELIMITER + string2 + DELIMITER + string3;
        string4 = string4.replaceAll("null", "");
        return string4;
    }

    public static String getComputerIdFromExternalKey(String string) {
        String string2;
        String string3;
        block4: {
            string3 = "";
            string2 = "getComputerIdFromExternalKey";
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string2, string);
            }
            try {
                String[] stringArray = ExternalKeyConverter.splitKey(string);
                Hashtable hashtable = ExternalKeyConverter.getInternalIdWhereClause(FabricManagerConstants.EXTERNAL_COMPUTER_KEY_SET, stringArray);
                columnName.clear();
                columnName.add("COMPUTER_ID");
                string3 = ExternalKeyConverter.runQuery(hashtable, columnName);
            }
            catch (Exception exception) {
                if (traceLogger == null || !traceLogger.isLogging()) break block4;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string2, exception);
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2, string3.toString());
        }
        return string3;
    }

    public static String getHBAIdFromExternalKey(String string) {
        String string2;
        String string3;
        block4: {
            string3 = "";
            string2 = "getHBAIdFromExternalKey";
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string2, string);
            }
            try {
                String[] stringArray = ExternalKeyConverter.splitKey(string);
                String string4 = ExternalKeyConverter.frameComputerKey(stringArray[0], stringArray[1], stringArray[2], null, null, null);
                String string5 = ExternalKeyConverter.getComputerIdFromExternalKey(string4);
                Hashtable hashtable = ExternalKeyConverter.getHBAIdWhereClause(FabricManagerConstants.EXTERNAL_HBA_KEY_SET, new String[]{string5, stringArray[6], stringArray[7]});
                columnName.clear();
                columnName.add("HBA_ID");
                string3 = ExternalKeyConverter.runHBAQuery(hashtable, columnName);
            }
            catch (Exception exception) {
                if (traceLogger == null || !traceLogger.isLogging()) break block4;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string2, exception);
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2, string3.toString());
        }
        return string3;
    }

    public static String getSubsystemIdFromExternalKey(String string) {
        String string2;
        String string3;
        block4: {
            string3 = "";
            string2 = "getSubsystemIdFromExternalKey";
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string2, string);
            }
            try {
                String[] stringArray = ExternalKeyConverter.splitStorageSubsystemKey(string);
                Hashtable hashtable = ExternalKeyConverter.getSubsystemIdWhereClause(FabricManagerConstants.EXTERNAL_SUBSYSTEM_KEY_SET, stringArray);
                columnName.clear();
                columnName.add("SUBSYSTEM_ID");
                string3 = ExternalKeyConverter.runSSQuery(hashtable, columnName);
            }
            catch (Exception exception) {
                if (traceLogger == null || !traceLogger.isLogging()) break block4;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string2, exception);
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2, string3.toString());
        }
        return string3;
    }

    public static String[] splitKey(String string) {
        if (string.startsWith(DELIMITER)) {
            string = " " + string;
        }
        if (string.endsWith(DELIMITER)) {
            string = String.valueOf(string) + " ";
        }
        string = string.replaceAll("\\+\\+", "\\+ \\+");
        String[] stringArray = string.split("\\+");
        return stringArray;
    }

    public static String[] splitStorageSubsystemKey(String string) {
        String[] stringArray = string.split("\\+");
        stringArray = ExternalKeyConverter.checkForSlash(stringArray);
        String string2 = null;
        String string3 = null;
        int n = 0;
        while (n < stringArray.length) {
            string2 = stringArray[n].replaceAll("\\\\\\\\", "\\\\");
            stringArray[n] = string3 = string2.replaceAll("\\\\\\+", "\\+");
            ++n;
        }
        return stringArray;
    }

    private static String[] checkForSlash(String[] stringArray) {
        LinkedList<String> linkedList = new LinkedList<String>();
        String string = null;
        if (stringArray.length > 0) {
            boolean bl = false;
            int n = 0;
            while (n < stringArray.length) {
                string = bl ? String.valueOf(string) + DELIMITER + stringArray[n] : stringArray[n];
                if (string.endsWith("\\")) {
                    int n2 = ExternalKeyConverter.countSlashFromEnd(string);
                    if (n2 % 2 == 0) {
                        linkedList.add(string);
                        bl = false;
                        string = null;
                    } else {
                        bl = true;
                    }
                } else {
                    linkedList.add(string);
                    bl = false;
                    string = null;
                }
                ++n;
            }
        }
        if (string != null) {
            linkedList.add(String.valueOf(string) + DELIMITER);
        }
        return linkedList.toArray(new String[0]);
    }

    private static int countSlashFromEnd(String string) {
        int n = 0;
        int n2 = string.length() - 1;
        while (n2 >= 0) {
            if (string.charAt(n2) == '\\') {
                ++n;
            } else {
                return n;
            }
            --n2;
        }
        return n;
    }

    public static Hashtable getInternalIdWhereClause(String[] stringArray, String[] stringArray2) {
        Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
        if (stringArray == null || stringArray.length == stringArray2.length) {
            // empty if block
        }
        int n = 0;
        while (n < stringArray.length) {
            hashtable.put(Host.getColumnInfo(stringArray[n]), stringArray2[n]);
            ++n;
        }
        return hashtable;
    }

    public static Hashtable getHBAIdWhereClause(String[] stringArray, String[] stringArray2) {
        Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
        if (stringArray == null || stringArray.length == stringArray2.length) {
            // empty if block
        }
        int n = 0;
        while (n < stringArray.length) {
            hashtable.put(Hba.getColumnInfo(stringArray[n]), stringArray2[n]);
            ++n;
        }
        return hashtable;
    }

    public static Hashtable getSubsystemIdWhereClause(String[] stringArray, String[] stringArray2) {
        Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
        if (stringArray == null || stringArray.length == stringArray2.length) {
            // empty if block
        }
        int n = 0;
        while (n < stringArray.length) {
            hashtable.put(StorageSubsystem.getColumnInfo(stringArray[n]), stringArray2[n]);
            ++n;
        }
        return hashtable;
    }

    public static String runQuery(Hashtable hashtable, Vector vector) throws Exception {
        String string = "getComputers";
        String string2 = new String();
        DBConnection dBConnection = ServiceUtils.getConnection();
        Host.HostCursor hostCursor = null;
        try {
            try {
                hostCursor = Host.getCursor(dBConnection, hashtable, vector);
                while (hostCursor.next()) {
                    Object[] objectArray = hostCursor.getAttribute(vector);
                    string2 = objectArray[0].toString();
                }
            }
            catch (Exception exception) {
                dBConnection.rollback();
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string, exception);
                }
                throw exception;
            }
        }
        finally {
            block19: {
                block18: {
                    try {
                        if (hostCursor != null) {
                            hostCursor.close();
                        }
                    }
                    catch (Exception exception) {
                        if (traceLogger == null || !traceLogger.isLogging()) break block18;
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, String.valueOf(string) + " Error closing cursor: ", exception);
                    }
                }
                try {
                    if (dBConnection != null) {
                        dBConnection.close();
                    }
                }
                catch (Exception exception) {
                    if (traceLogger == null || !traceLogger.isLogging()) break block19;
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, String.valueOf(string) + " Error closing connection: ", exception);
                }
            }
        }
        return string2;
    }

    public static String runSSQuery(Hashtable hashtable, Vector vector) throws Exception {
        String string = "getSubsystemId";
        String string2 = new String();
        DBConnection dBConnection = ServiceUtils.getConnection();
        StorageSubsystem.StorageSubsystemCursor storageSubsystemCursor = null;
        try {
            try {
                storageSubsystemCursor = StorageSubsystem.getCursor(dBConnection, hashtable, vector);
                while (storageSubsystemCursor.next()) {
                    Object[] objectArray = storageSubsystemCursor.getAttribute(vector);
                    string2 = objectArray[0].toString();
                }
            }
            catch (Exception exception) {
                dBConnection.rollback();
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string, exception);
                }
                throw exception;
            }
        }
        finally {
            block19: {
                block18: {
                    try {
                        if (storageSubsystemCursor != null) {
                            storageSubsystemCursor.close();
                        }
                    }
                    catch (Exception exception) {
                        if (traceLogger == null || !traceLogger.isLogging()) break block18;
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, String.valueOf(string) + " Error closing cursor: ", exception);
                    }
                }
                try {
                    if (dBConnection != null) {
                        dBConnection.close();
                    }
                }
                catch (Exception exception) {
                    if (traceLogger == null || !traceLogger.isLogging()) break block19;
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, String.valueOf(string) + " Error closing connection: ", exception);
                }
            }
        }
        return string2;
    }

    public static String runHBAQuery(Hashtable hashtable, Vector vector) throws Exception {
        String string = "getHbas";
        String string2 = new String();
        DBConnection dBConnection = ServiceUtils.getConnection();
        Hba.HbaCursor hbaCursor = null;
        try {
            try {
                hbaCursor = Hba.getCursor(dBConnection, hashtable, vector);
                while (hbaCursor.next()) {
                    Object[] objectArray = hbaCursor.getAttribute(vector);
                    string2 = objectArray[0].toString();
                }
            }
            catch (Exception exception) {
                dBConnection.rollback();
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string, exception);
                }
                throw exception;
            }
        }
        finally {
            block19: {
                block18: {
                    try {
                        if (hbaCursor != null) {
                            hbaCursor.close();
                        }
                    }
                    catch (Exception exception) {
                        if (traceLogger == null || !traceLogger.isLogging()) break block18;
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, String.valueOf(string) + " Error closing cursor: ", exception);
                    }
                }
                try {
                    if (dBConnection != null) {
                        dBConnection.close();
                    }
                }
                catch (Exception exception) {
                    if (traceLogger == null || !traceLogger.isLogging()) break block19;
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, String.valueOf(string) + " Error closing connection: ", exception);
                }
            }
        }
        return string2;
    }

    public static String frameKeyStorageSubsystem(String string, short s) {
        return new String(String.valueOf(ExternalKeyConverter.convertString(string)) + DELIMITER + s);
    }

    private static String convertString(String string) {
        string = string.replaceAll("\\\\", "\\\\\\\\");
        string = string.replaceAll("\\+", "\\\\+");
        return string;
    }
}

