/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Window;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import org.eclipse.aperi.TStorm.gui.ReportPrefsManager;
import org.eclipse.aperi.TStorm.server.guireq.DeviceRequest;
import org.eclipse.aperi.TStorm.server.guireq.GuiChartSettingsReq;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.common.Variables;
import org.eclipse.aperi.common.api.CIMOM;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.gui.AlertLogDDI;
import org.eclipse.aperi.gui.AlertManager;
import org.eclipse.aperi.gui.Capabilities;
import org.eclipse.aperi.gui.GuiMain;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiSendRequest;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.Help;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.charting.AperiChartCustomizationManager;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.SocketTransceiver;
import org.eclipse.aperi.sanmgmt.middleware.data.RoleChecker;
import org.eclipse.aperi.server.guireq.GComputer;
import org.eclipse.aperi.server.guireq.SignonResp;
import org.eclipse.aperi.server.guireq.UserPreferences;
import org.eclipse.aperi.server.guireq.UserPreferencesSM;
import org.eclipse.aperi.server.req.DeviceServerStatusResp;
import org.eclipse.aperi.server.req.FabricIpsExistResp;
import org.eclipse.aperi.server.req.GuiInfoReq;
import org.eclipse.aperi.server.req.ServerRequest;
import org.eclipse.aperi.server.req.ServerStatusResp;
import org.eclipse.aperi.xmsg.MessageLog;

public class GuiClient {
    public static String server;
    public static int port;
    public static ServerStatusResp serverStatusResp;
    public static DeviceServerStatusResp deviceServerStatusResp;
    public static Response response;
    private static Request request;
    private static final String SERVER;
    private static final String STATUS;
    private static final String PRESS_PF1;
    private static RequestNode pendingRequests;

    static {
        request = new Request();
        SERVER = MessageLog.getMessageNoID("GUI0001L", null);
        STATUS = MessageLog.getMessageNoID("GUI0002L", null);
        PRESS_PF1 = MessageLog.getMessageNoID("GUI0084M", null);
    }

    public static void getChartCustomizations(String string) {
        GuiChartSettingsReq guiChartSettingsReq = new GuiChartSettingsReq();
        guiChartSettingsReq.creator = string;
        guiChartSettingsReq.reqType = 5;
        Request request = new Request();
        request.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
        request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
        request.subType = "org.eclipse.aperi.server.handler.gui.ChartSettingsHndlr";
        request.userName = GuiUtil.getUserName();
        request.flags = (byte)4;
        request.requestData = guiChartSettingsReq;
        if (GuiClient.doRequest(request) <= 4) {
            AperiChartCustomizationManager.initManager(GuiUtil.getUserName(), (ArrayList)GuiClient.response.responseData);
        }
    }

    public static short serverStatus() {
        ServerRequest.serverStatus(request);
        short s = GuiClient.doRequest(request);
        if (s > 4) {
            s = 12;
            serverStatusResp = null;
        } else {
            s = GuiClient.response.status;
            serverStatusResp = (ServerStatusResp)GuiClient.response.responseData;
        }
        return s;
    }

    public static short deviceServerStatus() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(GuiClient.class.getName(), "deviceServerStatus", "");
        }
        DeviceRequest deviceRequest = new DeviceRequest("org.eclipse.aperi.server.svp.GuiSvp", "org.eclipse.aperi.server.handler.gui.DeviceServerStatusHndlr");
        deviceRequest.requestData = null;
        short s = GuiClient.doRequest(deviceRequest);
        if (s > 4) {
            s = 12;
            deviceServerStatusResp = null;
        } else {
            s = GuiClient.response.status;
            deviceServerStatusResp = (DeviceServerStatusResp)GuiClient.response.responseData;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(GuiClient.class.getName(), "deviceServerStatus", s);
        }
        return s;
    }

    public static boolean doesIpTableDefinitelyHaveIps() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(GuiClient.class.getName(), "deviceServerStatus", "");
        }
        DeviceRequest deviceRequest = new DeviceRequest("org.eclipse.aperi.server.svp.GuiSvp", "org.eclipse.aperi.server.handler.gui.fabric.FabricIpsExistHndlr");
        short s = GuiClient.doRequest(deviceRequest);
        boolean bl = false;
        if (s != 12) {
            FabricIpsExistResp fabricIpsExistResp = (FabricIpsExistResp)GuiClient.response.responseData;
            bl = fabricIpsExistResp.hasIps();
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(GuiClient.class.getName(), "deviceServerStatus", s);
        }
        return bl;
    }

    public static boolean doesCimomTableHaveCimoms() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(GuiClient.class.getName(), "doesCimomTableHaveCimoms", "");
        }
        Request request = GuiUtil.newGUIDeviceRequest("org.eclipse.aperi.server.handler.gui.cimom.CIMOMMgmtGetCIMOMsHandler");
        short s = GuiClient.doRequest(request);
        boolean bl = false;
        if (s != 12) {
            CIMOM[] cIMOMArray = (CIMOM[])GuiClient.response.responseData;
            bl = cIMOMArray != null && cIMOMArray.length != 0;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(GuiClient.class.getName(), "doesCimomTableHaveCimoms", s);
        }
        return bl;
    }

    protected static short signon(String string, String string2) {
        ServerRequest.signon(request, string, string2);
        int n = GuiClient.doRequest(request);
        if (n <= 4 && GuiClient.response.responseData != null) {
            SignonResp signonResp = (SignonResp)GuiClient.response.responseData;
            GuiMain.capabilities = new Capabilities(signonResp.userRoles, signonResp.productAvailabilities, signonResp.deviceServerInstalled);
            if (signonResp.userRoles == RoleChecker.NO_ROLE) {
                JOptionPane.showMessageDialog(null, Util.getString("GUI8214E", string), Util.getString("LOGIN_FAILED"), 0);
                n = 12;
                GuiClient.clearFields();
            }
            AlertManager.refresh(NameList.unpackList(signonResp.activeAlerts));
            GuiMain.prefs = signonResp.prefs;
            GuiMain.adminGroup = signonResp.adminGroup;
            GuiUtil.sortOrderNotASCII = signonResp.sortOrderNotASCII;
            GuiMain.dashTotalsRow = signonResp.dashTotalsRow;
            Variables.spaceUnits = GuiMain.prefs.spaceUnits;
            ReportPrefsManager.cacheAll(GuiMain.prefs.sm.reportPrefs);
            AlertLogDDI.showLoginAlerts();
            GuiMain.prefs.sm.reportPrefs = null;
            GuiMain.prefs.administrator = GuiMain.capabilities.isAperiAdmin();
        } else {
            GuiClient.clearFields();
        }
        return (short)n;
    }

    private static void clearFields() {
        GuiMain.prefs = new UserPreferences();
        GuiMain.prefs.showLoginAlerts = 1;
        GuiMain.prefs.tabToDisplay = 0;
        GuiMain.prefs.sm = new UserPreferencesSM();
        GuiMain.dashTotalsRow = null;
        GuiMain.adminGroup = null;
        GuiUtil.sortOrderNotASCII = false;
        Variables.spaceUnits = 0;
    }

    protected static short checkServerVersion(String string) {
        Request request = new Request();
        request.typeCode = "org.eclipse.aperi.server.svp.ServerSvp";
        GuiInfoReq guiInfoReq = new GuiInfoReq();
        guiInfoReq.dataRequested = GuiInfoReq.SERVER_PRODUCT_VERSION;
        guiInfoReq.productVersion = string;
        request.requestData = guiInfoReq;
        request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
        request.subType = "org.eclipse.aperi.server.handler.server.GuiHndlr";
        short s = GuiClient.doRequest(request);
        return s;
    }

    public static short saveUserPrefs() {
        IGuiMain iGuiMain = GuiManager.getGuiManager().getGuiMain();
        if (iGuiMain instanceof GuiMain && GuiMain.DEMO_MODE) {
            return 0;
        }
        UserPreferences userPreferences = iGuiMain.getUserPrefs();
        userPreferences.sm.reportPrefs = ReportPrefsManager.getAll();
        ServerRequest.userPrefUpd(request, GuiUtil.getUserName(), userPreferences);
        short s = GuiClient.doRequest(request);
        return s;
    }

    public static GComputer getComputer(int n) {
        ServerRequest.guiInfo(request, GuiInfoReq.COMPUTER, n);
        short s = GuiClient.doRequest(request);
        if (s > 4) {
            return null;
        }
        return GComputer.unpackList((GComputer[])GuiClient.response.responseData);
    }

    public static String getAgentHome(int n) {
        String string = null;
        ServerRequest.agentGetAgentHome(request, n);
        short s = GuiClient.doRequest(request);
        if (s > 4) {
            return null;
        }
        string = (String)((Object)GuiClient.response.responseData);
        return string;
    }

    public static void serverError(short s, String string) {
        Container container;
        Container container2;
        Object object;
        Object object2;
        int n;
        String string2;
        String string3;
        IGuiMain iGuiMain = GuiManager.getGuiManager().getGuiMain();
        if (s == 4) {
            string3 = "GUI0057M";
            string2 = "GUI0058M";
            n = 2;
        } else {
            string3 = "GUI0020M";
            string2 = "GUI0021M";
            n = 0;
        }
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append(MessageLog.getMessageNoID(string2));
        stringBuffer.append('\n');
        stringBuffer.append(SERVER);
        stringBuffer.append(" ");
        stringBuffer.append(server);
        stringBuffer.append("           ");
        stringBuffer.append(STATUS);
        stringBuffer.append(" ");
        stringBuffer.append(s);
        stringBuffer.append('\n');
        stringBuffer.append(" ");
        stringBuffer.append('\n');
        stringBuffer.append(string);
        String string4 = null;
        if (string != null && (string4 = GuiClient.getHelpID(string)) != null) {
            stringBuffer.append("\n\n");
            stringBuffer.append(PRESS_PF1);
        }
        JOptionPane jOptionPane = new JOptionPane();
        if (string != null) {
            object2 = new JTextArea(stringBuffer.toString(), 10, 75);
            ((JTextArea)object2).setLineWrap(true);
            ((JTextArea)object2).setWrapStyleWord(true);
            ((JTextComponent)object2).setEditable(false);
            object = jOptionPane.getBackground();
            ((JComponent)object2).setBackground((Color)object);
            container2 = new JScrollPane((Component)object2);
            jOptionPane.setMessage(container2);
        }
        object2 = MessageLog.getMessageNoID(string3);
        jOptionPane.setMessageType(n);
        object = iGuiMain.getFrame().getOwnedWindows();
        container2 = null;
        if (object != null) {
            int n2 = 0;
            while (n2 < ((Window[])object).length) {
                container = object[n2];
                if (container instanceof Dialog && ((Window)container).getFocusOwner() != null) {
                    container2 = (Dialog)container;
                    break;
                }
                ++n2;
            }
        }
        JDialog jDialog = container2 != null ? jOptionPane.createDialog(container2, (String)object2) : jOptionPane.createDialog(iGuiMain.getFrame(), (String)object2);
        if (string4 != null) {
            container = jDialog.getRootPane();
            Help.setHelpID(container, string4);
            ((JComponent)container).registerKeyboardAction(Help.getDisplayHelpFromSource(), KeyStroke.getKeyStroke(156, 0), 2);
            ((JComponent)container).registerKeyboardAction(Help.getDisplayHelpFromSource(), KeyStroke.getKeyStroke(112, 0), 2);
        }
        GuiUtil.centerDialog(jDialog);
        jDialog.pack();
        jDialog.show();
    }

    private static String getHelpID(String string) {
        int n = 0;
        String string2 = null;
        while (n >= 0) {
            char c;
            if ((n = string.indexOf(": ", n + 1)) < 8 || (c = string.charAt(n - 1)) != 'E' && c != 'I' && c != 'W' && c != 'M') continue;
            boolean bl = true;
            int n2 = n - 8;
            int n3 = 0;
            while (n3 < 3) {
                if ((c = string.charAt(n2++)) < 'A' || c > 'Z') {
                    bl = false;
                    break;
                }
                ++n3;
            }
            if (!bl) continue;
            n3 = 0;
            while (n3 < 4) {
                if (!Character.isDigit(string.charAt(n2++))) {
                    bl = false;
                    break;
                }
                ++n3;
            }
            if (!bl) continue;
            String string3 = string.substring(n - 8, n);
            if (!Help.isValidID(string3)) break;
            string2 = string3;
            break;
        }
        return string2;
    }

    private static short doRequest(Request request) {
        String string;
        int n;
        response = null;
        request.userName = GuiUtil.getUserName();
        try {
            Socket socket = new Socket(server, port);
            SocketTransceiver socketTransceiver = new SocketTransceiver(socket, server, 300);
            response = socketTransceiver.transmitRequest(request, null);
            socketTransceiver.close();
            if (response == null) {
                n = 12;
                string = MessageLog.getMessage("GUI0022M", null);
            } else {
                n = GuiClient.response.status;
                string = GuiClient.response.errorMessage;
            }
        }
        catch (Exception exception) {
            n = 12;
            string = MessageLog.getMessage("GUI0023M", null);
        }
        if (n != 0) {
            GuiClient.serverError((short)n, string);
        }
        return (short)n;
    }

    public static Response doRefreshRequest(Request request, short[] sArray, StringBuffer stringBuffer) {
        Response response = null;
        request.userName = GuiUtil.getUserName();
        if (sArray == null || sArray.length == 0) {
            sArray = new short[1];
        }
        if (stringBuffer == null) {
            stringBuffer = new StringBuffer();
        }
        stringBuffer.setLength(0);
        try {
            Socket socket = new Socket(server, port);
            SocketTransceiver socketTransceiver = new SocketTransceiver(socket, server, 300);
            response = socketTransceiver.transmitRequest(request, null);
            socketTransceiver.close();
            if (response == null) {
                sArray[0] = 12;
                stringBuffer.append(MessageLog.getMessage("GUI0022M", null));
            } else {
                sArray[0] = response.status;
                stringBuffer.append(response.errorMessage);
            }
            if (response != null && response.responseData != null && response.responseData instanceof NameList[]) {
                response.responseData = NameList.unpackList((NameList[])response.responseData);
            }
        }
        catch (Exception exception) {
            sArray[0] = 12;
            stringBuffer.append(MessageLog.getMessage("GUI0023M", null));
        }
        return response;
    }

    private static RequestNode addToPending(GuiRequestor guiRequestor) {
        RequestNode requestNode = new RequestNode();
        requestNode.requestor = guiRequestor;
        requestNode.next = pendingRequests;
        pendingRequests = requestNode;
        return requestNode;
    }

    static boolean removeNode(RequestNode requestNode) {
        RequestNode requestNode2 = null;
        RequestNode requestNode3 = pendingRequests;
        while (requestNode3 != null && requestNode3 != requestNode) {
            requestNode2 = requestNode3;
            requestNode3 = requestNode3.next;
        }
        if (requestNode3 == null) {
            return false;
        }
        if (requestNode2 != null) {
            requestNode2.next = requestNode3.next;
        } else {
            pendingRequests = requestNode3.next;
        }
        return true;
    }

    public static void cancelAll() {
        pendingRequests = null;
    }

    static boolean nonePending() {
        return pendingRequests == null;
    }

    public static void doRequest(GuiRequestor guiRequestor, Request request) {
        IGuiMain iGuiMain = GuiManager.getGuiManager().getGuiMain();
        iGuiMain.guiEnabled(false);
        RequestNode requestNode = GuiClient.addToPending(guiRequestor);
        request.userName = GuiUtil.getUserName();
        GuiSendRequest guiSendRequest = new GuiSendRequest(request, requestNode);
        Thread thread = new Thread((Runnable)guiSendRequest, "Server Request");
        thread.setPriority(thread.getPriority() + 1);
        thread.start();
        try {
            Thread.sleep(1L);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    public static boolean doRhetoricalRequest(Request request) {
        Socket socket;
        request.userName = GuiUtil.getUserName();
        try {
            socket = new Socket(server, port);
        }
        catch (IOException iOException) {
            MessageLog.logException("GUI0023M", null);
            return false;
        }
        SocketTransceiver socketTransceiver = new SocketTransceiver(socket, server);
        boolean bl = socketTransceiver.writeObject((Object)request, -1);
        socketTransceiver.close();
        return bl;
    }

    static class RequestNode {
        public RequestNode next;
        public GuiRequestor requestor;

        RequestNode() {
        }
    }
}

