/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.gui.JobChangeListener;

public class JobChangeManager {
    private static Map<Integer, List<JobChangeListener>> listenerListMap = new HashMap<Integer, List<JobChangeListener>>();

    public static void removeListener(JobChangeListener jobChangeListener) {
        for (List<JobChangeListener> list : listenerListMap.values()) {
            Iterator<JobChangeListener> iterator = list.iterator();
            while (iterator.hasNext()) {
                if (iterator.next() != jobChangeListener) continue;
                iterator.remove();
            }
        }
    }

    public static void addListener(JobChangeListener jobChangeListener, short s) {
        List<JobChangeListener> list = listenerListMap.get(s);
        if (list == null) {
            list = new LinkedList<JobChangeListener>();
            listenerListMap.put(Integer.valueOf(s), list);
        }
        list.add(jobChangeListener);
    }

    public static void signalChange(int n, NameList nameList) {
        List<JobChangeListener> list = listenerListMap.get(nameList.nlInfo);
        if (list != null) {
            for (JobChangeListener jobChangeListener : list) {
                jobChangeListener.jobChangeOccurred(n, nameList);
            }
        }
    }
}

