/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.eclipse.aperi.TStorm.common.FsNameList;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.IconFactory;
import org.eclipse.aperi.gui.TreeSelectorNode;

public class NameListTreeCellRenderer
extends DefaultTreeCellRenderer {
    private static NameList object = null;
    public static Color darkerGreen = Color.green.darker();

    public static Icon iconForObject(NameList nameList) {
        object = nameList;
        return NameListTreeCellRenderer.iconForType(nameList.nlInfo);
    }

    public static Icon iconForType(short s) {
        ImageIcon imageIcon = null;
        switch (s) {
            case 99: {
                imageIcon = IconFactory.getClusterIcon();
                break;
            }
            case 1: {
                if (object != null && Constants.isVirtualServer(NameListTreeCellRenderer.object.nlID2)) {
                    imageIcon = IconFactory.getVirtualServerIcon();
                    break;
                }
                imageIcon = IconFactory.getComputerIcon();
                break;
            }
            case 3: {
                imageIcon = IconFactory.getFilesystemIcon();
                break;
            }
            case 17: {
                break;
            }
            case 16: {
                break;
            }
            case 86: {
                imageIcon = IconFactory.getStateRunningIcon();
                break;
            }
            case 84: {
                imageIcon = IconFactory.getStateSuccessIcon();
                break;
            }
            case 85: {
                imageIcon = IconFactory.getStateWarningIcon();
                break;
            }
            case 87: {
                imageIcon = IconFactory.getStateFailedIcon();
                break;
            }
            default: {
                imageIcon = null;
            }
        }
        return imageIcon;
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
        TreeSelectorNode treeSelectorNode = (TreeSelectorNode)object;
        NameList nameList = (NameList)treeSelectorNode.getUserObject();
        Icon icon = NameListTreeCellRenderer.iconForObject(nameList);
        if (nameList instanceof FsNameList) {
            if (((FsNameList)nameList).fsWillBeExtended) {
                icon = IconFactory.getExtendableFsIcon();
            }
            if (((FsNameList)nameList).fsGovernorLimited) {
                icon = IconFactory.getGovernorLimitedFsIcon();
            }
        }
        this.setIcon(icon);
        this.setDisabledIcon(icon);
        Font font = nameList.nlInfo < 0 ? BaseTree.boldFont : BaseTree.plainFont;
        this.setFont(font);
        return this;
    }
}

