/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.admin.agent;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.eclipse.aperi.gui.Capabilities;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.TJCTableMouseInterface;
import org.eclipse.aperi.gui.admin.agent.AgentListDDI;
import org.eclipse.aperi.gui.disk.common.DiskGuiTable;

public abstract class AgentListPanel
extends JPanel
implements TJCTableMouseInterface,
ActionListener,
FocusListener {
    private AgentListDDI ddi;
    private DiskGuiTable table = new DiskGuiTable();
    private boolean dblClick = false;
    private static TableCellRenderer drillDownRenderer = new DrillDownRenderer();
    private JPanel tablePanel = GuiUtil.getPanel();
    private JPanel buttonPanel = null;
    private JPanel refreshPanel = null;
    protected JButton refreshNowButton = null;
    JComboBox refreshRatesComboBox = null;
    JLabel jLastRefreshTime = null;
    protected static IGuiMain guiMain = GuiManager.getGuiManager().getGuiMain();
    protected Capabilities capabilities = guiMain.getCapabilities();

    protected abstract JPanel getButtonPanel();

    abstract void disableAllButtons();

    abstract void chooseButtons(Object var1);

    public abstract void actionPerformed(ActionEvent var1);

    public AgentListPanel(AgentListDDI agentListDDI) {
        this.ddi = agentListDDI;
    }

    AgentListDDI getDDI() {
        return this.ddi;
    }

    public DiskGuiTable getTable() {
        return this.table;
    }

    public JComponent setComponents() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.buttonPanel = this.getButtonPanel();
        this.refreshPanel = this.getRefreshPanel();
        this.refreshPanel.setBorder(BorderFactory.createEtchedBorder());
        jPanel.add((Component)this.refreshPanel, "North");
        jPanel.add((Component)this.buttonPanel, "South");
        this.tablePanel.setLayout(new GridBagLayout());
        this.tablePanel.setBorder(new TitledBorder(this.ddi.getDescription()));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.tablePanel.add((Component)this.table, gridBagConstraints);
        this.buildTable(this.tablePanel.getVisibleRect().getSize());
        this.add((Component)jPanel, "North");
        this.add((Component)this.tablePanel, "Center");
        return this;
    }

    protected JButton getButton(String string) {
        JButton jButton = new JButton(string);
        jButton.setEnabled(false);
        jButton.addActionListener(this);
        GuiUtil.setAccessible(jButton, jButton.getText(), jButton.getText());
        return jButton;
    }

    public boolean select(int n, int n2) {
        boolean bl = true;
        if (this.dblClick) {
            this.dblClick = false;
            bl = false;
        }
        return bl;
    }

    public void showPopup(int n, int n2, Component component, int n3, int n4) {
    }

    public void selectionChanged(boolean bl) {
        if (this.getDDI().getTableModel().getNumRows() != 0) {
            Object object = null;
            int n = this.table.getSelectPolicy();
            boolean bl2 = n == 1 || n == 2;
            int[] nArray = this.table.getSelectedRows();
            if (nArray != null && nArray.length != 0) {
                if (!bl2) {
                    object = this.getDDI().elementAt(nArray[0]);
                } else {
                    object = new Vector(nArray.length);
                    int n2 = 0;
                    while (n2 < nArray.length) {
                        ((Vector)object).add(this.getDDI().elementAt(nArray[n2]));
                        ++n2;
                    }
                }
                this.chooseButtons(object);
            } else {
                this.disableAllButtons();
            }
        } else {
            this.disableAllButtons();
        }
    }

    public void doubleClick(int n, int n2) {
        this.dblClick = true;
        try {
            this.launchDetails(this.getDDI().elementAt(n));
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return;
        }
    }

    public void showDefaultChart(int n) {
    }

    private void buildTable(Dimension dimension) {
        this.table.setMouseListener(this);
        this.table.setBaseTableModel(this.getDDI().getTableModel());
        this.table.setCellRenderer(JLabel.class, drillDownRenderer);
        this.table.setRowIcon(10, true);
        this.table.setSelectionPolicy(this.getSelectionPolicy());
        this.table.sortByColumn(this.getDDI().getSortColumn(), this.getDDI().getSortDirection());
        this.table.setPreferredSize(dimension);
        this.table.updateUI();
    }

    public void focusGained(FocusEvent focusEvent) {
        this.selectionChanged(true);
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    protected int getSelectionPolicy() {
        return 2;
    }

    private void launchDetails(Object object) {
        this.getDDI().getTreeNode(object, true, false);
    }

    private int MapRefreshRateToComboBoxEntries(int n) {
        if (n != -1) {
            n /= 60000;
        }
        if (n == -1) {
            return 0;
        }
        if (n >= 1 && n <= 5) {
            return n;
        }
        if (n >= 10 && n <= 45) {
            return n / 5 + 4;
        }
        if (n == 60) {
            return 11;
        }
        return -1;
    }

    private JPanel getRefreshPanel() {
        this.refreshNowButton = this.getButton(GuiUtil.getString("REFRESH_TABLE"));
        this.refreshNowButton.setEnabled(true);
        String string = GuiUtil.getString("REFRESH_NEVER");
        this.refreshRatesComboBox = new JComboBox<String>(new String[]{string, "1", "2", "3", "4", "5", "10", "15", "20", "30", "45", "60"});
        this.refreshRatesComboBox.setEnabled(true);
        int n = this.MapRefreshRateToComboBoxEntries(this.getDDI().getRefreshRate());
        this.refreshRatesComboBox.setSelectedIndex(n);
        this.refreshRatesComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)AgentListPanel.this.refreshRatesComboBox.getSelectedItem();
                try {
                    AgentListPanel.this.ddi.setRefreshRate(Integer.parseInt(string) * 60000);
                }
                catch (NumberFormatException numberFormatException) {
                    AgentListPanel.this.ddi.setRefreshRate(-1);
                }
            }
        });
        JLabel jLabel = new JLabel(GuiUtil.getString("REFRESH_RATE"));
        JLabel jLabel2 = new JLabel(GuiUtil.getString("REFRESH_MINS"));
        JLabel jLabel3 = new JLabel(GuiUtil.getString("REFRESH_LAST"));
        this.jLastRefreshTime = new JLabel("      ");
        JPanel jPanel = GuiUtil.getPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        Insets insets = new Insets(0, 0, 0, 12);
        Insets insets2 = new Insets(0, 0, 0, 36);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.insets = insets;
        jPanel.add((Component)jLabel, gridBagConstraints2);
        jPanel.add((Component)this.refreshRatesComboBox, gridBagConstraints2);
        gridBagConstraints2.insets = insets2;
        jPanel.add((Component)jLabel2, gridBagConstraints2);
        gridBagConstraints2.insets = insets;
        jPanel.add((Component)jLabel3, gridBagConstraints2);
        gridBagConstraints2.insets = insets2;
        jPanel.add((Component)this.jLastRefreshTime, gridBagConstraints2);
        jPanel.add((Component)this.refreshNowButton, gridBagConstraints);
        GuiUtil.completePanel(jPanel);
        return jPanel;
    }

    private static class DrillDownRenderer
    extends DefaultTableCellRenderer {
        private DrillDownRenderer() {
        }

        public void setValue(Object object) {
            String string = ((JLabel)object).getText();
            this.setText(string);
            this.setVerticalAlignment(1);
            this.setHorizontalAlignment(10);
            Icon icon = ((JLabel)object).getIcon();
            this.setIcon(icon);
        }
    }
}

