/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.common;

import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.BoldLabel;
import org.eclipse.aperi.gui.Capabilities;
import org.eclipse.aperi.gui.GridBagPanel;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.common.DirtyListenerInterface;

public class ManageElementManagersPanel
extends GridBagPanel {
    HashMap model = new HashMap();
    private String NO_MAPPING;
    private DirtyListenerInterface dirtyListener;
    JButton firstDeleteButton = null;
    JButton lastDeleteButton = null;
    private IGuiMain guiMain = GuiManager.getGuiManager().getGuiMain();
    private Capabilities capabilities = this.guiMain.getCapabilities();

    public ManageElementManagersPanel(String[][] stringArray) {
        this.NO_MAPPING = Util.getString("ELEMENT_MANAGER_DELETED");
        this.setTitle(Util.getString("ELEMENT_MANAGER_DDI_TITLE"));
        this.buildPanel(stringArray);
        this.addComponentListener(new DeleteButtonAdapter());
    }

    private void buildPanel(String[][] stringArray) {
        this.firstDeleteButton = this.addDeleteAllButton(stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            this.buildRow(stringArray[n], n);
            ++n;
        }
        if (stringArray.length > 0) {
            this.lastDeleteButton = this.addDeleteAllButton(stringArray.length);
        }
        this.createStretchBox();
    }

    private JButton addDeleteAllButton(int n) {
        JButton jButton = new JButton(Util.getString("ELEMENT_MANAGER_DELETE_ALL_BUTTON"));
        GuiUtil.setAccessible(jButton, jButton.getText(), jButton.getText());
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = JOptionPane.showConfirmDialog(ManageElementManagersPanel.this.guiMain.getFrame(), Util.getString("ELEMENT_MANAGER_DELETE_ALL"), Util.getString("ELEMENT_MANAGER_DELETE_ALL_TITLE"), 0);
                if (n == 0) {
                    Iterator iterator = ManageElementManagersPanel.this.model.keySet().iterator();
                    while (iterator.hasNext()) {
                        ManageElementManagersPanel.this.deleteAllValues((String)iterator.next());
                    }
                    ManageElementManagersPanel.this.talkDirty(null);
                }
            }
        });
        jButton.setEnabled(this.capabilities.isAperiAdmin() && n > 0);
        this.add(jButton);
        this.newRow();
        return jButton;
    }

    private void buildRow(String[] stringArray, int n) {
        JComponent jComponent;
        String string = String.valueOf(stringArray[0]) + " " + stringArray[1];
        BoldLabel boldLabel = new BoldLabel(string);
        this.add(boldLabel);
        String[] stringArray2 = new String[stringArray.length - 2];
        System.arraycopy(stringArray, 2, stringArray2, 0, stringArray.length - 2);
        if (stringArray2.length == 1) {
            jComponent = new JTextField(stringArray2[0]);
            ((JTextField)jComponent).setEditable(false);
        } else {
            jComponent = new JComboBox<String>(stringArray2);
        }
        GuiUtil.setAccessibleLabel(boldLabel, jComponent, "", string, string);
        this.add(jComponent, 21, 2);
        RowData rowData = new RowData(stringArray, jComponent, n);
        this.model.put(string, rowData);
        JButton jButton = new JButton(Util.getString("LABEL_EDIT"));
        jButton.setActionCommand(string);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ManageElementManagersPanel.this.editTextField(actionEvent.getActionCommand());
            }
        });
        jButton.setEnabled(this.capabilities.isAperiAdmin());
        this.add((JComponent)jButton, 21, 0);
        JButton jButton2 = new JButton(Util.getString("LABEL_DELETE"));
        jButton2.setActionCommand(string);
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ManageElementManagersPanel.this.deleteTextField(actionEvent.getActionCommand());
            }
        });
        jButton2.setEnabled(this.capabilities.isAperiAdmin());
        this.add((JComponent)jButton2, 21, 0);
        this.newRow();
    }

    protected void editTextField(String string) {
        String string2 = this.getTextValue(string);
        string2 = (String)JOptionPane.showInputDialog(this.guiMain.getFrame(), Util.getString("GUI8208I", string), Util.getString("ELEMENT_MANAGER_EDIT_TITLE"), 3, null, null, string2);
        if (string2 != null) {
            this.setTextValue(string, string2);
            this.talkDirty(null);
        }
    }

    protected void deleteTextField(String string) {
        if (this.NO_MAPPING.equals(this.getTextValue(string))) {
            return;
        }
        int n = JOptionPane.showConfirmDialog(this.guiMain.getFrame(), Util.getString("GUI8202I", this.getTextValue(string), string), Util.getString("ELEMENT_MANAGER_DELETE_TITLE"), 0);
        if (n == 0) {
            this.setTextValue(string, this.NO_MAPPING);
            this.talkDirty(null);
        }
    }

    private void setTextValue(String string, String string2) {
        JComponent jComponent = ((RowData)this.model.get((Object)string)).textField;
        if (string2.trim().equals("")) {
            return;
        }
        if (jComponent instanceof JTextField) {
            ((JTextField)jComponent).setText(string2);
        } else if (jComponent instanceof JComboBox) {
            int n = ((JComboBox)jComponent).getSelectedIndex();
            ((JComboBox)jComponent).removeItemAt(n);
            if (!this.NO_MAPPING.equals(string2) || this.NO_MAPPING.equals(string2) && ((JComboBox)jComponent).getItemCount() == 0) {
                ((JComboBox)jComponent).insertItemAt(string2, n);
                ((JComboBox)jComponent).setSelectedIndex(n);
            }
        }
    }

    private void deleteAllValues(String string) {
        JComponent jComponent = ((RowData)this.model.get((Object)string)).textField;
        if (jComponent instanceof JTextField) {
            ((JTextField)jComponent).setText(this.NO_MAPPING);
        } else if (jComponent instanceof JComboBox) {
            ((JComboBox)jComponent).removeAllItems();
            ((JComboBox)jComponent).addItem(this.NO_MAPPING);
        }
    }

    private String getTextValue(String string) {
        JComponent jComponent = ((RowData)this.model.get((Object)string)).textField;
        if (jComponent instanceof JTextField) {
            return ((JTextField)jComponent).getText();
        }
        return (String)((JComboBox)jComponent).getSelectedItem();
    }

    public String[][] getModel(TreeSet treeSet) {
        String[][] stringArrayArray = new String[this.model.size()][];
        int n = 0;
        for (String string : this.model.keySet()) {
            RowData rowData = (RowData)this.model.get(string);
            String[] stringArray = rowData.getTextFieldData();
            if (stringArray != null) {
                ++n;
                stringArrayArray[rowData.order] = new String[2 + stringArray.length];
                stringArrayArray[rowData.order][0] = rowData.rowData[0];
                stringArrayArray[rowData.order][1] = rowData.rowData[1];
                System.arraycopy(stringArray, 0, stringArrayArray[rowData.order], 2, stringArray.length);
                if (treeSet == null || !rowData.isDataModified()) continue;
                treeSet.add(rowData.rowData[0]);
                continue;
            }
            if (treeSet == null) continue;
            treeSet.add(rowData.rowData[0]);
        }
        String[][] stringArray = new String[n][];
        int n2 = 0;
        int n3 = 0;
        while (n2 < stringArrayArray.length) {
            if (stringArrayArray[n2] != null) {
                stringArray[n3++] = stringArrayArray[n2];
            }
            ++n2;
        }
        return stringArray;
    }

    private void talkDirty(String string) {
        if (this.dirtyListener != null) {
            this.dirtyListener.dirtyTalk(this, string);
        }
    }

    public void addDirtyListener(DirtyListenerInterface dirtyListenerInterface) {
        this.dirtyListener = dirtyListenerInterface;
    }

    public void removeDirtyListener(DirtyListenerInterface dirtyListenerInterface) {
        if (this.dirtyListener == this.dirtyListener) {
            this.dirtyListener = null;
        }
    }

    private class DeleteButtonAdapter
    extends ComponentAdapter {
        private DeleteButtonAdapter() {
        }

        public void componentShown(ComponentEvent componentEvent) {
            this.activateLastDelete((ManageElementManagersPanel)componentEvent.getComponent());
        }

        public void componentResized(ComponentEvent componentEvent) {
            this.activateLastDelete((ManageElementManagersPanel)componentEvent.getComponent());
        }

        private void activateLastDelete(ManageElementManagersPanel manageElementManagersPanel) {
            Rectangle rectangle = manageElementManagersPanel.getVisibleRect();
            Rectangle rectangle2 = manageElementManagersPanel.getBounds();
            if (rectangle2.height == rectangle.height) {
                if (manageElementManagersPanel.lastDeleteButton != null && manageElementManagersPanel.lastDeleteButton.isVisible()) {
                    manageElementManagersPanel.lastDeleteButton.setVisible(false);
                }
            } else if (manageElementManagersPanel.lastDeleteButton != null && !manageElementManagersPanel.lastDeleteButton.isVisible()) {
                manageElementManagersPanel.lastDeleteButton.setVisible(true);
            }
        }
    }

    private class RowData {
        JComponent textField;
        String[] rowData;
        int order;

        public RowData(String[] stringArray, JComponent jComponent, int n) {
            this.rowData = stringArray;
            this.textField = jComponent;
            this.order = n;
        }

        String[] getTextFieldData() {
            if (this.textField instanceof JTextField) {
                if (!ManageElementManagersPanel.this.NO_MAPPING.equals(((JTextField)this.textField).getText())) {
                    return new String[]{((JTextField)this.textField).getText()};
                }
                return null;
            }
            if (((JComboBox)this.textField).getItemCount() == 0 || ((JComboBox)this.textField).getItemCount() == 1 && ManageElementManagersPanel.this.NO_MAPPING.equals((String)((JComboBox)this.textField).getItemAt(0))) {
                return null;
            }
            int n = ((JComboBox)this.textField).getItemCount();
            TreeSet<String> treeSet = new TreeSet<String>();
            ArrayList<String> arrayList = new ArrayList<String>();
            int n2 = 0;
            while (n2 < n) {
                if (treeSet.add((String)((JComboBox)this.textField).getItemAt(n2))) {
                    arrayList.add((String)((JComboBox)this.textField).getItemAt(n2));
                }
                ++n2;
            }
            return arrayList.toArray(new String[arrayList.size()]);
        }

        boolean isDataModified() {
            boolean bl = false;
            if (this.textField instanceof JTextField) {
                return ((JTextField)this.textField).getText().equals(this.rowData[2]);
            }
            int n = ((JComboBox)this.textField).getItemCount();
            if (n != this.rowData.length - 2) {
                return true;
            }
            TreeSet treeSet = new TreeSet();
            int n2 = 0;
            while (n2 < n) {
                treeSet.add(((JComboBox)this.textField).getItemAt(n2));
                ++n2;
            }
            n2 = 2;
            while (n2 < this.rowData.length) {
                if (!treeSet.remove(this.rowData[n2])) {
                    bl = true;
                }
                ++n2;
            }
            return bl || treeSet.size() > 0;
        }
    }
}

