/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.config.service;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.common.api.CIMOM;
import org.eclipse.aperi.common.api.CIMOMConnectionStatus;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.gui.BaseTreeNode;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.JSgcScheduleCreateWhenData;
import org.eclipse.aperi.gui.TJCTableMouseInterface;
import org.eclipse.aperi.gui.admin.AdminTreeLabel;
import org.eclipse.aperi.gui.admin.agent.AgentListTreeNode;
import org.eclipse.aperi.gui.admin.agent.AgentTreeNodesStore;
import org.eclipse.aperi.gui.admin.agent.CimomAgentListPanel;
import org.eclipse.aperi.gui.admin.agent.CimomAgentTableModel;
import org.eclipse.aperi.gui.common.CIMOMMgmtAddCIMOMDialog;
import org.eclipse.aperi.gui.config.common.ConfigNote;
import org.eclipse.aperi.gui.config.common.ConfigSection;
import org.eclipse.aperi.gui.config.common.ConfigUtil;
import org.eclipse.aperi.gui.config.common.LabelRenderer;
import org.eclipse.aperi.gui.config.common.NumberRenderer;
import org.eclipse.aperi.gui.config.service.CimomManagedDeviceDialog;
import org.eclipse.aperi.gui.tables.MegaTable;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.req.CimomManagedDeviceReq;
import org.eclipse.aperi.xmsg.MessageLog;

public class CIMAgentSection
extends ConfigSection
implements ActionListener,
TJCTableMouseInterface {
    private MegaTable table = null;
    private CimomAgentTableModel tableModel = null;
    private JButton link2detail = null;
    private JButton testBtn = null;
    private JButton addBtn = null;
    private JButton discoverBtn = null;
    private JButton deviceBtn = null;
    private JLabel noData = null;
    private ArrayList cimagtNodePath = null;
    private ArrayList cimjobNodePath = null;
    private int countTotal = 0;
    private int countSuccess = 0;
    private int countUnknown = 0;
    private int countUnreachable = 0;
    private int countTimeout = 0;

    public CIMAgentSection(boolean bl) {
        super(bl);
        this.prepareTreeNodes();
    }

    private void prepareTreeNodes() {
        this.cimagtNodePath = new ArrayList();
        this.cimagtNodePath.add(AdminTreeLabel.class);
        this.cimagtNodePath.add(MessageLog.getMessageNoID("ADG0200L", null));
        this.cimagtNodePath.add(AgentListTreeNode.class);
        this.cimagtNodePath.add(GuiUtil.getString("CIMOM_MGMT_LABEL"));
        this.cimjobNodePath = new ArrayList();
        this.cimjobNodePath.add(AdminTreeLabel.class);
        this.cimjobNodePath.add(MessageLog.getMessageNoID("STG4091L"));
        this.cimjobNodePath.add(MessageLog.getMessageNoID("STG7569L"));
        this.cimjobNodePath.add(new Integer(-1));
    }

    public String getSectionTitle() {
        String string = GuiUtil.getString("CONFIG_CIMAGENT_TITLE_EXPANDED");
        if (!this.isExpanded()) {
            string = Util.getString("CONFIG_CIMAGENT_TITLE_COLLAPSED", new String[]{String.valueOf(this.countTotal), String.valueOf(this.countSuccess), String.valueOf(this.countUnknown), String.valueOf(this.countTimeout)});
        }
        return string;
    }

    private void getAgents() {
        Request request = GuiUtil.newGUIDeviceRequest("org.eclipse.aperi.server.handler.gui.cimom.CIMOMMgmtGetCIMOMsHandler");
        GuiClient.doRequest(new GuiRequestor(){

            public void handleResponse(short s, Response response) {
                if (s <= 4) {
                    CIMOM[] cIMOMArray = (CIMOM[])response.responseData;
                    CIMAgentSection.this.resetStateCount();
                    int n = 0;
                    while (cIMOMArray != null && n < cIMOMArray.length) {
                        CIMAgentSection.this.setStateCount(cIMOMArray[n].getStatus());
                        ++n;
                    }
                    CIMAgentSection.this.tableModel = new CimomAgentTableModel(new ArrayList(Arrays.asList(cIMOMArray)));
                    if (cIMOMArray.length != 0 && CIMAgentSection.this.tableModel != null) {
                        if (CIMAgentSection.this.table != null) {
                            CIMAgentSection.this.remove(CIMAgentSection.this.table);
                        }
                        if (CIMAgentSection.this.noData != null) {
                            CIMAgentSection.this.remove(CIMAgentSection.this.noData);
                        }
                        CIMAgentSection.this.table = new MegaTable();
                        CIMAgentSection.this.table.setVisibleRows(10);
                        CIMAgentSection.this.table.setMouseListener(CIMAgentSection.this);
                        CIMAgentSection.this.table.setBaseTableModel(CIMAgentSection.this.tableModel);
                        CIMAgentSection.this.table.setCellRenderer(Number.class, new NumberRenderer());
                        CIMAgentSection.this.table.setCellRenderer(JLabel.class, new LabelRenderer());
                        CIMAgentSection.this.table.setSelectionPolicy(0);
                        CIMAgentSection.this.table.sortByColumn(1, 1);
                        CIMAgentSection.this.selectionChanged(true);
                        CIMAgentSection.this.table.updateUI();
                        CIMAgentSection.this.add((Component)CIMAgentSection.this.table, "First");
                    } else {
                        if (CIMAgentSection.this.table != null) {
                            CIMAgentSection.this.remove(CIMAgentSection.this.table);
                        }
                        CIMAgentSection.this.noData = new JLabel(GuiUtil.getString("CONFIG_NO_CIM_AGENTS"));
                        CIMAgentSection.this.add((Component)CIMAgentSection.this.noData, "Center");
                    }
                    if (CIMAgentSection.this.getContainer() != null) {
                        CIMAgentSection.this.getContainer().updateSectionTitle();
                    }
                    CIMAgentSection.this.revalidate();
                    CIMAgentSection.this.repaint();
                    CIMAgentSection.this.selectionChanged(false);
                }
            }
        }, request);
    }

    private void resetStateCount() {
        this.countSuccess = 0;
        this.countUnreachable = 0;
        this.countUnknown = 0;
        this.countTotal = 0;
        this.countTimeout = 0;
    }

    private void setStateCount(CIMOMConnectionStatus cIMOMConnectionStatus) {
        if (cIMOMConnectionStatus == CIMOMConnectionStatus.SUCCESS) {
            ++this.countSuccess;
        }
        if (cIMOMConnectionStatus == CIMOMConnectionStatus.UNKNOWN) {
            ++this.countUnknown;
        }
        if (cIMOMConnectionStatus == CIMOMConnectionStatus.TIMEOUT) {
            ++this.countTimeout;
        }
        ++this.countTotal;
    }

    public void refresh(boolean bl) {
        if (this.addBtn == null) {
            this.setLayout(new BorderLayout());
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            this.add((Component)jPanel, "Last");
            JPanel jPanel2 = new JPanel(new FlowLayout(3));
            this.addBtn = new JButton(GuiUtil.getString("CONFIG_CIMAGENT_BUTTON_ADD"));
            GuiUtil.setAccessible(this.addBtn, this.addBtn.getText(), this.addBtn.getText());
            this.addBtn.addActionListener(this);
            jPanel2.add(this.addBtn);
            this.link2detail = new JButton(GuiUtil.getString("CONFIG_CIMAGENT_BUTTON_DETAILS"));
            GuiUtil.setAccessible(this.link2detail, this.link2detail.getText(), this.link2detail.getText());
            this.link2detail.addActionListener(this);
            jPanel2.add(this.link2detail);
            this.testBtn = new JButton(GuiUtil.getString("CIMOM_MGMT_TST"));
            GuiUtil.setAccessible(this.testBtn, this.testBtn.getText(), this.testBtn.getText());
            this.testBtn.addActionListener(this);
            jPanel2.add(this.testBtn);
            this.discoverBtn = new JButton(GuiUtil.getString("CONFIG_COMMON_CIMOM_DISC_BTN"));
            GuiUtil.setAccessible(this.discoverBtn, this.discoverBtn.getText(), this.discoverBtn.getText());
            this.discoverBtn.addActionListener(this);
            jPanel2.add(this.discoverBtn);
            this.deviceBtn = new JButton(GuiUtil.getString("CONFIG_CIMAGENT_BUTTON_SHOW_DEVICES"));
            GuiUtil.setAccessible(this.deviceBtn, this.deviceBtn.getText(), this.deviceBtn.getText());
            this.deviceBtn.addActionListener(this);
            jPanel2.add(this.deviceBtn);
            jPanel2.setAlignmentX(0.0f);
            jPanel.add(jPanel2);
            ConfigNote configNote = new ConfigNote(GuiUtil.getString("CONFIG_CIMAGENT_NOTE"), jPanel);
            configNote.setAlignmentX(0.0f);
            jPanel.add(configNote);
            ConfigNote configNote2 = new ConfigNote(GuiUtil.getString("CONFIG_CIMAGENT_NOTE2"), jPanel);
            configNote2.setAlignmentX(0.0f);
            jPanel.add(configNote2);
        }
        if (bl || this.tableModel == null) {
            this.getAgents();
        }
        this.setVisible(this.isExpanded());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        CIMOM cIMOM;
        if (actionEvent.getSource() == this.link2detail) {
            CIMOM cIMOM2 = this.getSelectedCIMOM();
            if (cIMOM2 != null) {
                BaseTreeNode baseTreeNode = new ConfigUtil().getNode(this.cimagtNodePath);
                AgentTreeNodesStore.getTreeNode(cIMOM2, 6, baseTreeNode, true, false);
            }
        } else if (actionEvent.getSource() == this.addBtn) {
            new CIMOMMgmtAddCIMOMDialog(guiMain.getFrame(), GuiUtil.getString("CIMOM_MGMT_ADD_TITLE"), null);
            this.refresh(true);
        } else if (actionEvent.getSource() == this.testBtn) {
            final CIMOM cIMOM3 = this.getSelectedCIMOM();
            Request request = GuiUtil.newGUIDeviceRequest("org.eclipse.aperi.server.handler.gui.cimom.CIMOMMgmtTestCIMOMsHandler");
            request.requestData = cIMOM3;
            GuiClient.doRequest(new GuiRequestor(){

                public void handleResponse(short s, Response response) {
                    if (s <= 4) {
                        int n;
                        String string;
                        CIMOMConnectionStatus cIMOMConnectionStatus = (CIMOMConnectionStatus)response.responseData;
                        if (cIMOMConnectionStatus == CIMOMConnectionStatus.SUCCESS) {
                            string = Util.getString("GUI8102I", CimomAgentListPanel.getBestDisplayName(cIMOM3));
                            n = 1;
                        } else {
                            string = Util.getString("GUI8101I", CimomAgentListPanel.getBestDisplayName(cIMOM3), CimomAgentListPanel.getLocalizedStatus(cIMOMConnectionStatus));
                            n = 0;
                        }
                        cIMOM3.setStatus(cIMOMConnectionStatus);
                        CIMAgentSection.this.refresh(true);
                        JOptionPane.showMessageDialog(CIMAgentSection.access$8().getFrame(), string, GuiUtil.getString("CIMOM_MGMT_TST_TITLE"), n);
                    }
                }
            }, request);
        } else if (actionEvent.getSource() == this.discoverBtn) {
            Request request = new Request();
            request.typeCode = "org.eclipse.aperi.server.svp.SchedulerSvp";
            request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
            request.subType = "org.eclipse.aperi.server.handler.scheduler.SchRunNowHandler";
            request.flags = (byte)4;
            NameList nameList = new NameList();
            nameList.nlID = 110;
            nameList.nlInfo = (short)104;
            request.requestData = nameList;
            GuiClient.doRequest(new GuiRequestor(){

                public void handleResponse(short s, Response response) {
                    if (s <= 4) {
                        Object[] objectArray = new Object[2];
                        objectArray[0] = MessageLog.getMessageNoID("STG7578L");
                        Object[] objectArray2 = objectArray;
                        JSgcScheduleCreateWhenData.displayJobSubmittedMessage(objectArray2);
                        ArrayList arrayList = new ArrayList(CIMAgentSection.this.cimjobNodePath);
                        new ConfigUtil().selectNode(arrayList);
                    }
                }
            }, request);
        } else if (actionEvent.getSource() == this.deviceBtn && (cIMOM = this.getSelectedCIMOM()) != null) {
            Request request = new Request();
            request.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
            request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
            request.subType = "org.eclipse.aperi.server.handler.gui.CimomManagedDeviceHndlr";
            request.requestData = new CimomManagedDeviceReq(cIMOM.getServiceId());
            request.flags = (byte)4;
            GuiClient.doRequest(new GuiRequestor(){

                public void handleResponse(short s, Response response) {
                    if (s <= 4) {
                        CimomManagedDeviceReq cimomManagedDeviceReq = (CimomManagedDeviceReq)response.responseData;
                        ArrayList arrayList = cimomManagedDeviceReq.list;
                        if (arrayList != null) {
                            new CimomManagedDeviceDialog(CIMAgentSection.access$8().getFrame(), GuiUtil.getString("CONFIG_CIMMGMT_CIM_MANAGED_DEVICE"), arrayList);
                        }
                    }
                }
            }, request);
        }
    }

    public CIMOM getSelectedCIMOM() {
        int[] nArray;
        if (this.tableModel != null && this.tableModel.getNumRows() != 0 && (nArray = this.table.getSelectedRows()) != null && nArray.length > 0) {
            int n = nArray[0];
            return (CIMOM)this.tableModel.cimoms.get(n);
        }
        return null;
    }

    public void selectionChanged(boolean bl) {
        CIMOM cIMOM = this.getSelectedCIMOM();
        if (cIMOM != null) {
            this.link2detail.setEnabled(true);
            this.testBtn.setEnabled(true);
            this.deviceBtn.setEnabled(true);
        } else {
            this.link2detail.setEnabled(false);
            this.testBtn.setEnabled(false);
            this.deviceBtn.setEnabled(false);
        }
        if (!this.capabilities.isAperiAdmin()) {
            this.addBtn.setEnabled(false);
            this.link2detail.setEnabled(false);
            this.discoverBtn.setEnabled(false);
        }
    }

    public boolean select(int n, int n2) {
        return true;
    }

    public void doubleClick(int n, int n2) {
    }

    public void showPopup(int n, int n2, Component component, int n3, int n4) {
    }

    public void showDefaultChart(int n) {
    }

    static /* synthetic */ IGuiMain access$8() {
        return ConfigSection.guiMain;
    }
}

