/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.fabric.reports;

import org.eclipse.aperi.TStorm.common.ColumnDescriptor;
import org.eclipse.aperi.TStorm.common.CustomReportDataAdjuster;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.fabric.FabricGuiUtil;
import org.eclipse.aperi.server.guireq.fabric.reports.RespFabricAssets;

public class FabricAssetsAdjuster
extends CustomReportDataAdjuster {
    private static final String FABRIC_ID = Util.getString("FabricDetails_FabricID");
    private static final String LABEL = Util.getString("FabricDetails_Label");
    private static final String TYPE = Util.getString("FabricDetails_Type");
    private static final String STATUS = Util.getString("FabricSensorsEvents_Status");
    private static final String IP_ADDRESS = Util.getString("FabricDetails_IPAddress");
    private static final String VENDOR = Util.getString("FabricDetails_VendorID");
    private static final String MODEL = Util.getString("FabricDetails_Model");
    private static final String VERSION = Util.getString("FabricDetails_Version");
    private static final String SERIAL_NUMBER = Util.getString("FabricDetails_SerialNumber");
    private static final String OBJECT_ID = Util.getString("FabricDetails_ObjectID");
    private static final String MANAGEMENT_ID = Util.getString("FabricDetails_ManagementID");
    private static final String MANAGEMENT_ADDRESS = Util.getString("FabricDetails_ManagementAddress");
    private static final String DOMAIN = Util.getString("FabricDetails_Domain");
    private static final String CONTACT = Util.getString("FabricDetails_Contact");
    private static final String WWN = Util.getString("FabricDetails_WWN");
    private static final String LOCATION = Util.getString("FabricDetails_Location");
    private static final String PHYSICAL_SWITCH_WWN = Util.getString("FabricDetails_PhysicalSwitchWWN");
    private static final String ID = Util.getString("FabricDetails_Identifier");
    public String[] colNames;
    public String[] AssetsAll = new String[]{FABRIC_ID, TYPE, LABEL, STATUS};
    public String[] AssetsSwitches = new String[]{FABRIC_ID, TYPE, LABEL, IP_ADDRESS, VENDOR, MODEL, VERSION, SERIAL_NUMBER, OBJECT_ID, MANAGEMENT_ID, MANAGEMENT_ADDRESS, DOMAIN, CONTACT, WWN, LOCATION, PHYSICAL_SWITCH_WWN};
    public String[] AssetsConnectedDev = new String[]{FABRIC_ID, TYPE, LABEL, ID, STATUS};
    public static final int SAN_ASSETS_All_FABRIC_ID_COL = 0;
    public static final int SAN_ASSETS_All_TYPE_COL = 1;
    public static final int SAN_ASSETS_All_LABEL_COL = 2;
    public static final int SAN_ASSETS_All_STATUS_COL = 3;
    public static final int SAN_ASSETS_SWITCHES_FABRIC_ID_COL = 0;
    public static final int SAN_ASSETS_SWITCHES_TYPE_COL = 1;
    public static final int SAN_ASSETS_SWITCHES_LABEL_COL = 2;
    public static final int SAN_ASSETS_SWITCHES_IP_ADDRESS_COL = 3;
    public static final int SAN_ASSETS_SWITCHES_VENDOR_COL = 4;
    public static final int SAN_ASSETS_SWITCHES_MODEL_COL = 5;
    public static final int SAN_ASSETS_SWITCHES_VERSION_COL = 6;
    public static final int SAN_ASSETS_SWITCHES_SERIAL_NUMBER_COL = 7;
    public static final int SAN_ASSETS_SWITCHES_OBJECT_ID_COL = 8;
    public static final int SAN_ASSETS_SWITCHES_MANAGEMENT_ID_COL = 9;
    public static final int SAN_ASSETS_SWITCHES_MANAGEMENT_ADDRESS_COL = 10;
    public static final int SAN_ASSETS_SWITCHES_DOMAIN_COL = 11;
    public static final int SAN_ASSETS_SWITCHES_CONTACT_COL = 12;
    public static final int SAN_ASSETS_SWITCHES_WWN_COL = 13;
    public static final int SAN_ASSETS_SWITCHES_LOCATION_COL = 14;
    public static final int SAN_ASSETS_SWITCHES_PHYSICAL_SWITCH_WWN_COL = 15;
    public static final int SAN_ASSETS_CONNECTED_DEV_FABRIC_ID_COL = 0;
    public static final int SAN_ASSETS_CONNECTED_DEV_TYPE_COL = 1;
    public static final int SAN_ASSETS_CONNECTED_DEV_LABEL_COL = 2;
    public static final int SAN_ASSETS_CONNECTED_DEV_WWN_COL = 3;
    public static final int SAN_ASSETS_CONNECTED_DEV_STATUS_COL = 4;
    public static final int LOCATION_COL = 15;
    public static final int PHYSICAL_SWITCH_WWN_COL = 16;
    private GuiReportReq grr;
    private RespFabricAssets[] data;
    private MutableInteger[] mInt;
    private int[] rendererArray;
    private int rows;
    public int frozenRows;
    public int frozenLabels;
    public static final int FROZEN_LABEL_ROWS = 2;
    public static final int FROZEN_ROWS = 2;
    public static final int FROZEN_COLUMNS = 0;
    private boolean batch;
    private ColumnPopulator populator;

    private Object checkForUnknown(Object object) {
        Object object2 = object;
        String string = object.toString();
        if (string.equalsIgnoreCase("unknown")) {
            object2 = FabricGuiUtil.getString("FabricDetails_Unknown");
        }
        return object2;
    }

    public FabricAssetsAdjuster(GuiReportReq guiReportReq) {
        super(guiReportReq);
        this.grr = guiReportReq;
        this.populator = null;
        this.frozenColumns = 0;
        int n = 0;
        if (guiReportReq.reportSubtype == 101) {
            this.colNames = this.AssetsAll;
            this.populator = new SAN_Assets_All_Populator();
            this.frozenRows = 0;
            this.frozenLabels = 0;
            this.rendererArray = new int[this.colNames.length];
            n = 0;
            while (n < this.colNames.length) {
                this.rendererArray[n] = 0;
                ++n;
            }
        } else if (guiReportReq.reportSubtype == 102) {
            this.colNames = this.AssetsSwitches;
            this.populator = new SAN_Assets_Switches_Populator();
            this.frozenRows = 0;
            this.frozenLabels = 0;
            this.rendererArray = new int[this.colNames.length];
            n = 0;
            while (n < this.colNames.length) {
                this.rendererArray[n] = 0;
                ++n;
            }
            this.rendererArray[8] = 5;
        } else {
            this.colNames = this.AssetsConnectedDev;
            this.populator = new SAN_Assets_Connected_Dev_Populator();
            this.frozenRows = 0;
            this.frozenLabels = 0;
            this.rendererArray = new int[this.colNames.length];
            n = 0;
            while (n < this.colNames.length) {
                this.rendererArray[n] = 0;
                ++n;
            }
        }
        this.colNames = this.getCustomizedColNames(this.colNames);
    }

    public void adjust(Object[] objectArray, boolean bl) {
        this.adjustInit(objectArray, bl);
        this.adjustData();
    }

    public void adjustInit(Object[] objectArray, boolean bl) {
        this.batch = bl;
        this.data = (RespFabricAssets[])objectArray;
        this.rows = this.data.length;
        this.mInt = new MutableInteger[this.rows];
        int n = 0;
        while (n < this.rows) {
            this.mInt[n] = new MutableInteger();
            ++n;
        }
    }

    public void adjustData() {
    }

    protected void addValidValues(ColumnDescriptor[] columnDescriptorArray) {
    }

    public Object getArray() {
        return this.data;
    }

    public int getNumberRows() {
        return this.data.length;
    }

    public int getNumberColumns() {
        return this.colNames.length;
    }

    public int getNumberFrozenRows() {
        return 0;
    }

    public int[] getRenderers() {
        return this.rendererArray;
    }

    public int[] getHiddenColumns() {
        return this.hiddenColumns;
    }

    public int[] getSelectedIDs() {
        int[] nArray = new int[this.data.length];
        int n = 0;
        while (n < this.data.length) {
            RespFabricAssets cfr_ignored_0 = this.data[n];
            ++n;
        }
        return nArray;
    }

    public Object getCellData(int n, int n2) {
        return this.populator.getCellData(n, n2);
    }

    private static interface ColumnPopulator {
        public Object getCellData(int var1, int var2);
    }

    private class SAN_Assets_All_Populator
    implements ColumnPopulator {
        private SAN_Assets_All_Populator() {
        }

        public Object getCellData(int n, int n2) {
            RespFabricAssets cfr_ignored_0 = FabricAssetsAdjuster.this.data[n];
            Object object = null;
            switch (n2) {
                case 0: {
                    object = ((FabricAssetsAdjuster)FabricAssetsAdjuster.this).data[n].FabricID;
                    break;
                }
                case 1: {
                    object = ((FabricAssetsAdjuster)FabricAssetsAdjuster.this).data[n].Type;
                    break;
                }
                case 2: {
                    object = ((FabricAssetsAdjuster)FabricAssetsAdjuster.this).data[n].Label;
                    break;
                }
                case 3: {
                    ((FabricAssetsAdjuster)FabricAssetsAdjuster.this).mInt[n].value = ((FabricAssetsAdjuster)FabricAssetsAdjuster.this).data[n].Status;
                    object = FabricGuiUtil.getStatusString(((FabricAssetsAdjuster)FabricAssetsAdjuster.this).mInt[n].value);
                }
            }
            return object;
        }
    }

    private class SAN_Assets_Connected_Dev_Populator
    implements ColumnPopulator {
        private SAN_Assets_Connected_Dev_Populator() {
        }

        public Object getCellData(int n, int n2) {
            RespFabricAssets cfr_ignored_0 = FabricAssetsAdjuster.this.data[n];
            Object object = null;
            switch (n2) {
                case 0: {
                    object = ((FabricAssetsAdjuster)FabricAssetsAdjuster.this).data[n].FabricID;
                    break;
                }
                case 1: {
                    object = ((FabricAssetsAdjuster)FabricAssetsAdjuster.this).data[n].Type;
                    break;
                }
                case 2: {
                    object = ((FabricAssetsAdjuster)FabricAssetsAdjuster.this).data[n].Label;
                    break;
                }
                case 3: {
                    object = ((FabricAssetsAdjuster)FabricAssetsAdjuster.this).data[n].WWN;
                    break;
                }
                case 4: {
                    ((FabricAssetsAdjuster)FabricAssetsAdjuster.this).mInt[n].value = ((FabricAssetsAdjuster)FabricAssetsAdjuster.this).data[n].Status;
                    object = FabricGuiUtil.getStatusString(((FabricAssetsAdjuster)FabricAssetsAdjuster.this).mInt[n].value);
                }
            }
            return object;
        }
    }

    private class SAN_Assets_Switches_Populator
    implements ColumnPopulator {
        private SAN_Assets_Switches_Populator() {
        }

        public Object getCellData(int n, int n2) {
            RespFabricAssets cfr_ignored_0 = FabricAssetsAdjuster.this.data[n];
            Object object = null;
            switch (n2) {
                case 0: {
                    object = ((FabricAssetsAdjuster)FabricAssetsAdjuster.this).data[n].FabricID;
                    break;
                }
                case 1: {
                    object = ((FabricAssetsAdjuster)FabricAssetsAdjuster.this).data[n].Type;
                    break;
                }
                case 2: {
                    object = ((FabricAssetsAdjuster)FabricAssetsAdjuster.this).data[n].Label;
                    break;
                }
                case 3: {
                    object = ((FabricAssetsAdjuster)FabricAssetsAdjuster.this).data[n].IP_Address;
                    break;
                }
                case 4: {
                    object = FabricAssetsAdjuster.this.checkForUnknown(((FabricAssetsAdjuster)FabricAssetsAdjuster.this).data[n].Vendor);
                    break;
                }
                case 5: {
                    object = FabricAssetsAdjuster.this.checkForUnknown(((FabricAssetsAdjuster)FabricAssetsAdjuster.this).data[n].Model);
                    break;
                }
                case 6: {
                    object = ((FabricAssetsAdjuster)FabricAssetsAdjuster.this).data[n].Version;
                    break;
                }
                case 7: {
                    object = ((FabricAssetsAdjuster)FabricAssetsAdjuster.this).data[n].SerialNumber;
                    break;
                }
                case 8: {
                    ((FabricAssetsAdjuster)FabricAssetsAdjuster.this).mInt[n].value = ((FabricAssetsAdjuster)FabricAssetsAdjuster.this).data[n].ObjectID;
                    object = FabricAssetsAdjuster.this.mInt[n];
                    break;
                }
                case 9: {
                    object = ((FabricAssetsAdjuster)FabricAssetsAdjuster.this).data[n].ManagementID;
                    break;
                }
                case 10: {
                    object = ((FabricAssetsAdjuster)FabricAssetsAdjuster.this).data[n].ManagementAddress;
                    break;
                }
                case 11: {
                    object = ((FabricAssetsAdjuster)FabricAssetsAdjuster.this).data[n].Domain;
                    break;
                }
                case 12: {
                    object = ((FabricAssetsAdjuster)FabricAssetsAdjuster.this).data[n].Contact;
                    break;
                }
                case 13: {
                    object = ((FabricAssetsAdjuster)FabricAssetsAdjuster.this).data[n].WWN;
                    break;
                }
                case 14: {
                    object = ((FabricAssetsAdjuster)FabricAssetsAdjuster.this).data[n].Location;
                    break;
                }
                case 15: {
                    object = ((FabricAssetsAdjuster)FabricAssetsAdjuster.this).data[n].PhysicalSwitchWWN;
                }
            }
            return object;
        }
    }
}

