/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.model;

import java.text.CollationKey;
import java.util.Comparator;
import java.util.Vector;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.fabric.FabricGuiUtil;
import org.eclipse.aperi.gui.topo.model.GraphEntity;
import org.eclipse.aperi.gui.topo.model.GraphModelConstant;

public class GraphModelUtilities {
    public static Comparator DEFAULT_COMPARATOR = new Comparator(){

        public int compare(Object object, Object object2) {
            GraphEntity graphEntity = (GraphEntity)object;
            GraphEntity graphEntity2 = (GraphEntity)object2;
            if (graphEntity == null && graphEntity2 == null) {
                return 0;
            }
            if (graphEntity == null) {
                return 1;
            }
            if (graphEntity2 == null) {
                return -1;
            }
            Comparable comparable = graphEntity.getSortingValue();
            Comparable comparable2 = graphEntity2.getSortingValue();
            if (comparable != null && comparable2 != null) {
                return comparable.compareTo(comparable2);
            }
            if (comparable != null) {
                return -1;
            }
            if (comparable2 != null) {
                return 1;
            }
            CollationKey collationKey = graphEntity.getCollationKey();
            CollationKey collationKey2 = graphEntity2.getCollationKey();
            if (collationKey != null && collationKey2 != null) {
                return collationKey.compareTo(collationKey2);
            }
            if (collationKey != null) {
                return -1;
            }
            if (collationKey2 != null) {
                return 1;
            }
            return 0;
        }

        public boolean equals(Object object) {
            return this.equals(object);
        }
    };
    protected static Long UNIT_KB = new Long(1024L);
    protected static Long UNIT_MB = new Long(0x100000L);
    protected static Long UNIT_GB = new Long(0x40000000L);
    public static final String TOOLTIP_HEALTH_NA = String.valueOf(GuiUtil.getString("TOPO_LABEL_ATTR_COMMON_HEALTH")) + ": " + GuiUtil.getString("TOPO_LABEL_COMMON_NA");
    public static final String TOOLTIP_HEALTH_UNKNOWN = String.valueOf(GuiUtil.getString("TOPO_LABEL_ATTR_COMMON_HEALTH")) + ": " + GuiUtil.getString("TOPO_LABEL_STATUS_UNKNOWN");
    public static final String TOOLTIP_HEALTH_NORMAL = String.valueOf(GuiUtil.getString("TOPO_LABEL_ATTR_COMMON_HEALTH")) + ": " + GuiUtil.getString("TOPO_LABEL_STATUS_NORMAL");
    public static final String TOOLTIP_HEALTH_WARNING = String.valueOf(GuiUtil.getString("TOPO_LABEL_ATTR_COMMON_HEALTH")) + ": " + GuiUtil.getString("TOPO_LABEL_STATUS_WARNING");
    public static final String TOOLTIP_HEALTH_CRITICAL = String.valueOf(GuiUtil.getString("TOPO_LABEL_ATTR_COMMON_HEALTH")) + ": " + GuiUtil.getString("TOPO_LABEL_STATUS_CRITICAL");
    public static final String TOOLTIP_HEALTH_MISSING = String.valueOf(GuiUtil.getString("TOPO_LABEL_ATTR_COMMON_HEALTH")) + ": " + GuiUtil.getString("TOPO_LABEL_STATUS_MISSING");
    public static final String TOOLTIP_PERF_NA = String.valueOf(GuiUtil.getString("TOPO_LABEL_ATTR_COMMON_PERF")) + ": " + GuiUtil.getString("TOPO_LABEL_COMMON_NA");
    public static final String TOOLTIP_PERF_UNKNOWN = String.valueOf(GuiUtil.getString("TOPO_LABEL_ATTR_COMMON_PERF")) + ": " + GuiUtil.getString("TOPO_LABEL_STATUS_UNKNOWN");
    public static final String TOOLTIP_PERF_NORMAL = String.valueOf(GuiUtil.getString("TOPO_LABEL_ATTR_COMMON_PERF")) + ": " + GuiUtil.getString("TOPO_LABEL_STATUS_NORMAL");
    public static final String TOOLTIP_PERF_WARNING = String.valueOf(GuiUtil.getString("TOPO_LABEL_ATTR_COMMON_PERF")) + ": " + GuiUtil.getString("TOPO_LABEL_STATUS_WARNING");
    public static final String TOOLTIP_PERF_CRITICAL = String.valueOf(GuiUtil.getString("TOPO_LABEL_ATTR_COMMON_PERF")) + ": " + GuiUtil.getString("TOPO_LABEL_STATUS_CRITICAL");
    public static final String TOOLTIP_PERF_MISSING = String.valueOf(GuiUtil.getString("TOPO_LABEL_ATTR_COMMON_PERF")) + ": " + GuiUtil.getString("TOPO_LABEL_STATUS_MISSING");
    public static final String TOOLTIP_PIN_TRUE = GuiUtil.getString("TOPO_LABEL_ATTR_COMMON_PINNED");
    public static final String TOOLTIP_PIN_FALSE = null;

    public static boolean isAbnormal(GraphEntity graphEntity) {
        return graphEntity.getHealthStatus() != null && !graphEntity.getHealthStatus().equals(GraphModelConstant.STATUS_UNKNOWN) && !graphEntity.getHealthStatus().equals(GraphModelConstant.STATUS_NORMAL);
    }

    public static Integer aggregateStatus(Integer n, Integer n2) {
        if (n == null) {
            return n2;
        }
        if (n2 == null) {
            return n;
        }
        if (n.equals(n2)) {
            return n;
        }
        if (GraphModelConstant.STATUS_UNKNOWN.equals(n) && GraphModelConstant.STATUS_NORMAL.equals(n2) || GraphModelConstant.STATUS_UNKNOWN.equals(n2) && GraphModelConstant.STATUS_NORMAL.equals(n)) {
            return GraphModelConstant.STATUS_NORMAL;
        }
        if (GraphModelConstant.STATUS_MISSING.equals(n) && GraphModelConstant.STATUS_CRITICAL.equals(n2) || GraphModelConstant.STATUS_MISSING.equals(n2) && GraphModelConstant.STATUS_CRITICAL.equals(n)) {
            return GraphModelConstant.STATUS_CRITICAL;
        }
        return GraphModelConstant.STATUS_WARNING;
    }

    public static Integer aggregateHealthStatus(Vector vector) {
        Integer n = null;
        int n2 = 0;
        while (n2 < vector.size()) {
            GraphEntity graphEntity = (GraphEntity)vector.elementAt(n2);
            n = GraphModelUtilities.aggregateStatus(n, graphEntity.getHealthStatus());
            ++n2;
        }
        return n;
    }

    public static Integer aggregatePerfStatus(Vector vector) {
        Integer n = null;
        int n2 = 0;
        while (n2 < vector.size()) {
            GraphEntity graphEntity = (GraphEntity)vector.elementAt(n2);
            n = GraphModelUtilities.aggregateStatus(n, graphEntity.getPerfStatus());
            ++n2;
        }
        return n;
    }

    public static String getBooleanStr(Boolean bl) {
        if (bl == null) {
            return null;
        }
        if (bl.booleanValue()) {
            return GuiUtil.getString("TOPO_LABEL_COMMON_TRUE");
        }
        return GuiUtil.getString("TOPO_LABEL_COMMON_FALSE");
    }

    public static String byte2ByteString(Long l) {
        if (l == null) {
            return null;
        }
        return l.toString();
    }

    public static String byte2KBString(Long l) {
        if (l == null) {
            return null;
        }
        double d = l.doubleValue() / UNIT_KB.doubleValue();
        double d2 = 0.0;
        double d3 = 100.0;
        while (d2 == 0.0 && d != 0.0) {
            d2 = Math.rint(d * d3) / d3;
            if (!((d3 *= 10.0) > UNIT_KB.doubleValue())) continue;
            d2 = d;
            break;
        }
        return String.valueOf(d2);
    }

    public static String byte2MBString(Long l) {
        if (l == null) {
            return null;
        }
        double d = l.doubleValue() / UNIT_MB.doubleValue();
        double d2 = 0.0;
        double d3 = 100.0;
        while (d2 == 0.0 && d != 0.0) {
            d2 = Math.rint(d * d3) / d3;
            if (!((d3 *= 10.0) > UNIT_MB.doubleValue())) continue;
            d2 = d;
            break;
        }
        return String.valueOf(d2);
    }

    public static String byte2GBString(Long l) {
        if (l == null) {
            return null;
        }
        double d = l.doubleValue() / UNIT_GB.doubleValue();
        double d2 = 0.0;
        double d3 = 100.0;
        while (d2 == 0.0 && d != 0.0) {
            d2 = Math.rint(d * d3) / d3;
            if (!((d3 *= 10.0) > UNIT_GB.doubleValue())) continue;
            d2 = d;
            break;
        }
        return String.valueOf(d2);
    }

    public static String formatInteger(Integer n) {
        return n == null ? "" : n.toString();
    }

    public static String formatDouble(Double d) {
        String string = "";
        if (d != null) {
            string = String.valueOf((double)Math.round(d * 100.0) / 100.0);
        }
        return string;
    }

    public static String getSubsystemType(String string) {
        if (string == null) {
            return null;
        }
        String string2 = null;
        String string3 = "OTHER:";
        if (string.startsWith(string3)) {
            String string4 = string.substring(string3.length());
            try {
                string2 = GraphModelUtilities.getOtherType(new Integer(string4));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            string2 = string.equals("ESS") ? GuiUtil.getString("DISK_SUBSYSTEMS_TYPE_ESS") : (string.equals("DS6000") ? GuiUtil.getString("DISK_SUBSYSTEMS_TYPE_DS6000") : (string.equals("DS8000") ? GuiUtil.getString("DISK_SUBSYSTEMS_TYPE_DS8000") : (string.equals("SVC") ? GuiUtil.getString("DISK_SUBSYSTEMS_TYPE_SVC") : (string.equals("FAStT") ? GuiUtil.getString("DISK_SUBSYSTEMS_TYPE_FASTT") : (string.equals("HDS") ? GuiUtil.getString("DISK_SUBSYSTEMS_TYPE_HDS") : (string.equals("EMC") ? GuiUtil.getString("DISK_SUBSYSTEMS_TYPE_EMC") : GuiUtil.getString("DISK_SUBSYSTEMS_TYPE_OTHER")))))));
        }
        return string2;
    }

    public static String getOtherType(Integer n) {
        if (n == null) {
            return null;
        }
        String string = null;
        string = n >= 30 ? FabricGuiUtil.getPeTypeString(n) : FabricGuiUtil.getNodeTypeString(n);
        return string;
    }

    public static String getOperationalStatus(Integer n) {
        if (n == null) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        try {
            int n2 = n;
            int n3 = 19;
            int n4 = n3 - 1;
            while (n4 >= 0) {
                double d = Math.pow(2.0, n4);
                double d2 = (double)n2 / d;
                if (d2 >= 1.0) {
                    vector.addElement(String.valueOf(n4));
                    n2 = (int)((double)n2 - d);
                }
                --n4;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Vector<String> vector2 = new Vector<String>();
        for (String string : vector) {
            String string2 = null;
            if (string.equals("0")) {
                string2 = GuiUtil.getString("TOPO_LABEL_OPERATIONALSTATUS_UKNOWN");
            } else if (string.equals("1")) {
                string2 = GuiUtil.getString("TOPO_LABEL_OPERATIONALSTATUS_OTHER");
            } else if (string.equals("2")) {
                string2 = GuiUtil.getString("TOPO_LABEL_OPERATIONALSTATUS_OPERATIONAL");
            } else if (string.equals("3")) {
                string2 = GuiUtil.getString("TOPO_LABEL_OPERATIONALSTATUS_DEGRADED");
            } else if (string.equals("4")) {
                string2 = GuiUtil.getString("TOPO_LABEL_OPERATIONALSTATUS_STRESSED");
            } else if (string.equals("5")) {
                string2 = GuiUtil.getString("TOPO_LABEL_OPERATIONALSTATUS_PREDICTIVE_ERROR");
            } else if (string.equals("6")) {
                string2 = GuiUtil.getString("TOPO_LABEL_OPERATIONALSTATUS_ERROR");
            } else if (string.equals("7")) {
                string2 = GuiUtil.getString("TOPO_LABEL_OPERATIONALSTATUS_NONRECOVERABLE_ERROR");
            } else if (string.equals("8")) {
                string2 = GuiUtil.getString("TOPO_LABEL_OPERATIONALSTATUS_STARTING");
            } else if (string.equals("9")) {
                string2 = GuiUtil.getString("TOPO_LABEL_OPERATIONALSTATUS_STOPPING");
            } else if (string.equals("10")) {
                string2 = GuiUtil.getString("TOPO_LABEL_OPERATIONALSTATUS_STOPPED");
            } else if (string.equals("11")) {
                string2 = GuiUtil.getString("TOPO_LABEL_OPERATIONALSTATUS_IN_SERVICE");
            } else if (string.equals("12")) {
                string2 = GuiUtil.getString("TOPO_LABEL_OPERATIONALSTATUS_NO_CONTACT");
            } else if (string.equals("13")) {
                string2 = GuiUtil.getString("TOPO_LABEL_OPERATIONALSTATUS_LOST_COMMUNICATION");
            } else if (string.equals("14")) {
                string2 = GuiUtil.getString("TOPO_LABEL_OPERATIONALSTATUS_ABORTED");
            } else if (string.equals("15")) {
                string2 = GuiUtil.getString("TOPO_LABEL_OPERATIONALSTATUS_DORMANT");
            } else if (string.equals("16")) {
                string2 = GuiUtil.getString("TOPO_LABEL_OPERATIONALSTATUS_SUPPORTING_ENTITY_IN_ERROR");
            } else if (string.equals("17")) {
                string2 = GuiUtil.getString("TOPO_LABEL_OPERATIONALSTATUS_COMPLETED");
            } else if (string.equals("18")) {
                string2 = GuiUtil.getString("TOPO_LABEL_OPERATIONALSTATUS_POWER_MODE");
            }
            if (string2 == null) continue;
            vector2.add(string2);
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n5 = 0;
        while (n5 < vector2.size()) {
            String string = (String)vector2.elementAt(n5);
            if (n5 != 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(string);
            ++n5;
        }
        return stringBuffer.toString();
    }

    public static String getStatusAlias(Integer n) {
        String string = null;
        if (n == null || GraphModelConstant.STATUS_NA.equals(n)) {
            string = GuiUtil.getString("TOPO_LABEL_COMMON_NA");
        } else if (GraphModelConstant.STATUS_UNKNOWN.equals(n)) {
            string = GuiUtil.getString("TOPO_LABEL_STATUS_UNKNOWN");
        } else if (GraphModelConstant.STATUS_NORMAL.equals(n)) {
            string = GuiUtil.getString("TOPO_LABEL_STATUS_NORMAL");
        } else if (GraphModelConstant.STATUS_WARNING.equals(n)) {
            string = GuiUtil.getString("TOPO_LABEL_STATUS_WARNING");
        } else if (GraphModelConstant.STATUS_CRITICAL.equals(n)) {
            string = GuiUtil.getString("TOPO_LABEL_STATUS_CRITICAL");
        } else if (GraphModelConstant.STATUS_MISSING.equals(n)) {
            string = GuiUtil.getString("TOPO_LABEL_STATUS_MISSING");
        }
        return string;
    }

    public static String getTooltipHealth(Integer n) {
        String string = null;
        if (n == null || GraphModelConstant.STATUS_NA.equals(n)) {
            string = TOOLTIP_HEALTH_NA;
        } else if (GraphModelConstant.STATUS_UNKNOWN.equals(n)) {
            string = TOOLTIP_HEALTH_UNKNOWN;
        } else if (GraphModelConstant.STATUS_NORMAL.equals(n)) {
            string = TOOLTIP_HEALTH_NORMAL;
        } else if (GraphModelConstant.STATUS_WARNING.equals(n)) {
            string = TOOLTIP_HEALTH_WARNING;
        } else if (GraphModelConstant.STATUS_CRITICAL.equals(n)) {
            string = TOOLTIP_HEALTH_CRITICAL;
        } else if (GraphModelConstant.STATUS_MISSING.equals(n)) {
            string = TOOLTIP_HEALTH_MISSING;
        }
        return string;
    }

    public static String getTooltipPerf(Integer n) {
        String string = null;
        if (n == null || GraphModelConstant.STATUS_NA.equals(n)) {
            string = TOOLTIP_PERF_NA;
        } else if (GraphModelConstant.STATUS_UNKNOWN.equals(n)) {
            string = TOOLTIP_PERF_UNKNOWN;
        } else if (GraphModelConstant.STATUS_NORMAL.equals(n)) {
            string = TOOLTIP_PERF_NORMAL;
        } else if (GraphModelConstant.STATUS_WARNING.equals(n)) {
            string = TOOLTIP_PERF_WARNING;
        } else if (GraphModelConstant.STATUS_CRITICAL.equals(n)) {
            string = TOOLTIP_PERF_CRITICAL;
        } else if (GraphModelConstant.STATUS_MISSING.equals(n)) {
            string = TOOLTIP_PERF_MISSING;
        }
        return string;
    }

    public static String getTooltipPin(boolean bl) {
        return bl ? TOOLTIP_PIN_TRUE : TOOLTIP_PIN_FALSE;
    }

    public static String getViewAlias(String string) {
        String string2 = null;
        if (string != null) {
            if ("Overview".equals(string)) {
                string2 = GuiUtil.getString("TOPO_LABEL_VIEW_OVERVIEW");
            } else if ("FabricL0".equals(string)) {
                string2 = GuiUtil.getString("TOPO_LABEL_VIEW_L0FABRIC");
            } else if ("FabricL1".equals(string)) {
                string2 = GuiUtil.getString("TOPO_LABEL_VIEW_L1FABRIC");
            } else if ("FabricL2".equals(string)) {
                string2 = GuiUtil.getString("TOPO_LABEL_VIEW_L2FABRIC");
            } else if ("ComputerL0".equals(string)) {
                string2 = GuiUtil.getString("TOPO_LABEL_VIEW_L0COMPUTER");
            } else if ("ComputerL1".equals(string)) {
                string2 = GuiUtil.getString("TOPO_LABEL_VIEW_L1COMPUTER");
            } else if ("ComputerL2".equals(string)) {
                string2 = GuiUtil.getString("TOPO_LABEL_VIEW_L2COMPUTER");
            } else if ("SwitchL0".equals(string)) {
                string2 = GuiUtil.getString("TOPO_LABEL_VIEW_L0SWITCH");
            } else if ("SwitchL1".equals(string)) {
                string2 = GuiUtil.getString("TOPO_LABEL_VIEW_L1SWITCH");
            } else if ("SwitchL2".equals(string)) {
                string2 = GuiUtil.getString("TOPO_LABEL_VIEW_L2SWITCH");
            } else if ("StorageL0".equals(string)) {
                string2 = GuiUtil.getString("TOPO_LABEL_VIEW_L0STORAGE");
            } else if ("SubsystemL1".equals(string)) {
                string2 = GuiUtil.getString("TOPO_LABEL_VIEW_L1SUBSYSTEM");
            } else if ("SubsystemL2".equals(string)) {
                string2 = GuiUtil.getString("TOPO_LABEL_VIEW_L2SUBSYSTEM");
            } else if ("TapeLibraryL1".equals(string)) {
                string2 = GuiUtil.getString("TOPO_LABEL_VIEW_L1TAPELIBRARY");
            } else if ("TapeLibraryL2".equals(string)) {
                string2 = GuiUtil.getString("TOPO_LABEL_VIEW_L2TAPELIBRARY");
            } else if ("OtherL0".equals(string)) {
                string2 = GuiUtil.getString("TOPO_LABEL_VIEW_L0OTHER");
            } else if ("OtherL1".equals(string)) {
                string2 = GuiUtil.getString("TOPO_LABEL_VIEW_L1OTHER");
            } else if ("OtherL2".equals(string)) {
                string2 = GuiUtil.getString("TOPO_LABEL_VIEW_L2OTHER");
            }
        }
        return string2;
    }
}

