/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.tool;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import java.util.Vector;

public class BeanGenerator {
    private static final String PREFIX = "Graph";

    public static void main(String[] stringArray) {
        try {
            String string = "com/ibm/tpc/gui/topo/tool/GraphModel.txt";
            Vector vector = BeanGenerator.parse(string);
            String string2 = "com/ibm/tpc/gui/topo/model/bean";
            BeanGenerator.generateModel(string2, vector);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void generateModel(String string, Vector vector) throws Exception {
        new File(string);
        int n = 0;
        while (n < vector.size()) {
            String string2;
            String string3;
            String string4;
            String string5;
            Object object;
            Object object2;
            ClassDef classDef = (ClassDef)vector.elementAt(n);
            Vector vector2 = classDef.getProperties();
            Vector vector3 = classDef.getConstants();
            String string6 = classDef.getClassName();
            String string7 = classDef.getParentClassName();
            boolean bl = classDef.isAssociation;
            File file = new File(string, String.valueOf(string6) + ".java");
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(file)));
            String string8 = "/****************************************** {COPYRIGHT-TOP} **\r\n* Aperi Storage Manager\r\n* (C) Copyright IBM Corp. 2005, 2006\r\n* All rights reserved. This program and the accompanying materials\r\n* are made available under the terms of the Eclipse Public License v1.0\r\n* which accompanies this distribution, and is available at\r\n* http://www.eclipse.org/legal/epl-v10.html\r\n******************************************* {COPYRIGHT-END} **/\r\n";
            printWriter.println(string8);
            String string9 = string.replace('/', '.');
            printWriter.println("package " + string9 + ";");
            printWriter.println();
            String string10 = string9.substring(0, string9.lastIndexOf(46));
            printWriter.println("import " + string10 + ".GraphEntity;");
            if (bl) {
                printWriter.println("import " + string10 + ".GraphAssociation;");
            }
            int n2 = 0;
            while (n2 < vector2.size()) {
                object2 = (Property)vector2.elementAt(n2);
                object = ((Property)object2).getType();
                if (((String)object).equals("Vector")) {
                    printWriter.println("import java.util.Vector;");
                    break;
                }
                ++n2;
            }
            printWriter.println();
            if (string6.equals("GraphAssociation")) {
                printWriter.println("public class " + string6 + " extends " + string7 + " implements IGraphAssociativeEntity {");
            } else {
                printWriter.println("public class " + string6 + " extends " + string7 + " {");
            }
            printWriter.println("\tpublic static final GraphEntity.Type TYPE = new Type(\"" + string6 + "\", " + (bl ? "true" : "false") + ");");
            printWriter.println();
            n2 = 0;
            while (n2 < vector3.size()) {
                object2 = (Constant)vector3.elementAt(n2);
                object = ((Constant)object2).getType();
                string5 = ((Constant)object2).getName();
                string4 = ((Constant)object2).getValue();
                printWriter.println("\tpublic static final " + (String)object + " " + string5 + " = new " + (String)object + "(" + string4 + ");");
                ++n2;
            }
            printWriter.println();
            n2 = 0;
            int n3 = 0;
            while (n3 < vector2.size()) {
                object = (Property)vector2.elementAt(n3);
                boolean bl2 = ((Property)object).isParentVariableReused();
                if (!bl2) {
                    string4 = ((Property)object).getType();
                    string3 = ((Property)object).getVariable();
                    printWriter.println("\tprotected " + string4 + " " + string3 + ";");
                }
                ++n2;
                ++n3;
            }
            printWriter.println();
            printWriter.println("\tpublic " + string6 + "() {");
            printWriter.println("\t\tthis((String)null);");
            printWriter.println("\t}");
            printWriter.println();
            printWriter.println("\tpublic " + string6 + "(String id) {");
            printWriter.println("\t\tthis(new ID(id));");
            printWriter.println("\t}");
            printWriter.println();
            printWriter.println("\tpublic " + string6 + "(GraphEntity.ID entityID) {");
            printWriter.println("\t\tsuper(entityID);");
            printWriter.println("\t}");
            printWriter.println();
            printWriter.println("\tprotected void toString_helper(StringBuffer sb) {");
            printWriter.println("\t\tsuper.toString_helper(sb);");
            n3 = 0;
            while (n3 < vector2.size()) {
                object = (Property)vector2.elementAt(n3);
                string5 = ((Property)object).getType();
                string4 = ((Property)object).getName();
                boolean bl3 = ((Property)object).isParentVariableReused();
                string2 = ((Property)object).getVariable();
                if (bl3) {
                    printWriter.println("\t\tsb.append(\"" + string4 + "=\"+(" + string5 + ")" + string2 + "+\",\");");
                } else {
                    printWriter.println("\t\tsb.append(\"" + string4 + "=\"+" + string2 + "+\",\");");
                }
                ++n3;
            }
            printWriter.println("\t}");
            printWriter.println();
            printWriter.println("\tpublic Object clone() {");
            printWriter.println("\t\t" + string6 + " o = new " + string6 + "((" + string6 + ".ID)entityID.clone());");
            printWriter.println("\t\tclone_helper(o);");
            printWriter.println("\t\treturn o;");
            printWriter.println("\t}");
            printWriter.println();
            printWriter.println("\tprotected void clone_helper(GraphEntity entity) {");
            printWriter.println("\t\tsuper.clone_helper(entity);");
            printWriter.println("\t\t" + string6 + " o = (" + string6 + ")entity;");
            n3 = 0;
            while (n3 < vector2.size()) {
                object = (Property)vector2.elementAt(n3);
                string5 = ((Property)object).getName();
                boolean bl4 = ((Property)object).isParentVariableReused();
                string3 = ((Property)object).getVariable();
                if (bl4) {
                    printWriter.println("\t\to.set" + string5 + "(get" + string5 + "());");
                } else {
                    printWriter.println("\t\to.set" + string5 + "(" + string3 + ");");
                }
                ++n3;
            }
            printWriter.println("\t}");
            printWriter.println();
            n3 = 0;
            while (n3 < vector2.size()) {
                object = (Property)vector2.elementAt(n3);
                string5 = ((Property)object).getType();
                String string11 = ((Property)object).getName();
                boolean bl5 = ((Property)object).isParentVariableReused();
                string2 = ((Property)object).getVariable();
                printWriter.println("\tpublic " + string5 + " get" + string11 + "() {");
                if (bl5) {
                    printWriter.println("\t\treturn (" + string5 + ")" + string2 + ";");
                } else {
                    printWriter.println("\t\treturn " + string2 + ";");
                }
                printWriter.println("\t}");
                printWriter.println();
                printWriter.println("\tpublic void set" + string11 + "(" + string5 + " value) {");
                printWriter.println("\t\tthis." + string2 + " = value;");
                printWriter.println("\t}");
                printWriter.println();
                if (bl) {
                    String string12 = string5.substring(0, string5.length() - 3);
                    printWriter.println("\tpublic void set" + string11 + "(" + string12 + " value) {");
                    printWriter.println("\t\tthis." + string2 + " = value.getEntityID();");
                    printWriter.println("\t}");
                    printWriter.println();
                }
                ++n3;
            }
            printWriter.println("\tpublic static class ID extends " + string7 + ".ID {");
            printWriter.println("\t\tpublic ID() {");
            printWriter.println("\t\t\tthis(null);");
            printWriter.println("\t\t}");
            printWriter.println();
            printWriter.println("\t\tpublic ID(String id) {");
            printWriter.println("\t\t\tthis(TYPE, id);");
            printWriter.println("\t\t}");
            printWriter.println();
            printWriter.println("\t\tprotected ID(GraphEntity.Type entityType, String id) {");
            printWriter.println("\t\t\tsuper(entityType, id);");
            printWriter.println("\t\t}");
            printWriter.println();
            printWriter.println("\t\tpublic Object clone() {");
            printWriter.println("\t\t\treturn new ID((String)id);");
            printWriter.println("\t\t}");
            printWriter.println("\t}");
            printWriter.println();
            printWriter.println("}");
            printWriter.flush();
            printWriter.close();
            System.out.println("generate " + string6);
            ++n;
        }
    }

    private static Vector parse(String string) throws Exception {
        String string2;
        Vector<ClassDef> vector = new Vector<ClassDef>();
        File file = new File(string);
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        ClassDef classDef = null;
        while ((string2 = bufferedReader.readLine()) != null) {
            Object object;
            String string3;
            String string4;
            StringTokenizer stringTokenizer;
            System.out.println("aLine=" + string2);
            string2 = string2.trim();
            if (string2.startsWith("//") || string2.equals("")) continue;
            if (string2.startsWith("class")) {
                if (classDef != null) {
                    vector.add(classDef);
                }
                stringTokenizer = new StringTokenizer(string2, " \t\r\n");
                stringTokenizer.nextToken();
                String string5 = stringTokenizer.nextToken();
                string4 = null;
                stringTokenizer.nextToken();
                string4 = stringTokenizer.nextToken();
                boolean bl = false;
                if (stringTokenizer.hasMoreTokens() && (string3 = stringTokenizer.nextToken()).equalsIgnoreCase("[assocication]")) {
                    bl = true;
                }
                classDef = new ClassDef(string5, string4, bl);
                continue;
            }
            stringTokenizer = new StringTokenizer(string2, " \t\r\n");
            boolean bl = false;
            string4 = stringTokenizer.nextToken();
            if (string4.equalsIgnoreCase("constant")) {
                string4 = stringTokenizer.nextToken();
                String string6 = stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                string3 = stringTokenizer.nextToken();
                object = new Constant(string4, string6, string3);
                classDef.addConstant((Constant)object);
                continue;
            }
            if (string4.equalsIgnoreCase("ref")) {
                bl = true;
                string4 = stringTokenizer.nextToken();
            } else {
                string4.equalsIgnoreCase("constant");
            }
            String string7 = stringTokenizer.nextToken();
            string3 = null;
            if (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken();
            }
            object = new Property(string4, bl, string7, string3);
            classDef.addProperty((Property)object);
        }
        if (classDef != null) {
            vector.add(classDef);
        }
        bufferedReader.close();
        return vector;
    }

    private static class ClassDef {
        private String className;
        private String parentClassName;
        private boolean isAssociation;
        private Vector propertyV;
        private Vector constantV;

        public ClassDef(String string, String string2, boolean bl) {
            this.className = BeanGenerator.PREFIX + string;
            this.parentClassName = BeanGenerator.PREFIX + string2;
            this.isAssociation = bl;
            this.propertyV = new Vector();
            this.constantV = new Vector();
        }

        public String toString() {
            return String.valueOf(this.className) + "(parentClassName=" + this.parentClassName + ", propertyV=" + this.propertyV + ", constantV=" + this.constantV + ")";
        }

        public String getClassName() {
            return this.className;
        }

        public void setClassName(String string) {
            this.className = string;
        }

        public String getParentClassName() {
            return this.parentClassName;
        }

        public void setParentClassName(String string) {
            this.parentClassName = string;
        }

        public boolean isAssociation() {
            return this.isAssociation;
        }

        public void setAssociation(boolean bl) {
            this.isAssociation = bl;
        }

        public void addProperty(Property property) {
            this.propertyV.add(property);
        }

        public Vector getProperties() {
            return this.propertyV;
        }

        public void addConstant(Constant constant) {
            this.constantV.add(constant);
        }

        public Vector getConstants() {
            return this.constantV;
        }
    }

    private static class Constant {
        private String type;
        private String name;
        private String value;

        public Constant(String string, String string2, String string3) {
            this.type = string;
            this.name = string2;
            this.value = string3;
        }

        public String toString() {
            return "(" + this.type + "," + this.name + "," + this.value + ")";
        }

        public String getType() {
            return this.type;
        }

        public void setType(String string) {
            this.type = string;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String string) {
            this.value = string;
        }
    }

    private static class Property {
        private String type;
        private boolean isRef;
        private String name;
        private String variable;
        private boolean isParentVariableReused;

        public Property(String string, boolean bl, String string2, String string3) {
            this.type = bl ? BeanGenerator.PREFIX + string : string;
            this.isRef = bl;
            this.name = string2;
            this.isParentVariableReused = string3 != null;
            this.variable = this.isParentVariableReused ? string3 : string2;
        }

        public String toString() {
            return "(" + this.type + "," + this.isRef + "," + this.name + "," + this.variable + ")";
        }

        public String getType() {
            return this.type;
        }

        public void setType(String string) {
            this.type = string;
        }

        public boolean isRef() {
            return this.isRef;
        }

        public void setRef(boolean bl) {
            this.isRef = bl;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public String getVariable() {
            return this.variable;
        }

        public void setVariable(String string) {
            this.variable = string;
        }

        public boolean isParentVariableReused() {
            return this.isParentVariableReused;
        }

        public void setParentVaribleReused(boolean bl) {
            this.isParentVariableReused = bl;
        }
    }
}

