/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.widget;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.border.CompoundBorder;
import org.eclipse.aperi.gui.topo.model.GraphEntity;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoCanvas;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoContainer;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoEntity;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoGroup;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoGroupTitle;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoPin;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoPinContainer;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoSummary;
import org.eclipse.aperi.gui.topo.widget.ITopoEntityModel;
import org.eclipse.aperi.gui.topo.widget.ITopoGroupModel;
import org.eclipse.aperi.gui.topo.widget.ITopoNodeModel;
import org.eclipse.aperi.gui.topo.widget.ITopoPinContainerWidget;
import org.eclipse.aperi.gui.topo.widget.ITopoUnitModel;
import org.eclipse.aperi.gui.topo.widget.TopoEventSource;
import org.eclipse.aperi.gui.topo.widget.TopoResource;

public abstract class AbstractJTopoBox
extends AbstractJTopoGroup
implements ITopoPinContainerWidget {
    protected JLabel labelMinusPlus;
    protected TitlePanel titlePanel;
    protected SummaryPanel summaryPanel;
    protected PinPanel pinPanel;
    protected ContainerPanel containerPanel;
    protected ML_MinusPlus ml_minusPlus;

    protected AbstractJTopoBox() {
        this((ITopoGroupModel)null, true);
    }

    protected AbstractJTopoBox(ITopoGroupModel iTopoGroupModel, boolean bl) {
        super(iTopoGroupModel, bl);
        iTopoGroupModel = (ITopoGroupModel)this.widgetModel;
        this.labelMinusPlus = new JLabel();
        this.add((Component)this.labelMinusPlus, 0);
        this.ml_minusPlus = new ML_MinusPlus();
        this.labelMinusPlus.addMouseListener(this.ml_minusPlus);
        this.labelMinusPlus.addMouseListener(this.mlDrag);
        this.labelMinusPlus.addMouseMotionListener(this.mlDrag);
        this.titlePanel = new TitlePanel(iTopoGroupModel);
        this.summaryPanel = new SummaryPanel(iTopoGroupModel);
        this.pinPanel = new PinPanel(iTopoGroupModel);
        this.containerPanel = this.createContainerPanel(iTopoGroupModel);
        this.initState();
    }

    private void initState() {
        this.setExpansible(false);
        this.titlePanel.setLogicalParent(this);
        this.summaryPanel.setLogicalParent(this);
        this.pinPanel.setLogicalParent(this);
        this.containerPanel.setLogicalParent(this);
        this.add(this.titlePanel);
        this.add(this.summaryPanel);
        this.add(this.pinPanel);
        this.add(this.containerPanel);
    }

    public void resetState() {
        super.resetState();
        this.titlePanel.resetState();
        this.summaryPanel.resetState();
        this.pinPanel.resetState();
        this.containerPanel.resetState();
        this.initState();
    }

    public void setSessionModel(AbstractJTopoCanvas abstractJTopoCanvas, String string) {
        super.setSessionModel(abstractJTopoCanvas, string);
        this.titlePanel.setSessionModel(abstractJTopoCanvas, string);
        this.summaryPanel.setSessionModel(abstractJTopoCanvas, string);
        this.pinPanel.setSessionModel(abstractJTopoCanvas, string);
        this.containerPanel.setSessionModel(abstractJTopoCanvas, string);
    }

    public void setDataModel(GraphEntity graphEntity) {
        super.setDataModel(graphEntity);
        this.titlePanel.setDataModel(graphEntity);
        this.summaryPanel.setDataModel(graphEntity);
        this.containerPanel.setDataModel(graphEntity);
    }

    public TitlePanel getTitlePanel() {
        return this.titlePanel;
    }

    public SummaryPanel getSummaryPanel() {
        return this.summaryPanel;
    }

    public PinPanel getPinPanel() {
        return this.pinPanel;
    }

    public ContainerPanel getContainerPanel() {
        return this.containerPanel;
    }

    public void modelChanged() {
        this.modelChanged_setHighlight();
        this.titlePanel.modelChanged();
        this.summaryPanel.modelChanged();
        this.pinPanel.modelChanged();
        this.containerPanel.modelChanged();
    }

    public void selectionChanged() {
        this.titlePanel.selectionChanged();
        this.summaryPanel.selectionChanged();
        this.pinPanel.selectionChanged();
        this.containerPanel.selectionChanged();
        this.revalidate();
        this.repaint();
    }

    public void highlightChanged() {
        this.modelChanged_setHighlight();
        this.titlePanel.highlightChanged();
        this.summaryPanel.highlightChanged();
        this.pinPanel.highlightChanged();
        this.containerPanel.highlightChanged();
    }

    public void pinChanged() {
        this.titlePanel.pinChanged();
        this.summaryPanel.pinChanged();
        this.pinPanel.pinChanged();
        this.containerPanel.pinChanged();
    }

    protected void modelChanged_setHighlight() {
        ITopoEntityModel iTopoEntityModel = (ITopoEntityModel)this.widgetModel;
        CompoundBorder compoundBorder = null;
        compoundBorder = iTopoEntityModel.isHighlighted() ? TopoResource.BORDER_CONTAINERHIGHLIGHTED : TopoResource.BORDER_CONTAINERUNHIGHLIGHTED;
        this.setBorder(compoundBorder);
    }

    public void setExpansible(boolean bl) {
        super.setExpansible(bl);
        if (this.isExpansible) {
            this.setExpanded(this.isExpanded);
        } else {
            this.labelMinusPlus.setVisible(false);
            this.titlePanel.setIconRecursiveEnabled(false);
            this.titlePanel.setStrCounterEnabled(false);
            this.summaryPanel.setVisible(true);
            this.pinPanel.setVisible(true);
            this.containerPanel.setVisible(false);
            this.revalidate();
            this.repaint();
        }
    }

    public void setExpanded(boolean bl) {
        super.setExpanded(bl);
        if (this.isExpanded) {
            this.labelMinusPlus.setIcon(TopoResource.ICON_BOX_MINUS);
            this.labelMinusPlus.setVisible(true);
            this.titlePanel.setIconRecursiveEnabled(true);
            this.titlePanel.setStrCounterEnabled(true);
            this.summaryPanel.setVisible(false);
            this.pinPanel.setVisible(false);
            this.containerPanel.setVisible(true);
        } else {
            this.labelMinusPlus.setIcon(TopoResource.ICON_BOX_PLUS);
            this.labelMinusPlus.setVisible(true);
            this.titlePanel.setIconRecursiveEnabled(true);
            this.titlePanel.setStrCounterEnabled(false);
            this.summaryPanel.setVisible(true);
            this.pinPanel.setVisible(true);
            this.containerPanel.setVisible(false);
        }
        this.revalidate();
        this.repaint();
    }

    protected Point getConnectingPoint() {
        Point point = this.titlePanel.getConnectingPoint();
        Point point2 = new Point(this.getX() + point.x, this.getY() + point.y);
        return point2;
    }

    public Vector getLogicalChilds() {
        return this.containerPanel.getEntities();
    }

    public boolean isContainLogicalChild(AbstractJTopoEntity abstractJTopoEntity) {
        return this.containerPanel.isContainEntity(abstractJTopoEntity);
    }

    public void addLogicalChild(AbstractJTopoEntity abstractJTopoEntity) {
        AbstractJTopoBox abstractJTopoBox = (AbstractJTopoBox)abstractJTopoEntity.getLogicalParent();
        if (abstractJTopoBox != null) {
            abstractJTopoBox.removeLogicalChild(abstractJTopoEntity);
        }
        abstractJTopoEntity.setLogicalParent(this);
        this.containerPanel.addEntity(abstractJTopoEntity);
        this.setExpansible(this.isContainNonfilterable());
    }

    public void removeLogicalChild(AbstractJTopoEntity abstractJTopoEntity) {
        if (abstractJTopoEntity.getLogicalParent() == this) {
            abstractJTopoEntity.setLogicalParent(null);
        }
        this.containerPanel.removeEntity(abstractJTopoEntity);
        this.setExpansible(this.isContainNonfilterable());
    }

    public void removeAllLogicalChilds() {
        Vector vector = this.containerPanel.getEntities();
        int n = 0;
        while (n < vector.size()) {
            AbstractJTopoEntity abstractJTopoEntity = (AbstractJTopoEntity)vector.elementAt(n);
            if (abstractJTopoEntity.getLogicalParent() == this) {
                abstractJTopoEntity.setLogicalParent(null);
            }
            ++n;
        }
        this.containerPanel.removeAllEntities();
        this.setExpansible(false);
    }

    public Vector getPinWidgets() {
        return this.pinPanel.getEntities();
    }

    public AbstractJTopoPin getPinWidget(GraphEntity.ID iD) {
        AbstractJTopoPin abstractJTopoPin = null;
        Vector vector = this.pinPanel.getEntities();
        int n = 0;
        while (n < vector.size()) {
            AbstractJTopoPin abstractJTopoPin2 = (AbstractJTopoPin)vector.elementAt(n);
            GraphEntity.ID iD2 = abstractJTopoPin2.getFocusEntityID();
            if (iD2.equals(iD)) {
                abstractJTopoPin = abstractJTopoPin2;
                break;
            }
            ++n;
        }
        return abstractJTopoPin;
    }

    public void addPinWidget(AbstractJTopoPin abstractJTopoPin) {
        GraphEntity.ID iD = abstractJTopoPin.getFocusEntityID();
        AbstractJTopoPin abstractJTopoPin2 = this.getPinWidget(iD);
        if (abstractJTopoPin2 == null) {
            this.pinPanel.addEntity(abstractJTopoPin);
        }
    }

    public void removePinWidget(AbstractJTopoPin abstractJTopoPin) {
        GraphEntity.ID iD = abstractJTopoPin.getFocusEntityID();
        AbstractJTopoPin abstractJTopoPin2 = this.getPinWidget(iD);
        if (abstractJTopoPin2 != null) {
            this.pinPanel.removeEntity(abstractJTopoPin);
        }
    }

    public void updatePinPanel() {
        this.pinPanel.setArrange(null);
        this.pinPanel.updateContainer();
    }

    public void setOverlayHealthEnabled(boolean bl) {
        this.titlePanel.setOverlayHealthEnabled(bl);
        this.summaryPanel.setOverlayHealthEnabled(bl);
        this.pinPanel.setOverlayHealthEnabled(bl);
        this.containerPanel.setOverlayHealthEnabled(bl);
    }

    public void setOverlayPerfEnabled(boolean bl) {
        this.titlePanel.setOverlayPerfEnabled(bl);
        this.summaryPanel.setOverlayPerfEnabled(bl);
        this.pinPanel.setOverlayPerfEnabled(bl);
        this.containerPanel.setOverlayPerfEnabled(bl);
    }

    public void setArrange(AbstractJTopoCanvas.ArrangeRecord arrangeRecord) {
        this.titlePanel.setArrange(arrangeRecord);
        this.summaryPanel.setArrange(arrangeRecord);
        this.pinPanel.setArrange(arrangeRecord);
        this.containerPanel.setArrange(arrangeRecord);
    }

    protected void handleMinusPlusMouseClick(MouseEvent mouseEvent) {
        if (!mouseEvent.isMetaDown()) {
            if (!this.isExpanded && mouseEvent.isAltDown()) {
                Hashtable hashtable = this.canvas.getWidgetTable(this);
                Enumeration enumeration = hashtable.elements();
                while (enumeration.hasMoreElements()) {
                    AbstractJTopoGroup abstractJTopoGroup = (AbstractJTopoGroup)enumeration.nextElement();
                    if (abstractJTopoGroup.equals(this) || !abstractJTopoGroup.isExpanded()) continue;
                    abstractJTopoGroup.setExpanded(false);
                    abstractJTopoGroup.revalidate();
                    abstractJTopoGroup.repaint();
                }
            }
            this.setExpanded(!this.isExpanded);
        } else {
            this.handleMouseClick(mouseEvent);
        }
    }

    protected ContainerPanel createContainerPanel(ITopoGroupModel iTopoGroupModel) {
        return new ContainerPanel(iTopoGroupModel);
    }

    protected LayoutManager createDefaultLayout() {
        return new DefaultLayout();
    }

    protected class ContainerPanel
    extends AbstractJTopoContainer {
        public ContainerPanel(ITopoUnitModel iTopoUnitModel) {
            super(iTopoUnitModel, false);
        }

        protected void reattach() {
        }
    }

    protected class DefaultLayout
    implements LayoutManager {
        private int spacingForMinusPlus = 10;

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            Dimension dimension = new Dimension(0, 0);
            Insets insets = container.getInsets();
            dimension.width += insets.left + insets.right;
            dimension.height += insets.top + insets.bottom;
            int n = 0;
            int n2 = 0;
            Dimension dimension2 = AbstractJTopoBox.this.titlePanel.getPreferredSize();
            n += dimension2.width;
            if (AbstractJTopoBox.this.labelMinusPlus.isVisible()) {
                n += this.spacingForMinusPlus;
            }
            n2 += dimension2.height;
            if (AbstractJTopoBox.this.summaryPanel.isVisible()) {
                dimension2 = AbstractJTopoBox.this.summaryPanel.getPreferredSize();
                n = dimension2.width > n ? dimension2.width : n;
                n2 += dimension2.height;
            }
            if (AbstractJTopoBox.this.pinPanel.isVisible()) {
                dimension2 = AbstractJTopoBox.this.pinPanel.getPreferredSize();
                n = dimension2.width > n ? dimension2.width : n;
                n2 += dimension2.height;
            }
            if (AbstractJTopoBox.this.containerPanel.isVisible()) {
                dimension2 = AbstractJTopoBox.this.containerPanel.getPreferredSize();
                n = dimension2.width > n ? dimension2.width : n;
                n2 += dimension2.height;
            }
            dimension.width += n;
            dimension.height += n2;
            return dimension;
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        public void layoutContainer(Container container) {
            Insets insets = container.getInsets();
            int n = insets.left;
            int n2 = insets.top;
            Dimension dimension = AbstractJTopoBox.this.titlePanel.getPreferredSize();
            Rectangle rectangle = new Rectangle();
            rectangle.x = n;
            rectangle.y = n2;
            rectangle.width = container.getWidth() - insets.left - insets.right;
            rectangle.height = dimension.height;
            AbstractJTopoBox.this.titlePanel.setBounds(rectangle);
            n2 += AbstractJTopoBox.this.titlePanel.getHeight();
            if (AbstractJTopoBox.this.labelMinusPlus.isVisible()) {
                dimension = AbstractJTopoBox.this.labelMinusPlus.getPreferredSize();
                rectangle = new Rectangle();
                rectangle.x = container.getWidth() - insets.right - dimension.width / 2 - 1;
                rectangle.y = insets.top - dimension.height / 2;
                rectangle.width = dimension.width;
                rectangle.height = dimension.height;
                AbstractJTopoBox.this.labelMinusPlus.setBounds(rectangle);
            } else {
                AbstractJTopoBox.this.labelMinusPlus.setBounds(0, 0, 0, 0);
            }
            if (AbstractJTopoBox.this.summaryPanel.isVisible()) {
                dimension = AbstractJTopoBox.this.summaryPanel.getPreferredSize();
                rectangle = new Rectangle();
                rectangle.x = n;
                rectangle.y = n2;
                rectangle.width = AbstractJTopoBox.this.titlePanel.getWidth();
                rectangle.height = dimension.height;
                AbstractJTopoBox.this.summaryPanel.setBounds(rectangle);
                n2 += AbstractJTopoBox.this.summaryPanel.getHeight();
            } else {
                AbstractJTopoBox.this.summaryPanel.setBounds(0, 0, 0, 0);
            }
            if (AbstractJTopoBox.this.pinPanel.isVisible()) {
                dimension = AbstractJTopoBox.this.pinPanel.getPreferredSize();
                rectangle = new Rectangle();
                rectangle.x = n;
                rectangle.y = n2;
                rectangle.width = AbstractJTopoBox.this.titlePanel.getWidth();
                rectangle.height = dimension.height;
                AbstractJTopoBox.this.pinPanel.setBounds(rectangle);
                n2 += AbstractJTopoBox.this.pinPanel.getHeight();
            } else {
                AbstractJTopoBox.this.pinPanel.setBounds(0, 0, 0, 0);
            }
            if (AbstractJTopoBox.this.containerPanel.isVisible()) {
                dimension = AbstractJTopoBox.this.containerPanel.getPreferredSize();
                rectangle = new Rectangle();
                rectangle.x = n;
                rectangle.y = n2;
                rectangle.width = AbstractJTopoBox.this.titlePanel.getWidth();
                rectangle.height = dimension.height;
                AbstractJTopoBox.this.containerPanel.setBounds(rectangle);
            } else {
                AbstractJTopoBox.this.containerPanel.setBounds(0, 0, 0, 0);
            }
        }
    }

    protected class ML_MinusPlus
    extends MouseAdapter {
        protected ML_MinusPlus() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            mouseEvent.setSource(new TopoEventSource(mouseEvent));
            AbstractJTopoBox.this.handleMinusPlusMouseClick(mouseEvent);
        }
    }

    protected class PinPanel
    extends AbstractJTopoPinContainer {
        public PinPanel(ITopoUnitModel iTopoUnitModel) {
            super(iTopoUnitModel, false);
        }

        protected void reattach() {
        }
    }

    protected class SummaryPanel
    extends AbstractJTopoSummary {
        public SummaryPanel(ITopoGroupModel iTopoGroupModel) {
            super(iTopoGroupModel, false);
        }

        protected void reattach() {
        }
    }

    protected class TitlePanel
    extends AbstractJTopoGroupTitle {
        public TitlePanel(ITopoNodeModel iTopoNodeModel) {
            super(iTopoNodeModel, false);
        }

        protected void reattach() {
        }
    }
}

