/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.widget;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.border.LineBorder;
import org.eclipse.aperi.gui.topo.model.GraphModelConstant;
import org.eclipse.aperi.gui.topo.model.GraphModelUtilities;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoCanvas;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoNode;
import org.eclipse.aperi.gui.topo.widget.ITopoEntityModel;
import org.eclipse.aperi.gui.topo.widget.ITopoNodeModel;
import org.eclipse.aperi.gui.topo.widget.TopoResource;

public abstract class AbstractJTopoIcon
extends AbstractJTopoNode {
    public static final int LABELMODE_COMPACT = 0;
    public static final int LABELMODE_RELAX = 1;
    public static final int LABELMODE_FULL = 2;
    protected static final int GAP3 = 3;
    protected int maxLabelWidth_compact = 60;
    protected int maxLabelWidth_relax = 180;
    protected String strLabel;
    protected String tooltipLabel;
    protected String tooltipHealth;
    protected String tooltipPerf;
    protected String tooltipPin;
    protected ImageIcon iconType;
    protected ImageIcon iconHealth;
    protected ImageIcon iconPerf;
    protected ImageIcon iconPin;
    protected boolean isOverlayHealthEnabled;
    protected boolean isOverlayPerfEnabled;
    protected int labelMode;
    protected String clippedStrLabel;
    protected Point strLabelP = new Point();
    protected Rectangle strLabelR = new Rectangle();
    protected Rectangle iconTypeR = new Rectangle();
    protected Rectangle iconHealthR = new Rectangle();
    protected Rectangle iconPerfR = new Rectangle();
    protected Rectangle iconPinR = new Rectangle();
    protected Dimension preferredSizeD = new Dimension();

    protected AbstractJTopoIcon() {
        this((ITopoNodeModel)null, true);
    }

    protected AbstractJTopoIcon(ITopoNodeModel iTopoNodeModel, boolean bl) {
        super(iTopoNodeModel, bl);
        this.setToolTipText("");
        this.initState();
    }

    private void initState() {
        this.strLabel = null;
        this.tooltipLabel = null;
        this.tooltipHealth = null;
        this.tooltipPerf = null;
        this.tooltipPin = null;
        this.iconType = null;
        this.iconHealth = null;
        this.iconPerf = null;
        this.iconPin = null;
        this.labelMode = 0;
        this.clippedStrLabel = null;
        this.strLabelP.setLocation(0, 0);
        this.strLabelR.setBounds(0, 0, 0, 0);
        this.iconTypeR.setBounds(0, 0, 0, 0);
        this.iconHealthR.setBounds(0, 0, 0, 0);
        this.iconPerfR.setBounds(0, 0, 0, 0);
        this.iconPinR.setBounds(0, 0, 0, 0);
        this.preferredSizeD.setSize(0, 0);
    }

    public void resetState() {
        super.resetState();
        this.initState();
    }

    public void modelChanged() {
        this.modelChanged_setLabel();
        this.modelChanged_setTooltip();
        this.modelChanged_setHealth();
        this.modelChanged_setPerf();
        this.modelChanged_setPin();
        this.modelChanged_setSelection();
        this.modelChanged_setHighlight();
        this.revalidate();
        this.repaint();
    }

    public void selectionChanged() {
        this.modelChanged_setSelection();
        this.repaint();
    }

    public void highlightChanged() {
        this.modelChanged_setHighlight();
        this.repaint();
    }

    public void pinChanged() {
        this.modelChanged_setPin();
        this.revalidate();
        this.repaint();
    }

    protected void modelChanged_setLabel() {
        ITopoEntityModel iTopoEntityModel = (ITopoEntityModel)this.widgetModel;
        this.strLabel = iTopoEntityModel.getLabel();
    }

    protected void modelChanged_setTooltip() {
        ITopoEntityModel iTopoEntityModel = (ITopoEntityModel)this.widgetModel;
        String string = iTopoEntityModel.getLabel();
        String string2 = iTopoEntityModel.getType();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string2);
        stringBuffer.append(": ");
        stringBuffer.append(string);
        this.tooltipLabel = stringBuffer.toString();
    }

    protected void modelChanged_setHealth() {
        if (this.isOverlayHealthEnabled) {
            ITopoEntityModel iTopoEntityModel = (ITopoEntityModel)this.widgetModel;
            Integer n = iTopoEntityModel.getHealth();
            this.iconHealth = TopoResource.getIconHealth(n);
            this.tooltipHealth = GraphModelUtilities.getTooltipHealth(n);
        } else {
            this.iconHealth = null;
        }
    }

    protected void modelChanged_setPerf() {
        if (this.isOverlayPerfEnabled) {
            ITopoEntityModel iTopoEntityModel = (ITopoEntityModel)this.widgetModel;
            Integer n = iTopoEntityModel.getPerf();
            this.iconPerf = TopoResource.getIconPerf(n);
            this.tooltipPerf = iTopoEntityModel.getPerfTooltip();
            if (this.tooltipPerf == null) {
                this.tooltipPerf = GraphModelUtilities.getTooltipPerf(n);
            }
        } else {
            this.iconPerf = null;
        }
    }

    protected void modelChanged_setPin() {
        ITopoEntityModel iTopoEntityModel = (ITopoEntityModel)this.widgetModel;
        boolean bl = iTopoEntityModel.isPinned();
        this.iconPin = bl ? TopoResource.ICON_PIN_ON : null;
        this.tooltipPin = GraphModelUtilities.getTooltipPin(bl);
    }

    protected void modelChanged_setSelection() {
        ITopoNodeModel iTopoNodeModel = (ITopoNodeModel)this.widgetModel;
        this.iconType = iTopoNodeModel.isSelected() ? iTopoNodeModel.getIconSelected() : (GraphModelConstant.STATUS_MISSING.equals(iTopoNodeModel.getHealth()) ? iTopoNodeModel.getIconMissing() : iTopoNodeModel.getIconUnselected());
    }

    protected void modelChanged_setHighlight() {
        ITopoEntityModel iTopoEntityModel = (ITopoEntityModel)this.widgetModel;
        LineBorder lineBorder = null;
        lineBorder = iTopoEntityModel.isHighlighted() ? TopoResource.BORDER_HIGHLIGHTED : TopoResource.BORDER_UNHIGHLIGHTED;
        this.setBorder(lineBorder);
    }

    protected void handleMouseClick(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        if (this.strLabelR.contains(point) || this.iconTypeR.contains(point) || this.iconHealthR.contains(point) || this.iconPerfR.contains(point) || this.iconPinR.contains(point)) {
            this.handleMouseClick_regular(mouseEvent);
        } else {
            this.handleMouseClick_background(mouseEvent);
        }
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        String string = null;
        if (this.strLabelR.contains(point)) {
            string = this.tooltipLabel;
        } else if (this.iconHealthR.contains(point)) {
            string = this.tooltipHealth;
        } else if (this.iconPerfR.contains(point)) {
            string = this.tooltipPerf;
        } else if (this.iconPinR.contains(point)) {
            string = this.tooltipPin;
        }
        return string;
    }

    protected Point getConnectingPoint() {
        Point point = null;
        point = this.iconType != null ? new Point(this.getX() + this.iconTypeR.x + this.iconTypeR.width / 2, this.getY() + this.iconTypeR.y + this.iconTypeR.height / 2) : super.getConnectingPoint();
        return point;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        return this.preferredSizeD;
    }

    public void invalidate() {
        super.invalidate();
        this.layoutItself();
    }

    protected void layoutItself() {
        block15: {
            try {
                Graphics graphics = this.getGraphics();
                if (graphics == null) {
                    return;
                }
                if (this.focusEntity == null) {
                    return;
                }
                graphics.setFont(TopoResource.FONT_PLAIN);
                FontMetrics fontMetrics = graphics.getFontMetrics();
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                if (this.strLabel != null) {
                    n = fontMetrics.stringWidth(this.strLabel);
                    n2 = fontMetrics.getHeight();
                    n3 = fontMetrics.getAscent();
                }
                Insets insets = this.getInsets();
                int n4 = 28 + this.iconType.getIconWidth();
                int n5 = 19 > this.iconType.getIconHeight() ? 20 : this.iconType.getIconHeight();
                n5 = n5;
                int n6 = insets.left + insets.right;
                int n7 = insets.top + insets.bottom;
                int n8 = 0;
                n8 = this.labelMode == 0 ? this.maxLabelWidth_compact : (this.labelMode == 1 ? (n < this.maxLabelWidth_relax ? n : this.maxLabelWidth_relax) : n);
                int n9 = n8 > n4 ? n8 : n4;
                n7 += n5;
                this.preferredSizeD = new Dimension(n6 += n9, n7 += n2);
                n6 = this.getWidth();
                n7 = this.getHeight();
                if (n6 == 0 || n7 == 0) break block15;
                n8 = insets.left;
                int n10 = insets.top;
                int n11 = n6 - insets.left - insets.right;
                n8 += (n11 -= n4) > 0 ? n11 / 2 : 0;
                if (this.iconHealth != null) {
                    this.iconHealthR.setBounds(n8, n10, this.iconHealth.getIconWidth(), this.iconHealth.getIconHeight());
                } else {
                    this.iconHealthR.setBounds(0, 0, 0, 0);
                }
                if (this.iconPerf != null) {
                    this.iconPerfR.setBounds(n8, n10 + 11, this.iconPerf.getIconWidth(), this.iconPerf.getIconHeight());
                } else {
                    this.iconPerfR.setBounds(0, 0, 0, 0);
                }
                this.iconTypeR.setBounds(n8 += 11, n10, this.iconType.getIconWidth(), this.iconType.getIconHeight());
                n8 += this.iconType.getIconWidth() + 3;
                if (this.iconPin != null) {
                    this.iconPinR.setBounds(n8, n10, this.iconPin.getIconWidth(), this.iconPin.getIconHeight());
                } else {
                    this.iconPinR.setBounds(0, 0, 0, 0);
                }
                n8 = insets.left;
                n10 += n5;
                if (this.strLabel != null) {
                    int n12 = n6 - insets.left - insets.right;
                    n11 = n12 - n;
                    this.strLabelP.setLocation(n8 += n11 > 0 ? n11 / 2 : 0, n10 + n3);
                    this.strLabelR.setBounds(n8, n10, n11 > 0 ? n : n12, n2);
                    if (n11 < 0) {
                        this.clippedStrLabel = "";
                        int n13 = 0;
                        while (n13 < this.strLabel.length()) {
                            String string = String.valueOf(this.strLabel.substring(0, n13)) + "...";
                            int n14 = fontMetrics.stringWidth(string);
                            if (n14 <= n12) {
                                this.clippedStrLabel = string;
                                ++n13;
                                continue;
                            }
                            break block15;
                        }
                        break block15;
                    }
                    this.clippedStrLabel = this.strLabel;
                    break block15;
                }
                this.strLabelR.setBounds(0, 0, 0, 0);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.iconHealth != null) {
            this.iconHealth.paintIcon(this, graphics, this.iconHealthR.x, this.iconHealthR.y);
        }
        if (this.iconPerf != null) {
            this.iconPerf.paintIcon(this, graphics, this.iconPerfR.x, this.iconPerfR.y);
        }
        if (this.iconType != null) {
            this.iconType.paintIcon(this, graphics, this.iconTypeR.x, this.iconTypeR.y);
        }
        if (this.iconPin != null) {
            this.iconPin.paintIcon(this, graphics, this.iconPinR.x, this.iconPinR.y);
        }
        if (this.strLabel != null) {
            graphics.setFont(TopoResource.FONT_PLAIN);
            graphics.setColor(TopoResource.COLOR_FONT);
            graphics.drawString(this.clippedStrLabel, this.strLabelP.x, this.strLabelP.y);
        }
    }

    public void setOverlayHealthEnabled(boolean bl) {
        this.isOverlayHealthEnabled = bl;
        this.modelChanged_setHealth();
        this.revalidate();
        this.repaint();
    }

    public void setOverlayPerfEnabled(boolean bl) {
        this.isOverlayPerfEnabled = bl;
        this.modelChanged_setPerf();
        this.revalidate();
        this.repaint();
    }

    public void setArrange(AbstractJTopoCanvas.ArrangeRecord arrangeRecord) {
    }

    public void setLabelMode(int n) {
        this.labelMode = n;
    }

    protected LayoutManager createDefaultLayout() {
        return null;
    }
}

