/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.widget;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.HashSet;
import java.util.LinkedHashSet;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.border.LineBorder;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.topo.model.GraphModel;
import org.eclipse.aperi.gui.topo.util.GraphDebug;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoBase;
import org.eclipse.aperi.gui.topo.widget.ControllerApp;
import org.eclipse.aperi.gui.topo.widget.ControllerView;
import org.eclipse.aperi.gui.topo.widget.JTopoDialogGlobalSetting;
import org.eclipse.aperi.gui.topo.widget.JTopoDialogGroupBy;
import org.eclipse.aperi.gui.topo.widget.JTopoDialogRefreshSetting;
import org.eclipse.aperi.gui.topo.widget.JTopoView;
import org.eclipse.aperi.gui.topo.widget.JTopoViewGroup;
import org.eclipse.aperi.gui.topo.widget.TopoResource;
import org.eclipse.aperi.gui.topo.widget.TopoSetting;

public class JTopoApp
extends AbstractJTopoBase {
    protected ControllerApp controllerApp;
    protected JDesktopPane desktop;
    protected JInternalFrame mainFrame;
    protected JInternalFrame miniMapFrame;
    protected JTopoViewGroup viewGroup;

    public JTopoApp() {
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("JTopoApp, constructor");
        }
        this.setLayout(new BorderLayout());
        this.desktop = new JDesktopPane();
        this.add((Component)this.desktop, "Center");
        this.desktop.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if ((this).JTopoApp.this.desktop != null) {
                            (this).JTopoApp.this.desktop.getDesktopManager().maximizeFrame((this).JTopoApp.this.mainFrame);
                            Point point = new Point((this).JTopoApp.this.miniMapFrame.getX(), (this).JTopoApp.this.miniMapFrame.getY());
                            int n = 10;
                            if (point.x + (this).JTopoApp.this.miniMapFrame.getWidth() > (this).JTopoApp.this.mainFrame.getWidth()) {
                                point.x = (this).JTopoApp.this.mainFrame.getWidth() - (this).JTopoApp.this.miniMapFrame.getWidth() - n;
                                if (point.x < n) {
                                    point.x = n;
                                }
                            }
                            if (point.y + (this).JTopoApp.this.miniMapFrame.getHeight() > (this).JTopoApp.this.mainFrame.getHeight()) {
                                point.y = (this).JTopoApp.this.mainFrame.getHeight() - (this).JTopoApp.this.miniMapFrame.getHeight() - n;
                                if (point.y < n) {
                                    point.y = n;
                                }
                            }
                            (this).JTopoApp.this.miniMapFrame.setLocation(point);
                        }
                    }
                });
            }
        });
        this.mainFrame = new JInternalFrame(GuiUtil.getString("TOPO_LABEL_GRAPHICAL_MAIN"), false, false, false, false);
        this.mainFrame.setBorder(LineBorder.createGrayLineBorder());
        this.mainFrame.setFrameIcon(TopoResource.ICON_EMPTY_1X14);
        this.mainFrame.show();
        this.desktop.add(this.mainFrame);
        this.miniMapFrame = new JInternalFrame(GuiUtil.getString("TOPO_LABEL_GRAPHICAL_MINIMAP"), true, false, false, true);
        this.miniMapFrame.setBorder(LineBorder.createGrayLineBorder());
        this.miniMapFrame.setFrameIcon(TopoResource.ICON_EMPTY_1X14);
        this.miniMapFrame.show();
        this.desktop.add(this.miniMapFrame);
        this.desktop.setLayer(this.miniMapFrame, 10);
        this.viewGroup = new JTopoViewGroup(this);
        this.mainFrame.getContentPane().add(this.viewGroup);
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        toolTipManager.setInitialDelay(50);
        toolTipManager.setReshowDelay(50);
        toolTipManager.setDismissDelay(10000);
        this.initState();
    }

    private void initState() {
        this.controllerApp = null;
        this.miniMapFrame.getContentPane().removeAll();
        this.viewGroup.removeAll();
    }

    public void resetState() {
        this.initState();
    }

    public ControllerApp getControllerApp() {
        return this.controllerApp;
    }

    public void setSessionModel(ControllerApp controllerApp) {
        if (GraphDebug.isTraceVisible()) {
            GraphDebug.trace("JTopoApp, setSessionModel()");
        }
        this.controllerApp = controllerApp;
        TopoSetting topoSetting = controllerApp.getTopoSetting();
        Rectangle rectangle = topoSetting.getMinimapBounds();
        this.miniMapFrame.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        LinkedHashSet linkedHashSet = topoSetting.getOpenedViews();
        for (GraphModel.ID iD : linkedHashSet) {
            controllerApp.openView(iD);
        }
    }

    protected void reattach() {
    }

    public JDesktopPane getDesktopPane() {
        return this.desktop;
    }

    public JInternalFrame getMainFrame() {
        return this.mainFrame;
    }

    public JInternalFrame getMiniMapFrame() {
        return this.miniMapFrame;
    }

    public JTopoViewGroup getTopoViewGroup() {
        return this.viewGroup;
    }

    public JTopoView getFocusedTopoView() {
        return this.viewGroup.getFocusedTopoView();
    }

    public void showGlobalSettingDialog() {
        Frame frame = JOptionPane.getFrameForComponent(this.mainFrame);
        JTopoDialogGlobalSetting jTopoDialogGlobalSetting = new JTopoDialogGlobalSetting(frame, this.controllerApp);
        jTopoDialogGlobalSetting.show();
    }

    public void showRefreshSettingDialog() {
        Frame frame = JOptionPane.getFrameForComponent(this.mainFrame);
        JTopoDialogRefreshSetting jTopoDialogRefreshSetting = new JTopoDialogRefreshSetting(frame, this.controllerApp);
        jTopoDialogRefreshSetting.show();
    }

    public void showGroupingDialog(ControllerView controllerView, HashSet hashSet) {
        Frame frame = JOptionPane.getFrameForComponent(this.mainFrame);
        JTopoDialogGroupBy jTopoDialogGroupBy = new JTopoDialogGroupBy(frame, controllerView, hashSet);
        jTopoDialogGroupBy.show();
    }
}

