/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBPreparedStatement;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;

public class ComplexQuery {
    private static boolean debug = false;
    private static final String DELIMITER = "'";

    private ComplexQuery() {
    }

    public static int sqlUpdate(DBConnection dBConnection, String string, Hashtable hashtable) throws SQLException {
        if (string == null) {
            throw new SQLException("Error - no sql string provided");
        }
        if (dBConnection == null) {
            throw new SQLException("Error - no connection provided");
        }
        int n = 0;
        DBPreparedStatement dBPreparedStatement = null;
        try {
            dBPreparedStatement = dBConnection.prepareStatement(string);
            if (hashtable != null) {
                TreeMap treeMap = new TreeMap(hashtable);
                Iterator iterator = treeMap.keySet().iterator();
                int n2 = 1;
                while (iterator.hasNext()) {
                    ColumnInfo columnInfo = (ColumnInfo)iterator.next();
                    DBQueryAssistant.setPreparedStatementParameter(dBPreparedStatement, columnInfo, n2, hashtable);
                    ++n2;
                }
            }
            n = dBPreparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            if (dBPreparedStatement != null) {
                try {
                    dBPreparedStatement.close();
                }
                catch (Exception exception) {}
            }
            throw throwable;
        }
        if (dBPreparedStatement != null) {
            try {
                dBPreparedStatement.close();
            }
            catch (Exception exception) {}
        }
        return n;
    }

    public static DBResultSet sqlQuery(DBConnection dBConnection, String string, Hashtable hashtable) throws SQLException {
        Object object;
        if (string == null) {
            throw new SQLException("Error - no sql string provided");
        }
        if (dBConnection == null) {
            throw new SQLException("Error - no connection provided");
        }
        DBPreparedStatement dBPreparedStatement = dBConnection.prepareStatement(string);
        if (hashtable != null) {
            object = new TreeMap(hashtable);
            Iterator iterator = ((TreeMap)object).keySet().iterator();
            int n = 1;
            while (iterator.hasNext()) {
                ColumnInfo columnInfo = (ColumnInfo)iterator.next();
                DBQueryAssistant.setPreparedStatementParameter(dBPreparedStatement, columnInfo, n, hashtable);
                ++n;
            }
        }
        object = null;
        try {
            object = dBPreparedStatement.executeQuery();
        }
        catch (SQLException sQLException) {
            try {
                dBPreparedStatement.close();
            }
            catch (Exception exception) {}
            throw sQLException;
        }
        return object;
    }

    public static Hashtable generateHashtable(Vector vector, Vector vector2) throws SQLException {
        if (vector.size() != vector2.size()) {
            throw new SQLException("Invalid parameters - vector sizes dont match");
        }
        Hashtable hashtable = new Hashtable();
        int n = 0;
        while (n < vector.size()) {
            ColumnInfo columnInfo = new ColumnInfo();
            columnInfo.setDataType(((ColumnInfo)vector.elementAt(n)).getDataType());
            columnInfo.setName(String.valueOf(10 + n));
            hashtable.put(columnInfo, vector2.elementAt(n));
            ++n;
        }
        return hashtable;
    }
}

