/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.Normalizer;
import org.eclipse.aperi.infrastructure.database.tables.TResClientSettingDataTable;

public class ClientSettingData
extends TResClientSettingDataTable {
    private String m_CreationClassNameId_str;

    public void setCreationClassName(String string) {
        this.m_CreationClassNameId_str = string;
    }

    public String getCreationClassName() {
        return this.m_CreationClassNameId_str;
    }

    public static ClientSettingDataCursor getCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
        return new ClientSettingDataCursor(dBConnection, hashtable, vector);
    }

    public ClientSettingData() {
        this.clear();
    }

    public ClientSettingData(int n, String string, String string2, String string3, String string4, short s, int n2) {
        this.clear();
        this.m_SettingDataId = n;
        this.m_InstanceId = string;
        this.m_ElementName = string2;
        this.m_ClientTypes = string3;
        this.m_ClientTypeDescriptions = string4;
        this.m_CreationClassNameId = s;
        this.m_SubsystemId = n2;
    }

    private void setNonKeyValues(Hashtable hashtable) {
        if (this.m_SettingDataId != Integer.MIN_VALUE) {
            hashtable.put(ClientSettingData.getColumnInfo("SETTING_DATA_ID"), String.valueOf(this.m_SettingDataId));
        }
        if (this.m_ElementName != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(ClientSettingData.getColumnInfo("ELEMENT_NAME"), this.m_ElementName);
        }
        if (this.m_ClientTypes != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(ClientSettingData.getColumnInfo("CLIENT_TYPES"), this.m_ClientTypes);
        }
        if (this.m_ClientTypeDescriptions != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(ClientSettingData.getColumnInfo("CLIENT_TYPE_DESCRIPTIONS"), this.m_ClientTypeDescriptions);
        }
        if (this.m_CreationClassNameId != Short.MIN_VALUE) {
            hashtable.put(ClientSettingData.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(this.m_CreationClassNameId));
        }
    }

    public boolean insert(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(dBConnection, this.m_CreationClassNameId_str);
        }
        if (this.m_InstanceId == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key INSTANCE_ID not found");
        }
        this.htColsAndValues.put(ClientSettingData.getColumnInfo("INSTANCE_ID"), this.m_InstanceId);
        if (this.m_SubsystemId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SUBSYSTEM_ID not found");
        }
        this.htColsAndValues.put(ClientSettingData.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(this.m_SubsystemId));
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_CLIENT_SETTING_DATA", dBConnection, this.htColsAndValues);
    }

    public boolean insert(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(ClientSettingData.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(ClientSettingData.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable.get(ClientSettingData.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable.get(ClientSettingData.getColumnInfo("INSTANCE_ID")) == null) {
            throw new SQLException(" ERROR: key INSTANCE_ID not found");
        }
        if (hashtable.get(ClientSettingData.getColumnInfo("SUBSYSTEM_ID")) == null) {
            throw new SQLException(" ERROR: key SUBSYSTEM_ID not found");
        }
        return DBQueryAssistant.performInsert("T_RES_CLIENT_SETTING_DATA", dBConnection, hashtable);
    }

    public int update(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(dBConnection, this.m_CreationClassNameId_str);
        }
        if (this.m_InstanceId == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key INSTANCE_ID not found");
        }
        this.htWhereClause.put(ClientSettingData.getColumnInfo("INSTANCE_ID"), this.m_InstanceId);
        if (this.m_SubsystemId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SUBSYSTEM_ID not found");
        }
        this.htWhereClause.put(ClientSettingData.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(this.m_SubsystemId));
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_CLIENT_SETTING_DATA", dBConnection, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(ClientSettingData.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(ClientSettingData.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable.get(ClientSettingData.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable.get(ClientSettingData.getColumnInfo("INSTANCE_ID")) == null) {
            throw new SQLException(" ERROR: key INSTANCE_ID not found");
        }
        this.htWhereClause.put(ClientSettingData.getColumnInfo("INSTANCE_ID"), hashtable.get(ClientSettingData.getColumnInfo("INSTANCE_ID")));
        if (hashtable.get(ClientSettingData.getColumnInfo("SUBSYSTEM_ID")) == null) {
            throw new SQLException(" ERROR: key SUBSYSTEM_ID not found");
        }
        this.htWhereClause.put(ClientSettingData.getColumnInfo("SUBSYSTEM_ID"), hashtable.get(ClientSettingData.getColumnInfo("SUBSYSTEM_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_CLIENT_SETTING_DATA", dBConnection, hashtable, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(dBConnection, this.m_CreationClassNameId_str);
        }
        if (this.m_InstanceId == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key INSTANCE_ID not found");
        }
        this.htWhereClause.put(ClientSettingData.getColumnInfo("INSTANCE_ID"), this.m_InstanceId);
        if (this.m_SubsystemId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SUBSYSTEM_ID not found");
        }
        this.htWhereClause.put(ClientSettingData.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(this.m_SubsystemId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_CLIENT_SETTING_DATA", dBConnection, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(ClientSettingData.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(ClientSettingData.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable.get(ClientSettingData.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable.get(ClientSettingData.getColumnInfo("INSTANCE_ID")) == null) {
            throw new SQLException(" ERROR: key INSTANCE_ID not found");
        }
        this.htWhereClause.put(ClientSettingData.getColumnInfo("INSTANCE_ID"), hashtable.get(ClientSettingData.getColumnInfo("INSTANCE_ID")));
        if (hashtable.get(ClientSettingData.getColumnInfo("SUBSYSTEM_ID")) == null) {
            throw new SQLException(" ERROR: key SUBSYSTEM_ID not found");
        }
        this.htWhereClause.put(ClientSettingData.getColumnInfo("SUBSYSTEM_ID"), hashtable.get(ClientSettingData.getColumnInfo("SUBSYSTEM_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_CLIENT_SETTING_DATA", dBConnection, this.htWhereClause);
    }

    public boolean retrieve(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(dBConnection, this.m_CreationClassNameId_str);
        }
        if (this.m_InstanceId == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key INSTANCE_ID not found");
        }
        this.htWhereClause.put(ClientSettingData.getColumnInfo("INSTANCE_ID"), this.m_InstanceId);
        if (this.m_SubsystemId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SUBSYSTEM_ID not found");
        }
        this.htWhereClause.put(ClientSettingData.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(this.m_SubsystemId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        boolean bl = false;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_RES_CLIENT_SETTING_DATA", dBConnection, this.htWhereClause, null);
            if (dBResultSet.next()) {
                this.setFields(dBConnection, dBResultSet);
                bl = true;
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return bl;
    }

    public static ClientSettingData retrieve(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable hashtable2 = new Hashtable();
        ClientSettingData clientSettingData = null;
        if (hashtable.get(ClientSettingData.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(ClientSettingData.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable.get(ClientSettingData.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable.get(ClientSettingData.getColumnInfo("INSTANCE_ID")) == null) {
            throw new SQLException(" ERROR: key INSTANCE_ID not found");
        }
        hashtable2.put(ClientSettingData.getColumnInfo("INSTANCE_ID"), hashtable.get(ClientSettingData.getColumnInfo("INSTANCE_ID")));
        if (hashtable.get(ClientSettingData.getColumnInfo("SUBSYSTEM_ID")) == null) {
            throw new SQLException(" ERROR: key SUBSYSTEM_ID not found");
        }
        hashtable2.put(ClientSettingData.getColumnInfo("SUBSYSTEM_ID"), hashtable.get(ClientSettingData.getColumnInfo("SUBSYSTEM_ID")));
        if (hashtable2.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_RES_CLIENT_SETTING_DATA", dBConnection, hashtable2, null);
            if (dBResultSet.next()) {
                clientSettingData = new ClientSettingData();
                clientSettingData.setFields(dBConnection, dBResultSet);
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return clientSettingData;
    }

    public static int update(DBConnection dBConnection, Hashtable hashtable, Hashtable hashtable2) throws SQLException {
        if (dBConnection == null || hashtable == null || hashtable2 == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(ClientSettingData.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(ClientSettingData.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable.get(ClientSettingData.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable2.get(ClientSettingData.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            hashtable2.put(ClientSettingData.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable2.get(ClientSettingData.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        return DBQueryAssistant.performUpdate("T_RES_CLIENT_SETTING_DATA", dBConnection, hashtable, hashtable2);
    }

    public static int deletes(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(ClientSettingData.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(ClientSettingData.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable.get(ClientSettingData.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        return DBQueryAssistant.performDelete("T_RES_CLIENT_SETTING_DATA", dBConnection, hashtable);
    }

    protected void setFields(DBConnection dBConnection, DBResultSet dBResultSet) throws SQLException {
        this.setSettingDataId(dBResultSet.getInt("SETTING_DATA_ID"));
        this.setInstanceId(dBResultSet.getString("INSTANCE_ID"));
        this.setElementName(dBResultSet.getString("ELEMENT_NAME"));
        this.setClientTypes(dBResultSet.getString("CLIENT_TYPES"));
        this.setClientTypeDescriptions(dBResultSet.getString("CLIENT_TYPE_DESCRIPTIONS"));
        this.setCreationClassNameId(dBResultSet.getShort("CREATION_CLASS_NAME_ID"));
        this.setCreationClassName(Normalizer.CreationClassNameGetName(dBConnection, this.m_CreationClassNameId));
        this.setSubsystemId(dBResultSet.getInt("SUBSYSTEM_ID"));
    }

    public static class ClientSettingDataCursor
    extends DBCursor {
        private ClientSettingData element = new ClientSettingData();
        private DBConnection con;

        private static Hashtable normalize(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
            if (hashtable == null) {
                return null;
            }
            if (hashtable.get(ClientSettingData.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
                hashtable.put(ClientSettingData.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable.get(ClientSettingData.getColumnInfo("CREATION_CLASS_NAME_ID")))));
            }
            return hashtable;
        }

        public ClientSettingDataCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
            super("T_RES_CLIENT_SETTING_DATA", dBConnection, ClientSettingDataCursor.normalize(dBConnection, hashtable), vector);
            this.con = dBConnection;
        }

        public ClientSettingData getObject() throws SQLException {
            ClientSettingData clientSettingData = null;
            if (this.DBrs != null) {
                clientSettingData = new ClientSettingData();
                clientSettingData.setFields(this.con, this.DBrs);
            }
            return clientSettingData;
        }

        public ClientSettingData getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

