/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.tables.TResDeviceAgentTable;

public class DeviceAgent
extends TResDeviceAgentTable {
    public static DeviceAgentCursor getCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
        return new DeviceAgentCursor(dBConnection, hashtable, vector);
    }

    public DeviceAgent() {
        this.clear();
    }

    public DeviceAgent(int n, int n2, int n3, Timestamp timestamp, String string, String string2, int n4) {
        this.clear();
        this.m_DeviceAgentId = n;
        this.m_Port = n2;
        this.m_PolicyDomainId = n3;
        this.m_StatusLastChanged = timestamp;
        this.m_Status = string;
        this.m_Version = string2;
        this.m_HostId = n4;
    }

    private void setNonKeyValues(Hashtable hashtable) {
        if (this.m_Port != Integer.MIN_VALUE) {
            hashtable.put(DeviceAgent.getColumnInfo("PORT"), String.valueOf(this.m_Port));
        }
        if (this.m_PolicyDomainId != Integer.MIN_VALUE) {
            hashtable.put(DeviceAgent.getColumnInfo("POLICY_DOMAIN_ID"), String.valueOf(this.m_PolicyDomainId));
        }
        if (this.m_StatusLastChanged != DBConstants.INVALID_TIMESTAMP_VALUE) {
            hashtable.put(DeviceAgent.getColumnInfo("STATUS_LAST_CHANGED"), this.m_StatusLastChanged);
        }
        if (this.m_Status != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(DeviceAgent.getColumnInfo("STATUS"), this.m_Status);
        }
        if (this.m_Version != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(DeviceAgent.getColumnInfo("VERSION"), this.m_Version);
        }
        if (this.m_HostId != Integer.MIN_VALUE) {
            hashtable.put(DeviceAgent.getColumnInfo("HOST_ID"), String.valueOf(this.m_HostId));
        }
    }

    public boolean insert(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_DeviceAgentId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key DEVICE_AGENT_ID not found");
        }
        this.htColsAndValues.put(DeviceAgent.getColumnInfo("DEVICE_AGENT_ID"), String.valueOf(this.m_DeviceAgentId));
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_DEVICE_AGENT", dBConnection, this.htColsAndValues);
    }

    public boolean insert(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(DeviceAgent.getColumnInfo("DEVICE_AGENT_ID")) == null) {
            throw new SQLException(" ERROR: key DEVICE_AGENT_ID not found");
        }
        return DBQueryAssistant.performInsert("T_RES_DEVICE_AGENT", dBConnection, hashtable);
    }

    public int update(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_DeviceAgentId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key DEVICE_AGENT_ID not found");
        }
        this.htWhereClause.put(DeviceAgent.getColumnInfo("DEVICE_AGENT_ID"), String.valueOf(this.m_DeviceAgentId));
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_DEVICE_AGENT", dBConnection, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(DeviceAgent.getColumnInfo("DEVICE_AGENT_ID")) == null) {
            throw new SQLException(" ERROR: key DEVICE_AGENT_ID not found");
        }
        this.htWhereClause.put(DeviceAgent.getColumnInfo("DEVICE_AGENT_ID"), hashtable.get(DeviceAgent.getColumnInfo("DEVICE_AGENT_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_DEVICE_AGENT", dBConnection, hashtable, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_DeviceAgentId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key DEVICE_AGENT_ID not found");
        }
        this.htWhereClause.put(DeviceAgent.getColumnInfo("DEVICE_AGENT_ID"), String.valueOf(this.m_DeviceAgentId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_DEVICE_AGENT", dBConnection, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(DeviceAgent.getColumnInfo("DEVICE_AGENT_ID")) == null) {
            throw new SQLException(" ERROR: key DEVICE_AGENT_ID not found");
        }
        this.htWhereClause.put(DeviceAgent.getColumnInfo("DEVICE_AGENT_ID"), hashtable.get(DeviceAgent.getColumnInfo("DEVICE_AGENT_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_DEVICE_AGENT", dBConnection, this.htWhereClause);
    }

    public boolean retrieve(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_DeviceAgentId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key DEVICE_AGENT_ID not found");
        }
        this.htWhereClause.put(DeviceAgent.getColumnInfo("DEVICE_AGENT_ID"), String.valueOf(this.m_DeviceAgentId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        boolean bl = false;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_RES_DEVICE_AGENT", dBConnection, this.htWhereClause, null);
            if (dBResultSet.next()) {
                this.setFields(dBConnection, dBResultSet);
                bl = true;
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return bl;
    }

    public static DeviceAgent retrieve(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable hashtable2 = new Hashtable();
        DeviceAgent deviceAgent = null;
        if (hashtable.get(DeviceAgent.getColumnInfo("DEVICE_AGENT_ID")) == null) {
            throw new SQLException(" ERROR: key DEVICE_AGENT_ID not found");
        }
        hashtable2.put(DeviceAgent.getColumnInfo("DEVICE_AGENT_ID"), hashtable.get(DeviceAgent.getColumnInfo("DEVICE_AGENT_ID")));
        if (hashtable2.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_RES_DEVICE_AGENT", dBConnection, hashtable2, null);
            if (dBResultSet.next()) {
                deviceAgent = new DeviceAgent();
                deviceAgent.setFields(dBConnection, dBResultSet);
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return deviceAgent;
    }

    public static int update(DBConnection dBConnection, Hashtable hashtable, Hashtable hashtable2) throws SQLException {
        if (dBConnection == null || hashtable == null || hashtable2 == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performUpdate("T_RES_DEVICE_AGENT", dBConnection, hashtable, hashtable2);
    }

    public static int deletes(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performDelete("T_RES_DEVICE_AGENT", dBConnection, hashtable);
    }

    protected void setFields(DBConnection dBConnection, DBResultSet dBResultSet) throws SQLException {
        this.setDeviceAgentId(dBResultSet.getInt("DEVICE_AGENT_ID"));
        this.setPort(dBResultSet.getInt("PORT"));
        this.setPolicyDomainId(dBResultSet.getInt("POLICY_DOMAIN_ID"));
        this.setStatusLastChanged(dBResultSet.getTimestamp("STATUS_LAST_CHANGED"));
        this.setStatus(dBResultSet.getString("STATUS"));
        this.setVersion(dBResultSet.getString("VERSION"));
        this.setHostId(dBResultSet.getInt("HOST_ID"));
    }

    public static class DeviceAgentCursor
    extends DBCursor {
        private DeviceAgent element = new DeviceAgent();
        private DBConnection con;

        public DeviceAgentCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
            super("T_RES_DEVICE_AGENT", dBConnection, hashtable, vector);
            this.con = dBConnection;
        }

        public DeviceAgent getObject() throws SQLException {
            DeviceAgent deviceAgent = null;
            if (this.DBrs != null) {
                deviceAgent = new DeviceAgent();
                deviceAgent.setFields(this.con, this.DBrs);
            }
            return deviceAgent;
        }

        public DeviceAgent getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

