/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.Normalizer;
import org.eclipse.aperi.infrastructure.database.tables.TResDiskGroupTable;

public class DiskGroup
extends TResDiskGroupTable {
    private String m_CreationClassNameId_str;

    public void setCreationClassName(String string) {
        this.m_CreationClassNameId_str = string;
    }

    public String getCreationClassName() {
        return this.m_CreationClassNameId_str;
    }

    public static DiskGroupCursor getCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
        return new DiskGroupCursor(dBConnection, hashtable, vector);
    }

    public DiskGroup() {
        this.clear();
    }

    public DiskGroup(int n, String string, String string2, String string3, String string4, String string5, int n2, short s, int n3, String string6, String string7, int n4, double d, String string8, Timestamp timestamp, String string9, short s2, short s3) {
        this.clear();
        this.m_DiskGroupId = n;
        this.m_Name = string;
        this.m_Description = string2;
        this.m_RaidLevel = string3;
        this.m_Loop = string4;
        this.m_Array = string5;
        this.m_SubsystemId = n2;
        this.m_Width = s;
        this.m_StorageExtentId = n3;
        this.m_DeviceAdapter1 = string6;
        this.m_DeviceAdapter2 = string7;
        this.m_DaPairId = n4;
        this.m_DdmCap = d;
        this.m_DdmSpeed = string8;
        this.m_UpdateTimestamp = timestamp;
        this.m_Tag = string9;
        this.m_DiskGroupNumber = s2;
        this.m_CreationClassNameId = s3;
    }

    private void setNonKeyValues(Hashtable hashtable) {
        if (this.m_DiskGroupId != Integer.MIN_VALUE) {
            hashtable.put(DiskGroup.getColumnInfo("DISK_GROUP_ID"), String.valueOf(this.m_DiskGroupId));
        }
        if (this.m_Name != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(DiskGroup.getColumnInfo("NAME"), this.m_Name);
        }
        if (this.m_Description != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(DiskGroup.getColumnInfo("DESCRIPTION"), this.m_Description);
        }
        if (this.m_RaidLevel != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(DiskGroup.getColumnInfo("RAID_LEVEL"), this.m_RaidLevel);
        }
        if (this.m_Loop != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(DiskGroup.getColumnInfo("LOOP"), this.m_Loop);
        }
        if (this.m_Array != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(DiskGroup.getColumnInfo("ARRAY"), this.m_Array);
        }
        if (this.m_SubsystemId != Integer.MIN_VALUE) {
            hashtable.put(DiskGroup.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(this.m_SubsystemId));
        }
        if (this.m_Width != Short.MIN_VALUE) {
            hashtable.put(DiskGroup.getColumnInfo("WIDTH"), String.valueOf(this.m_Width));
        }
        if (this.m_StorageExtentId != Integer.MIN_VALUE) {
            hashtable.put(DiskGroup.getColumnInfo("STORAGE_EXTENT_ID"), String.valueOf(this.m_StorageExtentId));
        }
        if (this.m_DeviceAdapter1 != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(DiskGroup.getColumnInfo("DEVICE_ADAPTER1"), this.m_DeviceAdapter1);
        }
        if (this.m_DeviceAdapter2 != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(DiskGroup.getColumnInfo("DEVICE_ADAPTER2"), this.m_DeviceAdapter2);
        }
        if (this.m_DaPairId != Integer.MIN_VALUE) {
            hashtable.put(DiskGroup.getColumnInfo("DA_PAIR_ID"), String.valueOf(this.m_DaPairId));
        }
        if (this.m_DdmCap != Double.MIN_VALUE) {
            hashtable.put(DiskGroup.getColumnInfo("DDM_CAP"), String.valueOf(this.m_DdmCap));
        }
        if (this.m_DdmSpeed != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(DiskGroup.getColumnInfo("DDM_SPEED"), this.m_DdmSpeed);
        }
        if (this.m_UpdateTimestamp != DBConstants.INVALID_TIMESTAMP_VALUE) {
            hashtable.put(DiskGroup.getColumnInfo("UPDATE_TIMESTAMP"), this.m_UpdateTimestamp);
        }
        if (this.m_DiskGroupNumber != Short.MIN_VALUE) {
            hashtable.put(DiskGroup.getColumnInfo("DISK_GROUP_NUMBER"), String.valueOf(this.m_DiskGroupNumber));
        }
        if (this.m_CreationClassNameId != Short.MIN_VALUE) {
            hashtable.put(DiskGroup.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(this.m_CreationClassNameId));
        }
    }

    public boolean insert(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(dBConnection, this.m_CreationClassNameId_str);
        }
        if (this.m_Tag == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key TAG not found");
        }
        this.htColsAndValues.put(DiskGroup.getColumnInfo("TAG"), this.m_Tag);
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_DISK_GROUP", dBConnection, this.htColsAndValues);
    }

    public boolean insert(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(DiskGroup.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(DiskGroup.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable.get(DiskGroup.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable.get(DiskGroup.getColumnInfo("TAG")) == null) {
            throw new SQLException(" ERROR: key TAG not found");
        }
        return DBQueryAssistant.performInsert("T_RES_DISK_GROUP", dBConnection, hashtable);
    }

    public int update(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(dBConnection, this.m_CreationClassNameId_str);
        }
        if (this.m_Tag == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key TAG not found");
        }
        this.htWhereClause.put(DiskGroup.getColumnInfo("TAG"), this.m_Tag);
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_DISK_GROUP", dBConnection, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(DiskGroup.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(DiskGroup.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable.get(DiskGroup.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable.get(DiskGroup.getColumnInfo("TAG")) == null) {
            throw new SQLException(" ERROR: key TAG not found");
        }
        this.htWhereClause.put(DiskGroup.getColumnInfo("TAG"), hashtable.get(DiskGroup.getColumnInfo("TAG")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_DISK_GROUP", dBConnection, hashtable, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(dBConnection, this.m_CreationClassNameId_str);
        }
        if (this.m_Tag == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key TAG not found");
        }
        this.htWhereClause.put(DiskGroup.getColumnInfo("TAG"), this.m_Tag);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_DISK_GROUP", dBConnection, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(DiskGroup.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(DiskGroup.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable.get(DiskGroup.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable.get(DiskGroup.getColumnInfo("TAG")) == null) {
            throw new SQLException(" ERROR: key TAG not found");
        }
        this.htWhereClause.put(DiskGroup.getColumnInfo("TAG"), hashtable.get(DiskGroup.getColumnInfo("TAG")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_DISK_GROUP", dBConnection, this.htWhereClause);
    }

    public boolean retrieve(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(dBConnection, this.m_CreationClassNameId_str);
        }
        if (this.m_Tag == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key TAG not found");
        }
        this.htWhereClause.put(DiskGroup.getColumnInfo("TAG"), this.m_Tag);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        boolean bl = false;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_RES_DISK_GROUP", dBConnection, this.htWhereClause, null);
            if (dBResultSet.next()) {
                this.setFields(dBConnection, dBResultSet);
                bl = true;
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return bl;
    }

    public static DiskGroup retrieve(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable hashtable2 = new Hashtable();
        DiskGroup diskGroup = null;
        if (hashtable.get(DiskGroup.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(DiskGroup.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable.get(DiskGroup.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable.get(DiskGroup.getColumnInfo("TAG")) == null) {
            throw new SQLException(" ERROR: key TAG not found");
        }
        hashtable2.put(DiskGroup.getColumnInfo("TAG"), hashtable.get(DiskGroup.getColumnInfo("TAG")));
        if (hashtable2.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_RES_DISK_GROUP", dBConnection, hashtable2, null);
            if (dBResultSet.next()) {
                diskGroup = new DiskGroup();
                diskGroup.setFields(dBConnection, dBResultSet);
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return diskGroup;
    }

    public static int update(DBConnection dBConnection, Hashtable hashtable, Hashtable hashtable2) throws SQLException {
        if (dBConnection == null || hashtable == null || hashtable2 == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(DiskGroup.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(DiskGroup.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable.get(DiskGroup.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable2.get(DiskGroup.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            hashtable2.put(DiskGroup.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable2.get(DiskGroup.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        return DBQueryAssistant.performUpdate("T_RES_DISK_GROUP", dBConnection, hashtable, hashtable2);
    }

    public static int deletes(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(DiskGroup.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(DiskGroup.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable.get(DiskGroup.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        return DBQueryAssistant.performDelete("T_RES_DISK_GROUP", dBConnection, hashtable);
    }

    protected void setFields(DBConnection dBConnection, DBResultSet dBResultSet) throws SQLException {
        this.setDiskGroupId(dBResultSet.getInt("DISK_GROUP_ID"));
        this.setName(dBResultSet.getString("NAME"));
        this.setDescription(dBResultSet.getString("DESCRIPTION"));
        this.setRaidLevel(dBResultSet.getString("RAID_LEVEL"));
        this.setLoop(dBResultSet.getString("LOOP"));
        this.setArray(dBResultSet.getString("ARRAY"));
        this.setSubsystemId(dBResultSet.getInt("SUBSYSTEM_ID"));
        this.setWidth(dBResultSet.getShort("WIDTH"));
        this.setStorageExtentId(dBResultSet.getInt("STORAGE_EXTENT_ID"));
        this.setDeviceAdapter1(dBResultSet.getString("DEVICE_ADAPTER1"));
        this.setDeviceAdapter2(dBResultSet.getString("DEVICE_ADAPTER2"));
        this.setDaPairId(dBResultSet.getInt("DA_PAIR_ID"));
        this.setDdmCap(dBResultSet.getDouble("DDM_CAP"));
        this.setDdmSpeed(dBResultSet.getString("DDM_SPEED"));
        this.setUpdateTimestamp(dBResultSet.getTimestamp("UPDATE_TIMESTAMP"));
        this.setTag(dBResultSet.getString("TAG"));
        this.setDiskGroupNumber(dBResultSet.getShort("DISK_GROUP_NUMBER"));
        this.setCreationClassNameId(dBResultSet.getShort("CREATION_CLASS_NAME_ID"));
        this.setCreationClassName(Normalizer.CreationClassNameGetName(dBConnection, this.m_CreationClassNameId));
    }

    public static class DiskGroupCursor
    extends DBCursor {
        private DiskGroup element = new DiskGroup();
        private DBConnection con;

        private static Hashtable normalize(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
            if (hashtable == null) {
                return null;
            }
            if (hashtable.get(DiskGroup.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
                hashtable.put(DiskGroup.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable.get(DiskGroup.getColumnInfo("CREATION_CLASS_NAME_ID")))));
            }
            return hashtable;
        }

        public DiskGroupCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
            super("T_RES_DISK_GROUP", dBConnection, DiskGroupCursor.normalize(dBConnection, hashtable), vector);
            this.con = dBConnection;
        }

        public DiskGroup getObject() throws SQLException {
            DiskGroup diskGroup = null;
            if (this.DBrs != null) {
                diskGroup = new DiskGroup();
                diskGroup.setFields(this.con, this.DBrs);
            }
            return diskGroup;
        }

        public DiskGroup getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

