/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.tables.TResLparTable;

public class Lpar
extends TResLparTable {
    public static LparCursor getCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
        return new LparCursor(dBConnection, hashtable, vector);
    }

    public Lpar() {
        this.clear();
    }

    public Lpar(int n, int n2, int n3, int n4, int n5, int n6, int n7, Timestamp timestamp) {
        this.clear();
        this.m_LparId = n;
        this.m_RedundancyId = n2;
        this.m_VirtualMemory = n3;
        this.m_NumIoSlots = n4;
        this.m_NumProcs = n5;
        this.m_SubsystemId = n6;
        this.m_StorageFacilityId = n7;
        this.m_UpdateTimestamp = timestamp;
    }

    private void setNonKeyValues(Hashtable hashtable) {
        if (this.m_RedundancyId != Integer.MIN_VALUE) {
            hashtable.put(Lpar.getColumnInfo("REDUNDANCY_ID"), String.valueOf(this.m_RedundancyId));
        }
        if (this.m_VirtualMemory != Integer.MIN_VALUE) {
            hashtable.put(Lpar.getColumnInfo("VIRTUAL_MEMORY"), String.valueOf(this.m_VirtualMemory));
        }
        if (this.m_NumIoSlots != Integer.MIN_VALUE) {
            hashtable.put(Lpar.getColumnInfo("NUM_IO_SLOTS"), String.valueOf(this.m_NumIoSlots));
        }
        if (this.m_NumProcs != Integer.MIN_VALUE) {
            hashtable.put(Lpar.getColumnInfo("NUM_PROCS"), String.valueOf(this.m_NumProcs));
        }
        if (this.m_SubsystemId != Integer.MIN_VALUE) {
            hashtable.put(Lpar.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(this.m_SubsystemId));
        }
        if (this.m_StorageFacilityId != Integer.MIN_VALUE) {
            hashtable.put(Lpar.getColumnInfo("STORAGE_FACILITY_ID"), String.valueOf(this.m_StorageFacilityId));
        }
        if (this.m_UpdateTimestamp != DBConstants.INVALID_TIMESTAMP_VALUE) {
            hashtable.put(Lpar.getColumnInfo("UPDATE_TIMESTAMP"), this.m_UpdateTimestamp);
        }
    }

    public boolean insert(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_LparId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key LPAR_ID not found");
        }
        this.htColsAndValues.put(Lpar.getColumnInfo("LPAR_ID"), String.valueOf(this.m_LparId));
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_LPAR", dBConnection, this.htColsAndValues);
    }

    public boolean insert(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(Lpar.getColumnInfo("LPAR_ID")) == null) {
            throw new SQLException(" ERROR: key LPAR_ID not found");
        }
        return DBQueryAssistant.performInsert("T_RES_LPAR", dBConnection, hashtable);
    }

    public int update(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_LparId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key LPAR_ID not found");
        }
        this.htWhereClause.put(Lpar.getColumnInfo("LPAR_ID"), String.valueOf(this.m_LparId));
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_LPAR", dBConnection, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(Lpar.getColumnInfo("LPAR_ID")) == null) {
            throw new SQLException(" ERROR: key LPAR_ID not found");
        }
        this.htWhereClause.put(Lpar.getColumnInfo("LPAR_ID"), hashtable.get(Lpar.getColumnInfo("LPAR_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_LPAR", dBConnection, hashtable, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_LparId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key LPAR_ID not found");
        }
        this.htWhereClause.put(Lpar.getColumnInfo("LPAR_ID"), String.valueOf(this.m_LparId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_LPAR", dBConnection, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(Lpar.getColumnInfo("LPAR_ID")) == null) {
            throw new SQLException(" ERROR: key LPAR_ID not found");
        }
        this.htWhereClause.put(Lpar.getColumnInfo("LPAR_ID"), hashtable.get(Lpar.getColumnInfo("LPAR_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_LPAR", dBConnection, this.htWhereClause);
    }

    public boolean retrieve(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_LparId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key LPAR_ID not found");
        }
        this.htWhereClause.put(Lpar.getColumnInfo("LPAR_ID"), String.valueOf(this.m_LparId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        boolean bl = false;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_RES_LPAR", dBConnection, this.htWhereClause, null);
            if (dBResultSet.next()) {
                this.setFields(dBConnection, dBResultSet);
                bl = true;
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return bl;
    }

    public static Lpar retrieve(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable hashtable2 = new Hashtable();
        Lpar lpar = null;
        if (hashtable.get(Lpar.getColumnInfo("LPAR_ID")) == null) {
            throw new SQLException(" ERROR: key LPAR_ID not found");
        }
        hashtable2.put(Lpar.getColumnInfo("LPAR_ID"), hashtable.get(Lpar.getColumnInfo("LPAR_ID")));
        if (hashtable2.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_RES_LPAR", dBConnection, hashtable2, null);
            if (dBResultSet.next()) {
                lpar = new Lpar();
                lpar.setFields(dBConnection, dBResultSet);
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return lpar;
    }

    public static int update(DBConnection dBConnection, Hashtable hashtable, Hashtable hashtable2) throws SQLException {
        if (dBConnection == null || hashtable == null || hashtable2 == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performUpdate("T_RES_LPAR", dBConnection, hashtable, hashtable2);
    }

    public static int deletes(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performDelete("T_RES_LPAR", dBConnection, hashtable);
    }

    protected void setFields(DBConnection dBConnection, DBResultSet dBResultSet) throws SQLException {
        this.setLparId(dBResultSet.getInt("LPAR_ID"));
        this.setRedundancyId(dBResultSet.getInt("REDUNDANCY_ID"));
        this.setVirtualMemory(dBResultSet.getInt("VIRTUAL_MEMORY"));
        this.setNumIoSlots(dBResultSet.getInt("NUM_IO_SLOTS"));
        this.setNumProcs(dBResultSet.getInt("NUM_PROCS"));
        this.setSubsystemId(dBResultSet.getInt("SUBSYSTEM_ID"));
        this.setStorageFacilityId(dBResultSet.getInt("STORAGE_FACILITY_ID"));
        this.setUpdateTimestamp(dBResultSet.getTimestamp("UPDATE_TIMESTAMP"));
    }

    public static class LparCursor
    extends DBCursor {
        private Lpar element = new Lpar();
        private DBConnection con;

        public LparCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
            super("T_RES_LPAR", dBConnection, hashtable, vector);
            this.con = dBConnection;
        }

        public Lpar getObject() throws SQLException {
            Lpar lpar = null;
            if (this.DBrs != null) {
                lpar = new Lpar();
                lpar.setFields(this.con, this.DBrs);
            }
            return lpar;
        }

        public Lpar getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

