/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.tables.TResSwitchAttributeSnapshotTable;

public class SwitchAttributeSnapshot
extends TResSwitchAttributeSnapshotTable {
    public static SwitchAttributeSnapshotCursor getCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
        return new SwitchAttributeSnapshotCursor(dBConnection, hashtable, vector);
    }

    public SwitchAttributeSnapshot() {
        this.clear();
    }

    public SwitchAttributeSnapshot(String string, String string2, short s, int n) {
        this.clear();
        this.m_SwitchWwn = string;
        this.m_Version = string2;
        this.m_Detectable = s;
        this.m_OperationalStatus = n;
    }

    private void setNonKeyValues(Hashtable hashtable) {
        if (this.m_Version != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(SwitchAttributeSnapshot.getColumnInfo("VERSION"), this.m_Version);
        }
        if (this.m_Detectable != Short.MIN_VALUE) {
            hashtable.put(SwitchAttributeSnapshot.getColumnInfo("DETECTABLE"), String.valueOf(this.m_Detectable));
        }
        if (this.m_OperationalStatus != Integer.MIN_VALUE) {
            hashtable.put(SwitchAttributeSnapshot.getColumnInfo("OPERATIONAL_STATUS"), String.valueOf(this.m_OperationalStatus));
        }
    }

    public boolean insert(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_SwitchWwn == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key SWITCH_WWN not found");
        }
        this.htColsAndValues.put(SwitchAttributeSnapshot.getColumnInfo("SWITCH_WWN"), this.m_SwitchWwn);
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_SWITCH_ATTRIBUTE_SNAPSHOT", dBConnection, this.htColsAndValues);
    }

    public boolean insert(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(SwitchAttributeSnapshot.getColumnInfo("SWITCH_WWN")) == null) {
            throw new SQLException(" ERROR: key SWITCH_WWN not found");
        }
        return DBQueryAssistant.performInsert("T_RES_SWITCH_ATTRIBUTE_SNAPSHOT", dBConnection, hashtable);
    }

    public int update(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_SwitchWwn == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key SWITCH_WWN not found");
        }
        this.htWhereClause.put(SwitchAttributeSnapshot.getColumnInfo("SWITCH_WWN"), this.m_SwitchWwn);
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_SWITCH_ATTRIBUTE_SNAPSHOT", dBConnection, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(SwitchAttributeSnapshot.getColumnInfo("SWITCH_WWN")) == null) {
            throw new SQLException(" ERROR: key SWITCH_WWN not found");
        }
        this.htWhereClause.put(SwitchAttributeSnapshot.getColumnInfo("SWITCH_WWN"), hashtable.get(SwitchAttributeSnapshot.getColumnInfo("SWITCH_WWN")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_SWITCH_ATTRIBUTE_SNAPSHOT", dBConnection, hashtable, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_SwitchWwn == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key SWITCH_WWN not found");
        }
        this.htWhereClause.put(SwitchAttributeSnapshot.getColumnInfo("SWITCH_WWN"), this.m_SwitchWwn);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_SWITCH_ATTRIBUTE_SNAPSHOT", dBConnection, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(SwitchAttributeSnapshot.getColumnInfo("SWITCH_WWN")) == null) {
            throw new SQLException(" ERROR: key SWITCH_WWN not found");
        }
        this.htWhereClause.put(SwitchAttributeSnapshot.getColumnInfo("SWITCH_WWN"), hashtable.get(SwitchAttributeSnapshot.getColumnInfo("SWITCH_WWN")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_SWITCH_ATTRIBUTE_SNAPSHOT", dBConnection, this.htWhereClause);
    }

    public boolean retrieve(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_SwitchWwn == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key SWITCH_WWN not found");
        }
        this.htWhereClause.put(SwitchAttributeSnapshot.getColumnInfo("SWITCH_WWN"), this.m_SwitchWwn);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        boolean bl = false;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_RES_SWITCH_ATTRIBUTE_SNAPSHOT", dBConnection, this.htWhereClause, null);
            if (dBResultSet.next()) {
                this.setFields(dBConnection, dBResultSet);
                bl = true;
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return bl;
    }

    public static SwitchAttributeSnapshot retrieve(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable hashtable2 = new Hashtable();
        SwitchAttributeSnapshot switchAttributeSnapshot = null;
        if (hashtable.get(SwitchAttributeSnapshot.getColumnInfo("SWITCH_WWN")) == null) {
            throw new SQLException(" ERROR: key SWITCH_WWN not found");
        }
        hashtable2.put(SwitchAttributeSnapshot.getColumnInfo("SWITCH_WWN"), hashtable.get(SwitchAttributeSnapshot.getColumnInfo("SWITCH_WWN")));
        if (hashtable2.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_RES_SWITCH_ATTRIBUTE_SNAPSHOT", dBConnection, hashtable2, null);
            if (dBResultSet.next()) {
                switchAttributeSnapshot = new SwitchAttributeSnapshot();
                switchAttributeSnapshot.setFields(dBConnection, dBResultSet);
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return switchAttributeSnapshot;
    }

    public static int update(DBConnection dBConnection, Hashtable hashtable, Hashtable hashtable2) throws SQLException {
        if (dBConnection == null || hashtable == null || hashtable2 == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performUpdate("T_RES_SWITCH_ATTRIBUTE_SNAPSHOT", dBConnection, hashtable, hashtable2);
    }

    public static int deletes(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performDelete("T_RES_SWITCH_ATTRIBUTE_SNAPSHOT", dBConnection, hashtable);
    }

    protected void setFields(DBConnection dBConnection, DBResultSet dBResultSet) throws SQLException {
        this.setSwitchWwn(dBResultSet.getString("SWITCH_WWN"));
        this.setVersion(dBResultSet.getString("VERSION"));
        this.setDetectable(dBResultSet.getShort("DETECTABLE"));
        this.setOperationalStatus(dBResultSet.getInt("OPERATIONAL_STATUS"));
    }

    public static class SwitchAttributeSnapshotCursor
    extends DBCursor {
        private SwitchAttributeSnapshot element = new SwitchAttributeSnapshot();
        private DBConnection con;

        public SwitchAttributeSnapshotCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
            super("T_RES_SWITCH_ATTRIBUTE_SNAPSHOT", dBConnection, hashtable, vector);
            this.con = dBConnection;
        }

        public SwitchAttributeSnapshot getObject() throws SQLException {
            SwitchAttributeSnapshot switchAttributeSnapshot = null;
            if (this.DBrs != null) {
                switchAttributeSnapshot = new SwitchAttributeSnapshot();
                switchAttributeSnapshot.setFields(this.con, this.DBrs);
            }
            return switchAttributeSnapshot;
        }

        public SwitchAttributeSnapshot getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

