/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.tables.TResTapeDriveAttributeSnapshotTable;

public class TapeDriveAttributeSnapshot
extends TResTapeDriveAttributeSnapshotTable {
    public static TapeDriveAttributeSnapshotCursor getCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
        return new TapeDriveAttributeSnapshotCursor(dBConnection, hashtable, vector);
    }

    public TapeDriveAttributeSnapshot() {
        this.clear();
    }

    public TapeDriveAttributeSnapshot(int n, int n2, short s, String string, short s2) {
        this.clear();
        this.m_TapeDriveId = n;
        this.m_OperationalStatus = n2;
        this.m_NeedsCleaning = s;
        this.m_FirmwareVersion = string;
        this.m_Detectable = s2;
    }

    private void setNonKeyValues(Hashtable hashtable) {
        if (this.m_OperationalStatus != Integer.MIN_VALUE) {
            hashtable.put(TapeDriveAttributeSnapshot.getColumnInfo("OPERATIONAL_STATUS"), String.valueOf(this.m_OperationalStatus));
        }
        if (this.m_NeedsCleaning != Short.MIN_VALUE) {
            hashtable.put(TapeDriveAttributeSnapshot.getColumnInfo("NEEDS_CLEANING"), String.valueOf(this.m_NeedsCleaning));
        }
        if (this.m_FirmwareVersion != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(TapeDriveAttributeSnapshot.getColumnInfo("FIRMWARE_VERSION"), this.m_FirmwareVersion);
        }
        if (this.m_Detectable != Short.MIN_VALUE) {
            hashtable.put(TapeDriveAttributeSnapshot.getColumnInfo("DETECTABLE"), String.valueOf(this.m_Detectable));
        }
    }

    public boolean insert(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_TapeDriveId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key TAPE_DRIVE_ID not found");
        }
        this.htColsAndValues.put(TapeDriveAttributeSnapshot.getColumnInfo("TAPE_DRIVE_ID"), String.valueOf(this.m_TapeDriveId));
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_TAPE_DRIVE_ATTRIBUTE_SNAPSHOT", dBConnection, this.htColsAndValues);
    }

    public boolean insert(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(TapeDriveAttributeSnapshot.getColumnInfo("TAPE_DRIVE_ID")) == null) {
            throw new SQLException(" ERROR: key TAPE_DRIVE_ID not found");
        }
        return DBQueryAssistant.performInsert("T_RES_TAPE_DRIVE_ATTRIBUTE_SNAPSHOT", dBConnection, hashtable);
    }

    public int update(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_TapeDriveId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key TAPE_DRIVE_ID not found");
        }
        this.htWhereClause.put(TapeDriveAttributeSnapshot.getColumnInfo("TAPE_DRIVE_ID"), String.valueOf(this.m_TapeDriveId));
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_TAPE_DRIVE_ATTRIBUTE_SNAPSHOT", dBConnection, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(TapeDriveAttributeSnapshot.getColumnInfo("TAPE_DRIVE_ID")) == null) {
            throw new SQLException(" ERROR: key TAPE_DRIVE_ID not found");
        }
        this.htWhereClause.put(TapeDriveAttributeSnapshot.getColumnInfo("TAPE_DRIVE_ID"), hashtable.get(TapeDriveAttributeSnapshot.getColumnInfo("TAPE_DRIVE_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_TAPE_DRIVE_ATTRIBUTE_SNAPSHOT", dBConnection, hashtable, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_TapeDriveId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key TAPE_DRIVE_ID not found");
        }
        this.htWhereClause.put(TapeDriveAttributeSnapshot.getColumnInfo("TAPE_DRIVE_ID"), String.valueOf(this.m_TapeDriveId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_TAPE_DRIVE_ATTRIBUTE_SNAPSHOT", dBConnection, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(TapeDriveAttributeSnapshot.getColumnInfo("TAPE_DRIVE_ID")) == null) {
            throw new SQLException(" ERROR: key TAPE_DRIVE_ID not found");
        }
        this.htWhereClause.put(TapeDriveAttributeSnapshot.getColumnInfo("TAPE_DRIVE_ID"), hashtable.get(TapeDriveAttributeSnapshot.getColumnInfo("TAPE_DRIVE_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_TAPE_DRIVE_ATTRIBUTE_SNAPSHOT", dBConnection, this.htWhereClause);
    }

    public boolean retrieve(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_TapeDriveId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key TAPE_DRIVE_ID not found");
        }
        this.htWhereClause.put(TapeDriveAttributeSnapshot.getColumnInfo("TAPE_DRIVE_ID"), String.valueOf(this.m_TapeDriveId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        boolean bl = false;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_RES_TAPE_DRIVE_ATTRIBUTE_SNAPSHOT", dBConnection, this.htWhereClause, null);
            if (dBResultSet.next()) {
                this.setFields(dBConnection, dBResultSet);
                bl = true;
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return bl;
    }

    public static TapeDriveAttributeSnapshot retrieve(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable hashtable2 = new Hashtable();
        TapeDriveAttributeSnapshot tapeDriveAttributeSnapshot = null;
        if (hashtable.get(TapeDriveAttributeSnapshot.getColumnInfo("TAPE_DRIVE_ID")) == null) {
            throw new SQLException(" ERROR: key TAPE_DRIVE_ID not found");
        }
        hashtable2.put(TapeDriveAttributeSnapshot.getColumnInfo("TAPE_DRIVE_ID"), hashtable.get(TapeDriveAttributeSnapshot.getColumnInfo("TAPE_DRIVE_ID")));
        if (hashtable2.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_RES_TAPE_DRIVE_ATTRIBUTE_SNAPSHOT", dBConnection, hashtable2, null);
            if (dBResultSet.next()) {
                tapeDriveAttributeSnapshot = new TapeDriveAttributeSnapshot();
                tapeDriveAttributeSnapshot.setFields(dBConnection, dBResultSet);
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return tapeDriveAttributeSnapshot;
    }

    public static int update(DBConnection dBConnection, Hashtable hashtable, Hashtable hashtable2) throws SQLException {
        if (dBConnection == null || hashtable == null || hashtable2 == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performUpdate("T_RES_TAPE_DRIVE_ATTRIBUTE_SNAPSHOT", dBConnection, hashtable, hashtable2);
    }

    public static int deletes(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        return DBQueryAssistant.performDelete("T_RES_TAPE_DRIVE_ATTRIBUTE_SNAPSHOT", dBConnection, hashtable);
    }

    protected void setFields(DBConnection dBConnection, DBResultSet dBResultSet) throws SQLException {
        this.setTapeDriveId(dBResultSet.getInt("TAPE_DRIVE_ID"));
        this.setOperationalStatus(dBResultSet.getInt("OPERATIONAL_STATUS"));
        this.setNeedsCleaning(dBResultSet.getShort("NEEDS_CLEANING"));
        this.setFirmwareVersion(dBResultSet.getString("FIRMWARE_VERSION"));
        this.setDetectable(dBResultSet.getShort("DETECTABLE"));
    }

    public static class TapeDriveAttributeSnapshotCursor
    extends DBCursor {
        private TapeDriveAttributeSnapshot element = new TapeDriveAttributeSnapshot();
        private DBConnection con;

        public TapeDriveAttributeSnapshotCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
            super("T_RES_TAPE_DRIVE_ATTRIBUTE_SNAPSHOT", dBConnection, hashtable, vector);
            this.con = dBConnection;
        }

        public TapeDriveAttributeSnapshot getObject() throws SQLException {
            TapeDriveAttributeSnapshot tapeDriveAttributeSnapshot = null;
            if (this.DBrs != null) {
                tapeDriveAttributeSnapshot = new TapeDriveAttributeSnapshot();
                tapeDriveAttributeSnapshot.setFields(this.con, this.DBrs);
            }
            return tapeDriveAttributeSnapshot;
        }

        public TapeDriveAttributeSnapshot getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

