/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.Normalizer;
import org.eclipse.aperi.infrastructure.database.tables.TResTapeMediaLocationTable;

public class TapeMediaLocation
extends TResTapeMediaLocationTable {
    private String m_CreationClassNameId_str;

    public void setCreationClassName(String string) {
        this.m_CreationClassNameId_str = string;
    }

    public String getCreationClassName() {
        return this.m_CreationClassNameId_str;
    }

    public static TapeMediaLocationCursor getCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
        return new TapeMediaLocationCursor(dBConnection, hashtable, vector);
    }

    public TapeMediaLocation() {
        this.clear();
    }

    public TapeMediaLocation(int n, String string, short s, short s2, String string2, int n2, int n3, Timestamp timestamp, short s3) {
        this.clear();
        this.m_LocationId = n;
        this.m_Tag = string;
        this.m_CreationClassNameId = s;
        this.m_LocationType = s2;
        this.m_LocationCoordinates = string2;
        this.m_MediaCapacity = n2;
        this.m_TapeLibraryId = n3;
        this.m_UpdateTimestamp = timestamp;
        this.m_Mediatypessupported = s3;
    }

    private void setNonKeyValues(Hashtable hashtable) {
        if (this.m_LocationId != Integer.MIN_VALUE) {
            hashtable.put(TapeMediaLocation.getColumnInfo("LOCATION_ID"), String.valueOf(this.m_LocationId));
        }
        if (this.m_CreationClassNameId != Short.MIN_VALUE) {
            hashtable.put(TapeMediaLocation.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(this.m_CreationClassNameId));
        }
        if (this.m_LocationType != Short.MIN_VALUE) {
            hashtable.put(TapeMediaLocation.getColumnInfo("LOCATION_TYPE"), String.valueOf(this.m_LocationType));
        }
        if (this.m_LocationCoordinates != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(TapeMediaLocation.getColumnInfo("LOCATION_COORDINATES"), this.m_LocationCoordinates);
        }
        if (this.m_MediaCapacity != Integer.MIN_VALUE) {
            hashtable.put(TapeMediaLocation.getColumnInfo("MEDIA_CAPACITY"), String.valueOf(this.m_MediaCapacity));
        }
        if (this.m_TapeLibraryId != Integer.MIN_VALUE) {
            hashtable.put(TapeMediaLocation.getColumnInfo("TAPE_LIBRARY_ID"), String.valueOf(this.m_TapeLibraryId));
        }
        if (this.m_UpdateTimestamp != DBConstants.INVALID_TIMESTAMP_VALUE) {
            hashtable.put(TapeMediaLocation.getColumnInfo("UPDATE_TIMESTAMP"), this.m_UpdateTimestamp);
        }
        if (this.m_Mediatypessupported != Short.MIN_VALUE) {
            hashtable.put(TapeMediaLocation.getColumnInfo("MEDIATYPESSUPPORTED"), String.valueOf(this.m_Mediatypessupported));
        }
    }

    public boolean insert(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(dBConnection, this.m_CreationClassNameId_str);
        }
        if (this.m_Tag == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key TAG not found");
        }
        this.htColsAndValues.put(TapeMediaLocation.getColumnInfo("TAG"), this.m_Tag);
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_TAPE_MEDIA_LOCATION", dBConnection, this.htColsAndValues);
    }

    public boolean insert(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(TapeMediaLocation.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(TapeMediaLocation.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable.get(TapeMediaLocation.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable.get(TapeMediaLocation.getColumnInfo("TAG")) == null) {
            throw new SQLException(" ERROR: key TAG not found");
        }
        return DBQueryAssistant.performInsert("T_RES_TAPE_MEDIA_LOCATION", dBConnection, hashtable);
    }

    public int update(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(dBConnection, this.m_CreationClassNameId_str);
        }
        if (this.m_Tag == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key TAG not found");
        }
        this.htWhereClause.put(TapeMediaLocation.getColumnInfo("TAG"), this.m_Tag);
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_TAPE_MEDIA_LOCATION", dBConnection, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(TapeMediaLocation.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(TapeMediaLocation.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable.get(TapeMediaLocation.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable.get(TapeMediaLocation.getColumnInfo("TAG")) == null) {
            throw new SQLException(" ERROR: key TAG not found");
        }
        this.htWhereClause.put(TapeMediaLocation.getColumnInfo("TAG"), hashtable.get(TapeMediaLocation.getColumnInfo("TAG")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_TAPE_MEDIA_LOCATION", dBConnection, hashtable, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(dBConnection, this.m_CreationClassNameId_str);
        }
        if (this.m_Tag == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key TAG not found");
        }
        this.htWhereClause.put(TapeMediaLocation.getColumnInfo("TAG"), this.m_Tag);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_TAPE_MEDIA_LOCATION", dBConnection, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(TapeMediaLocation.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(TapeMediaLocation.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable.get(TapeMediaLocation.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable.get(TapeMediaLocation.getColumnInfo("TAG")) == null) {
            throw new SQLException(" ERROR: key TAG not found");
        }
        this.htWhereClause.put(TapeMediaLocation.getColumnInfo("TAG"), hashtable.get(TapeMediaLocation.getColumnInfo("TAG")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_TAPE_MEDIA_LOCATION", dBConnection, this.htWhereClause);
    }

    public boolean retrieve(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_CreationClassNameId_str != null) {
            this.m_CreationClassNameId = Normalizer.CreationClassNameGetID(dBConnection, this.m_CreationClassNameId_str);
        }
        if (this.m_Tag == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key TAG not found");
        }
        this.htWhereClause.put(TapeMediaLocation.getColumnInfo("TAG"), this.m_Tag);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        boolean bl = false;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_RES_TAPE_MEDIA_LOCATION", dBConnection, this.htWhereClause, null);
            if (dBResultSet.next()) {
                this.setFields(dBConnection, dBResultSet);
                bl = true;
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return bl;
    }

    public static TapeMediaLocation retrieve(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        Hashtable hashtable2 = new Hashtable();
        TapeMediaLocation tapeMediaLocation = null;
        if (hashtable.get(TapeMediaLocation.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(TapeMediaLocation.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable.get(TapeMediaLocation.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable.get(TapeMediaLocation.getColumnInfo("TAG")) == null) {
            throw new SQLException(" ERROR: key TAG not found");
        }
        hashtable2.put(TapeMediaLocation.getColumnInfo("TAG"), hashtable.get(TapeMediaLocation.getColumnInfo("TAG")));
        if (hashtable2.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        DBResultSet dBResultSet = null;
        try {
            dBResultSet = DBQueryAssistant.performRetrieve("T_RES_TAPE_MEDIA_LOCATION", dBConnection, hashtable2, null);
            if (dBResultSet.next()) {
                tapeMediaLocation = new TapeMediaLocation();
                tapeMediaLocation.setFields(dBConnection, dBResultSet);
            }
        }
        finally {
            if (dBResultSet != null) {
                dBResultSet.getStatement().close();
            }
        }
        return tapeMediaLocation;
    }

    public static int update(DBConnection dBConnection, Hashtable hashtable, Hashtable hashtable2) throws SQLException {
        if (dBConnection == null || hashtable == null || hashtable2 == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(TapeMediaLocation.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(TapeMediaLocation.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable.get(TapeMediaLocation.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        if (hashtable2.get(TapeMediaLocation.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            hashtable2.put(TapeMediaLocation.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable2.get(TapeMediaLocation.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        return DBQueryAssistant.performUpdate("T_RES_TAPE_MEDIA_LOCATION", dBConnection, hashtable, hashtable2);
    }

    public static int deletes(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(TapeMediaLocation.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
            hashtable.put(TapeMediaLocation.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable.get(TapeMediaLocation.getColumnInfo("CREATION_CLASS_NAME_ID")))));
        }
        return DBQueryAssistant.performDelete("T_RES_TAPE_MEDIA_LOCATION", dBConnection, hashtable);
    }

    protected void setFields(DBConnection dBConnection, DBResultSet dBResultSet) throws SQLException {
        this.setLocationId(dBResultSet.getInt("LOCATION_ID"));
        this.setTag(dBResultSet.getString("TAG"));
        this.setCreationClassNameId(dBResultSet.getShort("CREATION_CLASS_NAME_ID"));
        this.setCreationClassName(Normalizer.CreationClassNameGetName(dBConnection, this.m_CreationClassNameId));
        this.setLocationType(dBResultSet.getShort("LOCATION_TYPE"));
        this.setLocationCoordinates(dBResultSet.getString("LOCATION_COORDINATES"));
        this.setMediaCapacity(dBResultSet.getInt("MEDIA_CAPACITY"));
        this.setTapeLibraryId(dBResultSet.getInt("TAPE_LIBRARY_ID"));
        this.setUpdateTimestamp(dBResultSet.getTimestamp("UPDATE_TIMESTAMP"));
        this.setMediatypessupported(dBResultSet.getShort("MEDIATYPESSUPPORTED"));
    }

    public static class TapeMediaLocationCursor
    extends DBCursor {
        private TapeMediaLocation element = new TapeMediaLocation();
        private DBConnection con;

        private static Hashtable normalize(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
            if (hashtable == null) {
                return null;
            }
            if (hashtable.get(TapeMediaLocation.getColumnInfo("CREATION_CLASS_NAME_ID")) != null) {
                hashtable.put(TapeMediaLocation.getColumnInfo("CREATION_CLASS_NAME_ID"), String.valueOf(Normalizer.CreationClassNameGetID(dBConnection, (String)hashtable.get(TapeMediaLocation.getColumnInfo("CREATION_CLASS_NAME_ID")))));
            }
            return hashtable;
        }

        public TapeMediaLocationCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
            super("T_RES_TAPE_MEDIA_LOCATION", dBConnection, TapeMediaLocationCursor.normalize(dBConnection, hashtable), vector);
            this.con = dBConnection;
        }

        public TapeMediaLocation getObject() throws SQLException {
            TapeMediaLocation tapeMediaLocation = null;
            if (this.DBrs != null) {
                tapeMediaLocation = new TapeMediaLocation();
                tapeMediaLocation.setFields(this.con, this.DBrs);
            }
            return tapeMediaLocation;
        }

        public TapeMediaLocation getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

