/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.history.snapshot;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.aperi.infrastructure.database.ClassHelper;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.objects.SnapshotMetadata;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;

public class SnapshotUtil {
    static final String SNAPSHOT_TABLE_SUFFIX = "_SNAPSHOT";
    static final String SNAPSHOT_ID_COLNAME = "SNAPSHOT_ID";
    static final String SNAPSHOT_ID_TOKEN = "<<SNAPSHOT_ID>>";
    private static String insertStmtTemplate = "INSERT INTO <<BASE_TABLE>>_SNAPSHOT (SNAPSHOT_ID <<COLLIST>>) SELECT <<SNAPSHOT_ID>> <<QUALIFIED_COLLIST>> FROM <<BASE_TABLE>> T1 <<WHERE_CLAUSE>>";
    private static String[][] subsystemSnapshotCreationStmtTemplates = new String[][]{{"T_RES_STORAGE_SUBSYSTEM", "WHERE T1.DETECTABLE = 1 AND T1.SUBSYSTEM_ID = ?"}, {"T_RES_STORAGE_POOL", "WHERE T1.DETECTABLE = 1 AND T1.SUBSYSTEM_ID = ?"}, {"T_RES_STORAGE_EXTENT", "WHERE T1.SUBSYSTEM_ID = ?"}, {"T_RES_DISK_GROUP", "WHERE T1.SUBSYSTEM_ID = ?"}, {"T_RES_STORAGE_VOLUME", "WHERE T1.DETECTABLE = 1 AND T1.POOL_ID = ? AND T1.SUBSYSTEM_ID = ?"}, {"T_RES_VOLUME2EXTENT", ", T_RES_STORAGE_VOLUME T2 WHERE T1.VOLUME_ID = T2.SVID AND T2.POOL_ID = ? AND T2.SUBSYSTEM_ID = ?"}, {"T_RES_PORT", "WHERE T1.DETECTABLE = 1 AND T1.SUBSYSTEM_ID = ?"}, {"T_RES_NODE", "WHERE T1.DETECTABLE = 1 AND T1.SYSTEM_ID = ?"}, {"T_RES_CIMKEY_SUBSYSTEM", "WHERE T1.SUBSYSTEM_ID = ?"}, {"T_RES_VENDOR", ", T_RES_STORAGE_SUBSYSTEM T2 WHERE T1.VENDOR_ID = T2.VENDOR_ID AND T2.SUBSYSTEM_ID = ?"}, {"T_RES_MODEL", ", T_RES_STORAGE_SUBSYSTEM T2 WHERE T1.MODEL_ID = T2.MODEL_ID AND T2.SUBSYSTEM_ID = ?"}, {"T_RES_CIMKEY_PORT", ", T_RES_PORT T2 WHERE T2.PORT_ID = T1.PORT_ID AND T2.SUBSYSTEM_ID = ?"}, {"T_RES_CIMKEY_VOLUME", ", T_RES_STORAGE_VOLUME T2 WHERE T1.VOLUME_ID = T2.SVID AND T2.POOL_ID = ? AND T2.SUBSYSTEM_ID = ?"}, {"T_RES_IO_GROUP", "WHERE T1.SUBSYSTEM_ID = ?"}, {"T_RES_REDUNDANCY", "WHERE T1.SUBSYSTEM_ID = ?"}};
    private static String[][] switchSnapshotCreationStmtTemplates = new String[][]{{"T_RES_SWITCH", "WHERE T1.SWITCH_WWN = ?"}, {"T_RES_SWITCH2PORT", "WHERE T1.SWITCH_WWN = ?"}, {"T_RES_PORT", ", T_RES_SWITCH2PORT T2 WHERE T1.PORT_ID = T2.PORT_ID AND T2.SWITCH_WWN = ?"}, {"T_RES_CIMKEY_SWITCH", "WHERE T1.SWITCH_WWN = ?"}, {"T_RES_CIMKEY_PORT", ", T_RES_SWITCH2PORT T2 WHERE T1.PORT_ID = T2.PORT_ID AND T2.SWITCH_WWN = ?"}, {"T_RES_VENDOR", ", T_RES_SWITCH T2 WHERE T1.VENDOR_ID = T2.VENDOR_ID AND T2.SWITCH_WWN = ?"}, {"T_RES_MODEL", ", T_RES_SWITCH T2 WHERE T1.MODEL_ID = T2.MODEL_ID AND T2.SWITCH_WWN = ?"}};
    private static String[][] cimomSnapshotCreationStmtTemplates = new String[][]{{"T_RES_REGISTERED_CIMOM", "WHERE T1.REG_CIMOM_ID = ?"}, {"T_RES_CIMOM2NAMESPACE", "WHERE T1.CIMOM_ID = ?"}};
    private static Hashtable subsystemSnapshotSqlHtab = new Hashtable();
    private static Hashtable switchSnapshotSqlHtab = new Hashtable();
    private static Hashtable cimomSnapshotSqlHtab = new Hashtable();
    private static ILogger traceLogger = null;
    private static String className = SnapshotUtil.class.getName();
    private static boolean TRACE = false;

    static {
        traceLogger = DBConstants.getLogger();
        if (traceLogger != null) {
            TRACE = traceLogger.isLogging();
        }
        SnapshotUtil.genSnapshotCreationSqlStmts(subsystemSnapshotSqlHtab, subsystemSnapshotCreationStmtTemplates);
        SnapshotUtil.genSnapshotCreationSqlStmts(switchSnapshotSqlHtab, switchSnapshotCreationStmtTemplates);
        SnapshotUtil.genSnapshotCreationSqlStmts(cimomSnapshotSqlHtab, cimomSnapshotCreationStmtTemplates);
    }

    static SnapshotMetadata createSnapshotMetadata(DBConnection dBConnection, int n, Timestamp timestamp, int n2, int n3, boolean bl) throws SQLException {
        String string = "createSnapshotMetadata";
        SnapshotMetadata snapshotMetadata = new SnapshotMetadata();
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, string);
        }
        snapshotMetadata.setSnapshotId(n);
        snapshotMetadata.setSnapshotTime(timestamp);
        snapshotMetadata.setSystemId(n2);
        snapshotMetadata.setSystemType((short)n3);
        snapshotMetadata.setSnapshotConsistent(bl ? (short)1 : 0);
        snapshotMetadata.setSnapshotType((short)1);
        snapshotMetadata.insert(dBConnection);
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, string);
        }
        return snapshotMetadata;
    }

    static String getSnapshotCreationStmt(int n, String string) {
        String string2 = "getSnapshotCreationStmt(" + n + ", " + string + ")";
        String string3 = null;
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, string2);
        }
        if (n == 1) {
            string3 = (String)subsystemSnapshotSqlHtab.get(string);
        } else if (n == 2) {
            string3 = (String)switchSnapshotSqlHtab.get(string);
        } else if (n == 3) {
            string3 = (String)cimomSnapshotSqlHtab.get(string);
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, string2);
        }
        return string3;
    }

    private static void genSnapshotCreationSqlStmts(Hashtable hashtable, String[][] stringArray) {
        String string = "genSnapshotCreationSqlStmts";
        StringBuffer stringBuffer = new StringBuffer(100);
        StringBuffer stringBuffer2 = new StringBuffer(100);
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, string);
        }
        int n = 0;
        while (n < stringArray.length) {
            if (stringBuffer.length() > 0) {
                stringBuffer.delete(0, stringBuffer.length());
            }
            if (stringBuffer2.length() > 0) {
                stringBuffer2.delete(0, stringBuffer2.length());
            }
            String string2 = insertStmtTemplate;
            try {
                Class<?> clazz = ClassHelper.getObject(String.valueOf(stringArray[n][0]) + SNAPSHOT_TABLE_SUFFIX).getClass().getSuperclass();
                Hashtable hashtable2 = (Hashtable)clazz.getDeclaredMethod("getColumns", null).invoke(clazz, null);
                Enumeration enumeration = hashtable2.elements();
                while (enumeration.hasMoreElements()) {
                    String string3 = ((ColumnInfo)enumeration.nextElement()).getName();
                    if (string3.equals(SNAPSHOT_ID_COLNAME)) continue;
                    stringBuffer.append(", " + string3);
                    stringBuffer2.append(", T1." + string3);
                }
                string2 = string2.replaceAll("<<BASE_TABLE>>", stringArray[n][0]);
                string2 = string2.replaceAll("<<COLLIST>>", stringBuffer.toString());
                string2 = string2.replaceAll("<<QUALIFIED_COLLIST>>", stringBuffer2.toString());
                string2 = string2.replaceAll("<<WHERE_CLAUSE>>", stringArray[n][1]);
                hashtable.put(stringArray[n][0], string2);
            }
            catch (Exception exception) {
                if (TRACE) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string, exception);
                }
                exception.printStackTrace();
            }
            ++n;
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, string);
        }
    }
}

