/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.mapping;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import org.eclipse.aperi.build.DbGenerateClasses;
import org.eclipse.aperi.infrastructure.database.AutoIdentifier;
import org.eclipse.aperi.infrastructure.database.ClassHelper;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.CurrentTime;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBTable;
import org.eclipse.aperi.infrastructure.database.Normalizer;
import org.eclipse.aperi.infrastructure.database.SQLExceptionHelper;
import org.eclipse.aperi.infrastructure.history.detectability.DetectabilityService;
import org.eclipse.aperi.infrastructure.mapping.AbstractDBAttributeMapper;
import org.eclipse.aperi.infrastructure.mapping.DataConverter;
import org.eclipse.aperi.infrastructure.mapping.MapperInfo;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;
import org.eclipse.aperi.interfaces.IDBAttributeMapper;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;

public abstract class DBAttributeMapper
extends AbstractDBAttributeMapper
implements IDBAttributeMapper {
    protected Hashtable m_htAttribToMapperInfo = new Hashtable();
    protected DataConverter m_dataConverter = new DataConverter();
    protected ILogger myLogger = null;
    private boolean useLogger = true;
    protected String myClassname = this.getClass().getName();
    protected static Hashtable opStatXMLToSMIS = new Hashtable();

    static {
        opStatXMLToSMIS.put(new String("up"), new Integer(2));
        opStatXMLToSMIS.put(new String("down"), new Integer(10));
        opStatXMLToSMIS.put(new String("testing"), new Integer(11));
        opStatXMLToSMIS.put(new String("unknown"), new Integer(0));
        opStatXMLToSMIS.put(new String("dormant"), new Integer(10));
        opStatXMLToSMIS.put(new String("notpresent"), new Integer(6));
        opStatXMLToSMIS.put(new String("lowerlayerdown"), new Integer(6));
        opStatXMLToSMIS.put(new String("online"), new Integer(2));
        opStatXMLToSMIS.put(new String("offline"), new Integer(0));
        opStatXMLToSMIS.put(new String("faulty"), new Integer(2));
        opStatXMLToSMIS.put(new String("failed"), new Integer(6));
        opStatXMLToSMIS.put(new String("bypassed"), new Integer(10));
        opStatXMLToSMIS.put(new String("reserved"), new Integer(10));
        opStatXMLToSMIS.put(new String("diagnostics"), new Integer(10));
        opStatXMLToSMIS.put(new String("portoperdown"), new Integer(10));
        opStatXMLToSMIS.put(new String("ok"), new Integer(2));
        opStatXMLToSMIS.put(new String("disabled"), new Integer(10));
        opStatXMLToSMIS.put(new String("okbutdiagfailed"), new Integer(3));
        opStatXMLToSMIS.put(new String("boot"), new Integer(8));
        opStatXMLToSMIS.put(new String("selftest"), new Integer(11));
        opStatXMLToSMIS.put(new String("missing"), new Integer(13));
        opStatXMLToSMIS.put(new String("mismatchwithparent"), new Integer(6));
        opStatXMLToSMIS.put(new String("mismatchconfig"), new Integer(6));
        opStatXMLToSMIS.put(new String("diagfailed"), new Integer(6));
        opStatXMLToSMIS.put(new String("dormant"), new Integer(10));
        opStatXMLToSMIS.put(new String("outofserviceadmin"), new Integer(1));
        opStatXMLToSMIS.put(new String("outofserviceenvtemp"), new Integer(11));
        opStatXMLToSMIS.put(new String("powereddown"), new Integer(10));
        opStatXMLToSMIS.put(new String("poweredup"), new Integer(8));
        opStatXMLToSMIS.put(new String("powerdenied"), new Integer(6));
        opStatXMLToSMIS.put(new String("powercycled"), new Integer(8));
    }

    public DBAttributeMapper() {
        if (this.useLogger) {
            this.myLogger = DBConstants.getLogger();
        }
    }

    protected void logEntry(String string, String string2, Object[] objectArray) {
        if (this.useLogger && this.myLogger.isLogging()) {
            this.myLogger.entry(IRecordType.TYPE_ENTRY, (Object)string, string2, objectArray);
        } else {
            System.out.println(String.valueOf(string) + "." + string2 + ":  entry");
            int n = 0;
            while (n < objectArray.length) {
                System.out.println("\t" + objectArray[n]);
                ++n;
            }
        }
    }

    protected void logExit(String string, String string2, Object object) {
        if (this.useLogger && this.myLogger.isLogging()) {
            this.myLogger.exit(IRecordType.TYPE_EXIT, (Object)string, string2, object);
        } else {
            System.out.println(String.valueOf(string) + "." + string2 + ":  return code: " + object);
        }
    }

    protected void logWarning(String string, String string2, String string3) {
        if (this.useLogger && this.myLogger.isLogging()) {
            this.myLogger.text(IRecordType.TYPE_WARNING, string, string2, string3);
        } else {
            System.out.println(String.valueOf(string) + "." + string2 + ":  " + string3);
        }
    }

    protected void logException(String string, String string2, Exception exception, String string3) {
        if (this.useLogger && this.myLogger.isLogging()) {
            this.myLogger.exception(IRecordType.TYPE_ERROR_EXC, string, string2, exception, string3);
        } else {
            System.out.println(String.valueOf(string) + "." + string2 + ":  " + string3);
            System.out.println(exception.toString());
        }
    }

    protected void logInfo(String string, String string2, String string3) {
        if (this.useLogger && this.myLogger.isLogging()) {
            this.myLogger.text(IRecordType.TYPE_INFO, string, string2, string3);
        } else {
            System.out.println(String.valueOf(string) + "." + string2 + ":  " + string3);
        }
    }

    private void printMapperResultTablesAndColumns(MapperResult mapperResult, String string) {
        Hashtable hashtable = mapperResult.getAllRows();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Hashtable hashtable2 = (Hashtable)hashtable.get(enumeration.nextElement());
            Enumeration enumeration2 = hashtable2.keys();
            while (enumeration2.hasMoreElements()) {
                ColumnInfo columnInfo = (ColumnInfo)enumeration2.nextElement();
                this.logInfo(this.myClassname, string, "\tTable:" + columnInfo.getTableName() + "\tColumn:" + columnInfo.getName());
            }
        }
    }

    protected String[] convertSNIAOPStatToBitArrValue(String string) {
        return this.convertSNIAOPStatToBitArrValue(string, opStatXMLToSMIS);
    }

    protected String[] convertSNIAOPStatToBitArrValue(String string, Hashtable hashtable) {
        String string2 = "convertSNIAOPStatToBitArrValue(" + string + ")";
        String[] stringArray = new String[2];
        String string3 = null;
        Integer n = null;
        int n2 = 19;
        double d = 0.0;
        this.logEntry(this.myClassname, string2, new Object[]{string});
        if (string == "") {
            this.logWarning(this.myClassname, string2, "No operational status available, returning unknown = 0");
            int n3 = (Integer)hashtable.get("unknown");
            stringArray[0] = String.valueOf(Math.pow(2.0, n3));
            stringArray[0] = stringArray[0].substring(0, stringArray[0].indexOf("."));
            stringArray[1] = String.valueOf(n3);
            return stringArray;
        }
        string3 = string.toLowerCase();
        n = (Integer)hashtable.get(string3);
        if (n == null) {
            this.logWarning(this.myClassname, string2, "Unknown SNIA operational status input, returning unknown = 0");
            int n4 = (Integer)hashtable.get("unknown");
            stringArray[0] = String.valueOf(Math.pow(2.0, n4));
            stringArray[0] = stringArray[0].substring(0, stringArray[0].indexOf("."));
            stringArray[1] = String.valueOf(n4);
            return stringArray;
        }
        int n5 = n;
        if (n5 >= 0 && n5 < n2) {
            d = Math.pow(2.0, n5);
        }
        String string4 = String.valueOf(d);
        stringArray[0] = string4.substring(0, string4.indexOf("."));
        stringArray[1] = String.valueOf(n5);
        this.logExit(this.myClassname, string2, String.valueOf(stringArray[0]) + ", " + stringArray[1]);
        return stringArray;
    }

    public MapperResult persist(DBConnection dBConnection, IDBAttributeMapper iDBAttributeMapper, Hashtable hashtable, IDBAttributeMapper iDBAttributeMapper2, Hashtable hashtable2, String string) throws SQLException {
        TableAndCols tableAndCols;
        Hashtable hashtable3;
        ColumnInfo columnInfo;
        ColumnInfo columnInfo2;
        Object object;
        String string22;
        Object object2;
        String string3 = "persist(DBConnection conn, DBAttributeMapper entity1, Hashtable entity1_htValues, DBAttributeMapper entity2, Hashtable entity2_htValues, String scanID)";
        Object[] objectArray = new Object[]{dBConnection, iDBAttributeMapper, hashtable, iDBAttributeMapper2, hashtable2, string};
        this.logEntry(this.myClassname, string3, objectArray);
        if (dBConnection == null) {
            throw new SQLException("Mapper layer persist function was passed a null object for the DBConnection");
        }
        if (dBConnection.isClosed()) {
            throw new SQLException("Mapper layer persist function was passed a closed DBConnection object.");
        }
        if (dBConnection.isReadOnly()) {
            throw new SQLException("Mapper layer persist function was passed a read-only DBConnection object.");
        }
        MapperResult mapperResult = new MapperResult();
        MapperResult mapperResult2 = iDBAttributeMapper.persist(dBConnection, hashtable, string);
        MapperResult mapperResult3 = iDBAttributeMapper2.persist(dBConnection, hashtable2, string);
        Hashtable hashtable4 = mapperResult2.getAllRows();
        Hashtable hashtable5 = mapperResult3.getAllRows();
        if (hashtable4.isEmpty()) {
            throw new SQLException("Entity mapper, " + iDBAttributeMapper.getClass().getName() + ", did not return any information -- an error scenario.  Relationship information can not be persisted.");
        }
        if (hashtable5.isEmpty()) {
            throw new SQLException("Entity mapper, " + iDBAttributeMapper2.getClass().getName() + ", did not return any information -- an error scenario.  Relationship information can not be persisted.");
        }
        mapperResult.addMapperResult(mapperResult2);
        mapperResult.addMapperResult(mapperResult3);
        this.logInfo(this.myClassname, string3, "Tables referenced by: " + iDBAttributeMapper.getClass().getName());
        this.printMapperResultTablesAndColumns(mapperResult2, string3);
        this.logInfo(this.myClassname, string3, "Tables referenced by: " + iDBAttributeMapper2.getClass().getName());
        this.printMapperResultTablesAndColumns(mapperResult3, string3);
        TreeMap<String, TableAndCols> treeMap = new TreeMap<String, TableAndCols>();
        Hashtable hashtable6 = new Hashtable();
        hashtable6.putAll(hashtable4);
        hashtable6.putAll(hashtable5);
        if (hashtable6.size() == hashtable4.size()) {
            object2 = this.m_htAttribToMapperInfo.keys();
            boolean bl = true;
            while (object2.hasMoreElements()) {
                string22 = (String)object2.nextElement();
                object = (MapperInfo)this.m_htAttribToMapperInfo.get(string22);
                if (object == null) continue;
                columnInfo2 = ((MapperInfo)object).getTargetColInfo();
                columnInfo = columnInfo2.getReferencedColumn();
                hashtable3 = bl ? (Hashtable)hashtable4.get(columnInfo.getTableName()) : (Hashtable)hashtable5.get(columnInfo.getTableName());
                tableAndCols = (TableAndCols)treeMap.get(columnInfo2.getTableName());
                if (tableAndCols == null) {
                    tableAndCols = new TableAndCols(columnInfo2.getTableName(), new Hashtable());
                    treeMap.put(columnInfo2.getTableName(), tableAndCols);
                }
                tableAndCols.put(columnInfo2, hashtable3.get(columnInfo));
                if (((MapperInfo)object).getDerivedColumn() != null) {
                    tableAndCols.put(((MapperInfo)object).getDerivedColumn(), new String("-1"));
                }
                if (columnInfo.isPrimaryKey()) {
                    Hashtable hashtable7;
                    if (bl) {
                        hashtable7 = (Hashtable)hashtable5.get(columnInfo.getTableName());
                        tableAndCols.put(columnInfo, hashtable7.get(columnInfo));
                    } else {
                        hashtable7 = (Hashtable)hashtable4.get(columnInfo.getTableName());
                        tableAndCols.put(columnInfo, hashtable7.get(columnInfo));
                    }
                }
                bl = !bl;
            }
        } else {
            object2 = this.m_htAttribToMapperInfo.keys();
            while (object2.hasMoreElements()) {
                string22 = (String)object2.nextElement();
                MapperInfo mapperInfo = (MapperInfo)this.m_htAttribToMapperInfo.get(string22);
                if (mapperInfo == null) continue;
                columnInfo2 = mapperInfo.getTargetColInfo();
                columnInfo = columnInfo2.getReferencedColumn();
                object = (Hashtable)hashtable4.get(columnInfo.getTableName());
                if (object == null) {
                    hashtable3 = (Hashtable)hashtable5.get(columnInfo.getTableName());
                    if (hashtable3 == null) {
                        return mapperResult;
                    }
                    tableAndCols = (TableAndCols)treeMap.get(columnInfo2.getTableName());
                    if (tableAndCols == null) {
                        tableAndCols = new TableAndCols(columnInfo2.getTableName(), new Hashtable());
                        treeMap.put(columnInfo2.getTableName(), tableAndCols);
                    }
                    tableAndCols.put(columnInfo2, hashtable3.get(columnInfo));
                    if ((columnInfo.isPrimaryKey() || columnInfo.isAutoGenerated()) && columnInfo.getTableName().equals(columnInfo2.getTableName())) {
                        tableAndCols.putPrimaryKey(columnInfo, hashtable3.get(columnInfo));
                    }
                    if (mapperInfo.getDerivedColumn() == null) continue;
                    tableAndCols.put(mapperInfo.getDerivedColumn(), new String("-1"));
                    continue;
                }
                tableAndCols = (TableAndCols)treeMap.get(columnInfo2.getTableName());
                if (tableAndCols == null) {
                    tableAndCols = new TableAndCols(columnInfo2.getTableName(), new Hashtable());
                    treeMap.put(columnInfo2.getTableName(), tableAndCols);
                }
                tableAndCols.put(columnInfo2, ((Hashtable)object).get(columnInfo));
                if ((columnInfo.isPrimaryKey() || columnInfo.isAutoGenerated()) && columnInfo.getTableName().equals(columnInfo2.getTableName())) {
                    tableAndCols.putPrimaryKey(columnInfo, ((Hashtable)object).get(columnInfo));
                }
                if (mapperInfo.getDerivedColumn() == null) continue;
                tableAndCols.put(mapperInfo.getDerivedColumn(), new String("-1"));
            }
        }
        for (String string22 : treeMap.keySet()) {
            TableAndCols tableAndCols2 = (TableAndCols)treeMap.get(string22);
            object = tableAndCols2.getDBHelper();
            if (tableAndCols2.getPrimaryKeys().size() > 0) {
                boolean bl;
                block25: {
                    bl = false;
                    try {
                        bl = ((DBTable)object).retrieve(dBConnection);
                    }
                    catch (SQLException sQLException) {
                        this.logInfo(this.myClassname, string3, "Unable to find existing row for helper, " + object.getClass().getName() + ", exception was: " + sQLException.getMessage() + ".");
                        if (!SQLExceptionHelper.isDeadlock(dBConnection, sQLException)) break block25;
                        this.logInfo(this.myClassname, string3, "Above exception was a deadlock exception, throwing back to caller to handle as appropriate.");
                        throw sQLException;
                    }
                }
                if (bl) {
                    this.performUpdate(tableAndCols2, mapperResult, dBConnection, string);
                    return mapperResult;
                }
                this.logInfo(this.myClassname, string3, "Unable to find existing row for helper, " + object.getClass().getName() + ".  Will attempt an insert.");
            }
            this.performInsert(tableAndCols2, mapperResult, dBConnection, string);
        }
        this.logExit(this.myClassname, string3, mapperResult);
        return mapperResult;
    }

    public MapperResult persist(DBConnection dBConnection, Hashtable hashtable, String string) throws SQLException {
        return this.persist(dBConnection, this.m_htAttribToMapperInfo, hashtable, string);
    }

    private void performSEPhase1(Hashtable hashtable, TreeMap treeMap, Hashtable hashtable2) {
        String string = "performSEPhase1(Hashtable htValues, TreeMap distinctTables, Hashtable htAttribToMapInfo)";
        Object[] objectArray = new Object[]{hashtable, treeMap, hashtable2};
        this.logEntry(this.myClassname, string, objectArray);
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = string2.toLowerCase();
            MapperInfo mapperInfo = this.getMapperInfo(hashtable2, string3);
            if (mapperInfo == null) continue;
            TableAndCols tableAndCols = (TableAndCols)treeMap.get(mapperInfo.getTargetColInfo().getTableName());
            if (tableAndCols == null) {
                tableAndCols = new TableAndCols(mapperInfo.getTargetColInfo().getTableName(), new Hashtable());
                treeMap.put(mapperInfo.getTargetColInfo().getTableName(), tableAndCols);
            }
            tableAndCols.put(mapperInfo.getTargetColInfo(), hashtable.get(string2));
            if (mapperInfo.getDerivedColumn() != null) {
                tableAndCols.put(mapperInfo.getDerivedColumn(), new String("-1"));
            }
            if (!mapperInfo.getTargetColInfo().getForeignKeyConstraint() || mapperInfo.getForeignKeyColInfo() == null) continue;
            ColumnInfo[] columnInfoArray = mapperInfo.getForeignKeyColInfo();
            int n = 0;
            while (n < columnInfoArray.length) {
                TableAndCols tableAndCols2 = (TableAndCols)treeMap.get(columnInfoArray[n].getTableName());
                if (mapperInfo.getDerivedColumn() != null) {
                    columnInfoArray[n].setReferencedColumn(mapperInfo.getDerivedColumn());
                } else {
                    columnInfoArray[n].setReferencedColumn(mapperInfo.getTargetColInfo());
                }
                if (tableAndCols2 == null) {
                    tableAndCols2 = new TableAndCols(columnInfoArray[n].getTableName(), new Hashtable());
                    treeMap.put(tableAndCols2.getTableName(), tableAndCols2);
                }
                if (tableAndCols.getDependentTables().get(tableAndCols2.getTableName()) == null) {
                    tableAndCols2.setIsDependentTable(true);
                    tableAndCols.getDependentTables().put(tableAndCols2.getTableName(), tableAndCols2);
                }
                tableAndCols2.put(columnInfoArray[n], new String("-1"));
                ++n;
            }
        }
        this.logExit(this.myClassname, string, null);
    }

    private void performSEPhase2(TreeMap treeMap, MapperResult mapperResult, String string, DBConnection dBConnection) throws SQLException {
        String string2 = "performSEPhase2(TreeMap distinctTables, MapperResult mr, String scanID, DBConnection conn)";
        Object[] objectArray = new Object[]{treeMap, mapperResult, string, dBConnection};
        this.logEntry(this.myClassname, string2, objectArray);
        for (String string3 : treeMap.keySet()) {
            Object object;
            TableAndCols tableAndCols = (TableAndCols)treeMap.get(string3);
            if (tableAndCols.isDependentTable()) continue;
            int n = -1;
            if (tableAndCols.getPrimaryKeys().size() > 0) {
                boolean bl;
                block14: {
                    object = tableAndCols.getDBHelper();
                    bl = false;
                    try {
                        bl = ((DBTable)object).retrieve(dBConnection);
                    }
                    catch (SQLException sQLException) {
                        this.logInfo(this.myClassname, string2, "Unable to find existing row for helper, " + object.getClass().getName() + ", exception was: " + sQLException.getMessage() + ".");
                        if (!SQLExceptionHelper.isDeadlock(dBConnection, sQLException)) break block14;
                        this.logInfo(this.myClassname, string2, "Above exception was a deadlock exception, throwing back to caller to handle as appropriate.");
                        throw sQLException;
                    }
                }
                if (bl) {
                    n = this.performUpdate(tableAndCols, mapperResult, dBConnection, string);
                } else {
                    this.logInfo(this.myClassname, string2, "Unable to find existing row for helper, " + object.getClass().getName() + ".  Will attempt an insert.");
                }
            }
            if (n <= 0) {
                try {
                    this.performInsert(tableAndCols, mapperResult, dBConnection, string);
                }
                catch (SQLException sQLException) {
                    if (sQLException.getErrorCode() == -803) {
                        this.logWarning(this.myClassname, string2, "Get a dublicate row exception inserting new row into " + tableAndCols.getTableName() + ".  Will attempt an update instead of insert.");
                        n = this.performUpdate(tableAndCols, mapperResult, dBConnection, string);
                    }
                    throw sQLException;
                }
            }
            if ((object = tableAndCols.getDependentTables()) == null || ((Hashtable)object).size() <= 0) continue;
            for (String string4 : ((Hashtable)object).keySet()) {
                boolean bl;
                Object object22;
                Vector<Object> vector = new Vector<Object>();
                Vector<ColumnInfo> vector2 = new Vector<ColumnInfo>();
                TableAndCols tableAndCols2 = (TableAndCols)((Hashtable)object).get(string4);
                Hashtable hashtable = tableAndCols2.getAllColsAndValues();
                for (Object object22 : hashtable.keySet()) {
                    if (((ColumnInfo)object22).getReferencedColumn() == null || !((ColumnInfo)object22).getReferencedColumn().getTableName().equals(string3)) continue;
                    if (n <= 0 && ((ColumnInfo)object22).getReferencedColumn().isAutoGenerated()) {
                        Object object3 = tableAndCols.get(((ColumnInfo)object22).getReferencedColumn());
                        if (object3 == null) continue;
                        tableAndCols2.put((ColumnInfo)object22, object3.toString());
                        continue;
                    }
                    vector.add(object22);
                    vector2.add(((ColumnInfo)object22).getReferencedColumn());
                }
                if (vector.size() <= 0 || !(bl = ((DBTable)(object22 = tableAndCols.getDBHelper())).retrieve(dBConnection))) continue;
                int n2 = 0;
                while (n2 < vector2.size()) {
                    ColumnInfo columnInfo = (ColumnInfo)vector2.elementAt(n2);
                    ColumnInfo columnInfo2 = (ColumnInfo)vector.elementAt(n2);
                    tableAndCols2.put(columnInfo2, tableAndCols.get(columnInfo).toString());
                    ++n2;
                }
            }
        }
        this.logExit(this.myClassname, string2, mapperResult);
    }

    private void performSEPhase3(TreeMap treeMap, MapperResult mapperResult, String string, DBConnection dBConnection) throws SQLException {
        String string2 = "performSEPhase3(TreeMap distinctTables, MapperResult mr, String scanID, DBConnection conn)";
        Object[] objectArray = new Object[]{treeMap, mapperResult, string, dBConnection};
        this.logEntry(this.myClassname, string2, objectArray);
        for (String string3 : treeMap.keySet()) {
            TableAndCols tableAndCols = (TableAndCols)treeMap.get(string3);
            if (!tableAndCols.isDependentTable()) continue;
            int n = -1;
            if (tableAndCols.getPrimaryKeys().size() > 0) {
                DBTable dBTable = tableAndCols.getDBHelper();
                boolean bl = dBTable.retrieve(dBConnection);
                if (bl) {
                    n = this.performUpdate(tableAndCols, mapperResult, dBConnection, string);
                } else {
                    this.logInfo(this.myClassname, string2, "Unable to find existing row for helper, " + dBTable.getClass().getName() + ".  Will attempt an insert.");
                }
            }
            if (n > 0) continue;
            try {
                this.performInsert(tableAndCols, mapperResult, dBConnection, string);
            }
            catch (SQLException sQLException) {
                this.logException(this.myClassname, string2, sQLException, "Thrown by performInsert for table: " + string3);
            }
        }
        this.logExit(this.myClassname, string2, mapperResult);
    }

    protected MapperResult persist(DBConnection dBConnection, Hashtable hashtable, Hashtable hashtable2, String string) throws SQLException {
        String string2 = "persist(DBConnection conn, Hashtable htAttribToMapInfo, Hashtable htValues, String scanID)";
        Object[] objectArray = new Object[]{dBConnection, hashtable, hashtable2, string};
        this.logEntry(this.myClassname, string2, objectArray);
        if (dBConnection == null) {
            throw new SQLException("Mapper layer persist function was passed a null object for the DBConnection");
        }
        if (dBConnection.isClosed()) {
            throw new SQLException("Mapper layer persist function was passed a closed DBConnection object.");
        }
        if (dBConnection.isReadOnly()) {
            throw new SQLException("Mapper layer persist function was passed a read-only DBConnection object.");
        }
        this.m_dataConverter.performDataConversion(hashtable2);
        if (hashtable2.isEmpty()) {
            throw new SQLException("After performing data conversion, there was no information for the " + this.myClassname + " to persist!");
        }
        MapperResult mapperResult = new MapperResult();
        TreeMap treeMap = new TreeMap();
        this.performSEPhase1(hashtable2, treeMap, hashtable);
        this.performSEPhase2(treeMap, mapperResult, string, dBConnection);
        this.performSEPhase3(treeMap, mapperResult, string, dBConnection);
        this.logExit(this.myClassname, string2, mapperResult);
        return mapperResult;
    }

    private int performUpdate(TableAndCols tableAndCols, MapperResult mapperResult, DBConnection dBConnection, String string) throws SQLException {
        String string2 = "performUpdate( TableAndCols target, MapperResult mr, DBConnection conn, String scanID )";
        Object[] objectArray = new Object[]{tableAndCols, mapperResult, dBConnection, string};
        this.logEntry(this.myClassname, string2, objectArray);
        DBTable dBTable = tableAndCols.getDBHelper();
        Hashtable hashtable = tableAndCols.getNonAutoGeneratedColsAndValues();
        this.addDetectable(dBTable, hashtable);
        this.addUpdateTimestamp(dBTable, hashtable, this.getCurrentTime(dBConnection));
        int n = dBTable.update(dBConnection, hashtable);
        Hashtable hashtable2 = tableAndCols.getAllColsAndValues();
        for (ColumnInfo columnInfo : hashtable2.keySet()) {
            short s;
            String string3;
            if (columnInfo.isAutoGenerated()) {
                string3 = tableAndCols.get(columnInfo).toString();
                tableAndCols.put(columnInfo, string3);
                continue;
            }
            if (columnInfo.getDataType() != 5) continue;
            if (columnInfo.getName().equals("SYSTEM_CREATION_CLASS_NAME_ID")) {
                string3 = hashtable2.get(columnInfo).toString();
                s = Normalizer.SystemCreationClassNameGetID(dBConnection, string3);
                if (s <= 0) continue;
                tableAndCols.put(columnInfo, String.valueOf(s));
                continue;
            }
            if (columnInfo.getName().equals("CREATION_CLASS_NAME_ID")) {
                string3 = hashtable2.get(columnInfo).toString();
                s = Normalizer.CreationClassNameGetID(dBConnection, string3);
                if (s <= 0) continue;
                tableAndCols.put(columnInfo, String.valueOf(s));
                continue;
            }
            if (columnInfo.getName().equals("CLASS_NAME_ID")) {
                string3 = hashtable2.get(columnInfo).toString();
                s = Normalizer.ClassNameGetID(dBConnection, string3);
                if (s <= 0) continue;
                tableAndCols.put(columnInfo, String.valueOf(s));
                continue;
            }
            if (columnInfo.getName().equals("SYSTEM_NAMES_ID")) {
                string3 = hashtable2.get(columnInfo).toString();
                s = Normalizer.SystemNamesGetID(dBConnection, string3);
                if (s <= 0) continue;
                tableAndCols.put(columnInfo, String.valueOf(s));
                continue;
            }
            if (columnInfo.getName().equals("VENDOR_ID")) {
                string3 = hashtable2.get(columnInfo).toString();
                s = Normalizer.VendorGetID(dBConnection, string3);
                if (s <= 0) continue;
                tableAndCols.put(columnInfo, String.valueOf(s));
                continue;
            }
            if (!columnInfo.getName().equals("MODEL_ID") || (s = Normalizer.ModelGetID(dBConnection, string3 = hashtable2.get(columnInfo).toString())) <= 0) continue;
            tableAndCols.put(columnInfo, String.valueOf(s));
        }
        if (n > 0) {
            mapperResult.addUpdatedRow(tableAndCols.getTableName(), tableAndCols.getAllColsAndValues());
        } else {
            mapperResult.addNonModifiedRow(tableAndCols.getTableName(), tableAndCols.getAllColsAndValues());
            n = 1;
        }
        dBConnection.commit();
        try {
            DetectabilityService.tableUpdated(string, tableAndCols.getTableName(), tableAndCols.getAutoGeneratedColsAndValues());
        }
        catch (Exception exception) {
            this.logException(this.myClassname, string2, exception, "Detectability Layer's \"tableUpdated\" function threw an exception, will attempt to continue.");
        }
        this.logExit(this.myClassname, string2, new Integer(n));
        return n;
    }

    private void performInsert(TableAndCols tableAndCols, MapperResult mapperResult, DBConnection dBConnection, String string) throws SQLException {
        Object object2;
        String string2 = "performInsert( TableAndCols target, MapperResult mr, DBConnection conn, String scanID )";
        Object[] objectArray = new Object[]{tableAndCols, mapperResult, dBConnection, string};
        this.logEntry(this.myClassname, string2, objectArray);
        Vector<Object> vector = new Vector<Object>();
        if (tableAndCols.getAllColsAndValues().size() > 0) {
            Hashtable hashtable = tableAndCols.getAllColsAndValues();
            for (Object object2 : hashtable.keySet()) {
                if (!((ColumnInfo)object2).isAutoGenerated()) continue;
                vector.add(object2);
            }
        }
        int n = -1;
        if (vector.size() > 0) {
            n = AutoIdentifier.getIdentifier(1, vector.size());
            int n2 = 0;
            while (n2 < vector.size()) {
                object2 = (ColumnInfo)vector.get(n2);
                tableAndCols.put((ColumnInfo)object2, String.valueOf(n++));
                ++n2;
            }
        }
        DBTable dBTable = tableAndCols.getDBHelper();
        object2 = tableAndCols.getAllColsAndValues();
        this.addDetectable(dBTable, (Hashtable)object2);
        Timestamp timestamp = this.getCurrentTime(dBConnection);
        this.addUpdateTimestamp(dBTable, (Hashtable)object2, timestamp);
        this.addDiscoveredTimestamp(dBTable, (Hashtable)object2, timestamp);
        for (ColumnInfo columnInfo : ((Hashtable)object2).keySet()) {
            String string3 = ((Hashtable)object2).get(columnInfo).toString();
            this.logInfo(this.myClassname, string2, "key=" + columnInfo.getName() + " value=" + string3);
        }
        dBTable.insert(dBConnection, (Hashtable)object2);
        dBConnection.commit();
        try {
            DetectabilityService.tableUpdated(string, tableAndCols.getTableName(), tableAndCols.getAutoGeneratedColsAndValues());
        }
        catch (Exception exception) {
            this.logException(this.myClassname, string2, exception, "Detectability Layer's \"tableUpdated\" function threw an exception, will attempt to continue.");
        }
        mapperResult.addInsertedRow(tableAndCols.getTableName(), tableAndCols.getAllColsAndValues());
        this.logExit(this.myClassname, string2, new Boolean(true));
    }

    private boolean addDetectable(DBTable dBTable, Hashtable hashtable) {
        Object[] objectArray = null;
        Method method = null;
        ColumnInfo columnInfo = null;
        try {
            Class[] classArray = new Class[]{String.class};
            method = dBTable.getClass().getMethod("getColumnInfo", classArray);
            objectArray = new Object[method.getParameterTypes().length];
            objectArray[0] = new String("DETECTABLE");
            columnInfo = (ColumnInfo)method.invoke((Object)dBTable, objectArray);
        }
        catch (Exception exception) {
            return false;
        }
        if (columnInfo == null) {
            return false;
        }
        hashtable.put(columnInfo, "1");
        return true;
    }

    private Timestamp getCurrentTime(DBConnection dBConnection) throws SQLException {
        return CurrentTime.getTimestamp(dBConnection);
    }

    private boolean addUpdateTimestamp(DBTable dBTable, Hashtable hashtable, Timestamp timestamp) throws SQLException {
        Object[] objectArray = null;
        Method method = null;
        ColumnInfo columnInfo = null;
        try {
            Class[] classArray = new Class[]{String.class};
            method = dBTable.getClass().getMethod("getColumnInfo", classArray);
            objectArray = new Object[method.getParameterTypes().length];
            objectArray[0] = new String("UPDATE_TIMESTAMP");
            columnInfo = (ColumnInfo)method.invoke((Object)dBTable, objectArray);
        }
        catch (Exception exception) {
            return false;
        }
        if (columnInfo == null) {
            return false;
        }
        hashtable.put(columnInfo, timestamp);
        return true;
    }

    private boolean addDiscoveredTimestamp(DBTable dBTable, Hashtable hashtable, Timestamp timestamp) throws SQLException {
        Object[] objectArray = null;
        Method method = null;
        ColumnInfo columnInfo = null;
        try {
            Class[] classArray = new Class[]{String.class};
            method = dBTable.getClass().getMethod("getColumnInfo", classArray);
            objectArray = new Object[method.getParameterTypes().length];
            objectArray[0] = new String("DISCOVERED_TIME");
            columnInfo = (ColumnInfo)method.invoke((Object)dBTable, objectArray);
        }
        catch (Exception exception) {
            return false;
        }
        if (columnInfo == null) {
            return false;
        }
        hashtable.put(columnInfo, timestamp);
        return true;
    }

    protected Hashtable generateValuesHashtable(Hashtable hashtable) {
        Hashtable hashtable2 = new Hashtable();
        for (String string : hashtable.keySet()) {
            MapperInfo mapperInfo = (MapperInfo)this.m_htAttribToMapperInfo.get(string.toLowerCase());
            if (mapperInfo == null) continue;
            hashtable2.put(mapperInfo.getTargetColInfo(), hashtable.get(string));
        }
        return hashtable2;
    }

    protected static Vector processArrayvalues(String string) {
        Vector<String> vector = new Vector<String>();
        try {
            int n = string.indexOf("]");
            if (n == -1) {
                n = string.length();
            }
            string = string.substring(string.indexOf("[") + 1, n);
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                vector.add(stringTokenizer.nextToken().trim());
            }
            return vector;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected static void setPreparedStatementParameter(PreparedStatement preparedStatement, ColumnInfo columnInfo, int n, Hashtable hashtable) throws SQLException {
        DBAttributeMapper.setPreparedStatementParameter(preparedStatement, columnInfo, n, hashtable.get(columnInfo));
    }

    protected static void setPreparedStatementParameter(PreparedStatement preparedStatement, ColumnInfo columnInfo, int n, Object object) throws SQLException {
        if (object != null) {
            try {
                switch (columnInfo.getDataType()) {
                    case -1: 
                    case 1: 
                    case 12: {
                        String string = (String)object;
                        preparedStatement.setString(n, string);
                    }
                    case 2005: {
                        Clob clob = (Clob)object;
                        preparedStatement.setClob(n, clob);
                    }
                    case 3: {
                        BigDecimal bigDecimal = DBConstants.INVALID_BIGDECIMAL_VALUE;
                        if (object instanceof Float) {
                            bigDecimal = (BigDecimal)object;
                        } else if (object instanceof String) {
                            bigDecimal = new BigDecimal((String)object);
                        } else {
                            throw new SQLException("Error - unable to convert " + object.getClass() + " to a Java bigdecimal");
                        }
                        preparedStatement.setBigDecimal(n, bigDecimal);
                    }
                    case 8: {
                        double d = Double.MIN_VALUE;
                        if (object instanceof Double) {
                            d = (Double)object;
                        } else if (object instanceof String) {
                            d = Double.parseDouble((String)object);
                        } else {
                            throw new SQLException("Error - unable to conver " + object.getClass() + " to a Java double");
                        }
                        preparedStatement.setDouble(n, d);
                    }
                    case 6: 
                    case 7: {
                        float f = Float.MIN_VALUE;
                        if (object instanceof Float) {
                            f = ((Float)object).floatValue();
                        } else if (object instanceof String) {
                            f = Float.parseFloat((String)object);
                        } else {
                            throw new SQLException("Error - unable to convert " + object.getClass() + " to a Java float");
                        }
                        preparedStatement.setFloat(n, f);
                    }
                    case 4: {
                        int n2 = Integer.MIN_VALUE;
                        if (object instanceof Integer) {
                            n2 = (Integer)object;
                        } else if (object instanceof String) {
                            n2 = Integer.parseInt((String)object);
                        } else {
                            throw new SQLException("Error - unable to convert " + object.getClass() + " to a Java int");
                        }
                        preparedStatement.setInt(n, n2);
                    }
                    case 2: {
                        throw new SQLException("Error - Unsupported type - NUMERIC");
                    }
                    case 5: {
                        int n3 = Short.MIN_VALUE;
                        if (object instanceof Short) {
                            n3 = ((Short)object).shortValue();
                        } else if (object instanceof String) {
                            n3 = Short.parseShort((String)object);
                        } else {
                            throw new SQLException("Error - unable to convert " + object.getClass() + " to a Java short");
                        }
                        preparedStatement.setInt(n, n3);
                    }
                    case 16: {
                        String string = (String)object;
                        short s = string.equalsIgnoreCase("true") ? (short)1 : 0;
                        preparedStatement.setShort(n, s);
                    }
                    case -6: {
                        throw new SQLException("Error - Unsupported type - TINYINT");
                    }
                    case 93: {
                        Timestamp timestamp = DBConstants.INVALID_TIMESTAMP_VALUE;
                        if (object instanceof Timestamp) {
                            timestamp = (Timestamp)object;
                        } else if (object instanceof String) {
                            timestamp = Timestamp.valueOf((String)object);
                        } else {
                            throw new SQLException("Error - unable to convert " + object.getClass() + " to a Java timestamp");
                        }
                        preparedStatement.setTimestamp(n, timestamp);
                    }
                    case 2003: {
                        throw new SQLException("Error - Unsupported type - ARRAY");
                    }
                    case 2004: {
                        throw new SQLException("Error - Unsupported type - BLOB");
                    }
                    case -7: {
                        throw new SQLException("Error - Unsupported type - BIT");
                    }
                    case -4: 
                    case -3: 
                    case -2: {
                        byte[] byArray = ((String)object).getBytes();
                        preparedStatement.setBytes(n, byArray);
                    }
                    case 70: {
                        throw new SQLException("Error - Unsupported type - DATALINK");
                    }
                    case 91: {
                        Date date = (Date)object;
                        preparedStatement.setDate(n, date);
                    }
                    case 92: {
                        Time time = (Time)object;
                        preparedStatement.setTime(n, time);
                    }
                    case -5: {
                        long l = Long.MIN_VALUE;
                        if (object instanceof BigInteger) {
                            l = ((BigInteger)object).longValue();
                        } else if (object instanceof Long) {
                            l = (Long)object;
                        } else if (object instanceof String) {
                            l = Long.parseLong((String)object);
                        } else {
                            throw new SQLException("Error - unable to convert " + object.getClass() + " to a Java long");
                        }
                        preparedStatement.setLong(n, l);
                    }
                    default: {
                        throw new SQLException("Error - Unknown type encountered - " + columnInfo.getDataType());
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                String string = "Number Format exception on " + object + " and field " + columnInfo.getName();
                System.out.println(string);
                throw new SQLException(string);
            }
        } else {
            preparedStatement.setNull(n, columnInfo.getDataType());
        }
    }

    public static class RegistrationData {
        private String mCIMClassName;
        private String mSmisVersion;
        private String mDeviceType;
        private String mInstrumentationVersion;
        private String mDedicated;

        public RegistrationData(String string, String string2, String string3, String string4, String string5) {
            if (string == null || string.trim().length() == 0) {
                throw new NullPointerException("Name must be neither null nor whitespace only.");
            }
            this.mCIMClassName = string;
            this.mSmisVersion = string2;
            this.mDeviceType = string3;
            this.mInstrumentationVersion = string4;
            this.mDedicated = string5;
        }

        public RegistrationData(String string, String string2, String string3, String string4) {
            this(string, string2, string3, string4, null);
        }

        public boolean equals(Object object) {
            if (object instanceof RegistrationData) {
                RegistrationData registrationData = (RegistrationData)object;
                return this.mCIMClassName.equals(registrationData.mCIMClassName) && this.mSmisVersion.equals(registrationData.mSmisVersion) && this.mDeviceType.equals(registrationData.mDeviceType) && this.mInstrumentationVersion.equals(registrationData.mInstrumentationVersion) && this.mDedicated.equals(registrationData.mDedicated);
            }
            return false;
        }

        public String getCIMClassName() {
            return this.mCIMClassName;
        }

        public String getDeviceType() {
            return this.mDeviceType;
        }

        public String getInstrumentationVersion() {
            return this.mInstrumentationVersion;
        }

        public String getSmisVersion() {
            return this.mSmisVersion;
        }

        public String getDedicated() {
            return this.mDedicated;
        }
    }

    class TableAndCols {
        String m_tableName;
        DBTable m_dbHelper;
        Hashtable m_colsAndValues;
        Hashtable m_primaryKeyColsAndValues;
        Hashtable m_derivedCols;
        Hashtable m_nonAutoGeneratedKeys;
        Hashtable m_allKvPairs;
        boolean m_isDependentTable;
        Hashtable m_depTables;

        public TableAndCols(String string, Hashtable hashtable) {
            this.m_tableName = string;
            this.m_colsAndValues = hashtable;
            this.m_allKvPairs = new Hashtable();
            this.m_depTables = new Hashtable();
            this.m_primaryKeyColsAndValues = new Hashtable();
            this.m_derivedCols = new Hashtable();
            this.m_nonAutoGeneratedKeys = new Hashtable();
            this.m_isDependentTable = false;
            this.m_dbHelper = ClassHelper.getObject(string);
        }

        public String getTableName() {
            return this.m_tableName;
        }

        public DBTable getDBHelper() {
            return this.m_dbHelper;
        }

        public boolean isDependentTable() {
            return this.m_isDependentTable;
        }

        public void setIsDependentTable(boolean bl) {
            this.m_isDependentTable = bl;
        }

        public void addDependentTable(TableAndCols tableAndCols) {
            this.m_depTables.put(tableAndCols.getTableName(), tableAndCols);
        }

        public Hashtable getDependentTables() {
            return this.m_depTables;
        }

        public Hashtable getTargetColsAndValues() {
            return this.m_colsAndValues;
        }

        public Hashtable getPrimaryKeys() {
            return this.m_primaryKeyColsAndValues;
        }

        public Hashtable getNonAutoGeneratedColsAndValues() {
            return this.m_nonAutoGeneratedKeys;
        }

        public Hashtable getAutoGeneratedColsAndValues() {
            return this.m_derivedCols;
        }

        public Hashtable getAllColsAndValues() {
            return this.m_allKvPairs;
        }

        public Object get(ColumnInfo columnInfo) {
            try {
                Method method = this.getMethod("get", DbGenerateClasses.columnNameToMemberName(columnInfo.getName()), columnInfo, new Class[0]);
                return method.invoke((Object)this.m_dbHelper, new Object[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (Exception exception) {}
            return null;
        }

        public void putPrimaryKey(ColumnInfo columnInfo, Object object) {
            this.m_allKvPairs.put(columnInfo, object.toString());
            this.m_primaryKeyColsAndValues.put(columnInfo, object);
            if (columnInfo.isAutoGenerated()) {
                this.m_derivedCols.put(columnInfo, object);
            }
        }

        public void put(ColumnInfo columnInfo, Object object) {
            this.m_allKvPairs.put(columnInfo, object.toString());
            if (columnInfo.isPrimaryKey()) {
                this.m_primaryKeyColsAndValues.put(columnInfo, object);
                this.m_nonAutoGeneratedKeys.put(columnInfo, object);
            } else if (columnInfo.isAutoGenerated()) {
                this.m_derivedCols.put(columnInfo, object);
            } else {
                this.m_colsAndValues.put(columnInfo, object);
                this.m_nonAutoGeneratedKeys.put(columnInfo, object);
            }
            this.setHelperValue(columnInfo, object);
        }

        private Method getMethod(String string, String string2, ColumnInfo columnInfo, Class[] classArray) throws NoSuchMethodException {
            String string3 = new String(String.valueOf(string) + string2);
            Class<?> clazz = this.m_dbHelper.getClass();
            Method method = null;
            try {
                method = clazz.getDeclaredMethod(string3, classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                method = clazz.getSuperclass().getDeclaredMethod(string3, classArray);
            }
            return method;
        }

        private void setHelperValue(ColumnInfo columnInfo, Object object) {
            String string = String.valueOf(DBAttributeMapper.this.myClassname) + ".TableAndCols";
            String string2 = "setHelperValue(ColumnInfo c, Object val)";
            String string3 = DbGenerateClasses.columnNameToMemberName(columnInfo.getName());
            try {
                Object object2;
                Class[] classArray = new Class[]{object.getClass()};
                Object[] objectArray = new Object[]{object};
                switch (columnInfo.getDataType()) {
                    case -1: 
                    case 1: 
                    case 12: {
                        objectArray[0] = object.toString();
                        classArray[0] = String.class;
                        break;
                    }
                    case 3: {
                        objectArray[0] = new BigDecimal((String)object);
                        classArray[0] = objectArray[0].getClass();
                        break;
                    }
                    case 8: {
                        objectArray[0] = new Double((String)object);
                        classArray[0] = Double.TYPE;
                        break;
                    }
                    case 6: {
                        objectArray[0] = new Float((String)object);
                        classArray[0] = Float.TYPE;
                        break;
                    }
                    case 4: {
                        try {
                            objectArray[0] = new Integer((String)object);
                        }
                        catch (ClassCastException classCastException) {
                            objectArray[0] = object;
                        }
                        classArray[0] = Integer.TYPE;
                        break;
                    }
                    case 2: {
                        DBAttributeMapper.this.logWarning(string, "setHelperValue(ColumnInfo c, Object val)", "Warning: Attempt to set value for column: " + columnInfo.getName() + " which is of unsupported type Numeric.");
                        break;
                    }
                    case 7: {
                        objectArray[0] = new Float((String)object);
                        classArray[0] = Float.TYPE;
                        break;
                    }
                    case 5: {
                        classArray[0] = Short.TYPE;
                        if (!(object instanceof String)) break;
                        try {
                            objectArray[0] = new Short((String)object);
                        }
                        catch (NumberFormatException numberFormatException) {
                            if (string3.endsWith("SystemNamesId") || string3.endsWith("CreationClassNameId") || string3.endsWith("ClassNameId") || string3.endsWith("SystemCreationClassNameId") || string3.endsWith("VendorId") || string3.endsWith("ModelId")) {
                                string3 = string3.substring(0, string3.length() - 2);
                                classArray[0] = String.class;
                                break;
                            }
                            DBAttributeMapper.this.logInfo(string, string2, "Attempt to set a field, " + string3 + ", of type SHORT with a string value not representing a short, will try to find a normalizing function in helper class.");
                            if (!string3.endsWith("Id")) break;
                            string3 = string3.substring(0, string3.length() - 2);
                            classArray[0] = String.class;
                        }
                        break;
                    }
                    case 16: {
                        object2 = (String)object;
                        short s = ((String)object2).equalsIgnoreCase("true") ? (short)1 : 0;
                        objectArray[0] = new Short(s);
                        classArray[0] = Short.TYPE;
                        break;
                    }
                    case -6: {
                        DBAttributeMapper.this.logWarning(string, "setHelperValue(ColumnInfo c, Object val)", "Warning: Attempt to set value for column: " + columnInfo.getName() + " which is of unsupported type TINYINT.");
                        break;
                    }
                    case 93: {
                        objectArray[0] = Timestamp.valueOf((String)object);
                        classArray[0] = Timestamp.class;
                        break;
                    }
                    case 2003: {
                        DBAttributeMapper.this.logWarning(string, "setHelperValue(ColumnInfo c, Object val)", "Warning: Attempt to set value for column: " + columnInfo.getName() + " which is of unsupported type ARRAY.");
                        break;
                    }
                    case 2005: {
                        DBAttributeMapper.this.logWarning(string, "setHelperValue(ColumnInfo c, Object val)", "Warning: Attempt to set value for column: " + columnInfo.getName() + " which is of unsupported type CLOB.");
                        break;
                    }
                    case 2004: {
                        DBAttributeMapper.this.logWarning(string, "setHelperValue(ColumnInfo c, Object val)", "Warning: Attempt to set value for column: " + columnInfo.getName() + " which is of unsupported type BLOB.");
                        break;
                    }
                    case -7: {
                        DBAttributeMapper.this.logWarning(string, "setHelperValue(ColumnInfo c, Object val)", "Warning: Attempt to set value for column: " + columnInfo.getName() + " which is of unsupported type BIT.");
                        break;
                    }
                    case -4: 
                    case -3: 
                    case -2: {
                        break;
                    }
                    case 70: {
                        DBAttributeMapper.this.logWarning(string, "setHelperValue(ColumnInfo c, Object val)", "Warning: Attempt to set value for column: " + columnInfo.getName() + " which is of unsupported type DATALINK.");
                        break;
                    }
                    case 91: 
                    case 92: {
                        objectArray[0] = object;
                        break;
                    }
                    case -5: {
                        if (object instanceof BigInteger) {
                            objectArray[0] = new BigInteger((String)object);
                            classArray[0] = BigInteger.class;
                            break;
                        }
                        if (object instanceof Long) {
                            objectArray[0] = new Long((String)object);
                            classArray[0] = Long.TYPE;
                            break;
                        }
                        if (object instanceof String) {
                            objectArray[0] = new Long((String)object);
                            classArray[0] = Long.TYPE;
                            break;
                        }
                        DBAttributeMapper.this.logWarning(string, string2, "Unable to convert " + object.getClass() + " to a Java long.");
                        break;
                    }
                    default: {
                        DBAttributeMapper.this.logWarning(string, string2, "Warning: Attempt to set value for column: " + columnInfo.getName() + " which is of an unknown type: " + columnInfo.getDataType());
                    }
                }
                object2 = this.getMethod("set", string3, columnInfo, classArray);
                ((Method)object2).invoke((Object)this.m_dbHelper, objectArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                DBAttributeMapper.this.logException(string, string2, noSuchMethodException, "Could not find set method for column, " + columnInfo.getName() + ", and member, " + string3 + " in helper: " + this.m_dbHelper.getClass().getSuperclass().getName());
            }
            catch (InvocationTargetException invocationTargetException) {
                DBAttributeMapper.this.logException(string, string2, invocationTargetException, "");
            }
            catch (IllegalAccessException illegalAccessException) {
                DBAttributeMapper.this.logException(string, string2, illegalAccessException, "");
            }
            catch (NumberFormatException numberFormatException) {
                DBAttributeMapper.this.logException(string, string2, numberFormatException, "Number Format exception on " + object + " and field " + columnInfo.getName());
            }
        }
    }
}

