/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.mapping;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.objects.CimkeySubsystem;
import org.eclipse.aperi.infrastructure.database.objects.Cimom2namespace;
import org.eclipse.aperi.infrastructure.database.objects.RegisteredCimom;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem;
import org.eclipse.aperi.infrastructure.mapping.DBAttributeMapper;
import org.eclipse.aperi.infrastructure.mapping.MapperInfo;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;
import org.eclipse.aperi.infrastructure.mapping.SMISCIM_ComputerSystem_NodeToDBMapper;

public class SMISCIM_ComputerSystem_TopLevelToDBMapper
extends DBAttributeMapper {
    public static DBAttributeMapper.RegistrationData[] getRegistrationData() {
        String string = "CIM_ComputerSystem";
        String string2 = "1.0.2";
        String string3 = null;
        String string4 = null;
        String string5 = "15";
        DBAttributeMapper.RegistrationData registrationData = new DBAttributeMapper.RegistrationData(string, string2, string3, string4, string5);
        string2 = "1.0.3";
        DBAttributeMapper.RegistrationData registrationData2 = new DBAttributeMapper.RegistrationData(string, string2, string3, string4, string5);
        string2 = "1.1.0";
        DBAttributeMapper.RegistrationData registrationData3 = new DBAttributeMapper.RegistrationData(string, string2, string3, string4, string5);
        return new DBAttributeMapper.RegistrationData[]{registrationData, registrationData2, registrationData3};
    }

    public SMISCIM_ComputerSystem_TopLevelToDBMapper() {
        this.m_dataConverter.addSimpleDataConversion("nameformat", "SMISName_Format");
        this.m_htAttribToMapperInfo.put("nameformat", new MapperInfo(StorageSubsystem.getColumnInfo("NAME_FORMAT")));
        ColumnInfo columnInfo = StorageSubsystem.getColumnInfo("NAME");
        columnInfo.setIsPrimaryKey();
        MapperInfo mapperInfo = new MapperInfo(columnInfo);
        ColumnInfo columnInfo2 = StorageSubsystem.getColumnInfo("SUBSYSTEM_ID");
        columnInfo2.setAutoGenerated();
        mapperInfo.setDerivedColumn(columnInfo2);
        this.m_htAttribToMapperInfo.put("name", mapperInfo);
        this.m_htAttribToMapperInfo.put("elementname", new MapperInfo(StorageSubsystem.getColumnInfo("DISPLAY_NAME")));
        this.m_htAttribToMapperInfo.put("operationalstatus", new MapperInfo(StorageSubsystem.getColumnInfo("OPERATIONAL_STATUS")));
        this.m_htAttribToMapperInfo.put("accessinfo", new MapperInfo(StorageSubsystem.getColumnInfo("ACCESS_INFO")));
        this.m_htAttribToMapperInfo.put("TYPE".toLowerCase(), new MapperInfo(StorageSubsystem.getColumnInfo("TYPE")));
        this.m_htAttribToMapperInfo.put("CONSOLIDATED_STATUS".toLowerCase(), new MapperInfo(StorageSubsystem.getColumnInfo("CONSOLIDATED_STATUS")));
        this.m_htAttribToMapperInfo.put("OS_TYPE".toLowerCase(), new MapperInfo(StorageSubsystem.getColumnInfo("OS_TYPE")));
        this.m_htAttribToMapperInfo.put("SerialNumber".toLowerCase(), new MapperInfo(StorageSubsystem.getColumnInfo("SERIAL_NUMBER")));
        this.m_htAttribToMapperInfo.put("vendor", new MapperInfo(StorageSubsystem.getColumnInfo("VENDOR_ID")));
        this.m_htAttribToMapperInfo.put("model", new MapperInfo(StorageSubsystem.getColumnInfo("MODEL_ID")));
    }

    public MapperResult persist(DBConnection dBConnection, Hashtable hashtable, String string) throws SQLException {
        Object object;
        String string2;
        String string3;
        String string4;
        this.logEntry(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", new Object[]{dBConnection, hashtable, string});
        if (hashtable.get("ref_toplevelsystem_id") != null && hashtable.get("ref_toplevelsystem_name") != null && hashtable.get("ref_toplevelsystem_nameformat") != null) {
            SMISCIM_ComputerSystem_NodeToDBMapper sMISCIM_ComputerSystem_NodeToDBMapper = new SMISCIM_ComputerSystem_NodeToDBMapper();
            return sMISCIM_ComputerSystem_NodeToDBMapper.persist(dBConnection, hashtable, string);
        }
        String string5 = (String)hashtable.get("creationclassname");
        if (string5 != null) {
            if (string5.indexOf("EMC") > -1 && hashtable.get("OS_TYPE".toLowerCase()) == null) {
                hashtable.put("TYPE".toLowerCase(), "EMC");
                hashtable.put("OS_TYPE".toLowerCase(), String.valueOf(26));
            } else if (string5.toLowerCase().startsWith("sun") && hashtable.get("OS_TYPE".toLowerCase()) == null) {
                hashtable.put("TYPE".toLowerCase(), "SUN");
                hashtable.put("OS_TYPE".toLowerCase(), String.valueOf(26));
            } else if (string5.startsWith("HP") && hashtable.get("OS_TYPE".toLowerCase()) == null) {
                hashtable.put("TYPE".toLowerCase(), "HP");
                hashtable.put("OS_TYPE".toLowerCase(), String.valueOf(18));
            }
        }
        if (hashtable.get("OS_TYPE".toLowerCase()) == null) {
            hashtable.put("TYPE".toLowerCase(), "Unknown");
            hashtable.put("OS_TYPE".toLowerCase(), String.valueOf(26));
        }
        if ((string4 = (String)hashtable.get("nameformat")) != null) {
            hashtable.put("nameformat2", string4);
        }
        if (((string3 = (String)hashtable.get("elementname")) == null || string3.length() == 0) && (string2 = (String)hashtable.get("caption")) != null && string2.length() > 0) {
            hashtable.put("elementname", string2);
        }
        if ((string2 = (String)hashtable.get("operationalstatus")) != null) {
            object = SMISCIM_ComputerSystem_TopLevelToDBMapper.processArrayvalues(string2);
            if ((string2 = DBConstants.convertOperationalstatusArrayToBitValue((Vector)object)) != null) {
                hashtable.put("operationalstatus", string2);
            } else {
                hashtable.remove("operationalstatus");
            }
            string2 = DBConstants.convertOperationalstatusArrayToConsolidatedValue((List)object);
            if (string2 != null) {
                hashtable.put("CONSOLIDATED_STATUS".toLowerCase(), string2);
            }
        }
        object = (String)hashtable.get("SERIAL_NUMBER".toLowerCase());
        String string6 = (String)hashtable.get("SerialNumber");
        if (object != null) {
            hashtable.put("SerialNumber", object);
            this.m_htAttribToMapperInfo.remove("SERIAL_NUMBER".toLowerCase());
        } else if (string6 == null) {
            hashtable.remove("SerialNumber");
        }
        MapperResult mapperResult = super.persist(dBConnection, hashtable, string);
        Hashtable hashtable2 = mapperResult.getAllRows();
        String string7 = (String)((Hashtable)hashtable2.get("T_RES_STORAGE_SUBSYSTEM")).get(StorageSubsystem.getColumnInfo("SUBSYSTEM_ID"));
        hashtable.put("subsystemid", string7);
        SMISCimkeySubsystemToDBMapper sMISCimkeySubsystemToDBMapper = new SMISCimkeySubsystemToDBMapper();
        MapperResult mapperResult2 = sMISCimkeySubsystemToDBMapper.persist(dBConnection, hashtable, string);
        MapperResult mapperResult3 = mapperResult.addMapperResult(mapperResult2);
        mapperResult3.addKeyReference("ref_toplevelsystem_id", StorageSubsystem.getColumnInfo("SUBSYSTEM_ID"));
        mapperResult3.addKeyReference("ref_toplevelsystem_name", StorageSubsystem.getColumnInfo("NAME"));
        mapperResult3.addKeyReference("ref_toplevelsystem_nameformat", StorageSubsystem.getColumnInfo("NAME_FORMAT"));
        try {
            mapperResult3.addKeyReference("ref_toplevelsystem_cimom2namespaceid", CimkeySubsystem.getColumnInfo("CIM_NAMESPACE_ID"));
        }
        catch (Exception exception) {
            this.logInfo(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", "TopLevelSystem mapper called w/o cimom2namespace creation - Indication mapping!");
        }
        return mapperResult3;
    }

    private class SMISCimkeySubsystemToDBMapper
    extends DBAttributeMapper {
        public SMISCimkeySubsystemToDBMapper() {
            ColumnInfo columnInfo = CimkeySubsystem.getColumnInfo("NAME");
            columnInfo.setIsPrimaryKey();
            MapperInfo mapperInfo = new MapperInfo(columnInfo);
            this.m_htAttribToMapperInfo.put("name", mapperInfo);
            ColumnInfo columnInfo2 = CimkeySubsystem.getColumnInfo("SUBSYSTEM_ID");
            columnInfo2.setIsPrimaryKey();
            MapperInfo mapperInfo2 = new MapperInfo(columnInfo2);
            ColumnInfo columnInfo3 = CimkeySubsystem.getColumnInfo("CIMKEY_SUBSYSTEM_ID");
            columnInfo3.setAutoGenerated();
            mapperInfo2.setDerivedColumn(columnInfo3);
            this.m_htAttribToMapperInfo.put("subsystemid", mapperInfo2);
            this.m_dataConverter.addSimpleDataConversion("nameformat2", "SMISName_Format");
            this.m_htAttribToMapperInfo.put("nameformat2", new MapperInfo(CimkeySubsystem.getColumnInfo("NAME_FORMAT")));
            ColumnInfo columnInfo4 = CimkeySubsystem.getColumnInfo("CIM_NAMESPACE_ID");
            columnInfo4.setIsPrimaryKey();
            MapperInfo mapperInfo3 = new MapperInfo(columnInfo4);
            mapperInfo3.setDerivedColumn(columnInfo3);
            this.m_htAttribToMapperInfo.put("cimnamespaceid", mapperInfo3);
            this.m_htAttribToMapperInfo.put("creationclassname", new MapperInfo(CimkeySubsystem.getColumnInfo("CREATION_CLASS_NAME_ID")));
        }

        public MapperResult persist(DBConnection dBConnection, Hashtable hashtable, String string) throws SQLException {
            this.logEntry(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", new Object[]{dBConnection, hashtable, string});
            new Hashtable();
            String string2 = (String)hashtable.get("ref_serviceurl");
            if (string2 != null) {
                RegisteredCimom registeredCimom = new RegisteredCimom();
                registeredCimom.setServiceUrl(string2);
                boolean bl = registeredCimom.retrieve(dBConnection);
                if (bl) {
                    int n = registeredCimom.getRegCimomId();
                    string2 = (String)hashtable.get("ref_namespace");
                    if (string2 != null) {
                        Cimom2namespace cimom2namespace = new Cimom2namespace();
                        cimom2namespace.setCimomId(n);
                        cimom2namespace.setNamespace(string2);
                        bl = cimom2namespace.retrieve(dBConnection);
                        if (bl) {
                            hashtable.put("cimnamespaceid", new String(String.valueOf(cimom2namespace.getCimNamespaceId())));
                            MapperResult mapperResult = super.persist(dBConnection, hashtable, string);
                            this.logExit(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", mapperResult);
                            return mapperResult;
                        }
                    }
                }
            }
            MapperResult mapperResult = new MapperResult();
            this.logExit(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", mapperResult);
            return mapperResult;
        }
    }
}

