/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.mapping;

import java.sql.SQLException;
import java.util.Hashtable;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.PhysicalVolume;
import org.eclipse.aperi.infrastructure.mapping.DBAttributeMapper;
import org.eclipse.aperi.infrastructure.mapping.MapperInfo;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;
import org.eclipse.aperi.infrastructure.mapping.SMISCIM_DiskDriveToDBMapper;

public class SMISONTAP_DiskDriveToDBMapper
extends SMISCIM_DiskDriveToDBMapper {
    public static final String CR = "(C) Copyright IBM Corp. 2005.";
    protected final String NETAPP = "NETWORK APPLIANCE";

    public static DBAttributeMapper.RegistrationData[] getRegistrationData() {
        String string = "ONTAP_DiskDrive";
        String string2 = "1.1.0";
        String string3 = null;
        String string4 = null;
        DBAttributeMapper.RegistrationData registrationData = new DBAttributeMapper.RegistrationData(string, string2, string3, string4);
        return new DBAttributeMapper.RegistrationData[]{registrationData};
    }

    public SMISONTAP_DiskDriveToDBMapper() {
        this.m_htAttribToMapperInfo.put("serialnumber", new MapperInfo(PhysicalVolume.getColumnInfo("SERIAL_NUMBER")));
        this.m_htAttribToMapperInfo.put("capacity", new MapperInfo(PhysicalVolume.getColumnInfo("CAPACITY")));
        this.m_htAttribToMapperInfo.put("displayname", new MapperInfo(PhysicalVolume.getColumnInfo("DISPLAY_NAME")));
        this.m_htAttribToMapperInfo.put("subsystemserialno", new MapperInfo(PhysicalVolume.getColumnInfo("SUBSYSTEM_SERIAL_NUMBER")));
        this.m_htAttribToMapperInfo.put("devicetype", new MapperInfo(PhysicalVolume.getColumnInfo("DEVICE_TYPE")));
    }

    public MapperResult persist(DBConnection dBConnection, Hashtable hashtable, String string) throws SQLException {
        this.logEntry(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", new Object[]{dBConnection, hashtable, string});
        hashtable.put("model", "NETWORK APPLIANCE");
        hashtable.put("manufacturer", "NETWORK APPLIANCE");
        hashtable.put("devicetype", "0");
        String string2 = (String)hashtable.get("deviceid");
        String string3 = " ";
        int n = string2.lastIndexOf(":") + 1;
        if (n != -1) {
            string3 = string2.substring(n);
        }
        hashtable.put("displayname", string3);
        String string4 = (String)hashtable.get("ref_toplevelsystem_name");
        String string5 = " ";
        hashtable.put("subsystemserialno", string5);
        if (string4 != null) {
            n = string4.lastIndexOf(":") + 1;
            string5 = string4.substring(n);
            if (n != -1) {
                hashtable.put("subsystemserialno", string5);
            }
        }
        this.fixup_deviceId(dBConnection, hashtable);
        String string6 = (String)hashtable.get("deviceid");
        if (string6 != null) {
            hashtable.put("serialnumber", this.prep_serialno(string6, string5));
        } else {
            hashtable.put("serialnumber", "Not in CIM XML");
        }
        this.get_capacity(dBConnection, hashtable);
        MapperResult mapperResult = super.persist(dBConnection, hashtable, string);
        this.logExit(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", mapperResult);
        return mapperResult;
    }

    /*
     * Unable to fully structure code
     */
    private void fixup_deviceId(DBConnection var1_1, Hashtable var2_2) {
        block21: {
            block22: {
                this.logEntry(this.getClass().getName(), "fixup_deviceId(DBConnection pConn, Hashtable pParams)", new Object[]{var1_1, var2_2});
                var3_3 = null;
                var4_4 = null;
                var5_5 = " ";
                var6_6 = "select * from T_RES_PHYSICAL_VOLUME where SERIAL_NUMBER = ?";
                var7_7 = "update T_RES_PHYSICAL_VOLUME set DEVICE_ID = ?, SYSTEM_NAMES_ID = ?, SUBSYSTEM_ID = ? where SERIAL_NUMBER = ?";
                var8_8 = (String)var2_2.get("displayname");
                var9_9 = (String)var2_2.get("subsystemserialno");
                var10_10 = (String)var2_2.get("deviceid");
                var11_11 = (String)var2_2.get("ref_system_names_id");
                var12_12 = (String)var2_2.get("ref_toplevelsystem_id");
                if (var10_10 == null) {
                    this.logInfo(this.getClass().getName(), "fixup_deviceId(DBConnection pConn, Hashtable pParams)", "deviceId from SMIS is not present");
                    this.logExit(this.getClass().getName(), "fixup_deviceId(DBConnection pConn, Hashtable pParams)", new Object[]{var1_1, var2_2});
                    return;
                }
                if (var9_9 == null) {
                    this.logInfo(this.getClass().getName(), "fixup_deviceId(DBConnection pConn, Hashtable pParams)", "subsystem serial number from SMIS is not present");
                    this.logExit(this.getClass().getName(), "fixup_deviceId(DBConnection pConn, Hashtable pParams)", new Object[]{var1_1, var2_2});
                    return;
                }
                if (var8_8 == null) {
                    this.logInfo(this.getClass().getName(), "fixup_deviceId(DBConnection pConn, Hashtable pParams)", "device name from SMIS is not present");
                    this.logExit(this.getClass().getName(), "fixup_deviceId(DBConnection pConn, Hashtable pParams)", new Object[]{var1_1, var2_2});
                    return;
                }
                if (var11_11 == null) {
                    this.logInfo(this.getClass().getName(), "fixup_deviceId(DBConnection pConn, Hashtable pParams)", "system name from SMIS is not present");
                    this.logExit(this.getClass().getName(), "fixup_deviceId(DBConnection pConn, Hashtable pParams)", new Object[]{var1_1, var2_2});
                    return;
                }
                if (var12_12 == null) {
                    this.logInfo(this.getClass().getName(), "fixup_deviceId(DBConnection pConn, Hashtable pParams)", "subsystem Id from SMIS is not present");
                    this.logExit(this.getClass().getName(), "fixup_deviceId(DBConnection pConn, Hashtable pParams)", new Object[]{var1_1, var2_2});
                    return;
                }
                if (var8_8 != null && var9_9 != null) {
                    var5_5 = String.valueOf(var9_9) + "/" + var8_8 + ":" + "NETWORK APPLIANCE";
                }
                var3_3 = var1_1.getConnection().prepareStatement(var6_6);
                var13_13 = 1;
                var3_3.setString(var13_13, var5_5);
                var4_4 = var3_3.executeQuery();
                if (!var4_4.next() || !var4_4.next()) break block21;
                this.logInfo(this.getClass().getName(), "fixup_deviceId(DBConnection pConn, Hashtable pParams)", "More than 1 disk drive record matched");
                this.logExit(this.getClass().getName(), "fixup_deviceId(DBConnection pConn, Hashtable pParams)", new Object[]{var1_1, var2_2});
                if (var3_3 == null) break block22;
                try {
                    var4_4.close();
                    var3_3.close();
                }
                catch (Exception v0) {}
            }
            return;
        }
        try {
            try {
                var13_13 = 1;
                var3_3 = var1_1.getConnection().prepareStatement(var7_7);
                var3_3.setString(var13_13, var10_10);
                var3_3.setString(++var13_13, var11_11);
                var3_3.setString(++var13_13, var12_12);
                var3_3.setString(++var13_13, var5_5);
                var3_3.executeUpdate();
            }
            catch (SQLException var13_14) {
                this.logException(this.getClass().getName(), "fixup_deviceId(DBConnection pConn, Hashtable pParams)", var13_14, "Error retrieving capacity from storage extent table, continue without saving capacity.");
                if (var3_3 == null) ** GOTO lbl86
                try {
                    var4_4.close();
                    var3_3.close();
                }
                catch (Exception v1) {}
            }
        }
        catch (Throwable var14_15) {
            if (var3_3 != null) {
                try {
                    var4_4.close();
                    var3_3.close();
                }
                catch (Exception v2) {}
            }
            throw var14_15;
        }
        if (var3_3 != null) {
            try {
                var4_4.close();
                var3_3.close();
            }
            catch (Exception v3) {}
        }
lbl86:
        // 7 sources

        this.logExit(this.getClass().getName(), "fixup_deviceId(DBConnection pConn, Hashtable pParams)", new Object[]{var1_1, var2_2});
    }

    /*
     * Unable to fully structure code
     */
    private void get_capacity(DBConnection var1_1, Hashtable var2_2) {
        block15: {
            this.logEntry(this.getClass().getName(), "get_capacity(DBConnection pConn, Hashtable pParams)", new Object[]{var1_1, var2_2});
            var3_3 = null;
            var4_4 = null;
            var5_5 = (String)var2_2.get("deviceid");
            var6_6 = "select TOTAL_CAPACITY from T_RES_STORAGE_EXTENT where DEVICE_ID = ? and SUBSYSTEM_ID = ?";
            var3_3 = var1_1.getConnection().prepareStatement(var6_6);
            var7_7 = 1;
            var3_3.setString(var7_7, var5_5.substring(var5_5.lastIndexOf(":") + 1));
            var8_9 = (String)var2_2.get("ref_toplevelsystem_id");
            var3_3.setInt(++var7_7, Integer.parseInt(var8_9));
            var4_4 = var3_3.executeQuery();
            if (!var4_4.next()) ** GOTO lbl34
            var7_7 = 1;
            var9_10 = var4_4.getLong(var7_7);
            if (!var4_4.next()) break block15;
            this.logInfo(this.getClass().getName(), "get_capacity(DBConnection pConn, Hashtable pParams)", "More than 1 storage extent record matched");
            this.logExit(this.getClass().getName(), "get_capacity(DBConnection pConn, Hashtable pParams)", new Object[]{var1_1, var2_2});
lbl19:
            // 3 sources

            while (true) {
                if (var3_3 != null) {
                    try {
                        var4_4.close();
                        var3_3.close();
                    }
                    catch (Exception v0) {}
                }
                return;
            }
        }
        try {
            try {
                var2_2.put("capacity", String.valueOf(var9_10));
                this.logExit(this.getClass().getName(), "get_capacity(DBConnection pConn, Hashtable pParams)", new Object[]{var1_1, var2_2});
                ** GOTO lbl19
lbl34:
                // 1 sources

                this.logInfo(this.getClass().getName(), "get_capacity(DBConnection pConn, Hashtable pParams)", "Did not get a matchin storage extent record");
                this.logExit(this.getClass().getName(), "get_capacity(DBConnection pConn, Hashtable pParams)", new Object[]{var1_1, var2_2});
                ** continue;
            }
            catch (SQLException var7_8) {
                this.logException(this.getClass().getName(), "get_capacity(DBConnection pConn, Hashtable pParams)", var7_8, "Error retrieving capacity from storage extent table, continue without saving capacity.");
                if (var3_3 != null) {
                    try {
                        var4_4.close();
                        var3_3.close();
                    }
                    catch (Exception v1) {}
                }
            }
        }
        catch (Throwable var11_11) {
            if (var3_3 != null) {
                try {
                    var4_4.close();
                    var3_3.close();
                }
                catch (Exception v2) {}
            }
            throw var11_11;
        }
        this.logExit(this.getClass().getName(), "get_capacity(DBConnection pConn, Hashtable pParams)", new Object[]{var1_1, var2_2});
    }

    /*
     * Enabled aggressive block sorting
     */
    private String prep_serialno(String string, String string2) {
        this.logEntry(this.getClass().getName(), "prep_serialno(String devID)", new Object[]{string});
        int n = 0;
        int n2 = 0;
        int n3 = string.indexOf(":");
        if (n3 == -1) {
            this.logExit(this.getClass().getName(), "prep_serialno(String devID)", new Object[]{string});
            return "Missing 1st :";
        }
        if ((n = string.indexOf(":", ++n3)) == -1) {
            this.logExit(this.getClass().getName(), "prep_serialno(String devID)", new Object[]{string});
            return "Missing 2nd :";
        }
        n2 = string.indexOf(":", n + 1);
        if (n2 == -1) {
            this.logExit(this.getClass().getName(), "prep_serialno(String devID)", new Object[]{string});
            return "Missing 3rd :";
        }
        String string3 = String.valueOf(string2) + "/" + string.substring(++n2) + ":NETWORK APPLIANCE";
        this.logExit(this.getClass().getName(), "prep_serialno(String devID)", new Object[]{string});
        return string3;
    }
}

