/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.request;

import java.io.PrintWriter;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.LocalizableException;
import org.eclipse.aperi.xmsg.MessageLog;

public abstract class Transceiver {
    public abstract void returnTransceiver();

    public abstract Request receiveRequest();

    public abstract Object receiveData(Request var1);

    public abstract Response transmitRequest(Request var1, Object var2);

    public abstract boolean transmitResponse(Request var1, Response var2);

    public abstract boolean close();

    protected void logReceivedResponse(Response response) {
        block5: {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry(Transceiver.class.getName(), "logReceivedResponse", "response");
            }
            try {
                if (response != null && response.getErrorMessage() != null) {
                    String string = response.getErrorMessage().substring(15);
                    PrintWriter printWriter = MessageLog.getThreadLog();
                    printWriter.println("               " + string);
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                if (!TraceLogger.enableTrace) break block5;
                TraceLogger.exception(Transceiver.class.getName(), "logReceivedResponse", indexOutOfBoundsException);
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(Transceiver.class.getName(), "logReceivedResponse");
        }
    }

    protected void logResponse(Request request, Response response) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(Transceiver.class.getName(), "logResponse", "request, response");
        }
        if (request != null && response != null) {
            Object[] objectArray = new Object[4];
            objectArray[0] = request.machineName;
            if (objectArray[0] == null) {
                objectArray[0] = "unknown";
            }
            objectArray[1] = request.serviceName;
            if (objectArray[1] == null) {
                objectArray[1] = "unknown";
            }
            objectArray[2] = request.toString();
            objectArray[3] = request.userName;
            String string = request.userName == null ? (response.status > 4 ? "GEN7078E" : "GEN7079W") : (response.status > 4 ? "GEN7076E" : "GEN7077W");
            MessageLog.logMessage(string, objectArray);
            MessageLog.getThreadLog().println(response.getErrorMessage());
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(Transceiver.class.getName(), "logResponse");
        }
    }

    private void throwException(String string, Request request) throws LocalizableException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(Transceiver.class.getName(), "throwException", "id, request");
        }
        Object[] objectArray = new Object[1];
        if (request != null) {
            objectArray[0] = request.toString();
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(Transceiver.class.getName(), "throwException");
        }
        throw new LocalizableException(string, objectArray);
    }

    protected void checkResponseToSend(Request request, Response response) throws LocalizableException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(Transceiver.class.getName(), "checkResponseToSend", "request, response");
        }
        if (((response.flags | request.flags) & 2) == 0) {
            this.throwException("GEN7082E", request);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(Transceiver.class.getName(), "checkResponseToSend");
        }
    }

    protected void checkReceivedResponse(Request request, int n, Response response) throws LocalizableException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(Transceiver.class.getName(), "checkReceivedResponse", "request, phase, response");
        }
        if ((n &= 1) << 1 == (response.flags & 2)) {
            String string = n == 0 ? "GEN7081E" : "GEN7080E";
            this.throwException(string, request);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(Transceiver.class.getName(), "checkReceivedResponse");
        }
    }

    protected void checkTwoPhase(Request request) throws LocalizableException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(Transceiver.class.getName(), "checkTwoPhase", "request");
        }
        if ((request.flags & 2) == 0) {
            this.throwException("GEN7083E", request);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(Transceiver.class.getName(), "checkTwoPhase");
        }
    }
}

