/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.guireq.topology.views;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Vector;
import org.eclipse.aperi.gui.topo.model.GraphModel;
import org.eclipse.aperi.gui.topo.model.GraphModelConstant;
import org.eclipse.aperi.gui.topo.model.GraphModelSubsystemL1;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystem;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystem2SubsystemPerf;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystemPerf;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch2Subsystem;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.server.guireq.topology.request.ViewerRequest;
import org.eclipse.aperi.server.guireq.topology.request.ViewerResponse;
import org.eclipse.aperi.server.guireq.topology.views.Metric;
import org.eclipse.aperi.server.guireq.topology.views.ViewerServerL2;
import org.eclipse.aperi.server.guireq.topology.views.ViewerStorageL0;
import org.eclipse.aperi.server.guireq.topology.views.ViewerSubsystemL2;

public class ViewerSubsystemL1
extends ViewerStorageL0 {
    private static final boolean debug = false;
    public static final String SELECT_SUBSYSTEM = "    SELECT distinct \t\tT_RES_STORAGE_SUBSYSTEM.PREFIX_ID, \t\tT_RES_STORAGE_SUBSYSTEM.SUBSYSTEM_ID SUBSYSTEM_ID, \t\tCASE WHEN T_RES_STORAGE_SUBSYSTEM.USER_PROVIDED_NAME IS NOT NULL AND RTRIM(T_RES_STORAGE_SUBSYSTEM.USER_PROVIDED_NAME) != '' THEN T_RES_STORAGE_SUBSYSTEM.USER_PROVIDED_NAME \t\t\t WHEN T_RES_STORAGE_SUBSYSTEM.DISPLAY_NAME IS NOT NULL THEN T_RES_STORAGE_SUBSYSTEM.DISPLAY_NAME \t\t\t ELSE T_RES_STORAGE_SUBSYSTEM.NAME \t\tEND  DISPLAY_NAME, \t\tT_RES_STORAGE_SUBSYSTEM.NAME || '+' || RTRIM(CAST(T_RES_STORAGE_SUBSYSTEM.NAME_FORMAT as CHAR(5))) NATURAL_KEY, \t\t(T_RES_STORAGE_SUBSYSTEM.ALLOCATED_CAPACITY*512) ALLOCATED_CAPACITY, \t\t(T_RES_STORAGE_SUBSYSTEM.AVAILABLE_CAPACITY*512) AVAILABLE_CAPACITY, \t\t(T_RES_STORAGE_SUBSYSTEM.BACKEND_STORAGE_CAPACITY*512) BACKEND_STORAGE_CAPACITY, \t\tVENDOR.VENDOR_NAME VENDOR, \t\tMODEL.MODEL_NAME MODEL, \t\tT_RES_STORAGE_SUBSYSTEM.CACHE CACHE, \t\tT_RES_STORAGE_SUBSYSTEM.OS_TYPE OS_TYPE, \t\tT_RES_STORAGE_SUBSYSTEM.TYPE TYPE, \t\tT_RES_STORAGE_SUBSYSTEM.IP_ADDRESS IP_ADDRESS, \t\tT_RES_STORAGE_SUBSYSTEM.CODE_LEVEL CODE_LEVEL,      CASE WHEN T_RES_STORAGE_SUBSYSTEM.SERIAL_NUMBER IS NOT NULL THEN T_RES_STORAGE_SUBSYSTEM.SERIAL_NUMBER           ELSE T_RES_STORAGE_SUBSYSTEM.NAME      END  SERIAL_NUMBER, \t\tT_RES_STORAGE_SUBSYSTEM.DETECTABLE DETECTABLE, \t\tT_RES_STORAGE_SUBSYSTEM.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t\tT_RES_STORAGE_SUBSYSTEM.CONSOLIDATED_STATUS CONSOLIDATED_STATUS, \t\tT_RES_STORAGE_SUBSYSTEM.PROPAGATED_STATUS PROPAGATED_STATUS,\t\tT_RES_STORAGE_SUBSYSTEM.ACCESS_INFO DEFAULT_MANAGER, \t\tT_RES_STORAGE_SUBSYSTEM.USER_ATTRIB1 USER_ATTRIB1, \t\tT_RES_STORAGE_SUBSYSTEM.USER_ATTRIB2 USER_ATTRIB2, \t\tT_RES_STORAGE_SUBSYSTEM.USER_ATTRIB3 USER_ATTRIB3 , CAST(NULL as Integer) PERF_STATUS FROM     T_VIEW_VSTORAGE_SUBSYSTEM T_RES_STORAGE_SUBSYSTEM left outer join T_RES_VENDOR VENDOR on  \t T_RES_STORAGE_SUBSYSTEM.VENDOR_ID = VENDOR.VENDOR_ID left outer join T_RES_MODEL MODEL on \t T_RES_STORAGE_SUBSYSTEM.MODEL_ID = MODEL.MODEL_ID WHERE     T_RES_STORAGE_SUBSYSTEM.PREFIX_ID = ? and \t T_RES_STORAGE_SUBSYSTEM.SUBSYSTEM_ID = ?";
    public static String SELECT_METRIC = "SELECT \tMETRIC.PM_QUERY, \tMETRIC.PM_TABLE, \tMETRIC.NAME_KEY, \tMETRIC.DATA_TYPE, \tMETRIC.UNIT_TYPE, \tMETRIC.PRECISION  FROM \tT_PMM_METRIC METRIC WHERE \tMETRIC.SUMM_TYPE = ? and \tDEV_TYPE = ? and \tCOMP_TYPE = ? and \tMETRIC_TYPE = ?";
    public static final String SELECT_SWITCH_FROM_ARRAY = "SELECT distinct \t T_RES_SWITCH.PREFIX_ID,     CASE WHEN T_RES_SWITCH.DISPLAY_NAME IS NOT NULL  and RTRIM(T_RES_SWITCH.DISPLAY_NAME) != '' THEN T_RES_SWITCH.DISPLAY_NAME          WHEN T_RES_SWITCH.LOGICAL_NAME IS NOT NULL  and RTRIM(T_RES_SWITCH.LOGICAL_NAME) != '' THEN T_RES_SWITCH.LOGICAL_NAME \t\t  ELSE T_RES_SWITCH.SWITCH_WWN \t END DISPLAY_NAME,     T_RES_SWITCH.SWITCH_ID SWITCH_ID,     T_RES_SWITCH.LOGICAL_NAME LOGICAL_NAME,     T_RES_SWITCH.SWITCH_WWN SWITCH_WWN,     T_RES_SWITCH.SERIAL_NUMBER SERIAL_NUMBER,     T_RES_SWITCH.DESCRIPTION DESCRIPTION,     T_RES_SWITCH.IP_ADDRESS IP_ADDRESS,     T_RES_SWITCH.DOMAIN DOMAIN,     T_RES_SWITCH.VERSION VERSION,     MODEL.MODEL_NAME MODEL,     VENDOR.VENDOR_NAME VENDOR, \t T_RES_SWITCH.PARENT_SWITCH_WWN PARENT_SWITCH_WWN, \t T_RES_SWITCH.MGMT_URL_ADDR DEFAULT_MANAGER, \t T_RES_SWITCH.DETECTABLE DETECTABLE, \t T_RES_SWITCH.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t T_RES_SWITCH.CONSOLIDATED_STATUS CONSOLIDATED_STATUS, \t T_RES_SWITCH.PROPAGATED_STATUS PROPAGATED_STATUS, \t T_RES_SWITCH.USER_ATTRIB1 USER_ATTRIB1, \t T_RES_SWITCH.USER_ATTRIB2 USER_ATTRIB2, \t T_RES_SWITCH.USER_ATTRIB3 USER_ATTRIB3 FROM T_VIEW_VSWITCH2SUBSYSTEM SWITCH2SUBSYSTEM, \t T_VIEW_VSWITCH T_RES_SWITCH left outer join T_RES_VENDOR VENDOR on \t T_RES_SWITCH.VENDOR_ID = VENDOR.VENDOR_ID left outer join T_RES_MODEL MODEL on\t T_RES_SWITCH.MODEL_ID = MODEL.MODEL_ID where     SWITCH2SUBSYSTEM.SUBSYSTEM_PREFIX_ID = ? and \t SWITCH2SUBSYSTEM.SUBSYSTEM_ID = ? and  \t SWITCH2SUBSYSTEM.SWITCH_PREFIX_ID = T_RES_SWITCH.PREFIX_ID and \t SWITCH2SUBSYSTEM.SWITCH_ID = T_RES_SWITCH.SWITCH_ID ";
    public static final String SELECT_SWITCH2ARRAY_FROM_ARRAY = "SELECT distinct \t SWITCH2SUBSYSTEM.SWITCH_PREFIX_ID PREFIX_ID, \t SWITCH2SUBSYSTEM.SWITCH_ID SWITCH_ID, \t SWITCH2SUBSYSTEM.PORT2PORT_ID PORT2PORT_ID,\t SWITCH2SUBSYSTEM.DETECTABLE DETECTABLE FROM T_VIEW_VSWITCH2SUBSYSTEM SWITCH2SUBSYSTEM WHERE     SWITCH2SUBSYSTEM.SUBSYSTEM_PREFIX_ID = ? and \t SWITCH2SUBSYSTEM.SUBSYSTEM_ID = ? ";
    public static final String SELECT_ZONE2MEMBER_FROM_SUBSYSTEM = "SELECT DISTINCT     'subsystem:' || CAST(SUBSYSTEM2PORT.SUBSYSTEM_ID as CHAR) ENTITY_KEY,     PORT2ZONE.ZONE_ID ZONE_ID FROM T_VIEW_VSUBSYSTEM2PORT SUBSYSTEM2PORT, T_VIEW_PORT2ZONE PORT2ZONE WHERE \t SUBSYSTEM2PORT.PREFIX_ID = ? and \t SUBSYSTEM2PORT.SUBSYSTEM_ID = ? and     SUBSYSTEM2PORT.PORT_ID = PORT2ZONE.PORT_ID";
    public static String SELECT_SANS_FROM_ARRAY = "SELECT     SUBSYSTEM2FABRIC.FABRIC_ID,     SUBSYSTEM2FABRIC.PREFIX_ID, \t SUBSYSTEM2FABRIC.SUBSYSTEM_ID FROM T_VIEW_VSUBSYSTEM2FABRIC SUBSYSTEM2FABRIC WHERE \t SUBSYSTEM2FABRIC.PREFIX_ID = ? and \t SUBSYSTEM2FABRIC.SUBSYSTEM_ID = ?";
    public static final String SELECT_SANS_FROM_SWITCH_FROM_ARRAY = "SELECT \t SWITCH2FABRIC.PREFIX_ID, \t SWITCH2FABRIC.SWITCH_ID SWITCH_ID, \t\tT_RES_FABRIC.FABRIC_WWN FABRIC_WWN, \t\tCASE WHEN T_RES_FABRIC.DISPLAY_NAME IS NOT NULL AND RTRIM(T_RES_FABRIC.DISPLAY_NAME) != '' THEN T_RES_FABRIC.DISPLAY_NAME \t\t\tWHEN T_RES_FABRIC.NAME IS NOT NULL THEN RTRIM(T_RES_FABRIC.NAME) \t\t\tWHEN T_RES_FABRIC.SAN_WWN IS NOT NULL THEN RTRIM(T_RES_FABRIC.SAN_WWN) \t\t\tELSE T_RES_FABRIC.FABRIC_WWN \t\tEND DISPLAY_NAME, \t\tT_RES_FABRIC.FABRIC_ID FABRIC_ID, \t\tT_RES_FABRIC.NAME NAME, \t\tT_RES_FABRIC.ACTIVE ACTIVE, \t\tT_RES_FABRIC.IS_PHYSICAL IS_PHYSICAL, \t\tCASE WHEN PARENT.DISPLAY_NAME IS NOT NULL THEN PARENT.DISPLAY_NAME \t\t\tWHEN PARENT.SAN_WWN IS NOT NULL THEN RTRIM(PARENT.SAN_WWN) \t\t\tELSE PARENT.FABRIC_WWN \t\tEND PARENT_DISPLAY_NAME, \t\tT_RES_FABRIC.DETECTABLE DETECTABLE, \t\tT_RES_FABRIC.PROPAGATED_STATUS PROPAGATED_STATUS, \t\tT_RES_FABRIC.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t\tT_RES_FABRIC.USER_ATTRIB1 USER_ATTRIB1, \t\tT_RES_FABRIC.USER_ATTRIB2 USER_ATTRIB2, \t\tT_RES_FABRIC.USER_ATTRIB3 USER_ATTRIB3  FROM     T_RES_FABRIC left outer join T_RES_FABRIC PARENT on \t T_RES_FABRIC.PARENT_FABRIC_WWN = PARENT.FABRIC_WWN, T_VIEW_VSWITCH2SUBSYSTEM SWITCH2SUBSYSTEM, T_VIEW_VSWITCH2FABRIC SWITCH2FABRIC WHERE     T_RES_FABRIC.FABRIC_ID = SWITCH2FABRIC.FABRIC_ID and \t SWITCH2FABRIC.SWITCH_ID = SWITCH2SUBSYSTEM.SWITCH_ID and     SWITCH2SUBSYSTEM.SUBSYSTEM_PREFIX_ID = ? and     SWITCH2SUBSYSTEM.SUBSYSTEM_ID = ?";
    public static final String SELECT_SANS_FROM_DIRECTLY_ATTACHED_HOST_FROM_SUBSYSTEM = "SELECT \t HOST2FABRIC.FABRIC_ID FABRIC_ID, \t HOST2FABRIC.HOST_ID HOST_ID FROM T_VIEW_VHOST2SUBSYSTEM HOST2SUBSYSTEM, T_VIEW_VHOST2FABRIC HOST2FABRIC WHERE \t HOST2FABRIC.HOST_ID = HOST2SUBSYSTEM.HOST_ID and     HOST2SUBSYSTEM.SUBSYSTEM_ID = ?";
    public static final String SELECT_SUBSYSTEM_WITH_STATS_PRE = "SELECT   \t\tT_RES_STORAGE_SUBSYSTEM.PREFIX_ID, \t\tT_RES_STORAGE_SUBSYSTEM.SUBSYSTEM_ID SUBSYSTEM_ID, \t\tCASE WHEN T_RES_STORAGE_SUBSYSTEM.USER_PROVIDED_NAME IS NOT NULL AND RTRIM(T_RES_STORAGE_SUBSYSTEM.USER_PROVIDED_NAME) != '' THEN T_RES_STORAGE_SUBSYSTEM.USER_PROVIDED_NAME \t\t\t WHEN T_RES_STORAGE_SUBSYSTEM.DISPLAY_NAME IS NOT NULL THEN T_RES_STORAGE_SUBSYSTEM.DISPLAY_NAME \t\t\t ELSE T_RES_STORAGE_SUBSYSTEM.NAME \t\tEND  DISPLAY_NAME, \t\tT_RES_STORAGE_SUBSYSTEM.NAME || '+' || RTRIM(CAST(T_RES_STORAGE_SUBSYSTEM.NAME_FORMAT as CHAR(5))) NATURAL_KEY, \t\t(T_RES_STORAGE_SUBSYSTEM.ALLOCATED_CAPACITY*512) ALLOCATED_CAPACITY, \t\t(T_RES_STORAGE_SUBSYSTEM.AVAILABLE_CAPACITY*512) AVAILABLE_CAPACITY, \t\t(T_RES_STORAGE_SUBSYSTEM.BACKEND_STORAGE_CAPACITY*512) BACKEND_STORAGE_CAPACITY, \t\tVENDOR.VENDOR_NAME VENDOR, \t\tMODEL.MODEL_NAME MODEL, \t\tT_RES_STORAGE_SUBSYSTEM.CACHE CACHE, \t\tT_RES_STORAGE_SUBSYSTEM.OS_TYPE OS_TYPE, \t\tT_RES_STORAGE_SUBSYSTEM.TYPE TYPE, \t\tT_RES_STORAGE_SUBSYSTEM.IP_ADDRESS IP_ADDRESS, \t\tT_RES_STORAGE_SUBSYSTEM.CODE_LEVEL CODE_LEVEL,      CASE WHEN T_RES_STORAGE_SUBSYSTEM.SERIAL_NUMBER IS NOT NULL THEN T_RES_STORAGE_SUBSYSTEM.SERIAL_NUMBER           ELSE T_RES_STORAGE_SUBSYSTEM.NAME      END  SERIAL_NUMBER, \t\tT_RES_STORAGE_SUBSYSTEM.DETECTABLE DETECTABLE, \t\tT_RES_STORAGE_SUBSYSTEM.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t\tT_RES_STORAGE_SUBSYSTEM.CONSOLIDATED_STATUS CONSOLIDATED_STATUS, \t\tT_RES_STORAGE_SUBSYSTEM.PROPAGATED_STATUS PROPAGATED_STATUS,\t\tT_RES_STORAGE_SUBSYSTEM.ACCESS_INFO DEFAULT_MANAGER, \t\tT_RES_STORAGE_SUBSYSTEM.USER_ATTRIB1 USER_ATTRIB1, \t\tT_RES_STORAGE_SUBSYSTEM.USER_ATTRIB2 USER_ATTRIB2, \t\tT_RES_STORAGE_SUBSYSTEM.USER_ATTRIB3 USER_ATTRIB3  ";
    public static final String SELECT_SUBSYSTEM_WITH_STATS_POST = "\t    ,CASE WHEN TMP2.STATUS IS NULL THEN 0 ELSE TMP2.STATUS END PERF_STATUS \tFROM   \t\tT_VIEW_VSTORAGE_SUBSYSTEM T_RES_STORAGE_SUBSYSTEM left outer join \t(SELECT          MAX(TS.START_DATE_DEV || TS.START_TIME_DEV) ID,         SUBSYSTEM.SUBSYSTEM_ID SUBSYSTEM_ID     FROM          T_PRF_TIMESTAMP TS, #table_name# S,         T_RES_STORAGE_SUBSYSTEM SUBSYSTEM     WHERE      \t TS.COMP_TYPE = 1 and      \t TS.SUMM_TYPE = 1 and          TS.TIME_ID = S.TIME_ID and          S.ELEMENT_ID = SUBSYSTEM.SUBSYSTEM_ID      GROUP BY SUBSYSTEM.SUBSYSTEM_ID)  TS2SYSTEM on      T_RES_STORAGE_SUBSYSTEM.SUBSYSTEM_ID = TS2SYSTEM.SUBSYSTEM_ID  left outer join T_PRF_TIMESTAMP TS on     TS2SYSTEM.ID = (TS.START_DATE_DEV || TS.START_TIME_DEV) and \t TS.COMP_TYPE = 1 and \t TS.DEV_ID = T_RES_STORAGE_SUBSYSTEM.SUBSYSTEM_ID     left outer join #table_name# S on \t TS.TIME_ID = S.TIME_ID  and S.ELEMENT_ID = T_RES_STORAGE_SUBSYSTEM.SUBSYSTEM_ID left outer join \t   T_RES_VENDOR VENDOR on   \t\t T_RES_STORAGE_SUBSYSTEM.VENDOR_ID = VENDOR.VENDOR_ID left outer join T_RES_MODEL MODEL on   \t\t T_RES_STORAGE_SUBSYSTEM.MODEL_ID = MODEL.MODEL_ID left outer join  (SELECT       CASE WHEN TMP1.MAX_STATUS = 0 THEN 0 \t\tWHEN TMP1.MIN_STATUS = 2 THEN 2 \t\tELSE 1 \t END STATUS,      TMP1.SUBSYSTEM_ID   FROM   (SELECT  \tSUBSYSTEM2THRESH.SUBSYSTEM_ID,  \tMAX(CASE WHEN THRESH_EXC.BOUND_TYPE IS NULL THEN 0 \t     WHEN THRESH_EXC.BOUND_TYPE =1 OR THRESH_EXC.BOUND_TYPE =2 THEN 2 \t     ELSE 1 \tEND) MAX_STATUS, \tMIN(CASE WHEN THRESH_EXC.BOUND_TYPE IS NULL THEN 0 \t     WHEN THRESH_EXC.BOUND_TYPE =1 OR THRESH_EXC.BOUND_TYPE =2 THEN 2 \t     ELSE 1 \tEND) MIN_STATUS FROM \t(SELECT SUBSYSTEM.SUBSYSTEM_ID, THRESH.THRESH_TYPE \tFROM  \t  T_RES_STORAGE_SUBSYSTEM SUBSYSTEM,     (SELECT  \tPOLICY.DEV_TYPE, POLICY.DEV_ID, THRESH.COMP_TYPE, THRESH.THRESH_TYPE      FROM \tT_PMM_THRESHOLD THRESH, T_PMM_THRESHOLD_POLICY POLICY     WHERE \tTHRESH.ORIGIN = POLICY.ORIGIN and  \tTHRESH.POLICY_ID = POLICY.POLICY_ID and  \tTHRESH.ENABLED = 1 and  \tPOLICY.DEV_TYPE > 0 and POLICY.DEV_TYPE < 6) THRESH) SUBSYSTEM2THRESH left outer join  (SELECT  THRESH.DEV_ID, THRESH.COMP_TYPE, THRESH.COMP_TYPE, THRESH.THRESH_TYPE, EXC2.BOUND_TYPE FROM (SELECT  \tPOLICY.DEV_TYPE, POLICY.DEV_ID, THRESH.COMP_TYPE, THRESH.THRESH_TYPE FROM \tT_PMM_THRESHOLD THRESH, T_PMM_THRESHOLD_POLICY POLICY WHERE \tTHRESH.ORIGIN = POLICY.ORIGIN and  \tTHRESH.POLICY_ID = POLICY.POLICY_ID and  \tTHRESH.ENABLED = 1 and  \t(POLICY.DEV_TYPE > 0 and POLICY.DEV_TYPE < 6)) THRESH  \tleft outer join ( \t\tSELECT MAX(EXC.START_DATE_DEV || EXC.START_TIME_DEV) DATE,   \t\t    EXC.COMP_TYPE, EXC.COMP_ID,   \t\t    EXC.DEV_TYPE, EXC.DEV_ID,  \t\t    EXC.THRESH_TYPE  \t\tFROM  \t\t    T_PMM_EXCEPTION EXC  \t\tGROUP BY EXC.COMP_TYPE, EXC.COMP_ID, EXC.DEV_TYPE, EXC.DEV_ID, EXC.THRESH_TYPE) EXC on \tTHRESH.DEV_TYPE = EXC.DEV_TYPE and \t(THRESH.DEV_ID = -1 OR THRESH.DEV_ID = EXC.DEV_ID) and \tTHRESH.COMP_TYPE = EXC.COMP_TYPE and \tTHRESH.THRESH_TYPE = EXC.THRESH_TYPE left outer join T_PMM_EXCEPTION EXC2 on   \t\t\t    EXC.DEV_ID = EXC2.DEV_ID and EXC.DEV_TYPE = EXC2.DEV_TYPE and   \t\t\t    EXC.COMP_ID = EXC2.COMP_ID and EXC.COMP_TYPE = EXC2.COMP_TYPE and   \t\t\t    EXC.DATE = (EXC2.START_DATE_DEV || EXC2.START_TIME_DEV) and   \t\t\t    EXC.THRESH_TYPE = EXC2.THRESH_TYPE) THRESH_EXC on \tSUBSYSTEM2THRESH.SUBSYSTEM_ID = THRESH_EXC.DEV_ID and  \tSUBSYSTEM2THRESH.THRESH_TYPE = THRESH_EXC.THRESH_TYPE GROUP BY SUBSYSTEM2THRESH.SUBSYSTEM_ID) TMP1 ) TMP2 on \tT_RES_STORAGE_SUBSYSTEM.SUBSYSTEM_ID = TMP2.SUBSYSTEM_ID \tWHERE   \t\tT_RES_STORAGE_SUBSYSTEM.PREFIX_ID = ? and \t\tT_RES_STORAGE_SUBSYSTEM.SUBSYSTEM_ID = ? ";
    public static final String SELECT_SUBSYSTEM_TYPE = "SELECT SUBSYSTEM.TYPE TYPE FROM \tT_RES_STORAGE_SUBSYSTEM SUBSYSTEM WHERE \tSUBSYSTEM.SUBSYSTEM_ID = ?";

    public void getSwitchFromSubsystem(Connection connection, GraphModel graphModel, HashMap hashMap, String string, int n) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerSubsystemL1.class.getName(), "getSwitchFromSubsystem", "");
        }
        System.currentTimeMillis();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        GraphSubsystem graphSubsystem = (GraphSubsystem)hashMap.get(String.valueOf(string) + n);
        if (graphSubsystem == null) {
            if (TraceLogger.enableTrace) {
                TraceLogger.traceMessage(1, ViewerSubsystemL1.class.getName(), "getSwitchFromSubsystem", "Subsystem not found:subsystem:" + n);
            }
            return;
        }
        try {
            preparedStatement = connection.prepareStatement(SELECT_SWITCH_FROM_ARRAY);
            preparedStatement.setString(1, string);
            preparedStatement.setInt(2, n);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string2 = (String)resultSet.getObject("PREFIX_ID");
                Integer n2 = (Integer)resultSet.getObject("SWITCH_ID");
                if (n2 == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSubsystemL1.class.getName(), "getSwitchFromSubsystem", "NULL column field SWITCH_WWN from switch");
                    continue;
                }
                String string3 = String.valueOf(string2) + n2;
                GraphSwitch graphSwitch = (GraphSwitch)hashMap.get(string3);
                if (graphSwitch != null) continue;
                graphSwitch = new GraphSwitch(string3);
                this.populator.populateSwitch(resultSet, graphSwitch, true);
                graphModel.put(graphSwitch);
                hashMap.put(string3, graphSwitch);
            }
        }
        finally {
            block21: {
                block20: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!TraceLogger.enableTrace) break block20;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "getSwitch2HostFromHost", sQLException);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (SQLException sQLException) {
                    if (!TraceLogger.enableTrace) break block21;
                    TraceLogger.exception(ViewerServerL2.class.getName(), "getSwitch2HostFromHost", sQLException);
                }
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerSubsystemL1.class.getName(), "getSwitchFromSubsystem", "");
        }
    }

    public void getSwitch2ArrayFromSubsystem(Connection connection, GraphModel graphModel, HashMap hashMap, String string, int n) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerSubsystemL1.class.getName(), "getSwitch2ArrayFromSubsystem", "");
        }
        System.currentTimeMillis();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        GraphSubsystem graphSubsystem = (GraphSubsystem)hashMap.get(String.valueOf(string) + n);
        if (graphSubsystem == null) {
            if (TraceLogger.enableTrace) {
                TraceLogger.traceMessage(1, ViewerSubsystemL1.class.getName(), "getSwitch2ArrayFromSubsystem", "Subsystem not found:subsystem:" + n);
            }
            return;
        }
        try {
            preparedStatement = connection.prepareStatement(SELECT_SWITCH2ARRAY_FROM_ARRAY);
            preparedStatement.setString(1, string);
            preparedStatement.setInt(2, n);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string2 = (String)resultSet.getObject("PREFIX_ID");
                Integer n2 = (Integer)resultSet.getObject("SWITCH_ID");
                Integer n3 = (Integer)resultSet.getObject("PORT2PORT_ID");
                if (n2 == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSubsystemL1.class.getName(), "getSwitch2ArrayFromSubsystem", "NULL column field SWITCH_WWN from switch");
                    continue;
                }
                String string3 = String.valueOf(string2) + n2;
                GraphSwitch graphSwitch = (GraphSwitch)hashMap.get(string3);
                if (graphSwitch == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSubsystemL1.class.getName(), "getSwitch2ArrayFromSubsystem", "Switch not found:" + string3);
                    continue;
                }
                String string4 = "port2port:" + string2 + n2 + ',' + string + n + ',' + n3;
                if (hashMap.get(string4) == null) {
                    GraphSwitch2Subsystem graphSwitch2Subsystem = new GraphSwitch2Subsystem(string4);
                    graphSwitch2Subsystem.setSubsystemID((GraphSubsystem.ID)graphSubsystem.getEntityID());
                    graphSwitch2Subsystem.setSwitchID((GraphSwitch.ID)graphSwitch.getEntityID());
                    this.populator.populatePort2Port(resultSet, graphSwitch2Subsystem);
                    graphModel.put(graphSwitch2Subsystem);
                    hashMap.put(string4, graphSwitch2Subsystem);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerSubsystemL1.class.getName(), "getSwitch2ArrayFromSubsystem", "Duplicated :" + string4);
            }
        }
        finally {
            block23: {
                block22: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!TraceLogger.enableTrace) break block22;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "getSwitch2ArrayFromSubsystem", sQLException);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (SQLException sQLException) {
                    if (!TraceLogger.enableTrace) break block23;
                    TraceLogger.exception(ViewerServerL2.class.getName(), "getSwitch2ArrayFromSubsystem", sQLException);
                }
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerSubsystemL1.class.getName(), "getSwitch2ArrayFromSubsystem", "");
        }
    }

    public void getZonesFromSubsystem(Connection connection, GraphModel graphModel, HashMap hashMap, String string, int n) throws SQLException {
    }

    public void getSansFromHost(Connection connection, GraphModel graphModel, HashMap hashMap, String string, int n) throws SQLException {
        this.getSansFromHost(connection, graphModel, hashMap, string, new Integer(n), SELECT_SANS_FROM_DIRECTLY_ATTACHED_HOST_FROM_SUBSYSTEM);
    }

    public void getSansFromSubsystem(Connection connection, GraphModel graphModel, HashMap hashMap, String string, int n) throws SQLException {
        this.getSansFromSubsystem(connection, graphModel, hashMap, string, new Integer(n), SELECT_SANS_FROM_ARRAY);
    }

    public void getSansFromSwitch(Connection connection, GraphModel graphModel, HashMap hashMap, String string, int n) throws SQLException {
        this.getSansFromSwitch(connection, graphModel, hashMap, string, new Integer(n), SELECT_SANS_FROM_SWITCH_FROM_ARRAY);
    }

    public void commit(Connection connection) {
        block2: {
            try {
                connection.commit();
            }
            catch (SQLException sQLException) {
                if (!TraceLogger.enableTrace) break block2;
                TraceLogger.exception(ViewerServerL2.class.getName(), "commit", sQLException);
            }
        }
    }

    public static Metric getMetric(Connection connection, int n, int n2, int n3, int n4) throws SQLException {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(SELECT_METRIC);
            preparedStatement.setInt(1, n3);
            preparedStatement.setInt(2, n);
            preparedStatement.setInt(3, n2);
            preparedStatement.setInt(4, n4);
            resultSet = preparedStatement.executeQuery();
            Metric metric = null;
            while (resultSet.next()) {
                metric = new Metric((String)resultSet.getObject("PM_QUERY"), (String)resultSet.getObject("NAME_KEY"), (String)resultSet.getObject("PM_TABLE"));
            }
            Metric metric2 = metric;
            return metric2;
        }
        finally {
            block15: {
                block14: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!TraceLogger.enableTrace) break block14;
                        TraceLogger.exception(ViewerSubsystemL2.class.getName(), "getMetric", sQLException);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (SQLException sQLException) {
                    if (!TraceLogger.enableTrace) break block15;
                    TraceLogger.exception(ViewerSubsystemL2.class.getName(), "getMetric", sQLException);
                }
            }
        }
    }

    public static String getQuery(Metric[] metricArray, String string, String string2, boolean bl, String string3) {
        Metric metric = null;
        int n = 0;
        while (n < metricArray.length) {
            metric = metricArray[n];
            if (metric != null) {
                string = String.valueOf(string) + ", " + metric.query + " " + metric.nameKey + " ";
                string3 = metric.tableName;
            }
            ++n;
        }
        if (string3 != null && bl) {
            string2 = string2.replaceAll("#table_name#", string3);
        }
        return String.valueOf(string) + string2;
    }

    public static Metric[] getMetrics(Connection connection, int n, int n2) throws SQLException {
        Vector<Metric> vector = new Vector<Metric>();
        block0 : switch (n) {
            case 5: {
                switch (n2) {
                    case 12: {
                        vector.add(ViewerSubsystemL1.getMetric(connection, n, n2, 1, 819));
                        vector.add(ViewerSubsystemL1.getMetric(connection, n, n2, 1, 820));
                        vector.add(ViewerSubsystemL1.getMetric(connection, n, n2, 1, 803));
                        vector.add(ViewerSubsystemL1.getMetric(connection, n, n2, 1, 806));
                        vector.add(ViewerSubsystemL1.getMetric(connection, n, n2, 1, 812));
                        vector.add(ViewerSubsystemL1.getMetric(connection, n, n2, 1, 815));
                        break;
                    }
                    case 2: {
                        vector.add(ViewerSubsystemL1.getMetric(connection, n, n2, 1, 852));
                        vector.add(ViewerSubsystemL1.getMetric(connection, n, n2, 1, 853));
                        vector.add(ViewerSubsystemL1.getMetric(connection, n, n2, 1, 858));
                        vector.add(ViewerSubsystemL1.getMetric(connection, n, n2, 1, 859));
                        vector.add(ViewerSubsystemL1.getMetric(connection, n, n2, 1, 863));
                        vector.add(ViewerSubsystemL1.getMetric(connection, n, n2, 1, 864));
                        break;
                    }
                    case 4: {
                        break;
                    }
                    case 1: {
                        vector.add(ViewerSubsystemL1.getMetric(connection, n, n2, 1, 819));
                        vector.add(ViewerSubsystemL1.getMetric(connection, n, n2, 1, 820));
                        vector.add(ViewerSubsystemL1.getMetric(connection, n, n2, 1, 803));
                        vector.add(ViewerSubsystemL1.getMetric(connection, n, n2, 1, 806));
                        vector.add(ViewerSubsystemL1.getMetric(connection, n, n2, 1, 812));
                        vector.add(ViewerSubsystemL1.getMetric(connection, n, n2, 1, 815));
                    }
                }
                break;
            }
            case 4: {
                switch (n2) {
                    case 12: {
                        vector.add(ViewerSubsystemL1.getMetric(connection, n, n2, 1, 819));
                        vector.add(ViewerSubsystemL1.getMetric(connection, n, n2, 1, 820));
                        vector.add(ViewerSubsystemL1.getMetric(connection, n, n2, 1, 803));
                        vector.add(ViewerSubsystemL1.getMetric(connection, n, n2, 1, 806));
                        break block0;
                    }
                    case 2: {
                        vector.add(ViewerSubsystemL1.getMetric(connection, n, n2, 1, 852));
                        vector.add(ViewerSubsystemL1.getMetric(connection, n, n2, 1, 853));
                        vector.add(ViewerSubsystemL1.getMetric(connection, n, n2, 1, 858));
                        vector.add(ViewerSubsystemL1.getMetric(connection, n, n2, 1, 859));
                        vector.add(ViewerSubsystemL1.getMetric(connection, n, n2, 1, 863));
                        vector.add(ViewerSubsystemL1.getMetric(connection, n, n2, 1, 864));
                        break block0;
                    }
                }
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                switch (n2) {
                    case 12: {
                        vector.add(ViewerSubsystemL1.getMetric(connection, n, n2, 1, 819));
                        vector.add(ViewerSubsystemL1.getMetric(connection, n, n2, 1, 820));
                        vector.add(ViewerSubsystemL1.getMetric(connection, n, n2, 1, 803));
                        vector.add(ViewerSubsystemL1.getMetric(connection, n, n2, 1, 806));
                        vector.add(ViewerSubsystemL1.getMetric(connection, n, n2, 1, 822));
                        vector.add(ViewerSubsystemL1.getMetric(connection, n, n2, 1, 823));
                        vector.add(ViewerSubsystemL1.getMetric(connection, n, n2, 1, 812));
                        vector.add(ViewerSubsystemL1.getMetric(connection, n, n2, 1, 815));
                        break;
                    }
                    case 2: {
                        vector.add(ViewerSubsystemL1.getMetric(connection, n, n2, 1, 852));
                        vector.add(ViewerSubsystemL1.getMetric(connection, n, n2, 1, 853));
                        vector.add(ViewerSubsystemL1.getMetric(connection, n, n2, 1, 858));
                        vector.add(ViewerSubsystemL1.getMetric(connection, n, n2, 1, 859));
                        vector.add(ViewerSubsystemL1.getMetric(connection, n, n2, 1, 863));
                        vector.add(ViewerSubsystemL1.getMetric(connection, n, n2, 1, 864));
                        break;
                    }
                    case 4: {
                        break;
                    }
                    case 1: {
                        vector.add(ViewerSubsystemL1.getMetric(connection, n, n2, 1, 819));
                        vector.add(ViewerSubsystemL1.getMetric(connection, n, n2, 1, 820));
                        vector.add(ViewerSubsystemL1.getMetric(connection, n, n2, 1, 803));
                        vector.add(ViewerSubsystemL1.getMetric(connection, n, n2, 1, 806));
                        vector.add(ViewerSubsystemL1.getMetric(connection, n, n2, 1, 822));
                        vector.add(ViewerSubsystemL1.getMetric(connection, n, n2, 1, 823));
                        vector.add(ViewerSubsystemL1.getMetric(connection, n, n2, 1, 812));
                        vector.add(ViewerSubsystemL1.getMetric(connection, n, n2, 1, 815));
                        vector.add(ViewerSubsystemL1.getMetric(connection, n, n2, 1, 832));
                        vector.add(ViewerSubsystemL1.getMetric(connection, n, n2, 1, 834));
                    }
                }
                break;
            }
            case 6: {
                switch (n2) {
                    case 14: {
                        vector.add(ViewerSubsystemL1.getMetric(connection, n, n2, 1, 855));
                        vector.add(ViewerSubsystemL1.getMetric(connection, n, n2, 1, 856));
                        vector.add(ViewerSubsystemL1.getMetric(connection, n, n2, 1, 858));
                        vector.add(ViewerSubsystemL1.getMetric(connection, n, n2, 1, 859));
                        vector.add(ViewerSubsystemL1.getMetric(connection, n, n2, 1, 872));
                        vector.add(ViewerSubsystemL1.getMetric(connection, n, n2, 1, 874));
                        break block0;
                    }
                    case 13: {
                        vector.add(ViewerSubsystemL1.getMetric(connection, n, n2, 1, 855));
                        vector.add(ViewerSubsystemL1.getMetric(connection, n, n2, 1, 856));
                        vector.add(ViewerSubsystemL1.getMetric(connection, n, n2, 1, 858));
                        vector.add(ViewerSubsystemL1.getMetric(connection, n, n2, 1, 859));
                    }
                }
            }
        }
        return vector.toArray(new Metric[vector.size()]);
    }

    public static String getSubsystemType(Connection connection, int n) throws SQLException {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(SELECT_SUBSYSTEM_TYPE);
            preparedStatement.setInt(1, n);
            resultSet = preparedStatement.executeQuery();
            String string = null;
            while (resultSet.next()) {
                string = (String)resultSet.getObject("TYPE");
            }
            String string2 = string;
            return string2;
        }
        finally {
            block15: {
                block14: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!TraceLogger.enableTrace) break block14;
                        TraceLogger.exception(ViewerSubsystemL2.class.getName(), "getSubsystemType", sQLException);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (SQLException sQLException) {
                    if (!TraceLogger.enableTrace) break block15;
                    TraceLogger.exception(ViewerSubsystemL2.class.getName(), "getMetric", sQLException);
                }
            }
        }
    }

    public GraphSubsystem getSubsystem(Connection connection, GraphModel graphModel, HashMap hashMap, String string, int n, boolean bl) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerSubsystemL2.class.getName(), "getSubsystem", "");
        }
        System.currentTimeMillis();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        GraphSubsystem graphSubsystem = null;
        String string2 = null;
        try {
            String string3;
            if (bl && "subsystem:".equals(string)) {
                int n2;
                string2 = ViewerSubsystemL1.getSubsystemType(connection, n);
                string3 = null;
                if ("FAStT".equalsIgnoreCase(string2)) {
                    n2 = 5;
                    string3 = ViewerSubsystemL1.getQuery(ViewerSubsystemL1.getMetrics(connection, n2, 1), SELECT_SUBSYSTEM_WITH_STATS_PRE, SELECT_SUBSYSTEM_WITH_STATS_POST, true, "T_PRF_DSVOL");
                } else if ("SVC".equalsIgnoreCase(string2)) {
                    n2 = 4;
                    string3 = ViewerSubsystemL1.getQuery(ViewerSubsystemL1.getMetrics(connection, n2, 1), SELECT_SUBSYSTEM_WITH_STATS_PRE, SELECT_SUBSYSTEM_WITH_STATS_POST, true, "T_PRF_DSVOL");
                } else if ("ESS".equals(string2) || "DS8000".equals(string2) || "DS6000".equals(string2)) {
                    n2 = 0;
                    if ("ESS".equals(string2)) {
                        n2 = 1;
                    } else if ("DS6000".equals(string2)) {
                        n2 = 2;
                    } else if ("DS8000".equals(string2)) {
                        n2 = 3;
                    }
                    string3 = ViewerSubsystemL1.getQuery(ViewerSubsystemL1.getMetrics(connection, n2, 1), SELECT_SUBSYSTEM_WITH_STATS_PRE, SELECT_SUBSYSTEM_WITH_STATS_POST, true, "T_PRF_DSVOL");
                } else {
                    string3 = SELECT_SUBSYSTEM;
                }
                preparedStatement = connection.prepareStatement(string3);
            } else {
                preparedStatement = connection.prepareStatement(SELECT_SUBSYSTEM);
            }
            preparedStatement.setString(1, string);
            preparedStatement.setInt(2, n);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                string3 = (String)resultSet.getObject("PREFIX_ID");
                Integer n3 = (Integer)resultSet.getObject("SUBSYSTEM_ID");
                if (n3 == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSubsystemL2.class.getName(), "getSubsystem", "Subsystem ID is NULL");
                    continue;
                }
                String string4 = String.valueOf(string3) + n3;
                if (hashMap.get(string4) == null) {
                    graphSubsystem = new GraphSubsystem(string4);
                    this.populator.populateSubsystem(resultSet, graphSubsystem);
                    if (graphModel != null) {
                        graphModel.put(graphSubsystem);
                    }
                    if (hashMap != null) {
                        hashMap.put(string4, graphSubsystem);
                    }
                    if (!bl || !"subsystem:".equals(string)) continue;
                    GraphSubsystemPerf graphSubsystemPerf = new GraphSubsystemPerf((String)graphSubsystem.getEntityID().getID());
                    Integer n4 = (Integer)resultSet.getObject("PERF_STATUS");
                    if (n4 == null) {
                        graphSubsystemPerf.setHealthStatus(GraphModelConstant.STATUS_UNKNOWN);
                    } else if (n4 == 0) {
                        graphSubsystemPerf.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
                    } else if (n4 == 1) {
                        graphSubsystemPerf.setHealthStatus(GraphModelConstant.STATUS_WARNING);
                    } else if (n4 == 2) {
                        graphSubsystemPerf.setHealthStatus(GraphModelConstant.STATUS_CRITICAL);
                    }
                    Integer n5 = null;
                    Integer n6 = null;
                    Double d = null;
                    Double d2 = null;
                    Double d3 = null;
                    Double d4 = null;
                    if ("ESS".equals(string2) || "DS6000".equals(string2) || "DS8000".equals(string2) || "FAStT".equals(string2)) {
                        try {
                            n5 = (Integer)resultSet.getObject("MET_READ_HITS_PERC_NAME");
                        }
                        catch (SQLException sQLException) {}
                        graphSubsystemPerf.setCacheHitRx(n5 != null ? new Double((double)n5.intValue() / 100.0) : null);
                        try {
                            n6 = (Integer)resultSet.getObject("MET_WRITE_HITS_PERC_NAME");
                        }
                        catch (SQLException sQLException) {}
                        graphSubsystemPerf.setCacheHitTx(n6 != null ? new Double((double)n6.intValue() / 100.0) : null);
                        try {
                            d = (Double)resultSet.getObject("MET_READ_IO_RATE_NAME");
                        }
                        catch (SQLException sQLException) {}
                        graphSubsystemPerf.setIORateRx(d);
                        try {
                            d2 = (Double)resultSet.getObject("MET_WRITE_IO_RATE_NAME");
                        }
                        catch (SQLException sQLException) {}
                        graphSubsystemPerf.setIORateTx(d2);
                        try {
                            d3 = (Double)resultSet.getObject("MET_READ_KB_RATE_NAME");
                        }
                        catch (SQLException sQLException) {}
                        graphSubsystemPerf.setDataRateRx(d3);
                        try {
                            d4 = (Double)resultSet.getObject("MET_WRITE_KB_RATE_NAME");
                        }
                        catch (SQLException sQLException) {}
                        graphSubsystemPerf.setDataRateTx(d4);
                    }
                    Double d5 = null;
                    Double d6 = null;
                    if ("ESS".equals(string2) || "DS8000".equals(string2) || "DS6000".equals(string2)) {
                        try {
                            d5 = (Double)resultSet.getObject("MET_READ_RESP_TIME_NAME");
                        }
                        catch (SQLException sQLException) {}
                        graphSubsystemPerf.setResponseTimeRx(d5);
                        try {
                            d6 = (Double)resultSet.getObject("MET_WRITE_RESP_TIME_NAME");
                        }
                        catch (SQLException sQLException) {}
                        graphSubsystemPerf.setResponseTimeTx(d6);
                    }
                    Integer n7 = null;
                    Integer n8 = null;
                    if ("ESS".equals(string2) || "DS8000".equals(string2) || "DS6000".equals(string2)) {
                        try {
                            n8 = (Integer)resultSet.getObject("MET_NVS_FULL_PERC_NAME");
                        }
                        catch (SQLException sQLException) {}
                        graphSubsystemPerf.setNVSFullPercentage(n8 != null ? new Double(n8.intValue()) : null);
                        try {
                            n7 = (Integer)resultSet.getObject("MET_CACHE_HOLD_TIME_NAME");
                        }
                        catch (SQLException sQLException) {}
                        graphSubsystemPerf.setCacheHoldingTime(n7);
                    }
                    if ("SVC".equals(string2) || d4 != null || d3 != null || d != null || d2 != null || n5 != null || n6 != null || d5 != null || d6 != null || n7 != null || n8 != null) {
                        graphModel.put(graphSubsystemPerf);
                    } else {
                        graphSubsystemPerf = new GraphSubsystemPerf("subsystemperf:" + string4);
                        graphSubsystemPerf.setHealthStatus(GraphModelConstant.STATUS_UNKNOWN);
                        graphModel.put(graphSubsystemPerf);
                    }
                    GraphSubsystem2SubsystemPerf graphSubsystem2SubsystemPerf = new GraphSubsystem2SubsystemPerf("subsystem2perf:" + graphSubsystem.getEntityID().getID());
                    graphSubsystem2SubsystemPerf.setSubsystemID((GraphSubsystem.ID)graphSubsystem.getEntityID());
                    graphSubsystem2SubsystemPerf.setSubsystemPerfID((GraphSubsystemPerf.ID)graphSubsystemPerf.getEntityID());
                    graphModel.put(graphSubsystem2SubsystemPerf);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerSubsystemL2.class.getName(), "getSubsystem", "Duplicated Array entry:" + string4);
            }
        }
        finally {
            block67: {
                block66: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!TraceLogger.enableTrace) break block66;
                        TraceLogger.exception(ViewerSubsystemL2.class.getName(), "getSubsystem", sQLException);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (SQLException sQLException) {
                    if (!TraceLogger.enableTrace) break block67;
                    TraceLogger.exception(ViewerSubsystemL2.class.getName(), "getSubsystem", sQLException);
                }
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerSubsystemL2.class.getName(), "getSubsystem", "");
        }
        return graphSubsystem;
    }

    public void getView(Connection connection, ViewerRequest viewerRequest, ViewerResponse viewerResponse) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerSubsystemL1.class.getName(), "getView", "");
        }
        GraphModelSubsystemL1 graphModelSubsystemL1 = null;
        String string = null;
        GraphModel.MultiEntityID multiEntityID = (GraphModel.MultiEntityID)viewerRequest.getModelID();
        Vector vector = multiEntityID.getChildFocusEntityIDs();
        HashMap hashMap = new HashMap();
        Timestamp timestamp = viewerRequest.getTimestamp();
        Timestamp timestamp2 = null;
        if (timestamp2 == null || timestamp == null || timestamp2.after(timestamp)) {
            graphModelSubsystemL1 = new GraphModelSubsystemL1((GraphModelSubsystemL1.ID)viewerRequest.getModelID());
            for (GraphSubsystem.ID iD : vector) {
                int n;
                string = (String)iD.getID();
                int n2 = string.indexOf(58);
                String string2 = string.substring(0, n2 + 1);
                if (this.getSubsystem(connection, graphModelSubsystemL1, hashMap, string2, n = Integer.parseInt(string = string.substring(n2 + 1)), false) == null) continue;
                this.getSwitchFromSubsystem(connection, graphModelSubsystemL1, hashMap, string2, n);
                this.getSwitch2ArrayFromSubsystem(connection, graphModelSubsystemL1, hashMap, string2, n);
                this.getSansFromSwitch(connection, (GraphModel)graphModelSubsystemL1, hashMap, string2, n);
                this.commit(connection);
                if (!viewerRequest.getModelID().isNeedZoneData()) continue;
                this.getZonesFromSubsystem(connection, graphModelSubsystemL1, hashMap, string2, n);
                this.commit(connection);
            }
            graphModelSubsystemL1.setWithZoneData(viewerRequest.getModelID().isNeedZoneData());
            viewerResponse.addResponse(0, graphModelSubsystemL1);
        } else {
            viewerResponse.addResponse(0, null);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerSubsystemL1.class.getName(), "getView", "");
        }
    }
}

