/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.util.queue;

import java.util.Hashtable;
import org.eclipse.aperi.discovery.interfaces.JobInfo;
import org.eclipse.aperi.util.queue.IJobQueue;

public class QueueController {
    private static QueueController iCurrentInstance = new QueueController();
    private Hashtable queues = new Hashtable();

    private QueueController() {
    }

    public static QueueController getInstance() {
        return iCurrentInstance;
    }

    public boolean addQueue(String string, IJobQueue iJobQueue) {
        if (this.queues.containsKey(string)) {
            return false;
        }
        this.queues.put(string, iJobQueue);
        return true;
    }

    public void addJob(JobInfo jobInfo) {
        IJobQueue iJobQueue = (IJobQueue)this.queues.get(jobInfo.getResourceQueue());
        if (iJobQueue == null) {
            Exception exception = new Exception("QueueController->addJob:No queue registered for " + jobInfo.getResourceQueue());
            exception.printStackTrace();
            return;
        }
        iJobQueue.addJob(jobInfo);
    }

    public JobInfo getNextJob(String string) {
        IJobQueue iJobQueue = (IJobQueue)this.queues.get(string);
        if (iJobQueue == null) {
            Exception exception = new Exception("QueueController->getNextJob:No queue registered for " + string);
            exception.printStackTrace();
            return null;
        }
        JobInfo jobInfo = iJobQueue.getNextJob();
        if (Thread.interrupted()) {
            return null;
        }
        return jobInfo;
    }

    public void jobComplete(JobInfo jobInfo) {
        IJobQueue iJobQueue = (IJobQueue)this.queues.get(jobInfo.getResourceQueue());
        if (iJobQueue == null) {
            Exception exception = new Exception("QueueController->jobComplete:No queue registered for " + jobInfo.getResourceQueue());
            exception.printStackTrace();
            return;
        }
        iJobQueue.jobCompleted(jobInfo);
    }
}

